/*
 * The new sysinstall program.
 *
 * This is probably the last program in the `sysinstall' line - the next
 * generation being essentially a complete rewrite.
 *
 * Copyright (c) 1995
 *	Jordan Hubbard.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer,
 *    verbatim and that no modifications are made prior to this
 *    point in the file.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY JORDAN HUBBARD ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL JORDAN HUBBARD OR HIS PETS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, LIFE OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef lint
static const char rcsid[] =
  "$FreeBSD: src/release/sysinstall/menus.c,v 1.252.2.56 2002/01/05 16:06:10 phantom Exp $";
#endif

#include "sysinstall.h"

/* Miscellaneous work routines for menus */
static int
setSrc(dialogMenuItem *self)
{
    Dists |= DIST_SRC;
    SrcDists = DIST_SRC_ALL;
    CRYPTODists |= (DIST_CRYPTO_SCRYPTO | DIST_CRYPTO_SSECURE |
	DIST_CRYPTO_SKERBEROS4 | DIST_CRYPTO_SKERBEROS5);
    return DITEM_SUCCESS | DITEM_REDRAW;
}

static int
clearSrc(dialogMenuItem *self)
{
    Dists &= ~DIST_SRC;
    SrcDists = 0;
    CRYPTODists &= ~(DIST_CRYPTO_SCRYPTO | DIST_CRYPTO_SSECURE |
	DIST_CRYPTO_SKERBEROS4 | DIST_CRYPTO_SKERBEROS5);
    return DITEM_SUCCESS | DITEM_REDRAW;
}

static int
setX11Misc(dialogMenuItem *self)
{
    XF86Dists |= DIST_XF86_MISC_ALL;
    Dists |= DIST_XF86;
    return DITEM_SUCCESS | DITEM_REDRAW;
}

static int
clearX11Misc(dialogMenuItem *self)
{
    XF86Dists &= ~DIST_XF86_MISC_ALL;
    if (!XF86ServerDists && !XF86FontDists)
	Dists &= ~DIST_XF86;
    return DITEM_SUCCESS | DITEM_REDRAW;
}

static int
setX11Servers(dialogMenuItem *self)
{
    XF86Dists |= DIST_XF86_SERVER;
    XF86ServerDists = DIST_XF86_SERVER_ALL;
    return DITEM_SUCCESS | DITEM_REDRAW;
}

static int
clearX11Servers(dialogMenuItem *self)
{
    XF86Dists &= ~DIST_XF86_SERVER;
    XF86ServerDists = 0;
    return DITEM_SUCCESS | DITEM_REDRAW;
}

static int
setX11Fonts(dialogMenuItem *self)
{
    XF86Dists |= DIST_XF86_FONTS;
    XF86FontDists = DIST_XF86_FONTS_ALL;
    return DITEM_SUCCESS | DITEM_REDRAW;
}

static int
clearX11Fonts(dialogMenuItem *self)
{
    XF86Dists &= ~DIST_XF86_FONTS;
    XF86FontDists = 0;
    return DITEM_SUCCESS | DITEM_REDRAW;
}

#define _IS_SET(dist, set) (((dist) & (set)) == (set))

#define IS_DEVELOPER(dist, extra) (_IS_SET(dist, _DIST_DEVELOPER | extra) || \
	_IS_SET(dist, _DIST_DEVELOPER | extra))

#define IS_USER(dist, extra) (_IS_SET(dist, _DIST_USER | extra) || \
	_IS_SET(dist, _DIST_USER | extra))

static int
checkDistDeveloper(dialogMenuItem *self)
{
    return IS_DEVELOPER(Dists, 0) && _IS_SET(SrcDists, DIST_SRC_ALL);
}

static int
checkDistXDeveloper(dialogMenuItem *self)
{
    return IS_DEVELOPER(Dists, DIST_XF86) && _IS_SET(SrcDists, DIST_SRC_ALL);
}

static int
checkDistKernDeveloper(dialogMenuItem *self)
{
    return IS_DEVELOPER(Dists, 0) && _IS_SET(SrcDists, DIST_SRC_SYS);
}

static int
checkDistXKernDeveloper(dialogMenuItem *self)
{
    return IS_DEVELOPER(Dists, DIST_XF86) && _IS_SET(SrcDists, DIST_SRC_SYS);
}

static int
checkDistUser(dialogMenuItem *self)
{
    return IS_USER(Dists, 0);
}

static int
checkDistXUser(dialogMenuItem *self)
{
    return IS_USER(Dists, DIST_XF86);
}

static int
checkDistMinimum(dialogMenuItem *self)
{
    return Dists == (DIST_BIN | DIST_CRYPTO);
}

static int
checkDistEverything(dialogMenuItem *self)
{
    return Dists == DIST_ALL && CRYPTODists == DIST_CRYPTO_ALL && \
	_IS_SET(SrcDists, DIST_SRC_ALL) && \
	_IS_SET(XF86Dists, DIST_XF86_ALL) && \
	_IS_SET(XF86ServerDists, DIST_XF86_SERVER_ALL) && \
	_IS_SET(XF86FontDists, DIST_XF86_FONTS_ALL);
}

static int
srcFlagCheck(dialogMenuItem *item)
{
    return SrcDists;
}

static int
x11FlagCheck(dialogMenuItem *item)
{
    return Dists & DIST_XF86;
}

static int
checkTrue(dialogMenuItem *item)
{
    return TRUE;
}

/* All the system menus go here.
 *
 * Hardcoded things like version number strings will disappear from
 * these menus just as soon as I add the code for doing inline variable
 * expansion.
 */

#if 1
DMenu MenuLocalization = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "FreeBSD sysinstall - Localization Menu",
    "Please choose a language you want to use in FreeBSD installation.
Select it from this list by using the arrow keys and [Enter] key.",
    "Press F1 for more HELP",
    "languages",
    { { "English",  "English (US-ASCII)",
	  NULL, dmenuSetVariable, NULL, "_language=english"},
#ifdef JAPANESE
	{ "Japanese", "Japanese (EUC-JP)",
	  NULL, dmenuSetVariable, NULL, "_language=japanese"},
#endif
#ifdef KOREAN
	{ "Korean", "Korean (EUC-KR)",
	    NULL,  dmenuSetVariable, NULL, "_language=korean"},
#endif
#ifdef PORTUGUESE_BR
	{ "Portuguese(BR)", "Portuguese (ISO-8859-1) [Test]",
	    NULL,  dmenuSetVariable, NULL, "_language=portuguese_br"},
#endif
#ifdef RUSSIAN
	{ "Russian", "Russian (KOI-8) [Test]",
	    NULL,  dmenuSetVariable, NULL, "_language=russian"},
#endif
#ifdef TRAD_CHINESE 
	{ "Traditional Chinese", "Traditional Chinese (Big5) [Test]",
	    NULL,  dmenuSetVariable, NULL, "_language=trad_chinese"},
#endif
	{ NULL } },
};
#endif

DMenu MenuIndex = {
    DMENU_NORMAL_TYPE,
    "$$$$00001 Glossary of functions",
    "$$$$00002 This menu contains an alphabetized index of the top level functions in\n"
    "this program (sysinstall).  Invoke an option by pressing [SPACE] or\n"
    "[ENTER].  To exit, use [TAB] to move to the Cancel button.",
    "$$$$00003 Use PageUp or PageDown to move through this menu faster!",
    NULL,
    { { " Anon FTP",		"$$$$00007 Configure anonymous FTP logins.",	dmenuVarCheck, configAnonFTP, NULL, "anon_ftp" },
      { " Commit",		"$$$$00009 Commit any pending actions (dangerous!)", NULL, installCustomCommit },
      { " Console settings",	"$$$$00011 Customize system console behavior.",	NULL, dmenuSubmenu, NULL, &MenuSyscons },
      { " Configure",		"$$$$00013 The system configuration menu.",	NULL, dmenuSubmenu, NULL, &MenuConfigure },
      { " Defaults, Load",	"$$$$32061 Load default settings.",		NULL, dispatch_load_floppy },
      { " Device, Mouse",	"$$$$00015 The mouse configuration menu.",	NULL, dmenuSubmenu, NULL, &MenuMouse },
      { " Disklabel",		"$$$$32001 The disk Label editor",		NULL, diskLabelEditor },
      { " Dists, All",		"$$$$00017 Root of the distribution tree.",	NULL, dmenuSubmenu, NULL, &MenuDistributions },
      { " Dists, Basic",	"$$$$00019 Basic FreeBSD distribution menu.",	NULL, dmenuSubmenu, NULL, &MenuSubDistributions },
      { " Dists, Developer",	"$$$$00023 Select developer's distribution.",	checkDistDeveloper, distSetDeveloper },
      { " Dists, Src",		"$$$$00025 Src distribution menu.",		NULL, dmenuSubmenu, NULL, &MenuSrcDistributions },
      { " Dists, X Developer",	"$$$$00027 Select X developer's distribution.",	checkDistXDeveloper, distSetXDeveloper },
      { " Dists, Kern Developer", "$$$$00029 Select kernel developer's distribution.", checkDistKernDeveloper, distSetKernDeveloper },
      { " Dists, User",		"$$$$00031 Select average user distribution.",	checkDistUser, distSetUser },
      { " Dists, X User",	"$$$$00033 Select average X user distribution.",	checkDistXUser, distSetXUser },
      { " Distributions, Adding", "$$$$32003 Installing additional distribution sets", NULL, distExtractAll },
      { " Distributions, XFree86","$$$$00035 XFree86 distribution menu.",		NULL, distSetXF86 },
      { " Documentation",	"$$$$00037 Installation instructions, README, etc.", NULL, dmenuSubmenu, NULL, &MenuDocumentation },
      { " Doc, README",		"$$$$00039 The distribution README file.",	NULL, dmenuDisplayFile, NULL, "README" },
      { " Doc, Hardware",	"$$$$00041 The distribution hardware guide.",	NULL, dmenuDisplayFile,	NULL, "HARDWARE" },
      { " Doc, Install",	"$$$$00043 The distribution installation guide.",	NULL, dmenuDisplayFile,	NULL, "INSTALL" },
      { " Doc, Copyright",	"$$$$00045 The distribution copyright notices.",	NULL, dmenuDisplayFile,	NULL, "COPYRIGHT" },
      { " Doc, Release",	"$$$$00047 The distribution release notes.",	NULL, dmenuDisplayFile, NULL, "RELNOTES" },
      { " Doc, HTML",		"$$$$00049 The HTML documentation menu.",		NULL, docBrowser },
      { " Dump Vars",		"$$$$32270 (debugging) dump out internal variables.", NULL, dump_variables },
      { " Emergency shell",	"$$$$32005 Start an Emergency Holographic shell.",	NULL, installFixitHoloShell },
#ifdef __i386__
      { " Fdisk",		"$$$$32007 The disk Partition Editor",		NULL, diskPartitionEditor },
#endif
      { " Fixit",		"$$$$00053 Repair mode with CDROM or fixit floppy.",	NULL, dmenuSubmenu, NULL, &MenuFixit },
      { " FTP sites",		"$$$$00055 The FTP mirror site listing.",		NULL, dmenuSubmenu, NULL, &MenuMediaFTP },
      { " Gateway",		"$$$$00059 Set flag to route packets between interfaces.", dmenuVarCheck, dmenuToggleVariable, NULL, "gateway=YES" },
      { " HTML Docs",		"$$$$00061 The HTML documentation menu",		NULL, docBrowser },
      { " inetd Configuration",	"Configure inetd and simple internet services.",	dmenuVarCheck, configInetd, NULL, "inetd_enable=YES" },
      { " Install, Standard",	"$$$$00063 A standard system installation.",	NULL, installStandard },
      { " Install, Express",	"$$$$00065 An express system installation.",	NULL, installExpress },
      { " Install, Custom",	"$$$$00067 The custom installation menu",		NULL, dmenuSubmenu, NULL, &MenuInstallCustom },
      { " Label",		"$$$$00069 The disk Label editor",		NULL, diskLabelEditor },
      { " Media",		"$$$$00071 Top level media selection menu.",	NULL, dmenuSubmenu, NULL, &MenuMedia },
      { " Media, Tape",		"$$$$00073 Select tape installation media.",	NULL, mediaSetTape },
      { " Media, NFS",		"$$$$00075 Select NFS installation media.",	NULL, mediaSetNFS },
      { " Media, Floppy",	"$$$$00077 Select floppy installation media.",	NULL, mediaSetFloppy },
      { " Media, CDROM/DVD",	"$$$$00079 Select CDROM/DVD installation media.",	NULL, mediaSetCDROM },
      { " Media, DOS",		"$$$$00081 Select DOS installation media.",	NULL, mediaSetDOS },
      { " Media, UFS",		"$$$$00083 Select UFS installation media.",	NULL, mediaSetUFS },
      { " Media, FTP",		"$$$$00085 Select FTP installation media.",	NULL, mediaSetFTP },
      { " Media, FTP Passive",	"$$$$00087 Select passive FTP installation media.", NULL, mediaSetFTPPassive },
      { " Media, HTTP",		"$$$$00088 Select FTP via HTTP proxy installation media.", NULL, mediaSetHTTP },
      { " Network Interfaces",	"$$$$00089 Configure network interfaces",		NULL, tcpMenuSelect },
      { " Networking Services",	"$$$$00091 The network services menu.",		NULL, dmenuSubmenu, NULL, &MenuNetworking },
      { " NFS, client",		"$$$$00093 Set NFS client flag.",			dmenuVarCheck, dmenuToggleVariable, NULL, "nfs_client_enable=YES" },
      { " NFS, server",		"$$$$00095 Set NFS server flag.",			dmenuVarCheck, configNFSServer, NULL, "nfs_server_enable=YES" },
      { " NTP Menu",		"$$$$00097 The NTP configuration menu.",		NULL, dmenuSubmenu, NULL, &MenuNTP },
      { " Options",		"$$$$00099 The options editor.",			NULL, optionsEditor },
      { " Packages",		"$$$$00101 The packages collection",		NULL, configPackages },
      { " Partition",		"$$$$00103 The disk Slice (PC-style partition) Editor",	NULL, diskPartitionEditor },
      { " PCNFSD",		"$$$$00105 Run authentication server for PC-NFS.", dmenuVarCheck, configPCNFSD, NULL, "pcnfsd" },
      { " Root Password",	"$$$$00109 Set the system manager's password.",   NULL, passwdRoot },
      { " Router",		"$$$$00111 Select routing daemon (default: routed)", NULL, configRouter, NULL, "router_enable" },
      { " Security",		"$$$$00113 Select a default system security profile.", NULL, dmenuSubmenu, NULL, &MenuSecurityProfile },
      { " Syscons",		"$$$$00115 The system console configuration menu.", NULL, dmenuSubmenu, NULL, &MenuSyscons },
      { " Syscons, Font",	"$$$$00961 The console screen font.",	  NULL, dmenuSubmenu, NULL, &MenuSysconsFont },
      { " Syscons, Keymap",	"$$$$00117 The console keymap configuration menu.", NULL, dmenuSubmenu, NULL, &MenuSysconsKeymap },
      { " Syscons, Keyrate",	"$$$$00119 The console key rate configuration menu.", NULL, dmenuSubmenu, NULL, &MenuSysconsKeyrate },
      { " Syscons, Saver",	"$$$$00121 The console screen saver configuration menu.",	NULL, dmenuSubmenu, NULL, &MenuSysconsSaver },
      { " Syscons, Screenmap",	"$$$$00963 The console screenmap configuration menu.", NULL, dmenuSubmenu, NULL, &MenuSysconsScrnmap },
      { " Time Zone",		"$$$$00123 Set the system's time zone.",		NULL, tzsetup },
      { " TTYs",		"$$$$32360 Configure system ttys.",		NULL, configEtcTtys, NULL, "ttys" },
      { " Upgrade",		"$$$$00125 Upgrade an existing system.",		NULL, installUpgrade },
      { " Usage",		"$$$$00127 Quick start - How to use this menu system.",	NULL, dmenuDisplayFile, NULL, "usage" },
      { " User Management",	"$$$$00976 Add user and group information.",	NULL, dmenuSubmenu, NULL, &MenuUsermgmt },
      { " XFree86, Fonts",	"$$$$00131 XFree86 Font selection menu.",		NULL, dmenuSubmenu, NULL, &MenuXF86SelectFonts },
      { " XFree86, Server",	"$$$$00133 XFree86 Server selection menu.",	NULL, dmenuSubmenu, NULL, &MenuXF86SelectServer },
#if defined(__i386__) && defined(PC98)
      { " XFree86, PC98 Server", "$$$$00965 XFree86 PC98 Server selection menu.",	NULL, dmenuSubmenu, NULL, &MenuXF86SelectPC98Server },
#endif
      { NULL } },
};

/* The initial installation menu */
DMenu MenuInitial = {
    DMENU_NORMAL_TYPE,
    "$$$$00135 /stand/sysinstall Main Menu",			/* title */
    "$$$$00136 Welcome to the FreeBSD installation and configuration tool.  Please\n" /* prompt */
    "select one of the options below by using the arrow keys or typing the\n"
    "first character of the option name you're interested in.  Invoke an\n"
    "option with [SPACE] or [ENTER].  To exit, use [TAB] to move to Exit.", 
    "$$$$00137 Press F1 for Installation Guide",			/* help line */
    "INSTALL",						/* help file */
    { { "$$$$00138 Select" },
      { "$$$$00139 X Exit Install",	NULL, NULL, dmenuExit },
      { " Usage",	"$$$$00141 Quick start - How to use this menu system",	NULL, dmenuDisplayFile, NULL, "usage" },
      { "Standard",	"$$$$00147 Begin a standard installation (recommended)",	NULL, installStandard },
      { "Express",	"$$$$00149 Begin a quick installation (for the impatient)", NULL, installExpress },
      { " Custom",	"$$$$00151 Begin a custom installation (for experts)",	NULL, dmenuSubmenu, NULL, &MenuInstallCustom },
      { "Configure",	"$$$$00157 Do post-install configuration of FreeBSD",	NULL, dmenuSubmenu, NULL, &MenuConfigure },
      { "Doc",		"$$$$00143 Installation instructions, README, etc.",	NULL, dmenuSubmenu, NULL, &MenuDocumentation },
      { "Keymap",	"$$$$00956 Select keyboard type",				NULL, dmenuSubmenu, NULL, &MenuSysconsKeymap },
      { "Options",	"$$$$00145 View/Set various installation options",	NULL, optionsEditor },
      { "Fixit",	"$$$$00153 Enter repair mode with CDROM/DVD/floppy or start shell",	NULL, dmenuSubmenu, NULL, &MenuFixit },
      { "Upgrade",	"$$$$00155 Upgrade an existing system",			NULL, installUpgrade },
      { "Load Config",	"$$$$32063 Load default install configuration",		NULL, dispatch_load_floppy },
      { "Index",	"$$$$00159 Glossary of functions",			NULL, dmenuSubmenu, NULL, &MenuIndex },
      { NULL } },
};

/* The main documentation menu */
DMenu MenuDocumentation = {
    DMENU_NORMAL_TYPE,
    "$$$$00171 FreeBSD Documentation Menu",
    "$$$$00172 If you are at all unsure about the configuration of your hardware\n"
    "or are looking to build a system specifically for FreeBSD, read the\n"
    "Hardware guide!  New users should also read the Install document for\n"
    "a step-by-step tutorial on installing FreeBSD.  For general information,\n"
    "consult the README file.",
    "$$$$00173 Confused?  Press F1 for help.",
    "usage",
    { { "X Exit",	"$$$$00191 Exit this menu (returning to previous)",	NULL, dmenuExit },
      { "2 README",	"$$$$00175 A general description of FreeBSD.  Read this!", NULL, dmenuDisplayFile, NULL, "README" },
      { "3 Hardware",	"$$$$00177 The FreeBSD survival guide for PC hardware.",	NULL, dmenuDisplayFile,	NULL, "HARDWARE" },
      { "4 Install",	"$$$$00179 A step-by-step guide to installing FreeBSD.",	NULL, dmenuDisplayFile,	NULL, "INSTALL" },
      { "5 Copyright",	"$$$$00181 The FreeBSD Copyright notices.",		NULL, dmenuDisplayFile,	NULL, "COPYRIGHT" },
      { "6 Release",	"$$$$00183 The release notes for this version of FreeBSD.", NULL, dmenuDisplayFile, NULL, "RELNOTES" },
      { "7 Shortcuts",	"$$$$00185 Creating shortcuts to sysinstall.",		NULL, dmenuDisplayFile, NULL, "shortcuts" },
      { "8 HTML Docs",	"$$$$00187 Go to the HTML documentation menu (post-install).", NULL, docBrowser },
#ifdef MULTILINGUAL
      { "L Localize",	"$$$$00188 A Guide to Multilingual FreeBSD Install Floppy",		NULL, dmenuDisplayFile, NULL, "LOCALIZE" },
#endif
      { NULL } },
};

DMenu MenuMouseType = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$32141 Select a protocol type for your mouse",
    "$$$$32142 If your mouse is attached to the PS/2 mouse port or the bus mouse port,\n"
    "you should always choose \"Auto\", regardless of the model and the brand\n"
    "of the mouse.  All other protocol types are for serial mice and should\n"
    "not be used with the PS/2 port mouse or the bus mouse.  If you have\n"
    "a serial mouse and are not sure about its protocol, you should also try\n"
    "\"Auto\".  It may not work for the serial mouse if the mouse does not\n"
    "support the PnP standard.  But, it won't hurt.  Many 2-button serial mice\n"
    "are compatible with \"Microsoft\" or \"MouseMan\".  3-button serial mice\n"
    "may be compatible with \"MouseSystems\" or \"MouseMan\".  If the serial\n"
    "mouse has a wheel, it may be compatible with \"IntelliMouse\".",
    NULL,
    NULL,
    { { "1 Auto",	"$$$$32143 Bus mouse, PS/2 style mouse or PnP serial mouse",	
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=auto" },
      { "2 GlidePoint",	"$$$$32144 ALPS GlidePoint pad (serial)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=glidepoint" },
      { "3 Hitachi",	"$$$$32145 Hitachi tablet (serial)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=mmhittab" },
      { "4 IntelliMouse", "$$$$32146 Microsoft IntelliMouse (serial)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=intellimouse" },
      { "5 Logitech",	"$$$$32147 Logitech protocol (old models) (serial)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=logitech" },
      { "6 Microsoft",	"$$$$32148 Microsoft protocol (serial)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=microsoft" },
      { "7 MM Series",	"$$$$32149 MM Series protocol (serial)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=mmseries" },
      { "8 MouseMan",	"$$$$32150 Logitech MouseMan/TrackMan models (serial)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=mouseman" },
      { "9 MouseSystems", "$$$$32151 MouseSystems protocol (serial)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=mousesystems" },
      { "A ThinkingMouse", "$$$$32152 Kensington ThinkingMouse (serial)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_TYPE "=thinkingmouse" },
      { NULL } },
};

DMenu MenuMousePort = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$32160 Select your mouse port from the following menu",
    "$$$$32161 The built-in pointing device of laptop/notebook computers is usually\n"
    "a PS/2 style device.",
    NULL,
    NULL,
    { { "1 PS/2",	"$$$$32162 PS/2 style mouse (/dev/psm0)", 
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/psm0" },
      { "2 COM1",	"$$$$32163 Serial mouse on COM1 (/dev/cuaa0)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/cuaa0" },
      { "3 COM2",	"$$$$32164 Serial mouse on COM2 (/dev/cuaa1)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/cuaa1" },
      { "4 COM3",	"$$$$32165 Serial mouse on COM3 (/dev/cuaa2)",
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/cuaa2" },
      { "5 COM4",	"$$$$32166 Serial mouse on COM4 (/dev/cuaa3)", 
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/cuaa3" },
      { "6 BusMouse",	"$$$$32167 Logitech, ATI or MS bus mouse (/dev/mse0)", 
	dmenuVarCheck, dmenuSetVariable, NULL, VAR_MOUSED_PORT "=/dev/mse0" },
      { NULL } },
};

DMenu MenuMouse = {
    DMENU_NORMAL_TYPE,
    "$$$$32170 Please configure your mouse",
    "$$$$32252 You can cut and paste text in the text console by running the mouse\n"
    "daemon.  Specify a port and a protocol type of your mouse and enable\n"
    "the mouse daemon.  If you don't want this feature, select 6 to disable\n"
    "the daemon.\n"
    "Once you've enabled the mouse daemon, you can specify \"/dev/sysmouse\"\n"
    "as your mouse device and \"SysMouse\" or \"MouseSystems\" as mouse\n"
    "protocol when running the X configuration utility (see Configuration\n"
    "menu).",
    NULL,
    NULL,
    { { "X Exit",	"$$$$32180 Exit this menu (returning to previous)", NULL, dmenuExit },
      { "2 Enable",	"$$$$32172 Test and run the mouse daemon", NULL, mousedTest, NULL, NULL },
      { "3 Type",	"$$$$32174 Select mouse protocol type", NULL, dmenuSubmenu, NULL, &MenuMouseType },
      { "4 Port",	"$$$$32176 Select mouse port", NULL, dmenuSubmenu, NULL, &MenuMousePort },
      { "5 Flags",      "$$$$32175 Set additional flags", dmenuVarCheck, setMouseFlags,
	NULL, VAR_MOUSED_FLAGS "=" },
      { "6 Disable",	"$$$$32178 Disable the mouse daemon", NULL, mousedDisable, NULL, NULL },
      { NULL } },
};

DMenu MenuMediaCDROM = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00211 Choose a CD/DVD type",
    "$$$$00212 FreeBSD can be installed directly from a CD/DVD containing a valid\n"
    "FreeBSD distribution.  If you are seeing this menu it is because\n"
    "more than one CD/DVD drive was found on your system.  Please select one\n"
    "of the following CD/DVD drives as your installation drive.",
    "$$$$00213 Press F1 to read the installation guide",
    "INSTALL",
    { { NULL } },
};

DMenu MenuMediaFloppy = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00215 Choose a Floppy drive",
    "$$$$00216 You have more than one floppy drive.  Please choose which drive\n"
    "you would like to use.",
    NULL,
    NULL,
    { { NULL } },
};

DMenu MenuMediaDOS = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00221 Choose a DOS partition",
    "$$$$00222 FreeBSD can be installed directly from a DOS partition\n"
    "assuming, of course, that you have copied the relevant\n"
    "distributions into your DOS partition before starting this\n"
    "installation.  If this is not the case then you should reboot\n"
    "DOS at this time and copy the distributions you wish to install\n"
    "into a \"FREEBSD\" subdirectory on one of your DOS partitions.\n"
    "Otherwise, please select the DOS partition containing the FreeBSD\n"
    "distribution files.",
    "$$$$00223 Press F1 to read the installation guide",
    "INSTALL",
    { { NULL } },
};

DMenu MenuMediaFTP = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00225 Please select a FreeBSD FTP distribution site",
    "$$$$00226 Please select the site closest to you or \"other\" if you'd like to\n"
    "specify a different choice.  Also note that not every site listed here\n"
    "carries more than the base distribution kits. Only the Primary site is\n"
    "guaranteed to carry the full range of possible distributions.",
    "$$$$00227 Select a site that's close!",
    "INSTALL",
    { { "Primary Site",	"ftp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.freebsd.org" },
      { "URL", "$$$$00231 Specify some other ftp site by URL", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=other" },
      { " 5.0 SNAP Server", "current.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://current.freebsd.org" },
      { " 4.0 SNAP Server", "releng4.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://releng4.freebsd.org/pub/FreeBSD/snapshots/" },
      { " IPv6 Ready", "ftp2.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.jp.freebsd.org" },
      { " IPv6 Ready #2", "ftp7.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp7.jp.freebsd.org" },
      { "Argentina",	"ftp.ar.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.ar.freebsd.org" },
      { " Australia",	"ftp.au.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.au.freebsd.org" },
      { " Australia #2","ftp2.au.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.au.freebsd.org" },
      { " Australia #3","ftp3.au.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.au.freebsd.org" },
      { " Australia #4","ftp4.au.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp4.au.freebsd.org" },
      { " Australia #5","ftp5.au.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp5.au.freebsd.org" },
      { "Brazil",	"ftp.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.br.freebsd.org" },
      { " Brazil #2",	"ftp2.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.br.freebsd.org" },
      { " Brazil #3",	"ftp3.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.br.freebsd.org" },
      { " Brazil #4",	"ftp4.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp4.br.freebsd.org" },
      { " Brazil #5",	"ftp5.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp5.br.freebsd.org" },
      { " Brazil #6",	"ftp6.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp6.br.freebsd.org" },
      { " Brazil #7",	"ftp7.br.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp7.br.freebsd.org" },
      { " Canada",	"ftp.ca.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.ca.freebsd.org" },
      { " Czech Republic", "ftp.cz.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.cz.freebsd.org" },
      { "Denmark",	"ftp.dk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.dk.freebsd.org" },
      { " Denmark #2",	"ftp2.dk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.dk.freebsd.org" },
      { "Estonia",	"ftp.ee.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.ee.freebsd.org" },
      { "Finland",	"ftp.fi.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.fi.freebsd.org" },
      { " France",	"ftp.fr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.fr.freebsd.org" },
      { " France #1",	"ftp.fr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.fr.freebsd.org" },
      { " France #2",	"ftp2.fr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.fr.freebsd.org" },
      { " France #3",	"ftp3.fr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.fr.freebsd.org" },
      { " France #4",	"ftp4.fr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp4.fr.freebsd.org" },
      { " France #5",	"ftp5.fr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp5.fr.freebsd.org" },
      { " France #6",	"ftp6.fr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp6.fr.freebsd.org" },
      { "Germany",	"ftp.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.de.freebsd.org" },
      { " Germany #2",	"ftp2.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.de.freebsd.org" },
      { " Germany #3",	"ftp3.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.de.freebsd.org" },
      { " Germany #4",	"ftp4.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp4.de.freebsd.org" },
      { " Germany #5",	"ftp5.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp5.de.freebsd.org" },
      { " Germany #6",	"ftp6.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp6.de.freebsd.org" },
      { " Germany #7",	"ftp7.de.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp7.de.freebsd.org" },
      { " Greece",	"ftp.gr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.gr.freebsd.org" },
      { " Greece #2",	"ftp2.gr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.gr.freebsd.org" },
      { "Holland",	"ftp.nl.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.nl.freebsd.org" },
      { " Hong Kong",	"ftp.hk.super.net", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.hk.super.net" },
      { " Hungary",     "ftp.hu.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.hu.freebsd.org" },
      { "Iceland",	"ftp.is.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.is.freebsd.org" },
      { " Ireland",	"ftp.ie.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.ie.freebsd.org" },
      { " Israel",	"ftp.il.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.il.freebsd.org" },
      { " Israel #2",	"ftp2.il.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.il.freebsd.org" },
      { "Japan",	"ftp.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.jp.freebsd.org" },
      { " Japan #2",	"ftp2.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.jp.freebsd.org" },
      { " Japan #3",	"ftp3.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.jp.freebsd.org" },
      { " Japan #4",	"ftp4.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp4.jp.freebsd.org" },
      { " Japan #5",	"ftp5.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp5.jp.freebsd.org" },
      { " Japan #6",	"ftp6.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp6.jp.freebsd.org" },
      { " Japan #7",	"ftp7.jp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp7.jp.freebsd.org" },
      { "Korea",	"ftp.kr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.kr.freebsd.org" },
      { " Korea #2",	"ftp2.kr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.kr.freebsd.org" },
      { " Korea #3",	"ftp3.kr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.kr.freebsd.org" },
      { " Korea #4",	"ftp4.kr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp4.kr.freebsd.org" },
      { " Korea #5",	"ftp5.kr.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp5.kr.freebsd.org" },
      { "Lithuania",	"ftp.lt.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.lt.freebsd.org" },
      { "New Zealand",	"ftp.nz.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.nz.freebsd.org" },
      { "Norway",	"ftp.no.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.no.freebsd.org" },
      { "Poland",	"ftp.pl.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.pl.freebsd.org" },
      { " Portugal",	"ftp.pt.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.pt.freebsd.org" },
      { " Portugal #2",	"ftp2.pt.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.pt.freebsd.org" },
      { "Romania",	"ftp.ro.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.ro.freebsd.org" },
      { " Russia",	"ftp.ru.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.ru.freebsd.org" },
      { " Russia #2",	"ftp2.ru.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.ru.freebsd.org" },
      { " Russia #3",	"ftp3.ru.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.ru.freebsd.org" },
      { " Russia #4",    "ftp4.ru.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp4.ru.freebsd.org" },
      { "Slovak Republic",	"ftp.sk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.sk.freebsd.org" },
      { "Slovenia",	"ftp.si.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.si.freebsd.org" },
      { " South Africa",	"ftp.za.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.za.freebsd.org" },
      { " South Africa #2", "ftp2.za.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.za.freebsd.org" },
      { " South Africa #3", "ftp3.za.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.za.freebsd.org" },
      { " South Africa #4", "ftp4.za.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp4.za.freebsd.org" },
      { " Spain",	"ftp.es.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.es.freebsd.org" },
      { " Spain #2",	"ftp2.es.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.es.freebsd.org" },
      { " Spain #3",	"ftp3.es.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.es.freebsd.org" },
      { " Sweden",	"ftp.se.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.se.freebsd.org" },
      { " Sweden #2",	"ftp2.se.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.se.freebsd.org" },
      { " Sweden #3",	"ftp3.se.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.se.freebsd.org" },
      { "Taiwan",	"ftp.tw.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.tw.freebsd.org" },
      { " Taiwan #2",	"ftp2.tw.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.tw.freebsd.org" },
      { " Taiwan #3",	"ftp3.tw.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.tw.freebsd.org" },
      { " Taiwan #4",   "ftp4.tw.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp4.tw.freebsd.org" },
      { " Thailand",	"ftp.nectec.or.th", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.nectec.or.th/pub/mirrors/FreeBSD/" },
      { "UK",		"ftp.uk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.uk.freebsd.org" },
      { " UK #2",	"ftp2.uk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.uk.freebsd.org" },
      { " UK #3",	"ftp3.uk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.uk.freebsd.org" },
      { " UK #4",	"ftp4.uk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp4.uk.freebsd.org" },
      { " UK #5",	"ftp5.uk.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp5.uk.freebsd.org" },
      { " Ukraine",	"ftp.ua.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.ua.freebsd.org" },
      { " Ukraine #2",	"ftp2.ua.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.ua.freebsd.org" },
      { " Ukraine #3",	"ftp3.ua.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.ua.freebsd.org" },
      { " USA",		"ftp.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp.freebsd.org" },
      { " USA #2",	"ftp2.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp2.freebsd.org" },
      { " USA #3",	"ftp3.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp3.freebsd.org" },
      { " USA #4",	"ftp4.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp4.freebsd.org" },
      { " USA #5",	"ftp5.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp5.freebsd.org" },
      { " USA #6",	"ftp6.freebsd.org", NULL, dmenuSetVariable, NULL,
	VAR_FTP_PATH "=ftp://ftp6.freebsd.org" },
      { NULL } }
};

DMenu MenuMediaTape = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00345 Choose a tape drive type",
    "$$$$00346 FreeBSD can be installed from tape drive, though this installation\n"
    "method requires a certain amount of temporary storage in addition\n"
    "to the space required by the distribution itself (tape drives make\n"
    "poor random-access devices, so we extract _everything_ on the tape\n"
    "in one pass).  If you have sufficient space for this, then you should\n"
    "select one of the following tape devices detected on your system.",
    "$$$$00347 Press F1 to read the installation guide",
    "INSTALL",
    { { NULL } },
};

DMenu MenuNetworkDevice = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00351 Network interface information required",
    "$$$$00352 If you are using PPP over a serial device, as opposed to a direct\n"
    "ethernet connection, then you may first need to dial your Internet\n"
    "Service Provider using the ppp utility we provide for that purpose.\n"
    "If you're using SLIP over a serial device then the expectation is\n"
    "that you have a HARDWIRED connection.\n\n"
    "You can also install over a parallel port using a special \"laplink\"\n"
    "cable to another machine running a fairly recent (2.0R or later)\n"
    "version of FreeBSD.",
    "$$$$00353 Press F1 to read network configuration manual",
    "network_device",
    { { NULL } },
};

/* Prototype KLD load menu */
DMenu MenuKLD = {
    DMENU_NORMAL_TYPE,
    "KLD Menu",
    "Load a KLD from a floppy\n",
    NULL,
    NULL,
    { { NULL } },
};

/* The media selection menu */
DMenu MenuMedia = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00355 Choose Installation Media",
    "$$$$00356 FreeBSD can be installed from a variety of different installation\n"
    "media, ranging from floppies to an Internet FTP server.  If you're\n"
    "installing FreeBSD from a supported CD/DVD drive then this is generally\n"
    "the best media to use if you have no overriding reason for using other\n"
    "media.",
    "$$$$00357 Press F1 for more information on the various media types",
    "media",
    { { "1 CD/DVD",		"$$$$00359 Install from a FreeBSD CD/DVD",		NULL, mediaSetCDROM },
      { "2 FTP",		"$$$$00361 Install from an FTP server",		NULL, mediaSetFTPActive },
      { "3 FTP Passive",	"$$$$00363 Install from an FTP server through a firewall", NULL, mediaSetFTPPassive },
      { "4 HTTP",		"$$$$00364 Install from an FTP server through a http proxy", NULL, mediaSetHTTP },
      { "5 DOS",		"$$$$00365 Install from a DOS partition",		NULL, mediaSetDOS },
      { "6 NFS",		"$$$$00367 Install over NFS",			NULL, mediaSetNFS },
      { "7 File System",	"$$$$00369 Install from an existing filesystem",	NULL, mediaSetUFS },
      { "8 Floppy",		"$$$$00371 Install from a floppy disk set",	NULL, mediaSetFloppy },
      { "9 Tape",		"$$$$00373 Install from SCSI or QIC tape",	NULL, mediaSetTape },
      { "X Options",		"$$$$32085 Go to the Options screen",		NULL, optionsEditor },
      { NULL } },
};

/* The distributions menu */
DMenu MenuDistributions = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00375 Choose Distributions",
    "$$$$00376 As a convenience, we provide several \"canned\" distribution sets.\n"
    "These select what we consider to be the most reasonable defaults for the\n"
    "type of system in question.  If you would prefer to pick and choose the\n"
    "list of distributions yourself, simply select \"Custom\".  You can also\n"
    "pick a canned distribution set and then fine-tune it with the Custom item.\n\n"
    "Choose an item by pressing [SPACE] or [ENTER].  When finished, choose the\n"
    "Exit item or move to the OK button with [TAB].",
    "$$$$00377 Press F1 for more information on these options.",
    "distributions",
    { { "X Exit",		"$$$$00397 Exit this menu (returning to previous)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
      { "All",			"$$$$00391 All system sources, binaries and X Window System)",
	checkDistEverything,	distSetEverything, NULL, NULL, ' ', ' ', ' ' },
      { "Reset",		"$$$$00395 Reset selected distribution list to nothing",
	NULL,			distReset, NULL, NULL, ' ', ' ', ' ' },
      { "4 Developer",		"$$$$00379 Full sources, binaries and doc but no games", 
	checkDistDeveloper,	distSetDeveloper },
      { "5 X-Developer",	"$$$$00381 Same as above + X Window System",
	checkDistXDeveloper,	distSetXDeveloper },
      { "6 Kern-Developer",	"$$$$00383 Full binaries and doc, kernel sources only",
	checkDistKernDeveloper, distSetKernDeveloper },
      { "7 X-Kern-Developer",	"$$$$32060 Same as above + X Window System",
	checkDistXKernDeveloper, distSetXKernDeveloper },
      { "8 User",		"$$$$00385 Average user - binaries and doc only",
	checkDistUser,		distSetUser },
      { "9 X-User",		"$$$$32062 Same as above + X Window System",
	checkDistXUser,		distSetXUser },
      { "A Minimal",		"$$$$00389 The smallest configuration possible",
	checkDistMinimum,	distSetMinimum },
      { "B Custom",		"$$$$00393 Specify your own distribution set",
	NULL,			dmenuSubmenu, NULL, &MenuSubDistributions, '>', '>', '>' },
      { NULL } },
};

DMenu MenuSubDistributions = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00401 Select the distributions you wish to install.",
    "$$$$00402 Please check off the distributions you wish to install.  At the\n"
    "very minimum, this should be \"bin\".",
    NULL,
    NULL,
    { { "X Exit",	"$$$$00438 Exit this menu (returning to previous)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
      { "All",		"$$$$00434 All system sources, binaries and X Window System",
	NULL, distSetEverything, NULL, NULL, ' ', ' ', ' ' },
      { "Reset",	"$$$$00436 Reset all of the below",
	NULL, distReset, NULL, NULL, ' ', ' ', ' ' },
      { " bin",		"$$$$00404 Binary base distribution (required)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_BIN },
#ifdef __i386__
      { " compat1x",	"$$$$00408 FreeBSD 1.x binary compatibility",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_COMPAT1X },
      { " compat20",	"$$$$00410 FreeBSD 2.0 binary compatibility",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_COMPAT20 },
      { " compat21",	"$$$$00412 FreeBSD 2.1 binary compatibility",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_COMPAT21 },
      { " compat22",	"$$$$31279 FreeBSD 2.2.x and 3.0 a.out binary compatibility",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_COMPAT22 },
#if __FreeBSD__ > 3
      { " compat3x",	"$$$$31280 FreeBSD 3.x binary compatibility",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_COMPAT3X },
#endif
#if __FreeBSD__ >= 4
      { " compat4x",	"$$$$32020 FreeBSD 4.x binary compatibility",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_COMPAT4X },
#endif
#endif
      { " crypto",	"$$$$00444 Basic encryption services",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &CRYPTODists, '[', 'X', ']', DIST_CRYPTO_CRYPTO, },
#if __FreeBSD__ <= 3
      { " krb",		"$$$$00445 KerberosIV authentication services",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &CRYPTODists, '[', 'X', ']', DIST_CRYPTO_KERBEROS },
#else
      { " krb4",	"$$$$00446 KerberosIV authentication services",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &CRYPTODists, '[', 'X', ']', DIST_CRYPTO_KERBEROS4 },
      { " krb5",	"$$$$00447 Kerberos5 authentication services",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &CRYPTODists, '[', 'X', ']', DIST_CRYPTO_KERBEROS5 },
#endif
      { " dict",	"$$$$00416 Spelling checker dictionary files",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_DICT },
      { " doc",		"$$$$00418 Miscellaneous FreeBSD online docs",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_DOC },
      { " games",	"$$$$00420 Games (non-commercial)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_GAMES },
      { " info",	"$$$$00422 GNU info files",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_INFO },
      { " man",		"$$$$00424 System manual pages - recommended",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_MANPAGES },
      { " catman",	"$$$$32030 Preformatted system manual pages",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_CATPAGES },
      { " proflibs",	"$$$$00426 Profiled versions of the libraries",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_PROFLIBS },
      { " src",		"$$$$00428 Sources for everything",
	srcFlagCheck,	distSetSrc },
      { " ports",	"$$$$32032 The FreeBSD Ports collection",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_PORTS },
      { " local",	"$$$$32034 Local additions collection",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &Dists, '[', 'X', ']', DIST_LOCAL},
      { " XFree86",	"$$$$00430 The XFree86 3.3.6 distribution",
	x11FlagCheck,	distSetXF86 },
      { NULL } },
};

DMenu MenuSrcDistributions = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00455 Select the sub-components of src you wish to install.",
    "$$$$00456 Please check off those portions of the FreeBSD source tree\n"
    "you wish to install.",
    NULL,
    NULL,
    { { "X Exit",	"$$$$00494 Exit this menu (returning to previous)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
      { "All",		"$$$$00490 Select all of the below",
	NULL,		setSrc, NULL, NULL, ' ', ' ', ' ' },
      { "Reset",	"$$$$00492 Reset all of the below",
	NULL,		clearSrc, NULL, NULL, ' ', ' ', ' ' },
      { " base",	"$$$$00458 top-level files in /usr/src",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_BASE },
      { " contrib",	"$$$$00880 /usr/src/contrib (contributed software)",
	dmenuFlagCheck,	dmenuSetFlag,	NULL, &SrcDists, '[', 'X', ']', DIST_SRC_CONTRIB },
      { " gnu",		"$$$$00460 /usr/src/gnu (software from the GNU Project)",
	dmenuFlagCheck,	dmenuSetFlag,	NULL, &SrcDists, '[', 'X', ']', DIST_SRC_GNU },
      { " etc",		"$$$$00462 /usr/src/etc (miscellaneous system files)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_ETC },
      { " games",	"$$$$00464 /usr/src/games (the obvious!)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_GAMES },
      { " include",	"$$$$00466 /usr/src/include (header files)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_INCLUDE },
      { " lib",		"$$$$00468 /usr/src/lib (system libraries)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_LIB },
      { " libexec",	"$$$$00470 /usr/src/libexec (system programs)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_LIBEXEC },
      { " release",	"$$$$00474 /usr/src/release (release-generation tools)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_RELEASE },
      { " bin",		"$$$$00476 /usr/src/bin (system binaries)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_BIN },
      { " sbin",	"$$$$00478 /usr/src/sbin (system binaries)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_SBIN },
      { " scrypto",	"$$$$32210 /usr/src/crypto (contrib encryption sources)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &CRYPTODists, '[', 'X', ']', DIST_CRYPTO_SCRYPTO },
      { " share",	"$$$$00480 /usr/src/share (documents and shared files)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_SHARE },
      { " skrb4",	"$$$$00448 /usr/src/kerberosIV (sources for KerberosIV)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &CRYPTODists, '[', 'X', ']', DIST_CRYPTO_SKERBEROS4 },
      { " skrb5",	"$$$$00449 /usr/src/kerberos5 (sources for Kerberos5)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &CRYPTODists, '[', 'X', ']', DIST_CRYPTO_SKERBEROS5 },
      { " ssecure",	"$$$$00450 /usr/src/secure (BSD encryption sources)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &CRYPTODists, '[', 'X', ']', DIST_CRYPTO_SSECURE },
      { " sys",		"$$$$00482 /usr/src/sys (FreeBSD kernel)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_SYS },
      { " tools",	"$$$$00483 /usr/src/tools (miscellaneous tools)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_TOOLS },
      { " ubin",	"$$$$00484 /usr/src/usr.bin (user binaries)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_UBIN },
      { " usbin",	"$$$$00486 /usr/src/usr.sbin (aux system binaries)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &SrcDists, '[', 'X', ']', DIST_SRC_USBIN },
      { NULL } },
};

DMenu MenuXF86Config = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$32010 Please select the XFree86 configuration tool you want to use.",
#ifdef __alpha__
    "Due to problems with the VGA16 server right now, only the\n"
    "text-mode configuration tool (xf86config) is currently supported.",
#else
    "$$$$32011 The first tool, XF86Setup, is fully graphical and requires the\n"
    "VGA16 server in order to work (should have been selected by\n"
    "default, but if you de-selected it then you won't be able to\n"
    "use this fancy setup tool).  The second tool, xf86config, is\n"
    "a more simplistic shell-script based tool and less friendly to\n"
    "new users, but it may work in situations where the fancier one\n"
    "does not.",
#endif
    NULL,
    NULL,
    { { "X Exit",	"$$$$32012 Exit this menu (returning to previous)",
	NULL, dmenuExit },
#ifdef __alpha__
      { "2 xf86config",	"$$$$32014 Shell-script based XFree86 configuration tool.",
	NULL, dmenuSetVariable, NULL, VAR_XF86_CONFIG "=xf86config" },
#else
      { "2 XF86Setup",	"$$$$32013 Fully graphical XFree86 configuration tool.",
	NULL, dmenuSetVariable, NULL, VAR_XF86_CONFIG "=XF86Setup" },
      { "3 xf86config",	"$$$$32064 Shell-script based XFree86 configuration tool.",
	NULL, dmenuSetVariable, NULL, VAR_XF86_CONFIG "=xf86config" },
#ifdef PC98
      { "4 XF98Setup",	"$$$$32190 Fully graphical XFree86 configuration tool (PC98).",
	NULL, dmenuSetVariable, NULL, VAR_XF86_CONFIG "=XF98Setup" },
#endif
#endif
      { "D XDesktop",	"$$$$32271 X already set up, just do desktop configuration.",
	NULL, dmenuSubmenu, NULL, &MenuXDesktops },
      { NULL } },
};

DMenu MenuXDesktops = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$32272 Please select the default X desktop to use.",
    "$$$$32273 By default, XFree86 comes with a fairly vanilla desktop which\n"
    "is based around the twm(1) window manager and does not offer\n"
    "much in the way of features.  It does have the advantage of\n"
    "being a standard part of X so you don't need to load anything\n"
    "extra in order to use it.  If, however, you have access to a\n"
    "reasonably full packages collection on your installation media,\n"
    "you can choose any one of the following desktops as alternatives.",
    NULL,
    NULL,
    { { "X Exit",		"$$$$32280 Exit this menu (returning to previous)",
	NULL, dmenuExit },
      { "2 KDE",		"$$$$32274 The K Desktop Environment.",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=kde" },
      { "3 GNOME + Sawfish",	"$$$$32300 GNOME + Sawfish window manager.",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=gnome" },
      { "4 GNOME + Enlightenment", "$$$$32278 GNOME + The E window manager",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=enlightenment" },
      { "5 Afterstep",		"$$$$32276 The Afterstep window manager",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=afterstep" },
      { "6 Windowmaker",	"$$$$32277 The Windowmaker window manager",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=windowmaker" },
      { "7 fvwm",		"$$$$32279 The fvwm window manager",
	NULL, dmenuSetVariable, NULL, VAR_DESKSTYLE "=fvwm2" },
      { NULL } },
};

DMenu MenuXF86Select = {
    DMENU_NORMAL_TYPE,
    "$$$$00495 XFree86 3.3.6 Distribution",
    "$$$$00496 Please select the components you need from the XFree86 3.3.6\n"
    "distribution sets.",
    NULL,
    NULL,
    { { "X Exit",	"$$$$00509 Exit this menu (returning to previous)", NULL, dmenuExit },
      { "Basic",	"$$$$00499 Basic component menu (required)",	NULL, dmenuSubmenu, NULL, &MenuXF86SelectCore },
      { "Server",	"$$$$00501 X server menu",			NULL, dmenuSubmenu, NULL, &MenuXF86SelectServer },
      { "Fonts",	"$$$$00503 Font set menu",			NULL, dmenuSubmenu, NULL, &MenuXF86SelectFonts },
      { NULL } },
};

DMenu MenuXF86SelectCore = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00511 XFree86 3.3.6 base distribution types",
    "$$$$00512 Please check off the basic XFree86 components you wish to install.\n"
    "Bin, lib, and set are recommended for a minimum installaion.",
    NULL,
    NULL,
    { { "X Exit",	"$$$$00545 Exit this menu (returning to previous)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
      { "All",		"$$$$00543 Select all below",
	NULL,		setX11Misc, NULL, NULL, ' ', ' ', ' ' },
      { "Reset",	"$$$$00541 Reset all below",
	NULL,		clearX11Misc, NULL, NULL, ' ', ' ', ' ' },
      { " bin",         "$$$$00515 Client applications and shared libs",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_BIN },
      { " lib",         "$$$$00517 Data files needed at runtime",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_LIB },
      { " cfg",         "$$$$00885 Configuration files",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_CFG },
      { " set",         "$$$$00890 XFree86 Setup Utility",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_SET },
      { " man",         "$$$$00527 Manual pages",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_MAN },
      { " doc",         "$$$$00525 READMEs and release notes",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_DOC },
      { " html",        "$$$$00886 HTML documentation files",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_HTML },
      { " lkit",        "$$$$00888 Server link kit for all other machines",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_LKIT },
      { " prog",        "$$$$00531 Programmer's header and library files",
	dmenuFlagCheck, dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_PROG },
#if defined(__i386__) && defined(PC98)
      { " 9set",	"$$$$32220 XFree86 Setup Utility for PC98 machines",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_9SET },
      { " lk98",	"$$$$00887 Server link kit for PC98 machines",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86Dists, '[', 'X', ']', DIST_XF86_LKIT98 },
#endif
      { NULL } },
};

DMenu MenuXF86SelectFonts = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00551 Font distribution selection.",
    "$$$$00552 Please check off the individual font distributions you wish to\n\
install.  At the minimum, you should install the standard\n\
75 DPI and misc fonts if you're also installing a server\n\
(these are selected by default).",
    NULL,
    NULL,
    { { "X Exit",	"$$$$00571 Exit this menu (returning to previous)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
      { "All",		"$$$$00567 All fonts",
	NULL,		setX11Fonts, NULL, NULL, ' ', ' ', ' ' },
      { "Reset",	"$$$$00569 Reset font selections",
	NULL,		clearX11Fonts, NULL, NULL, ' ', ' ', ' ' },
      { " fnts",	"$$$$00555 Standard 75 DPI and miscellaneous fonts",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_MISC },
      { " f100",	"$$$$00557 100 DPI fonts",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_100 },
      { " fcyr",	"$$$$00559 Cyrillic Fonts",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_CYR },
      { " fscl",	"$$$$00561 Speedo and Type scalable fonts",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_SCALE },
      { " non",		"$$$$00563 Japanese, Chinese and other non-english fonts",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_NON },
      { " server",	"$$$$00565 Font server",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86FontDists, '[', 'X', ']', DIST_XF86_FONTS_SERVER },
      { NULL } },
};

DMenu MenuXF86SelectServer = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00575 X Server selection.",
    "$$$$00576 Please check off the types of X servers you wish to install.\n"
    "If you are unsure as to which server will work for your graphics card,\n"
    "it is recommended that try the SVGA or VGA16 servers or, for PC98\n"
    "machines, the 9EGC or 9840 servers.",
    NULL,
    NULL,
    { { "X Exit",	"$$$$00607 Exit this menu (returning to previous)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
      { "All",		"$$$$00603 Select all of the above",
	NULL,		setX11Servers, NULL, NULL, ' ', ' ', ' ' },
      { "Reset",	"$$$$00605 Reset all of the above",
	NULL,		clearX11Servers, NULL, NULL, ' ', ' ', ' ' },
      { " SVGA",	"$$$$00579 Standard VGA or Super VGA card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_SVGA },
      { " VGA16",	"$$$$00581 Standard 16 color VGA card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_VGA16 },
      { " Mono",	"$$$$00583 Standard Monochrome card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_MONO },
      { " 3DL",		"$$$$00584 8, 16 and 24 bit color 3D Labs boards",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_3DL },
      { " 8514",	"$$$$00585 8-bit (256 color) IBM 8514 or compatible card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_8514 },
      { " AGX",		"$$$$00587 8-bit AGX card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_AGX },
      { " I128",	"$$$$00594 8, 16 and 24-bit #9 Imagine I128 card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_I128 },
      { " Ma8",		"$$$$00589 8-bit ATI Mach8 card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_MACH8 },
      { " Ma32",	"$$$$00591 8 and 16-bit (65K color) ATI Mach32 card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_MACH32 },
      { " Ma64",	"$$$$00593 8 and 16-bit (65K color) ATI Mach64 card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_MACH64 },
      { " P9K",		"$$$$00595 8, 16, and 24-bit color Weitek P9000 based boards",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_P9000 },
      { " S3",		"$$$$00597 8, 16 and 24-bit color S3 based boards",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_S3 },
      { " S3V",		"$$$$00895 8, 16 and 24-bit color S3 Virge based boards",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_S3V },
      { " W32",		"$$$$00599 8-bit ET4000/W32, /W32i and /W32p cards",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_W32 },
#if defined(__i386__) && defined(PC98)
      { " PC98",	"$$$$00893 Select an X server for a NEC PC98 [Submenu]",
	NULL,		dmenuSubmenu,  NULL, &MenuXF86SelectPC98Server, '>', ' ', '>', 0 },
#elif __alpha__
      { " TGA",		"$$$$00894 TGA cards (alpha architecture only)",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_TGA },
#endif
      { NULL } },
};

#if defined(__i386__) && defined(PC98)
DMenu MenuXF86SelectPC98Server = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00900 PC98 X Server selection.",
    "$$$$00901 Please check off the types of NEC PC98 X servers you wish to install.\n\
If you are unsure as to which server will work for your graphics card,\n\
it is recommended that try the SVGA or VGA16 servers (the VGA16 and\n\
Mono servers are particularly well-suited to most LCD displays).",
    NULL,
    NULL,
    { { "X Exit",	"$$$$00916 Exit this menu (returning to previous)",
	checkTrue,	dmenuExit, NULL, NULL, '<', '<', '<' },
      { " 9480",	"$$$$00903 PC98 8-bit (256 color) PEGC-480 card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9480 },
      { " 9EGC",	"$$$$00904 PC98 4-bit (16 color) EGC card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9EGC },
      { " 9GA9",	"$$$$00905 PC98 GA-968V4/PCI (S3 968) card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9GA9 },
      { " 9GAN",	"$$$$00906 PC98 GANB-WAP (cirrus) card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9GAN },
      { " 9LPW",	"$$$$00907 PC98 PowerWindowLB (S3) card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9LPW },
      { " 9MGA",	"$$$$32230 PC98 MGA (Matrox) card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9MGA },
      { " 9NKV",	"$$$$00908 PC98 NKV-NEC (cirrus) card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9NKV },
      { " 9NS3",	"$$$$00909 PC98 NEC (S3) card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9NS3 },
      { " 9SPW",	"$$$$00910 PC98 SKB-PowerWindow (S3) card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9SPW },
      { " 9SVG",	"$$$$32231 PC98 generic SVGA card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9SVG },
      { " 9TGU",	"$$$$00911 PC98 Cyber9320 and TGUI9680 cards",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9TGU },
      { " 9WEP",	"$$$$00912 PC98 WAB-EP (cirrus) card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9WEP },
      { " 9WS",		"$$$$00913 PC98 WABS (cirrus) card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9WS },
      { " 9WSN",	"$$$$00914 PC98 WSN-A2F (cirrus) card",
	dmenuFlagCheck,	dmenuSetFlag, NULL, &XF86ServerDists, '[', 'X', ']', DIST_XF86_SERVER_9WSN },
      { NULL } }
};
#endif

DMenu MenuDiskDevices = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00611 Select Drive(s)",
    "$$$$00612 Please select the drive, or drives, on which you wish to perform\n"
    "this operation.  If you are attempting to install a boot partition\n"
    "on a drive other than the first one or have multiple operating\n"
    "systems on your machine, you will have the option to install a boot\n"
    "manager later.  To select a drive, use the arrow keys to move to it\n"
    "and press [SPACE] or [ENTER].  To de-select it, press it again.\n\n"
    "Use [TAB] to get to the buttons and leave this menu.",
    "$$$$00613 Press F1 for important information regarding disk geometry!",
    "drives",
    { { NULL } },
};

DMenu MenuHTMLDoc = {
    DMENU_NORMAL_TYPE,
    "$$$$00615 Select HTML Documentation pointer",
    "$$$$00616 Please select the body of documentation you're interested in, the main\n"
    "ones right now being the FAQ and the Handbook.  You can also choose \"other\"\n"
    "to enter an arbitrary URL for browsing.",
    "$$$$00617 Press F1 for more help on what you see here.",
    "html",
    { { "X Exit",	"$$$$00618 Exit this menu (returning to previous)", NULL,	dmenuExit },
      { "2 Handbook",	"$$$$00619 The FreeBSD Handbook.",				NULL, docShowDocument },
      { "3 FAQ",	"$$$$00621 The Frequently Asked Questions guide.",		NULL, docShowDocument },
      { "4 Home",	"$$$$00623 The Home Pages for the FreeBSD Project (requires net)", NULL, docShowDocument },
      { "5 Other",	"$$$$00625 Enter a URL.",						NULL, docShowDocument },
      { NULL } },
};

/* The main installation menu */
DMenu MenuInstallCustom = {
    DMENU_NORMAL_TYPE,
    "$$$$00631 Choose Custom Installation Options",
    "$$$$00632 This is the custom installation menu. You may use this menu to specify\n"
    "details on the type of distribution you wish to have, where you wish\n"
    "to install it from and how you wish to allocate disk storage to FreeBSD.",
    "$$$$00633 Press F1 to read the installation guide",
    "INSTALL",
    { { "X Exit",		"$$$$00649 Exit this menu (returning to previous)", NULL,	dmenuExit },
      { "2 Options",		"$$$$00635 View/Set various installation options", NULL, optionsEditor },
#ifdef __alpha__
      { "3 Label",		"$$$$00640 Label disk partitions",		NULL, diskLabelEditor },
      { "4 Distributions",	"$$$$00641 Select distribution(s) to extract",	NULL, dmenuSubmenu, NULL, &MenuDistributions },
      { "5 Media",		"$$$$00643 Choose the installation media type",	NULL, dmenuSubmenu, NULL, &MenuMedia },
      { "6 Commit",		"$$$$00645 Perform any pending Partition/Label/Extract actions", NULL, installCustomCommit },
#else
      { "3 Partition",		"$$$$00637 Allocate disk space for FreeBSD",	NULL, diskPartitionEditor },
      { "4 Label",		"$$$$00639 Label allocated disk partitions",	NULL, diskLabelEditor },
      { "5 Distributions",	"$$$$32080 Select distribution(s) to extract",	NULL, dmenuSubmenu, NULL, &MenuDistributions },
      { "6 Media",		"$$$$32081 Choose the installation media type",	NULL, dmenuSubmenu, NULL, &MenuMedia },
      { "7 Commit",		"$$$$32082 Perform any pending Partition/Label/Extract actions", NULL, installCustomCommit },
#endif
      { NULL } },
};

/* MBR type menu */
DMenu MenuMBRType = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "overwrite me",		/* will be disk specific label */
    "$$$$00652 FreeBSD comes with a boot selector that allows you to easily\n"
    "select between FreeBSD and any other operating systems on your machine\n"
    "at boot time.  If you have more than one drive and want to boot\n"
    "from the second one, the boot selector will also make it possible\n"
    "to do so (limitations in the PC BIOS usually prevent this otherwise).\n"
    "If you do not want a boot selector, or wish to replace an existing\n"
    "one, select \"standard\".  If you would prefer your Master Boot\n"
    "Record to remain untouched then select \"None\".\n\n"
    "  NOTE:  PC-DOS users will almost certainly require \"None\"!",
    "$$$$00653 Press F1 to read about drive setup",
    "drives",
    { { "BootMgr",	"$$$$00655 Install the FreeBSD Boot Manager",
	dmenuRadioCheck, dmenuSetValue, NULL, &BootMgr },
#ifndef PC98
      { "Standard",	"$$$$00657 Install a standard MBR (no boot manager)",
	dmenuRadioCheck, dmenuSetValue, NULL, &BootMgr, '(', '*', ')', 1 },
#endif
      { "None",		"$$$$00659 Leave the Master Boot Record untouched",
	dmenuRadioCheck, dmenuSetValue, NULL, &BootMgr, '(', '*', ')', 2 },
      { NULL } },
};


/* snatched from passwd (1) */

static unsigned char itoa64[] =         /* 0 ... 63 => ascii - 64 */
        "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
#include <ctype.h>

static void
to64(char *s, long v, int n)
{
    while (--n >= 0) {
	*s++ = itoa64[v&0x3f];
	v >>= 6;
    }
}

int
passwdRoot(dialogMenuItem *self)
{
    struct timeval tv;
    int i;
    char *p1, *p2;
    char pw[256], cmd[256], salt[16];
    
    while (1) {
	variable_set2(ROOT_PASS1, "", 0);
	variable_set2(ROOT_PASS2, "", 0);
	DialogInputAttrs |= DITEM_NO_ECHO;
	dialog_clear_norefresh();
	p1 = variable_get_value(ROOT_PASS1, 
				"$$$$32065 Please type the password for\n"
				"\"root\" user (system manager):", 0);
	if (!p1) {
	    DialogInputAttrs &= ~DITEM_NO_ECHO;
	    return 1;
	}
	dialog_clear_norefresh();
	p2 = variable_get_value(ROOT_PASS2, 
				"$$$$32066 Please retype the password for\n"
				"\"root\" user (system manager) again:", 0);
	DialogInputAttrs &= ~DITEM_NO_ECHO;
	if (!p2)
	    goto tryagain;
	p1 = variable_get(ROOT_PASS1);
	p2 = variable_get(ROOT_PASS2);
	if (p1 && p2 && (strcmp(p1, p2) == 0)) {
	    int len = strlen(p1);
	    int alllower = 1, alldigit = 1;
		
	    if (len < 5) {
		msgConfirm("$$$$32069 Please enter a longer password.");
		goto tryagain;
	    }
	    for (i = 0; i < len; i++) {
		if (!islower(p1[i])) {
		    alllower = 0;
		}
		if (!isdigit(p1[i])) {
		    alldigit = 0;
		}
	    }
	    if (alllower || alldigit) {
		msgConfirm("$$$$32070 Please don't use an all-lower case or all-digit password.\n"
			   "Unusual capitalization, control characters or digits are suggested.");
		goto tryagain;
	    }
	    if (len < 5) {
		msgConfirm("$$$$32090 Please enter a longer password.");
		goto tryagain;
	    }
	    break;
	}
	dialog_clear_norefresh();
	msgConfirm("$$$$32067 Mismatch. Try Again.");
tryagain:
    }

    gettimeofday(&tv,0);
    (void)srandom((int)time((time_t *)NULL));

    strncpy(&salt[0], "$1$", 3);
    to64(&salt[3], random(), 3);
    to64(&salt[6], tv.tv_usec, 3);
    salt[8] = '\0';

    strcpy(pw, p1);
    sprintf(cmd, "chpass -p '%s' root", crypt(pw, salt));
    systemExecute(cmd);
    msgNotify("$$$$32068 Root password changed.");
    variable_set2(ROOT_PASS1, "", 0);
    variable_set2(ROOT_PASS2, "", 0);
    variable_set2("root_password", "YES", 0);
    sleep(2);

    return 0;
}


/* Final configuration menu */
DMenu MenuConfigure = {
    DMENU_NORMAL_TYPE,
    "$$$$00661 FreeBSD Configuration Menu",	/* title */
    "$$$$00662 If you've already installed FreeBSD, you may use this menu to customize\n"
    "it somewhat to suit your particular configuration.  Most importantly,\n"
    "you can use the Packages utility to load extra \"3rd party\"\n"
    "software not provided in the base distributions.",
    "$$$$00663 Press F1 for more information on these options",
    "configure",
    { { "X Exit",	"$$$$00689 Exit this menu (returning to previous)",
	NULL,	dmenuExit },
      { " Distributions", "$$$$32036 Install additional distribution sets",
	NULL, distExtractAll },
      { " Packages",	"$$$$00679 Install pre-packaged software for FreeBSD",
	NULL, configPackages },
      { " Root Password", "$$$$00683 Set the system manager's password",
	NULL,	passwdRoot },
#ifdef __i386__
      { " Fdisk",	"$$$$32040 The disk Slice (PC-style partition) Editor",
	NULL, diskPartitionEditor },
#endif
      { " Label",	"$$$$32038 The disk Label editor",
	NULL, diskLabelEditor },
      { " User Management", "$$$$00665 Add user and group information",
	NULL, dmenuSubmenu, NULL, &MenuUsermgmt },
      { " Console",	"$$$$00667 Customize system console behavior",
	NULL,	dmenuSubmenu, NULL, &MenuSyscons },
      { " Time Zone",	"$$$$00669 Set which time zone you're in",
	NULL,	tzsetup },
      { " Media",	"$$$$00671 Change the installation media type",
	NULL,	dmenuSubmenu, NULL, &MenuMedia },
      { " Mouse",	"$$$$00673 Configure your mouse",
	NULL,	dmenuSubmenu, NULL, &MenuMouse, NULL },
      { " Networking",	"$$$$00675 Configure additional network services",
	NULL,	dmenuSubmenu, NULL, &MenuNetworking },
      { " Security",	"$$$$00676 Select default system security profile",
	NULL,	dmenuSubmenu, NULL, &MenuSecurityProfile },
      { " Startup",	"$$$$32087 Configure system startup options",
	NULL,	dmenuSubmenu, NULL, &MenuStartup },
      { " TTYs",	"$$$$32021 Configure system ttys.",
	NULL,	configEtcTtys, NULL, "ttys" },
      { " Options",	"$$$$00677 View/Set various installation options",
	NULL, optionsEditor },
      { " XFree86",	"$$$$00687 Configure XFree86 Server",
	NULL, configXSetup },
      { " Desktop",	"$$$$32281 Configure XFree86 Desktop",
	NULL, configXDesktop },
      { " HTML Docs",	"$$$$00685 Go to the HTML documentation menu (post-install)",
	NULL, docBrowser },
      { " Load KLD",	"Load a KLD from a floppy",
	NULL, kldBrowser },
      { NULL } },
};

DMenu MenuStartup = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$32100 Startup Services Menu",
    "$$$$32101 This menu allows you to configure various aspects of your system's\n"
    "startup configuration.  Use [SPACE] or [ENTER] to select items, and\n"
    "[TAB] to move to the buttons.  Select Exit to leave this menu.",
    NULL,
    NULL,
    { { "X Exit",	"$$$$32131 Exit this menu (returning to previous)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
      { " APM",		"$$$$32103 Advanced-power management services (typically laptops)",
	dmenuVarCheck,	dmenuToggleVariable, NULL, "apm_enable=YES" },
      { " pccard",	"$$$$32105 Enable PCCARD (AKA PCMCIA) services (also laptops)",
	dmenuVarCheck, dmenuToggleVariable, NULL, "pccard_enable=YES" },
      { " pccard mem",	"$$$$32107 Set PCCARD memory address (if enabled)",
	dmenuVarCheck, dmenuISetVariable, NULL, "pccard_mem" },
      { " pccard ifconfig", "$$$$32314 List of PCCARD ethernet devices to configure",
	dmenuVarCheck, dmenuISetVariable, NULL, "pccard_ifconfig" },
      { " usbd", "$$$$32022 Enable USB daemon (detect USB attach / detach)",
        dmenuVarCheck, dmenuToggleVariable, NULL, "usbd_enable=YES" },
      { " usbd flags", "$$$$32023 Set default flags to usbd (if enabled)", 
        dmenuVarCheck, dmenuISetVariable, NULL, "usbd_flags" },
      { " ",		" -- ", NULL,	NULL, NULL, NULL, ' ', ' ', ' ' },
      { " startup dirs", "$$$$32111 Set the list of dirs to look for startup scripts",
	dmenuVarCheck, dmenuISetVariable, NULL, "local_startup" },
      { " named",	"$$$$32113 Run a local name server on this host",
	dmenuVarCheck, dmenuToggleVariable, NULL, "named_enable=YES" },
      { " named flags",	"$$$$32115 Set default flags to named (if enabled)",
	dmenuVarCheck, dmenuISetVariable, NULL, "named_flags" },
      { " nis client",	"$$$$32117 This host wishes to be an NIS client.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "nis_client_enable=YES" },
      { " nis domainname", "$$$$32118 Set NIS domainname (if enabled)",
	dmenuVarCheck, dmenuISetVariable, NULL, "nisdomainname" },
      { " nis server",	"$$$$32119 This host wishes to be an NIS server.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "nis_server_enable=YES" },
      { " ",		" -- ", NULL,	NULL, NULL, NULL, ' ', ' ', ' ' },
      { " accounting",	"$$$$32121 This host wishes to run process accounting.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "accounting_enable=YES" },
      { " lpd",		"$$$$32123 This host has a printer and wants to run lpd.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "lpd_enable=YES" },
#ifdef __i386__
      { " linux",	"$$$$32125 This host wants to be able to run linux binaries.",
	dmenuVarCheck, configLinux, NULL, VAR_LINUX_ENABLE "=YES" },
      { " SVR4",	"$$$$32126 This host wants to be able to run SVR4 binaries.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "svr4_enable=YES" },
      { " SCO",		"$$$$32129 This host wants to be able to run IBCS2 binaries.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "ibcs2_enable=YES" },
#elif __alpha__
      { " OSF/1",	"$$$$32128 This host wants to be able to run DEC OSF/1 binaries.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "osf1_enable=YES" },
#endif
      { " quotas",	"$$$$32127 This host wishes to check quotas on startup.",
	dmenuVarCheck, dmenuToggleVariable, NULL, "check_quotas=YES" },
      { NULL } },
};

DMenu MenuNetworking = {
    DMENU_CHECKLIST_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00695 Network Services Menu",
    "$$$$00696 You may have already configured one network device (and the other\n"
    "various hostname/gateway/name server parameters) in the process\n"
    "of installing FreeBSD.  This menu allows you to configure other\n"
    "aspects of your system's network configuration.",
    NULL,
    NULL,
    { { "X Exit",	"$$$$00724 Exit this menu (returning to previous)",
	checkTrue, dmenuExit, NULL, NULL, '<', '<', '<' },
      { " Interfaces",	"$$$$00698 Configure additional network interfaces",
	NULL, tcpMenuSelect },
      { " AMD",		"$$$$32089 This machine wants to run the auto-mounter service",
	dmenuVarCheck,	dmenuToggleVariable, NULL, "amd_enable=YES" },
      { " AMD Flags",	"$$$$32091 Set flags to AMD service (if enabled)",
	dmenuVarCheck,	dmenuISetVariable, NULL, "amd_flags" },
      { " Anon FTP",	"$$$$00716 This machine wishes to allow anonymous FTP.",
	dmenuVarCheck,	configAnonFTP, NULL, "anon_ftp" },
      { " Gateway",	"$$$$00704 This machine will route packets between interfaces",
	dmenuVarCheck,	dmenuToggleVariable, NULL, "gateway_enable=YES" },
      { " inetd",	"$$$$00706 This machine wants to run the inet daemon",
	dmenuVarCheck,	configInetd, NULL, "inetd_enable=YES" },
      { " NFS client",	"$$$$00700 This machine will be an NFS client",
	dmenuVarCheck,	dmenuToggleVariable, NULL, "nfs_client_enable=YES" },
      { " NFS server",	"$$$$00702 This machine will be an NFS server",
	dmenuVarCheck,	configNFSServer, NULL, "nfs_server_enable=YES" },
      { " Ntpdate",	"$$$$00710 Select a clock-synchronization server",
	dmenuVarCheck,	dmenuSubmenu, NULL, &MenuNTP, '[', 'X', ']', "ntpdate_enable=YES" },
      { " PCNFSD",	"$$$$00722 Run authentication server for clients with PC-NFS.",
	dmenuVarCheck,	configPCNFSD, NULL, "pcnfsd" },
      { " portmap",	"$$$$00720 This machine wants to run the portmapper daemon",
	dmenuVarCheck,	dmenuToggleVariable, NULL, "portmap_enable=YES" },
      { " Routed",	"$$$$00712 Select routing daemon (default: routed)",
	dmenuVarCheck,	configRouter, NULL, "router_enable=YES" },
      { " Rwhod",	"$$$$00714 This machine wants to run the rwho daemon",
	dmenuVarCheck,	dmenuToggleVariable, NULL, "rwhod_enable=YES" },
      { " Sendmail",	"$$$$32346 This machine wants to run the sendmail daemon",
	dmenuVarCheck,	dmenuToggleVariable, NULL, "sendmail_enable=YES" },
      { " Sshd",	"$$$$32348 This machine wants to run the ssh daemon",
	dmenuVarCheck,	dmenuToggleVariable, NULL, "sshd_enable=YES" },
      { " TCP Extensions", "$$$$32093 Allow RFC1323 and RFC1644 TCP extensions?",
	dmenuVarCheck,	dmenuToggleVariable, NULL, "tcp_extensions=YES" },
      { NULL } },
};

DMenu MenuNTP = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00725 NTPDATE Server Selection",
    "$$$$00726 There are a number of time synchronization servers available\n"
    "for public use around the Internet.  Please select one reasonably\n"
    "close to you to have your system time synchronized accordingly.",
    "$$$$00727 These are the primary open-access NTP servers",
    NULL,
    { { "None",		        "$$$$32095 No NTP server",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=NO,ntpdate_flags=none" },
      { "Other",		"$$$$00729 Select a site not on this list",
	dmenuVarsCheck, configNTP, NULL, NULL },
      { "Argentina",		"tick.nap.com.ar",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=tick.nap.com.ar" },
      { "Argentina #2",		"time.sinectis.com.ar",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=time.sinectis.com.ar" },
      { "Argentina #3",		"tock.nap.com.ar",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=tock.nap.com.ar" },
      { "Australia",		"augean.eleceng.adelaide.edu.au",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=augean.eleceng.adelaide.edu.au" },
      { "Australia #2",		"ntp.adelaide.edu.au",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp.adelaide.edu.au" },
      { "Australia #3",		"ntp.saard.net",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp.saard.net" },
      { "Australia #4",		"time.deakin.edu.au",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=time.deakin.edu.au" },
      { "Australia #5",		"time.esec.com.au",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=time.esec.com.au" },
      { "Belgium",		"ntp1.belbone.be",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp1.belbone.be" },
      { "Belgium #2",		"ntp2.belbone.be",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2.belbone.be" },
      { "Brazil",		"ntp.cais.rnp.br",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.cais.rnp.br" },
      { "Brazil #2",		"ntp.pop-df.rnp.br",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.pop-df.rnp.br" },
      { "Brazil #3",		"ntp.ufes.br",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.ufes.br" },
      { "Brazil #4",		"ntp1.pucpr.br",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp1.pucpr.br" },
      { "Canada",		"ntp.cpsc.ucalgary.ca",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp.cpsc.ucalgary.ca" },
      { "Canada #2",		"ntp1.cmc.ec.gc.ca",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp1.cmc.ec.gc.ca" },
      { "Canada #3",		"ntp2.cmc.ec.gc.ca",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp2.cmc.ec.gc.ca" },
      { "Canada #4",		"tick.utoronto.ca",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=tick.utoronto.ca" },
      { "Canada #5",		"time.chu.nrc.ca",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=time.chu.nrc.ca" },
      { "Canada #6",		"time.nrc.ca",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=time.nrc.ca" },
      { "Canada #7",		"timelord.uregina.ca",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=timelord.uregina.ca" },
      { "Canada #8",		"tock.utoronto.ca",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=tock.utoronto.ca" },
      { "Czech",		"ntp.karpo.cz",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.karpo.cz" },
      { "Denmark",		"clock.netcetera.dk",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=clock.netcetera.dk" },
      { "Denmark",		"clock2.netcetera.dk",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=clock2.netcetera.dk" },
      { "Spain",		"slug.ctv.es",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=slug.ctv.es" },
      { "Finland",		"tick.keso.fi",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=tick.keso.fi" },
      { "Finland #2",		"tock.keso.fi",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=tock.keso.fi" },
      { "France",		"ntp.obspm.fr",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp.obspm.fr" },
      { "France #2",		"ntp.univ-lyon1.fr",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.univ-lyon1.fr" },
      { "France #3",		"ntp.via.ecp.fr",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.via.ecp.fr" },
      { "Croatia",		"zg1.ntp.carnet.hr",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=zg1.ntp.carnet.hr" },
      { "Croatia #2",		"zg2.ntp.carnet.hr",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=zg2.ntp.carnet.hr" },
      { "Croatia #3",		"st.ntp.carnet.hr",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=st.ntp.carnet.hr" },
      { "Croatia #4",		"ri.ntp.carnet.hr",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ri.ntp.carnet.hr" },
      { "Croatia #5",		"os.ntp.carnet.hr",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=os.ntp.carnet.hr" },
      { "Hungary",		"time.kfki.hu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=time.kfki.hu" },
      { "Indonesia",		"ntp.incaf.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.incaf.net" },
      { "Ireland",		"ntp.maths.tcd.ie",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.maths.tcd.ie" },
      { "Italy",		"ntps.net4u.it",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=" },
      { "Japan",		"ntp.cyber-fleet.net",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp.cyber-fleet.net" },
      { "Korea",		"time.nuri.net",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=time.nuri.net" },
      { "Mexico",		"ntp2a.audiotel.com.mx",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2a.audiotel.com.mx" },
      { "Mexico #2",		"ntp2b.audiotel.com.mx",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2b.audiotel.com.mx" },
      { "Mexico #3",		"ntp2c.audiotel.com.mx",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2c.audiotel.com.mx" },
      { "Nigeria",		"ntp.supernet300.com",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.supernet300.com" },
      { "Netherlands",		"ntp1.theinternetone.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp1.theinternetone.net" },
      { "Netherlands #2",	"ntp2.theinternetone.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2.theinternetone.net" },
      { "Netherlands #3",	"ntp3.theinternetone.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp3.theinternetone.net" },
      { "Norway",		"fartein.ifi.uio.no",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=fartein.ifi.uio.no" },
      { "Norway #2",		"time.alcanet.no",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=time.alcanet.no" },
      { "New Zealand",		"ntp.massey.ac.nz",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.massey.ac.nz" },
      { "New Zealand #2",	"ntp.public.otago.ac.nz",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.public.otago.ac.nz" },
      { "New Zealand #3",	"tk1.ihug.co.nz",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=tk1.ihug.co.nz" },
      { "New Zealand #4",	"ntp.waikato.ac.nz",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.waikato.ac.nz" },
      { "Poland",		"info.cyf-kr.edu.pl",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=info.cyf-kr.edu.pl" },
      { "Portugal",		"bug.fe.up.pt",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=bug.fe.up.pt" },
      { "Romania",		"ntp.ip.ro",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.ip.ro" },
      { "Russia",		"ntp.psn.ru",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.psn.ru" },
      { "Russia #2",		"sign.chg.ru",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=sign.chg.ru" },
      { "Sweden",		"ntp.lth.se",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp.lth.se" },
      { "Singapore",		"ntp.shim.org",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.shim.org" },
      { "Slovenia",		"calvus.rzs-hm.si",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=calvus.rzs-hm.si" },
      { "Slovenia #2",		"sizif.mf.uni-lj.si",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=sizif.mf.uni-lj.si" },
      { "Slovenia #3",		"ntp1.arnes.si",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp1.arnes.si" },
      { "Slovenia #4",		"ntp2.arnes.si",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2.arnes.si" },
      { "Slovenia #5",		"time.ijs.si",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=time.ijs.si" },
      { "Scotland",		"ntp.cs.strath.ac.uk",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.cs.strath.ac.uk" },
      { "United Kingdom",	"ntp.exnet.com",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.exnet.com" },
      { "United Kingdom #2",	"ntp0.uk.uu.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp0.uk.uu.net" },
      { "United Kingdom #3",	"ntp1.uk.uu.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp1.uk.uu.net" },
      { "United Kingdom #4",	"ntp2.uk.uu.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2.uk.uu.net" },
      { "United Kingdom #5",	"ntp2a.mcc.ac.uk",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2a.mcc.ac.uk" },
      { "United Kingdom #6",	"ntp2b.mcc.ac.uk",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2b.mcc.ac.uk" },
      { "United Kingdom #7",	"ntp2c.mcc.ac.uk",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2c.mcc.ac.uk" },
      { "United Kingdom #8",	"ntp2d.mcc.ac.uk",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2d.mcc.ac.uk" },
      { "United Kingdom #9",	"tick.tanac.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=tick.tanac.net" },
      { "U.S. AR",	"sushi.compsci.lyon.edu",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=sushi.compsci.lyon.edu" },
      { "U.S. AZ",	"ntp.drydog.com",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp.drydog.com" },
      { "U.S. CA",	"ntp.ucsd.edu",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp.ucsd.edu" },
      { "U.S. CA #2",	"ntp1.mainecoon.com",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp1.mainecoon.com" },
      { "U.S. CA #3",	"ntp2.mainecoon.com",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp2.mainecoon.com" },
      { "U.S. CA #4",	"reloj.kjsl.com",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=reloj.kjsl.com" },
      { "U.S. CA #5",	"time.five-ten-sg.com",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=time.five-ten-sg.com" },
      { "U.S. DE",	"louie.udel.edu",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=louie.udel.edu" },
      { "U.S. GA",		"ntp.shorty.com",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=ntp.shorty.com" },
      { "U.S. GA #2",		"rolex.usg.edu",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=rolex.usg.edu" },
      { "U.S. GA #3",		"timex.usg.edu",
	dmenuVarsCheck,	dmenuSetVariables, NULL, 
	"ntpdate_enable=YES,ntpdate_flags=timex.usg.edu" },
      { "U.S. IL",	"ntp-0.cso.uiuc.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp-0.cso.uiuc.edu" },
      { "U.S. IL #2",	"ntp-1.cso.uiuc.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp-1.cso.uiuc.edu" },
      { "U.S. IL #3",	"ntp-1.mcs.anl.gov",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp-1.mcs.anl.gov" },
      { "U.S. IL #4",	"ntp-2.cso.uiuc.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp-2.cso.uiuc.edu" },
      { "U.S. IL #5",	"ntp-2.mcs.anl.gov",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp-2.mcs.anl.gov" },
      { "U.S. IN",	"gilbreth.ecn.purdue.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=gilbreth.ecn.purdue.edu" },
      { "U.S. IN #2",	"harbor.ecn.purdue.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=harbor.ecn.purdue.edu" },
      { "U.S. IN #3",	"molecule.ecn.purdue.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=molecule.ecn.purdue.edu" },
      { "U.S. KS",	"ntp1.kansas.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp1.kansas.net" },
      { "U.S. KS #2",	"ntp2.kansas.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2.kansas.net" },
      { "U.S. MA",	"ntp.ourconcord.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.ourconcord.net" },
      { "U.S. MA #2",	"timeserver.cs.umb.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=timeserver.cs.umb.edu" },
      { "U.S. MN",	"ns.nts.umn.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ns.nts.umn.edu" },
      { "U.S. MN #2",	"nss.nts.umn.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=nss.nts.umn.edu" },
      { "U.S. MO",	"time-ext.missouri.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=time-ext.missouri.edu" },
      { "U.S. MT",	"chronos1.umt.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=chronos1.umt.edu" },
      { "U.S. MT #2",	"chronos2.umt.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=chronos2.umt.edu" },
      { "U.S. MT #3",	"chronos3.umt.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=chronos3.umt.edu" },
      { "U.S. NC",	"clock1.unc.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=clock1.unc.edu" },
      { "U.S. NV",	"cuckoo.nevada.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=cuckoo.nevada.edu" },
      { "U.S. NV #2",	"tick.cs.unlv.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=tick.cs.unlv.edu" },
      { "U.S. NV #3",	"tock.cs.unlv.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=tock.cs.unlv.edu" },
      { "U.S. NY",	"clock.linuxshell.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=clock.linuxshell.net" },
      { "U.S. NY #2",	"ntp.ctr.columbia.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.ctr.columbia.edu" },
      { "U.S. NY #3",	"ntp0.cornell.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp0.cornell.edu" },
      { "U.S. NY #4",	"ntp1.mpis.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp1.mpis.net" },
      { "U.S. NY #5",	"ntp2.mpis.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2.mpis.net" },
      { "U.S. NY #6",	"sundial.columbia.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=sundial.columbia.edu" },
      { "U.S. NY #7",	"timex.cs.columbia.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=timex.cs.columbia.edu" },
      { "U.S. OK",	"constellation.ecn.uoknor.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=constellation.ecn.uoknor.edu" },
      { "U.S. PA",	"clock-1.cs.cmu.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=clock-1.cs.cmu.edu" },
      { "U.S. PA #2",	"clock-2.cs.cmu.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=clock-2.cs.cmu.edu" },
      { "U.S. PA #3",	"clock.psu.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=clock.psu.edu" },
      { "U.S. PA #4",	"fuzz.psc.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=fuzz.psc.edu" },
      { "U.S. PA #5",	"ntp-1.ece.cmu.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp-1.ece.cmu.edu" },
      { "U.S. PA #6",	"ntp-2.ece.cmu.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp-2.ece.cmu.edu" },
      { "U.S. TX",	"ntp.cox.smu.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.cox.smu.edu" },
      { "U.S. TX #2",	"ntp.fnbhs.com",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.fnbhs.com" },
      { "U.S. TX #3",	"ntp.tmc.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.tmc.edu" },
      { "U.S. TX #4",	"ntp5.tamu.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp5.tamu.edu" },
      { "U.S. TX #5",	"tick.greyware.com",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=tick.greyware.com" },
      { "U.S. TX #6",	"tock.greyware.com",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=tock.greyware.com" },
      { "U.S. VA",	"ntp-1.vt.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp-1.vt.edu" },
      { "U.S. VA #2",	"ntp-2.vt.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp-2.vt.edu" },
      { "U.S. VA #3",	"ntp.cmr.gov",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.cmr.gov" },
      { "U.S. VT",	"ntp0.state.vt.us",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp0.state.vt.us" },
      { "U.S. VT #2",	"ntp1.state.vt.us",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp1.state.vt.us" },
      { "U.S. VT #3",	"ntp2.state.vt.us",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp2.state.vt.us" },
      { "U.S. WA",	"clock.tricity.wsu.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=clock.tricity.wsu.edu" },
      { "U.S. WA #2",	"ntp.tcp-udp.net",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.tcp-udp.net" },
      { "U.S. WI",	"ntp1.cs.wisc.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp1.cs.wisc.edu" },
      { "U.S. WI #2",	"ntp3.cs.wisc.edu",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp3.cs.wisc.edu" },
      { "Venezuela",	"ntp.linux.org.ve",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.linux.org.ve" },
      { "South Africa",	"ntp.cs.unp.ac.za",
	dmenuVarsCheck, dmenuSetVariables, NULL,
	"ntpdate_enable=YES,ntpdate_flags=ntp.cs.unp.ac.za" },
      { NULL } },
};

DMenu MenuSyscons = {
    DMENU_NORMAL_TYPE,
    "$$$$00781 System Console Configuration",
    "$$$$00782 The default system console driver for FreeBSD (syscons) has a\n"
    "number of configuration options which may be set according to\n"
    "your preference.\n\n"
    "When you are done setting configuration options, select Cancel.",
    "$$$$00783 Configure your system console settings",
    NULL,
    { { "X Exit",	"$$$$00791 Exit this menu (returning to previous)", NULL, dmenuExit },
      { "2 Font",	"$$$$00923 Choose an alternate screen font",	NULL, dmenuSubmenu, NULL, &MenuSysconsFont },
      { "3 Keymap",	"$$$$00785 Choose an alternate keyboard map",	NULL, dmenuSubmenu, NULL, &MenuSysconsKeymap },
      { "4 Repeat",	"$$$$00787 Set the rate at which keys repeat",	NULL, dmenuSubmenu, NULL, &MenuSysconsKeyrate },
      { "5 Saver",	"$$$$00789 Configure the screen saver",		NULL, dmenuSubmenu, NULL, &MenuSysconsSaver },
      { "6 Screenmap",	"$$$$00921 Choose an alternate screenmap",	NULL, dmenuSubmenu, NULL, &MenuSysconsScrnmap },
      { NULL } },
};

#ifdef PC98
DMenu MenuSysconsKeymap = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$32024 System Console Keymap",
    "$$$$32025 The default system console driver for FreeBSD (syscons) defaults\n"
    "to a standard \"PC-98x1\" keyboard map.  Users may wish to choose\n"
    "one of the other keymaps below.\n"
    "Note that sysinstall itself only uses the part of the keyboard map\n"
    "which is required to generate the ANSI character subset, but your\n"
    "choice of keymap will also be saved for later (fuller) use.",
    "Choose a keyboard map",
    NULL,
    { { "Japanese PC-98x1",		"$$$$32026 Japanese PC-98x1 keymap",  dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=jp.pc98" },
      { " Japanese PC-98x1 (ISO)",	"$$$$32027 Japanese PC-98x1 (ISO) keymap",  dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=jp.pc98.iso" },
      { NULL } },
};
#else
DMenu MenuSysconsKeymap = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00795 System Console Keymap",
    "$$$$00796 The default system console driver for FreeBSD (syscons) defaults\n"
    "to a standard \"American\" keyboard map.  Users in other countries\n"
    "(or with different keyboard preferences) may wish to choose one of\n"
    "the other keymaps below.\n"
    "Note that sysinstall itself only uses the part of the keyboard map\n"
    "which is required to generate the ANSI character subset, but your\n"
    "choice of keymap will also be saved for later (fuller) use.",
    "$$$$00797 Choose a keyboard map",
    NULL,
    { { "Belgian",	"$$$$00932 Belgian ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=be.iso" },
      { " Brazil CP850",	"$$$$00924 Brazil CP850 keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=br275.cp850" },
      { " Brazil ISO (accent)",	"$$$$32240 Brazil ISO keymap (accent keys)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=br275.iso.acc" },
      { " Brazil ISO",	"$$$$00925 Brazil ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=br275.iso" },
      { " Bulgarian BDS",	"$$$$32361 Bulgarian BDS keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=bg.bds.ctrlcaps" },
      { " Bulgarian Phonetic",	"$$$$32362 Bulgarian Phonetic keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=bg.phonetic.ctrlcaps" },
      { " Croatian ISO",	"$$$$32282 Croatian ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=hr.iso" },
      { " Czech ISO (accent)",	"$$$$32363 Czech ISO keymap (accent keys)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=cs.latin2.qwertz" },
      { "Danish CP865",	"$$$$00799 Danish Code Page 865 keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=danish.cp865" },
      { " Danish ISO",	"$$$$00801 Danish ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=danish.iso" },
      { "Estonian ISO", "$$$$32330 Estonian ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=estonian.iso" },
      { " Estonian ISO 15", "$$$$32332 Estonian ISO 8859-15 keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=estonian.iso15" },
      { " Estonian CP850", "$$$$32334 Estonian Code Page 850 keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=estonian.cp850" },
      { "Finnish CP850","$$$$32283 Finnish Code Page 850 keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=finnish.cp850" },
      { " Finnish ISO",  "$$$$32284 Finnish ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=finnish.iso" },
      { " French ISO (accent)", "$$$$32285 French ISO keymap (accent keys)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=fr.iso.acc" },
      { " French ISO",	"$$$$00803 French ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=fr.iso" },
      { "German CP850",	"$$$$00805 German Code Page 850 keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=german.cp850"	},
      { " German ISO",	"$$$$00807 German ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=german.iso" },
      { "Hungarian 101", "$$$$32286 Hungarian ISO keymap (101 key)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=hu.iso2.101keys" },
      { " Hungarian 102", "$$$$32287 Hungarian ISO keymap (102 key)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=hu.iso2.102keys" },
      { "Icelandic (accent)", "$$$$32241 Icelandic ISO keymap (accent keys)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=icelandic.iso.acc" },
      { " Icelandic",	"$$$$32242 Icelandic ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=icelandic.iso" },
      { " Italian",	"$$$$00809 Italian ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=it.iso" },
      { "Japanese 106",	"$$$$00811 Japanese 106 keymap",  dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=jp.106" },
      { "Latin American", "$$$$32243 Latin American ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=lat-amer" },
      { "Norway ISO",	"$$$$00926 Norwegian ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=norwegian.iso" },
      { "Polish ISO",	"$$$$32288 Polish ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=pl_PL.ISO8859-2" },
      { " Portuguese (accent)",	"$$$$32289 Portuguese ISO keymap (accent keys)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=pt.iso.acc" },
      { " Portuguese",	"$$$$32290 Portuguese ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=pt.iso" },
      { "Russia KOI8-R", "$$$$00928 Russian KOI8-R keymap", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=ru.koi8-r" },
      { "Slovenian", "$$$$32244 Slovenian ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=si.iso" },
      { " Spanish (accent)", "$$$$32245 Spanish ISO keymap (accent keys)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=spanish.iso.acc" },
      { " Spanish",	"$$$$00929 Spanish ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=spanish.iso" },
      { " Swedish CP850", "$$$$00819 Swedish Code Page 850 keymap", dmenuVarCheck,	dmenuSetKmapVariable, NULL, "keymap=swedish.cp850" },
      { " Swedish ISO",	"$$$$00821 Swedish ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swedish.iso" },
      { " Swiss French ISO (accent)", "$$$$32336 Swiss French ISO keymap (accent keys)", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissfrench.iso.acc" },
      { " Swiss French ISO", "$$$$32291 Swiss French ISO keymap", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissfrench.iso" },
      { " Swiss French CP850", "$$$$32338 Swiss French Code Page 850 keymap", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissfrench.cp850" },
      { " Swiss German ISO (accent)", "$$$$32340 Swiss German ISO keymap (accent keys)", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissgerman.iso.acc" },
      { " Swiss German ISO", "$$$$00930 Swiss German ISO keymap", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissgerman.iso" },
      { " Swiss German CP850", "$$$$32342 Swiss German Code Page 850 keymap", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=swissgerman.cp850" },
      { "UK CP850",	"$$$$00823 UK Code Page 850 keymap", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=uk.cp850" },
      { " UK ISO",	"$$$$00825 UK ISO keymap", dmenuVarCheck,	dmenuSetKmapVariable, NULL, "keymap=uk.iso" },
      { " Ukrainian KOI8-U",	"$$$$32028 Ukrainian KOI8-U keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=ua.koi8-u" },
      { " Ukrainian KOI8-U+KOI8-R",	"$$$$32029 Ukrainian KOI8-U+KOI8-R keymap (alter)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=ua.koi8-u.shift.alt" },
      { " USA CapsLock->Ctrl",	"$$$$32350 US standard (Caps as L-Control)",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=us.pc-ctrl" },
      { " USA Dvorak",	"$$$$00931 US Dvorak keymap", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=us.dvorak" },
      { " USA Dvorak (left)",	"$$$$32352 US left handed Dvorak keymap", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=us.dvorakl" },
      { " USA Dvorak (right)",	"$$$$32354 US right handed Dvorak keymap", dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=us.dvorakr" },
      { " USA Emacs",	"$$$$32356 US standard optimized for EMACS",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=us.emacs" },
      { " USA ISO",	"$$$$00827 US ISO keymap",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=us.iso" },
      { " USA UNIX",	"$$$$32358 US traditional UNIX-workstation",	dmenuVarCheck, dmenuSetKmapVariable, NULL, "keymap=us.unix" },
      { NULL } },
};
#endif

DMenu MenuSysconsKeyrate = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00831 System Console Keyboard Repeat Rate",
    "$$$$00832 This menu allows you to set the speed at which keys repeat\n"
    "when held down.",
    "$$$$00833 Choose a keyboard repeat rate",
    NULL,
    { { "Slow",	"$$$$00835 Slow keyboard repeat rate",	dmenuVarCheck,	dmenuSetVariable, NULL, "keyrate=slow" },
      { "Normal", "$$$$00837 \"Normal\" keyboard repeat rate",	dmenuVarCheck,	dmenuSetVariable, NULL, "keyrate=normal" },
      { "Fast",	"$$$$00839 Fast keyboard repeat rate",	dmenuVarCheck,	dmenuSetVariable, NULL, "keyrate=fast" },
      { "Default", "$$$$00841 Use default keyboard repeat rate",	dmenuVarCheck,	dmenuSetVariable, NULL, "keyrate=NO" },
      { NULL } },
};

DMenu MenuSysconsSaver = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00845 System Console Screen Saver",
    "$$$$00846 By default, the console driver will not attempt to do anything\n"
    "special with your screen when it's idle.  If you expect to leave your\n"
    "monitor switched on and idle for long periods of time then you should\n"
    "probably enable one of these screen savers to prevent phosphor burn-in.",
    "$$$$00847 Choose a nifty-looking screen saver",
    NULL,
    { { "1 Blank",	"$$$$00849 Simply blank the screen",
	dmenuVarCheck, configSaver, NULL, "saver=blank" },
      { "2 Daemon",	"$$$$32251 \"BSD Daemon\" animated screen saver (text)",
	dmenuVarCheck, configSaver, NULL, "saver=daemon" },
      { "3 Fade",	"$$$$32292 Fade out effect screen saver",
	dmenuVarCheck, configSaver, NULL, "saver=fade" },
      { "4 Fire",	"$$$$32293 Flames effect screen saver",
	dmenuVarCheck, configSaver, NULL, "saver=fire" },
      { "5 Green",	"$$$$00851 \"Green\" power saving mode (if supported by monitor)",
	dmenuVarCheck, configSaver, NULL, "saver=green" },
      { "6 Logo",	"$$$$32294 \"BSD Daemon\" animated screen saver (graphics)",
	dmenuVarCheck, configSaver, NULL, "saver=logo" },
      { "7 Rain",	"$$$$32295 Rain drops screen saver",
	dmenuVarCheck, configSaver, NULL, "saver=rain" },
      { "8 Snake",	"$$$$00853 Draw a FreeBSD \"snake\" on your screen",
	dmenuVarCheck, configSaver, NULL, "saver=snake" },
      { "9 Star",	"$$$$00855 A \"twinkling stars\" effect",
	dmenuVarCheck, configSaver, NULL, "saver=star" },
      { "Warp",	"$$$$32296 A \"stars warping\" effect",
	dmenuVarCheck, configSaver, NULL, "saver=warp" },
      { "Timeout",	"$$$$00857 Set the screen saver timeout interval",
	NULL, configSaverTimeout, NULL, NULL, ' ', ' ', ' ' },
      { NULL } },
};

DMenu MenuSysconsScrnmap = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00935 System Console Screenmap",
    "$$$$00936 Unless you load a specific font, most PC hardware defaults to\n"
    "displaying characters in the IBM 437 character set.  However,\n"
    "in the Unix world, this character set is very rarely used.  Most\n"
    "Western European countries, for example, prefer ISO 8859-1.\n"
    "American users won't notice the difference since the bottom half\n"
    "of all these character sets is ANSI anyway.\n"
    "If your hardware is capable of downloading a new display font,\n"
    "you should probably choose that option.  However, for hardware\n"
    "where this is not possible (e.g. monochrome adapters), a screen\n"
    "map will give you the best approximation that your hardware can\n"
    "display at all.",
    "$$$$00937 Choose a screen map",
    NULL,
    { { "None",			"$$$$00939 No screenmap, use default font", dmenuVarCheck, dmenuSetVariable, NULL, "scrnmap=NO" },
      { "KOI8-R to IBM866",	"$$$$00940 Russian KOI8-R to IBM 866 screenmap", dmenuVarCheck, dmenuSetVariable, NULL, "scrnmap=koi8-r2cp866" },
      { "KOI8-U to IBM866u",	"$$$$32200 Ukrainian KOI8-U to IBM 866u screenmap", dmenuVarCheck, dmenuSetVariable, NULL, "scrnmap=koi8-u2cp866u" },
      { "ISO 8859-1 to IBM437",	"$$$$00941 W-Europe ISO 8859-1 to IBM 437 screenmap", dmenuVarCheck, dmenuSetVariable, NULL, "scrnmap=iso-8859-1_to_cp437" },
      { NULL } },
};

DMenu MenuSysconsFont = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$00945 System Console Font",
    "$$$$00946 Most PC hardware defaults to displaying characters in the\n"
    "IBM 437 character set.  However, in the Unix world, this\n"
    "character set is very rarely used.  Most Western European\n"
    "countries, for example, prefer ISO 8859-1.\n"
    "American users won't notice the difference since the bottom half\n"
    "of all these charactersets is ANSI anyway.  However, they might\n"
    "want to load a font anyway to use the 30- or 50-line displays.\n"
    "If your hardware is capable of downloading a new display font,\n"
    "you can select the appropriate font below.",
    "$$$$00957 Choose a font",
    NULL,
    { { "1 None", "$$$$00947 Use hardware default font",	dmenuVarCheck,	dmenuSetVariables, NULL,
	"font8x8=NO,font8x14=NO,font8x16=NO" },
      { "2 IBM 437", "$$$$00948 English and others, VGA default",	dmenuVarCheck,	dmenuSetVariables, NULL,
	"font8x8=cp437-8x8,font8x14=cp437-8x14,font8x16=cp437-8x16" },
      { "3 IBM 850", "$$$$00949 Western Europe, IBM encoding",	dmenuVarCheck,	dmenuSetVariables, NULL,
	"font8x8=cp850-8x8,font8x14=cp850-8x14,font8x16=cp850-8x16" },
      { "4 IBM 865", "$$$$00950 Norwegian, IBM encoding",	dmenuVarCheck,	dmenuSetVariables, NULL,
	"font8x8=cp865-8x8,font8x14=cp865-8x14,font8x16=cp865-8x16" },
      { "5 IBM 866", "$$$$00951 Russian, IBM encoding (use with KOI8-R screenmap)",	dmenuVarCheck,	dmenuSetVariables, NULL,
	"font8x8=cp866-8x8,font8x14=cp866-8x14,font8x16=cp866b-8x16,mousechar_start=3" },
      { "6 IBM 866u", "$$$$32201 Ukrainian, IBM encoding (use with KOI8-U screenmap)",   dmenuVarCheck,  dmenuSetVariables, NULL,
	"font8x8=cp866u-8x8,font8x14=cp866u-8x14,font8x16=cp866u-8x16,mousechar_start=3" },
      { "7 IBM 1251", "$$$$32370 Cyrillic, MS Windows encoding",  dmenuVarCheck, dmenuSetVariables, NULL,
	"font8x8=cp1251-8x8,font8x14=cp1251-8x14,font8x16=cp1251-8x16,mousechar_start=3" },
      { "8 ISO 8859-1", "$$$$00952 Western Europe, ISO encoding",	dmenuVarCheck,	dmenuSetVariables, NULL,
	"font8x8=iso-8x8,font8x14=iso-8x14,font8x16=iso-8x16" },
      { "9 ISO 8859-2", "$$$$00958 Eastern Europe, ISO encoding",	dmenuVarCheck,	dmenuSetVariables, NULL,
	"font8x8=iso02-8x8,font8x14=iso02-8x14,font8x16=iso02-8x16" },
      { "a ISO 8859-4", "$$$$32371 Baltic, ISO encoding", dmenuVarCheck,  dmenuSetVariables, NULL,
	"font8x8=iso04-8x8,font8x14=iso04-8x14,font8x16=iso04-8x16" },
      { "b ISO 8859-7", "$$$$32372 Greek, ISO encoding", dmenuVarCheck,  dmenuSetVariables, NULL,
	"font8x8=iso07-8x8,font8x14=iso07-8x14,font8x16=iso07-8x16" },
      { "c ISO 8859-8", "$$$$32373 Hebrew, ISO encoding", dmenuVarCheck,  dmenuSetVariables, NULL,
	"font8x8=iso08-8x8,font8x14=iso08-8x14,font8x16=iso08-8x16" },
      { "d ISO 8859-15", "$$$$32374 Europe, ISO encoding", dmenuVarCheck,  dmenuSetVariables, NULL,
	"font8x8=iso15-8x8,font8x14=iso15-8x14,font8x16=iso15-8x16" },
      { "e SWISS", "$$$$00954 English, better resolution", dmenuVarCheck,	dmenuSetVariables, NULL,
	"font8x8=swiss-8x8,font8x14=NO,font8x16=swiss-8x16" },
      { NULL } },
};

DMenu MenuUsermgmt = {
    DMENU_NORMAL_TYPE,
    "$$$$00980 User and group management",
    "$$$$00981 The submenus here allow to manipulate user groups and\n"
    "login accounts.\n",
    "$$$$00982 Configure your user groups and users",
    NULL,
    { { "X Exit",	"$$$$00986 Exit this menu (returning to previous)", NULL, dmenuExit },
      { "User",		"$$$$00983 Add a new user to the system.",	NULL, userAddUser },
      { "Group",	"$$$$00984 Add a new user group to the system.",	NULL, userAddGroup },
      { NULL } },
};

DMenu MenuSecurityProfile = {
    DMENU_NORMAL_TYPE | DMENU_SELECTION_RETURNS,
    "$$$$32400 Default system security profile",
    "$$$$32402 Each item in this list will set what it considers to\n"
    "be \"appropriate\" values in that category for various\n"
    "security-related knobs in /etc/rc.conf.",
    "$$$$32404 Select a canned security profile - F1 for help",
    "security",						/* help file */
    { { "X Exit",	"$$$$32406 Exit this menu (returning to previous)", NULL, configSecurityModerate },
      { "Medium",	"$$$$32410 Moderate security settings [DEFAULT].", NULL, configSecurityModerate },
      { "Extreme",	"$$$$32414 Very restrictive security settings.", NULL, configSecurityExtreme },
      { NULL } },
};

DMenu MenuFixit = {
    DMENU_NORMAL_TYPE,
    "$$$$32050 Please choose a fixit option",
    "$$$$32051 There are three ways of going into \"fixit\" mode:\n"
    "- you can use the live filesystem CDROM/DVD, in which case there will be\n"
    "  full access to the complete set of FreeBSD commands and utilities,\n"
    "- you can use the more limited (but perhaps customized) fixit floppy,\n"
    "- or you can start an Emergency Holographic Shell now, which is\n"
    "  limited to the subset of commands that is already available right now.",
    "$$$$32052 Press F1 for more detailed repair instructions",
    "fixit",
{ { "X Exit",	"$$$$32344 Exit this menu (returning to previous)",		NULL, dmenuExit },
  { "2 CDROM/DVD",	"$$$$32053 Use the 2nd \"live\" CDROM/DVD",	NULL, installFixitCDROM },
  { "3 Floppy",	"$$$$32054 Use a floppy generated from the fixit image",		NULL, installFixitFloppy },
  { "4 Shell",	"$$$$32055 Start an Emergency Holographic Shell",			NULL, installFixitHoloShell },
  { NULL } },
};

static void 
convert_catalog(char **str)
{
    char *s;
    if (!*str) {
	return;
    }
    s = catalog(*str);
    if (s != *str) {
	*str = strdup(s);
    }
}

void 
menus_catalog(void)
{
    int i;
    static DMenu *menus[] = {
	&MenuIndex,
	&MenuInitial,
	&MenuDocumentation,
	&MenuMouse,
	&MenuMouseType,
	&MenuMousePort,
	&MenuMediaCDROM,
	&MenuMediaFloppy,
	&MenuXF86Config,
	&MenuXDesktops,
	&MenuMediaDOS,
	&MenuMediaFTP,
	&MenuMediaTape,
	&MenuNetworkDevice,
	&MenuMedia,
	&MenuDistributions,
	&MenuSubDistributions,
	&MenuSrcDistributions,
	&MenuXF86Select,
	&MenuXF86SelectCore,
	&MenuXF86SelectFonts,
	&MenuXF86SelectServer, 
#if defined(__i386__) && defined(PC98)
	&MenuXF86SelectPC98Server,
#endif
	&MenuDiskDevices, 
	&MenuHTMLDoc,
	&MenuInstallCustom,
	&MenuMBRType, 
	&MenuConfigure, 
	&MenuNetworking, 
	&MenuNTP, 
	&MenuStartup, 
	&MenuSyscons, 
	&MenuSysconsKeymap, 
	&MenuSysconsKeyrate,
	&MenuSysconsSaver, 
	&MenuSysconsScrnmap, 
	&MenuSysconsFont, 
	&MenuSecurityProfile,
	&MenuFixit, 
	&MenuUsermgmt,
	0
    };

    for (i = 0; menus[i]; i++) {
	DMenu *menu;
	dialogMenuItem *d;
	
	menu = menus[i];
	convert_catalog(&menu->title);
	convert_catalog(&menu->prompt);
	convert_catalog(&menu->helpline);

	for (d = menu->items; d->prompt; d++) {
	    convert_catalog(&d->prompt);
	    convert_catalog(&d->title);
	}
    }
}

