#!/usr/bin/perl

# Copyright (c) 2000 Tatsumi HOSOKAWA <hosokawa@FreeBSD.org>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
#	$FreeBSD:$

if ($#ARGV ne 1 and $#ARGV ne 2) {
    print STDERR "Usage: getmsg.pl SysinstallSrcDir MessageCatalogDir [NewMessageCatalogDir]\n";
    exit 1;
}

$overwrite = 1 if ($#ARGV eq 1);

$sysinstall = $ARGV[0];
$catalog = $ARGV[1];
if (!$overwrite) {
    $newcatalog = $ARGV[2];
}

@catfiles = glob "$catalog/*.txt";

$/ = '';

foreach $c (@catfiles) {
    print "Checking category file $c...\n";
    open CATFILE, "$c" or die "Cannot open $c\n";
    while (<CATFILE>) {
	while (/(\n|^)\$\$\$\$(\d\d\d\d\d)\n/ and not /\\\\/) {
	    $_ .= <CATFILE>;
	}
	s/^(.*\n|)#[^\n]*\n/$1/g;
	if (/(\n|^)\$\$\$\$(\d\d\d\d\d)\n(.*?)\\\\/s) {
	    $catalogs{$2} = $3;
	}
    }
    close CATFILE;
}

@cfiles = glob "$sysinstall/*.c";

$/ = '';

foreach $f (@cfiles) {
    print "Checking C source file $f and updating corresponding catalog file...\n";
    @order = ();
    open CFILE, "$f" or die "Cannot open $f\n";
    while (<CFILE>) {
	do {
	    s!/\*[^\*]*\*/!!g;
	    if (s/\"\$\$\$\$(\d\d\d\d\d) (([^\"]|\\\"|\"\s*\")*[^\\])\"//s) {
		$number = $1;
		$message = $2;
		$message =~ s/\\t/\t/gs;
		$message =~ s/"\s*\n\s*"/\n/gs;
		$message =~ s/\\n//gs;
		$message =~ s/\\"/"/gs;
		if ($occurence{$number}) {
		    $lastfile = $file{$number};
		    print "Message ID $number found twice at $f and $lastfile\n";
		    exit 1;
		}
		$occurence{$number} = $message;
		$file{$number} = $f;
		push @order, $number;
	    }
	} while (/\"\$\$\$\$(\d\d\d\d\d) (([^\"]|\\\"|\"\s*\")*[^\\])\"/s);
    }
    close CFILE;
    if ($#order ne -1) {
	$catfilename = $f;
	$catfilename =~ s/.*\///;
	$catfilename =~ s/\.c$/_c/;
	$catfilename .= '.txt';
	@lines = ();

	foreach $m (@order) {
	    push @lines, "#Message ID: $m\n";
	    if (not $catalogs{$m}) {
		push @lines, "#[no translated message!]\n";
		push @lines, "#\$\$\$\$$m\n#\\\\\n";
	    }
	    else {
		$message = $catalogs{$m};
		push @lines, "\$\$\$\$$m\n$message\\\\\n";
	    }
	    $message = $occurence{$m};
	    $message =~ s/\n/\n\#/g;
	    push @lines, "#[English]\n#$message\n\n";
	}
	if ($overwrite) {
	    open CATFILE, "> $catalog/$catfilename" or die "Cannot open $catalog/$catfilename";
	    print CATFILE @lines;
	    close CATFILE;
	}
	else {
	    open CATFILE, "> $newcatalog/$catfilename" or die "Cannot open $newcatalog/$catfilename";
	    print CATFILE @lines;
	    close CATFILE;
	}
    }
}
