/*
 * KON - Kanji ON Linux / FreeBSD Console -
 * Copyright (C) 1992, 1993 Takashi MANABE (manabe@tut.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "getcap.h"

#include "version.h"
#include "term.h"

#include "kon2_config.h"
#include "kon2_sysinstall.h"

extern int masterPty;
enum lang language;

void 
kon2_main(int lang)
{
    char	*config_name;

#if 0
#if defined(linux)
    fprintf(stderr, "Kanji ON Linux console " KON2_VERSION "\n\n");
#elif defined(__FreeBSD__)
    fprintf(stderr, "Kanji ON FreeBSD console " KON2_VERSION "\n\n");
#endif
    if (geteuid() != 0) {
	fprintf(stderr, "can not get I/O permissions.\n");
	exit(50);
    }
#endif
    config_name = "/stand/fonts/kon.cfg";

    if (language == LANG_JAPANESE) {
	config_name = "/stand/fonts/kon.ja.cfg";
    }
    else if (language == LANG_KOREAN) {
	config_name = "/stand/fonts/kon.ko.cfg";
    }
    else if (language == LANG_TRAD_CHINESE) {
	config_name = "/stand/fonts/kon.zh_TW.cfg";
    }

    ChangeNewConsole();
#if 1
    TermInit();
#else
    TermInit(argc - 1, argv + 1);
#endif
    if (ReadConfig(config_name) < 0) {
	fprintf(stderr, "KON> error reading %s\n", config_name);
	exit(51);
    }
    TermStart();
}
