/*
 * KON - Kanji ON Linux / FreeBSD Console -
 * Copyright (C) 1992, 1993 Takashi MANABE (manabe@tut.ac.jp)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */

#include	"kon2_config.h"
#include	"kon2_sysinstall.h"

#include	<stdio.h>
#include	<stdlib.h>
#include	<sys/types.h>
#include	<sys/file.h>
#include	<string.h>
#include	<unistd.h>
#include	<signal.h>

#include	"interface.h"
#include	"vt.h"
#include	"fnld.h"

struct fontRegs *dbFReg, *sbFReg;

void FontDetach(void)
{
    int i;
    struct fontRegs *p;

    for (i = 0, p = &fSRegs[0]; p->registry; i++, p++) {
	if (p->stat == FR_ATTACH)
	    free(p->bitmap);
        p->bitmap = NULL;
	p->width = p->high = p->size = p->stat = 0;
    }
    for (i = 0, p = &fDRegs[0]; p->registry; i++, p++) {
	if (p->stat == FR_ATTACH)
            free(p->bitmap);
        p->bitmap = NULL;
	p->width = p->high = p->size = p->stat = 0;
    }
}

static char *fontfiles_jpn[] = {
  "/stand/fonts/8x16.bin",
  "/stand/fonts/jiskan16.bin",
};

static char *fontfiles_krn[] = {
  "/stand/fonts/8x16.bin",
  "/stand/fonts/g16.bin",
};

static char *fontfiles_ztw[] = {
  "/stand/fonts/8x16.bin",
  "/stand/fonts/hku-ch16.bin",
};

static char **fontfiles;

#define n_fontfiles(fontfiles) (sizeof(fontfiles) / sizeof(fontfiles[0]))

void FontAttach(void)
{
    int i;
    int n;

    u_char *font;
    struct fontRegs *p;
    struct fontInfo fi;

    FontDetach(); /* clear all fonts, first */

    switch (language) {
      case LANG_JAPANESE:
	fontfiles = fontfiles_jpn;
	n = n_fontfiles(fontfiles_jpn);
	break;
      case LANG_KOREAN:
	fontfiles = fontfiles_krn;
	n = n_fontfiles(fontfiles_krn);
	break;
      case LANG_TRAD_CHINESE:
	fontfiles = fontfiles_ztw;
	n = n_fontfiles(fontfiles_ztw);
	break;
      default:
	fprintf(stderr, "Unsupported Language!");
	exit(1);
    }
    for (i = 0; i < n; i++) {
        FILE *fp;
	int fildes[2];
    	static char tmp[FILENAME_MAX];

	sig_t old_hand = NULL;
	pid_t pid = 0;
	int stat = 0;

        if (!(fp = fopen(fontfiles[i], "r"))) {
	    strncpy(tmp, fontfiles[i], sizeof(tmp) - 4);
	    strcat(tmp, ".gz");
	    if (access(tmp, R_OK)) {
		perror(fontfiles[i]);
		exit(1);
	    }
	    old_hand = signal(SIGCHLD, SIG_DFL);
	    pipe(fildes);
	    pid = fork();
	    if (pid < 0) {
		perror("fork");
		exit(1);
	    }
	    else if (pid == 0) {
		close(fildes[0]);
		dup2(fildes[1], fileno(stdout));
		strncpy(tmp, fontfiles[i], sizeof(tmp) - 4);
		strcat(tmp, ".gz");
		execlp("zcat", "zcat", tmp, NULL);
		perror("execlp");
		_exit(1);
	    }
	    close(fildes[1]);
	    fp = fdopen(fildes[0], "r");
	    if (!fp) {
		strncpy(tmp, fontfiles[i], sizeof(tmp) - 4);
		strcat(tmp, ".gz");
		perror(tmp);
		exit(1);
	    }
        }
#if 1
        if (fread(&fi, sizeof(fi), 1, fp) != 1)
	    stat = -1;
	font = (u_char *)malloc(fi.size);
	if (!font) {
	    perror("malloc");
	    exit(1);
	}
	if (fread(font, 1, fi.size, fp) != fi.size)
	    stat = -1;
	if (stat) {
	    fprintf(stderr, "%s: Illegal file format.\n", fontfiles[i]);
	    exit(1);
	}
#else
        font = FontLoadBdf(fp, &fi);
#endif
	fclose(fp);
	if (pid) {
	    waitpid(pid, &stat, 0);
	    signal(SIGCHLD, old_hand);
	}

        if (fi.type & CHR_DBC) {
#if 0
FILE *fp = fopen("errlog", "a");
fprintf(fp, "D: loading %s to %d\n",
	fontfiles[i], (fi.type & ~CHR_DFLD));
fclose(fp);
#endif
            dbFReg = p = &fDRegs[fi.type & ~CHR_DFLD];
        } else {
#if 0
FILE *fp = fopen("errlog", "a");
fprintf(fp, "S: loading %s to %d\n",
	fontfiles[i], (fi.type & ~CHR_DFLD));
fclose(fp);
#endif
            sbFReg = p = &fSRegs[fi.type & ~CHR_DFLD];
        }
        if (p->registry) {
	    p->stat = FR_ATTACH;
	    p->high = fi.high;
	    p->size = fi.size;
	    p->bitmap = font;
        }
    }

    if (fSRegs[lInfo.sb].stat)
        sbFReg = &fSRegs[lInfo.sb];

    for (i = 0; fSRegs[i].registry; i++) {
	if (!fSRegs[i].stat) {
#if 0
FILE *fp = fopen("/tmp/errlog", "a");
fprintf(fp, "S: copy %d to %d\n", sbFReg - &fSRegs[0], i);
fclose(fp);
#endif
	    fSRegs[i].stat = FR_PROXY;
	    fSRegs[i].high = sbFReg->high;
	    fSRegs[i].size = sbFReg->size;
	    fSRegs[i].bitmap = sbFReg->bitmap;
	}
    }

    dbFReg = &fDRegs[lInfo.db];
}
