'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var RecordingList;
var RecordingPage;
var RecordingInstance;
var RecordingContext;

/* jshint ignore:start */
/**
 * Initialize the RecordingList
 *
 * @constructor Twilio.Trunking.V1.TrunkContext.RecordingList
 *
 * @param {Twilio.Trunking.V1} version - Version of the resource
 * @param {string} trunkSid - The unique string that identifies the resource
 */
/* jshint ignore:end */
RecordingList = function RecordingList(version, trunkSid) {
  /* jshint ignore:start */
  /**
   * @function recordings
   * @memberof Twilio.Trunking.V1.TrunkContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Trunking.V1.TrunkContext.RecordingContext}
   */
  /* jshint ignore:end */
  function RecordingListInstance(sid) {
    return RecordingListInstance.get(sid);
  }

  RecordingListInstance._version = version;
  // Path Solution
  RecordingListInstance._solution = {trunkSid: trunkSid};
  /* jshint ignore:start */
  /**
   * Constructs a recording
   *
   * @function get
   * @memberof Twilio.Trunking.V1.TrunkContext.RecordingList#
   *
   * @returns {Twilio.Trunking.V1.TrunkContext.RecordingContext}
   */
  /* jshint ignore:end */
  RecordingListInstance.get = function get() {
    return new RecordingContext(this._version, this._solution.trunkSid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Trunking.V1.TrunkContext.RecordingList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  RecordingListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  RecordingListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return RecordingListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the RecordingPage
 *
 * @constructor Twilio.Trunking.V1.TrunkContext.RecordingPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {RecordingSolution} solution - Path solution
 *
 * @returns RecordingPage
 */
/* jshint ignore:end */
RecordingPage = function RecordingPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(RecordingPage.prototype, Page.prototype);
RecordingPage.prototype.constructor = RecordingPage;

/* jshint ignore:start */
/**
 * Build an instance of RecordingInstance
 *
 * @function getInstance
 * @memberof Twilio.Trunking.V1.TrunkContext.RecordingPage#
 *
 * @param {RecordingPayload} payload - Payload response from the API
 *
 * @returns RecordingInstance
 */
/* jshint ignore:end */
RecordingPage.prototype.getInstance = function getInstance(payload) {
  return new RecordingInstance(this._version, payload, this._solution.trunkSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Trunking.V1.TrunkContext.RecordingPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
RecordingPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RecordingPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RecordingContext
 *
 * @constructor Twilio.Trunking.V1.TrunkContext.RecordingInstance
 *
 * @property {recording.recording_mode} mode - The recording mode for the trunk.
 * @property {recording.recording_trim} trim -
 *          The recording trim setting for the trunk.
 *
 * @param {V1} version - Version of the resource
 * @param {RecordingPayload} payload - The instance payload
 * @param {sid} trunkSid - The unique string that identifies the resource
 */
/* jshint ignore:end */
RecordingInstance = function RecordingInstance(version, payload, trunkSid) {
  this._version = version;

  // Marshaled Properties
  this.mode = payload.mode; // jshint ignore:line
  this.trim = payload.trim; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {trunkSid: trunkSid, };
};

Object.defineProperty(RecordingInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new RecordingContext(this._version, this._solution.trunkSid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a RecordingInstance
 *
 * @function fetch
 * @memberof Twilio.Trunking.V1.TrunkContext.RecordingInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a RecordingInstance
 *
 * @function update
 * @memberof Twilio.Trunking.V1.TrunkContext.RecordingInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {recording.recording_mode} [opts.mode] -
 *          The recording mode for the trunk.
 * @param {recording.recording_trim} [opts.trim] -
 *          The recording trim setting for the trunk.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Trunking.V1.TrunkContext.RecordingInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
RecordingInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RecordingInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RecordingContext
 *
 * @constructor Twilio.Trunking.V1.TrunkContext.RecordingContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} trunkSid -
 *          The SID of the Trunk from which to fetch the recording settings.
 */
/* jshint ignore:end */
RecordingContext = function RecordingContext(version, trunkSid) {
  this._version = version;

  // Path Solution
  this._solution = {trunkSid: trunkSid, };
  this._uri = `/Trunks/${trunkSid}/Recording`;
};

/* jshint ignore:start */
/**
 * fetch a RecordingInstance
 *
 * @function fetch
 * @memberof Twilio.Trunking.V1.TrunkContext.RecordingContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new RecordingInstance(this._version, payload, this._solution.trunkSid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a RecordingInstance
 *
 * @function update
 * @memberof Twilio.Trunking.V1.TrunkContext.RecordingContext#
 *
 * @param {object} [opts] - Options for request
 * @param {recording.recording_mode} [opts.mode] -
 *          The recording mode for the trunk.
 * @param {recording.recording_trim} [opts.trim] -
 *          The recording trim setting for the trunk.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RecordingInstance
 */
/* jshint ignore:end */
RecordingContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({'Mode': _.get(opts, 'mode'), 'Trim': _.get(opts, 'trim')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new RecordingInstance(this._version, payload, this._solution.trunkSid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Trunking.V1.TrunkContext.RecordingContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
RecordingContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

RecordingContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  RecordingList: RecordingList,
  RecordingPage: RecordingPage,
  RecordingInstance: RecordingInstance,
  RecordingContext: RecordingContext
};
