'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var NotificationList;
var NotificationPage;
var NotificationInstance;

/* jshint ignore:start */
/**
 * Initialize the NotificationList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Notify.V1.ServiceContext.NotificationList
 *
 * @param {Twilio.Notify.V1} version - Version of the resource
 * @param {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 */
/* jshint ignore:end */
NotificationList = function NotificationList(version, serviceSid) {
  /* jshint ignore:start */
  /**
   * @function notifications
   * @memberof Twilio.Notify.V1.ServiceContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Notify.V1.ServiceContext.NotificationContext}
   */
  /* jshint ignore:end */
  function NotificationListInstance(sid) {
    return NotificationListInstance.get(sid);
  }

  NotificationListInstance._version = version;
  // Path Solution
  NotificationListInstance._solution = {serviceSid: serviceSid};
  NotificationListInstance._uri = `/Services/${serviceSid}/Notifications`;
  /* jshint ignore:start */
  /**
   * create a NotificationInstance
   *
   * @function create
   * @memberof Twilio.Notify.V1.ServiceContext.NotificationList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.body] - The notification body text
   * @param {notification.priority} [opts.priority] -
   *          The priority of the notification
   * @param {number} [opts.ttl] - How long, in seconds, the notification is valid
   * @param {string} [opts.title] - The notification title
   * @param {string} [opts.sound] -
   *          The name of the sound to be played for the notification
   * @param {string} [opts.action] - The actions to display for the notification
   * @param {object} [opts.data] -
   *          The custom key-value pairs of the notification's payload
   * @param {object} [opts.apn] -
   *          The APNS-specific payload that overrides corresponding attributes in a generic payload for APNS Bindings
   * @param {object} [opts.gcm] -
   *          The GCM-specific payload that overrides corresponding attributes in generic payload for GCM Bindings
   * @param {object} [opts.sms] -
   *          The SMS-specific payload that overrides corresponding attributes in generic payload for SMS Bindings
   * @param {object} [opts.facebookMessenger] - Deprecated
   * @param {object} [opts.fcm] -
   *          The FCM-specific payload that overrides corresponding attributes in generic payload for FCM Bindings
   * @param {string|list} [opts.segment] - A Segment to notify
   * @param {object} [opts.alexa] - Deprecated
   * @param {string|list} [opts.toBinding] -
   *          The destination address specified as a JSON string
   * @param {string} [opts.deliveryCallbackUrl] - URL to send webhooks
   * @param {string|list} [opts.identity] -
   *          The `identity` value that identifies the new resource's User
   * @param {string|list} [opts.tag] - A tag that selects the Bindings to notify
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed NotificationInstance
   */
  /* jshint ignore:end */
  NotificationListInstance.create = function create(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Identity': serialize.map(_.get(opts, 'identity'), function(e) { return e; }),
      'Tag': serialize.map(_.get(opts, 'tag'), function(e) { return e; }),
      'Body': _.get(opts, 'body'),
      'Priority': _.get(opts, 'priority'),
      'Ttl': _.get(opts, 'ttl'),
      'Title': _.get(opts, 'title'),
      'Sound': _.get(opts, 'sound'),
      'Action': _.get(opts, 'action'),
      'Data': serialize.object(_.get(opts, 'data')),
      'Apn': serialize.object(_.get(opts, 'apn')),
      'Gcm': serialize.object(_.get(opts, 'gcm')),
      'Sms': serialize.object(_.get(opts, 'sms')),
      'FacebookMessenger': serialize.object(_.get(opts, 'facebookMessenger')),
      'Fcm': serialize.object(_.get(opts, 'fcm')),
      'Segment': serialize.map(_.get(opts, 'segment'), function(e) { return e; }),
      'Alexa': serialize.object(_.get(opts, 'alexa')),
      'ToBinding': serialize.map(_.get(opts, 'toBinding'), function(e) { return e; }),
      'DeliveryCallbackUrl': _.get(opts, 'deliveryCallbackUrl')
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new NotificationInstance(this._version, payload));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Notify.V1.ServiceContext.NotificationList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  NotificationListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  NotificationListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return NotificationListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the NotificationPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Notify.V1.ServiceContext.NotificationPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {NotificationSolution} solution - Path solution
 *
 * @returns NotificationPage
 */
/* jshint ignore:end */
NotificationPage = function NotificationPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(NotificationPage.prototype, Page.prototype);
NotificationPage.prototype.constructor = NotificationPage;

/* jshint ignore:start */
/**
 * Build an instance of NotificationInstance
 *
 * @function getInstance
 * @memberof Twilio.Notify.V1.ServiceContext.NotificationPage#
 *
 * @param {NotificationPayload} payload - Payload response from the API
 *
 * @returns NotificationInstance
 */
/* jshint ignore:end */
NotificationPage.prototype.getInstance = function getInstance(payload) {
  return new NotificationInstance(this._version, payload, this._solution.serviceSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Notify.V1.ServiceContext.NotificationPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
NotificationPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

NotificationPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the NotificationContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Notify.V1.ServiceContext.NotificationInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} serviceSid -
 *          The SID of the Service that the resource is associated with
 * @property {Date} dateCreated -
 *          The RFC 2822 date and time in GMT when the resource was created
 * @property {string} identities -
 *          The list of identity values of the Users to notify
 * @property {string} tags - The tags that select the Bindings to notify
 * @property {string} segments - The list of Segments to notify
 * @property {notification.priority} priority - The priority of the notification
 * @property {number} ttl - How long, in seconds, the notification is valid
 * @property {string} title - The notification title
 * @property {string} body - The notification body text
 * @property {string} sound -
 *          The name of the sound to be played for the notification
 * @property {string} action - The actions to display for the notification
 * @property {object} data -
 *          The custom key-value pairs of the notification's payload
 * @property {object} apn -
 *          The APNS-specific payload that overrides corresponding attributes in a generic payload for APNS Bindings
 * @property {object} gcm -
 *          The GCM-specific payload that overrides corresponding attributes in generic payload for GCM Bindings
 * @property {object} fcm -
 *          The FCM-specific payload that overrides corresponding attributes in generic payload for FCM Bindings
 * @property {object} sms -
 *          The SMS-specific payload that overrides corresponding attributes in generic payload for SMS Bindings
 * @property {object} facebookMessenger - Deprecated
 * @property {object} alexa - Deprecated
 *
 * @param {V1} version - Version of the resource
 * @param {NotificationPayload} payload - The instance payload
 * @param {sid} serviceSid -
 *          The SID of the Service that the resource is associated with
 */
/* jshint ignore:end */
NotificationInstance = function NotificationInstance(version, payload,
                                                      serviceSid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.serviceSid = payload.service_sid; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.identities = payload.identities; // jshint ignore:line
  this.tags = payload.tags; // jshint ignore:line
  this.segments = payload.segments; // jshint ignore:line
  this.priority = payload.priority; // jshint ignore:line
  this.ttl = deserialize.integer(payload.ttl); // jshint ignore:line
  this.title = payload.title; // jshint ignore:line
  this.body = payload.body; // jshint ignore:line
  this.sound = payload.sound; // jshint ignore:line
  this.action = payload.action; // jshint ignore:line
  this.data = payload.data; // jshint ignore:line
  this.apn = payload.apn; // jshint ignore:line
  this.gcm = payload.gcm; // jshint ignore:line
  this.fcm = payload.fcm; // jshint ignore:line
  this.sms = payload.sms; // jshint ignore:line
  this.facebookMessenger = payload.facebook_messenger; // jshint ignore:line
  this.alexa = payload.alexa; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {serviceSid: serviceSid, };
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Notify.V1.ServiceContext.NotificationInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
NotificationInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

NotificationInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  NotificationList: NotificationList,
  NotificationPage: NotificationPage,
  NotificationInstance: NotificationInstance
};
