<?php
// $Id: service.class.php,v 1.1.1.1 2011/12/15 02:18:04 ohwada Exp $

//=========================================================
// GooglePlus Login with Google API Client
// 2011-12-12 K.OHWADA
//=========================================================

//---------------------------------------------------------
// https://developers.google.com/+/downloads
//---------------------------------------------------------

class googleplus_service
{
	var $_api_client   = null;
	var $_plus_service = null;

	var $_application_name = null;
	var $_client_id        = null; 
	var $_client_secret    = null; 
	var $_developer_key    = null; 
	var $_url_callback     = null;
	var $_scope_array      = array();
	var $_flag_login       = false;

	var $_error_code = 0;
	var $_error_msg  = null;

	var $_URL_SCOPE_PLUS_ME = 'https://www.googleapis.com/auth/plus.me';

	var $_NAME_CODE         = 'code';

	var $_DATE_FORMAT_DATE     = "Y/n/j";
	var $_DATE_FORMAT_DATETIME = "Y/n/j H:i";

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function googleplus_service()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance))  {
		$instance =& new googleplus_service();
	}
	return $instance;
}

function get_error_code() 
{
	return $this->_error_code ;
}

function get_error_msg() 
{
	return $this->_error_msg ;
}

function set_application_name( $v )
{
	$this->_application_name = $v; 
}

function set_client_id( $v )
{
	$this->_client_id = $v; 
}

function set_client_secret( $v )
{
	$this->_client_secret = $v; 
}

function set_developer_key( $v )
{
	$this->_developer_key = $v; 
}

function set_url_callback( $v )
{
	$this->_url_callback = $v; 
}

function set_scope_plus_me( $v )
{
	if ( $v ) {
		$this->add_scope( $this->_URL_SCOPE_PLUS_ME );
	}
}

function add_scope( $v )
{
	$this->_scope_array[] = $v;
}

function set_scope_array( $v )
{
	if ( Is_array($v) ) {
		$this->_scope_array = $v;
	}
}

function set_client_access_token( $v )
{
	$this->_api_client->setAccessToken( $v );
}

function set_flag_login( $v )
{
	$this->_flag_login = (bool)$v;
}

//---------------------------------------------------------
// init
//---------------------------------------------------------
function init_api_client()
{
	$this->_api_client = new apiClient();
	$this->_api_client->setApplicationName( $this->_application_name );
	$this->_api_client->setClientId(        $this->_client_id );
	$this->_api_client->setClientSecret(    $this->_client_secret );
	$this->_api_client->setDeveloperKey(    $this->_developer_key );
	$this->_api_client->setRedirectUri(     $this->_url_callback );
	$this->_api_client->setScopes(          $this->_scope_array );
}

function init_plus_service()
{
	$this->_plus_service = new apiPlusService( $this->_api_client );
}

//---------------------------------------------------------
// login
//---------------------------------------------------------
function login()
{
	$redirect_url = $this->_api_client->createAuthUrl();
	header('Location: '. $redirect_url );
	exit();
}

//---------------------------------------------------------
// callback
//---------------------------------------------------------
function callback()
{
	if ( !isset($_GET[ $this->_NAME_CODE ]) ) {
		$this->_error_code = 21;
		return false;
	}

	$this->_api_client->authenticate();
	$token = $this->_api_client->getAccessToken();
	$this->_api_client->setAccessToken( $token );

	$param = array(
		'token' => $token ,
	);
	return $param;

}

//---------------------------------------------------------
// people
//---------------------------------------------------------
function get_people( $id )
{
	return $this->_plus_service->people->get( $id );
}

//---------------------------------------------------------
// activityi
//---------------------------------------------------------
function get_activity_feeds( $id, $max=100 )
{
  	$optParams = array('maxResults' => $max);
  	return $this->_plus_service->activities->listActivities($id, 'public', $optParams);
}

//---------------------------------------------------------
// utitity
//---------------------------------------------------------
function person_to_flat( $item )
{
	$arr = array();
	foreach ( $item as $k => $v ) {
		$arr = $this->array_to_flat( $arr, $k, $v );
	}
	return $arr;
}

function activity_feeds_to_flat( $item )
{
	$arr = array();
	foreach ( $item as $k => $v )
	{
		if ( $k == 'items' ) {
			$arr[ $k ] = $this->activity_items_to_flat( $v );
		} else {
			$arr = $this->array_to_flat( $arr, $k, $v );
		}
	}
	return $arr;
}

function activity_items_to_flat( $items )
{
	$arr = array();
	foreach ( $items as $item ) {
		$arr[] = $this->activity_item_to_flat( $item );
	}
	return $arr;
}

function activity_item_to_flat( $item )
{
	$arr = array();
	foreach ( $item as $k => $v )
	{
		if ( $k == 'actor' ) {
			$arr = $this->activity_item_actor_to_flat( $arr, $k, $v );
		} elseif ( $k == 'published' ) {
			$arr = $this->activity_item_datetime( $arr, $k, $v );
		} elseif ( $k == 'updated' ) {
			$arr = $this->activity_item_datetime( $arr, $k, $v );
		} else {
			$arr = $this->array_to_flat( $arr, $k, $v );
		}
	}
	return $arr;
}

function activity_item_actor_to_flat( $arr, $key, $value )
{
	$person = $this->person_to_flat( $value );
	foreach ( $person as $k => $v ) {
		$arr[ $key.'_'.$k ] = $v;
	}
	return $arr;
}

function activity_item_datetime( $arr, $key, $value )
{
	$arr[ $key ] = $value;

	$unixtime = strtotime( $value );
	if ( $unixtime > 0 ) {
		$arr[ $key.'_unixtime' ] = $unixtime;
		$arr[ $key.'_date' ]     = date( $this->_DATE_FORMAT_DATE, $unixtime);
		$arr[ $key.'_datetime' ] = date( $this->_DATE_FORMAT_DATETIME, $unixtime);
	}

	return $arr;
}

function array_to_flat( $array, $key, $value )
{
	$key = strtolower( $key );
	if ( is_array($value) ) {
		foreach ( $value as $k1 => $v1 ) {
			if ( is_int($k1) ) {
				$array[ $key ][ $k1 ] = $v1;
			} else {
				$kk = strtolower( $key.'_'.$k1 );
				$array[ $kk ] = $v1;
			}
		}
	} else {
		$array[ $key ] = $value;
	}
	return $array;
}

// reference: XOOPS module.textsanitizer.php
function make_clickable_http( $str )
{
	$p[] = "/(^|[^]_a-z0-9-=\"'\/])([a-z]+?):\/\/([^, \r\n\"\(\)'<>]+)/i";
	$p[] = "/(^|[^]_a-z0-9-=\"'\/])www\.([a-z0-9\-]+)\.([^, \r\n\"\(\)'<>]+)/i";
	$p[] = "/(^|[^]_a-z0-9-=\"'\/])ftp\.([a-z0-9\-]+)\.([^, \r\n\"\(\)'<>]+)/i";
	$p[] = "/(^|[^]_a-z0-9-=\"'\/:\.])([a-z0-9\-_\.]+?)@([^, \r\n\"\(\)'<>\[\]]+)/i";

	$r[] = "\\1<a href=\"\\2://\\3\" target=\"_blank\">\\2://\\3</a>";
	$r[] = "\\1<a href=\"http://www.\\2.\\3\" target=\"_blank\">www.\\2.\\3</a>";
	$r[] = "\\1<a href=\"ftp://ftp.\\2.\\3\" target=\"_blank\">ftp.\\2.\\3</a>";
	$r[] = "\\1<a href=\"mailto:\\2@\\3\">\\2@\\3</a>";

	$str = preg_replace( $p, $r, $str );
	return $str;
}

//---------------------------------------------------------
// encoding
//---------------------------------------------------------
function convert_encoding_person( $person, $to )
{
	return $this->convert_encoding_array( $person, $to );
}

function convert_encoding_activity_feeds( $items, $to )
{
	$arr = array();
	foreach ( $items as $k => $v )
	{
		if ( $k == 'items' ) {
			$arr[ $k ] = $this->convert_encoding_activity_items( $v, $to );
		} else {
			$arr[ $k ] = $this->convert_encoding_array_recurcive( $v, $to );
		}
	}
	return $arr;
}

function convert_encoding_activity_items( $items, $to )
{
	$arr = array();
	foreach ( $items as $item ) {
		$arr[] = $this->convert_encoding_array( $item, $to );
	}
	return $arr;
}

function convert_encoding_array( $array, $to )
{
	$arr = array();
	foreach ( $array as $k => $v ) {
		$arr[ $k ] = $this->convert_encoding_array_recurcive( $v, $to );
	}
	return $arr;
}

function convert_encoding_array_recurcive( $value, $to, $depth=0 )
{
	$depth ++;
	if ( $depth > 10 ) {
		return $value;
	}

	if ( !is_array($value) ) {
		return $this->convert_from_utf8( $value, $to );
	}

	$arr = array();
	foreach ( $value as $k => $v ) {
		$arr[ $k ] = $this->convert_encoding_array_recurcive( $v, $to, $depth );
	}
	return $arr;

}

function convert_from_utf8( $str, $to )
{
	return $this->convert_encoding( $str, 'UTF-8', $to );
}

function convert_to_utf8( $str, $from )
{
	return $this->convert_encoding( $str, $from, 'UTF-8' );
}

function convert_encoding( $str, $from, $to, $extra='//IGNORE' )
{
	if ( strtolower($to) == strtolower($from) ) {
		return $str;
	}
	if ( function_exists('iconv') ) {
		return iconv( $from, $to.$extra, $str );
	}
	if ( function_exists('mb_convert_encoding') ) {
		return mb_convert_encoding( $str, $from, $to );
	}
	return $str;
}

// === class end ===
}
?>