#include "itext.h"
#include <ctype.h>


void euc2utf8_c(iconv_t con,char *to,char *from,int from_len)
{
	char *utf8,*utf;
	char *euc;
	int euc_len,utf8_len;

	euc_len = from_len;
	utf8_len = from_len * 2;

	euc = from;
	utf8 = (char *)malloc(utf8_len);
	memset(utf8,0,utf8_len);

	utf = utf8;
	iconv(con,&euc,&euc_len,&utf8,&utf8_len);

	strcpy(to,utf);
	free(utf);

}
char * euc2utf8(iconv_t con,char *str,int len)
{
	char *euc,*utf8,*utf;
	int euc_len,utf8_len;

	euc_len = len;
	euc = str;

	utf8_len = len * 2;
	utf8 = (char *)malloc(utf8_len);
	memset(utf8,0,utf8_len);

	utf = utf8;
	iconv(con,&euc,&euc_len,&utf8,&utf8_len);

	return utf;
}
static int _16to10(char *p)
{
	char c;
	unsigned int f;

	if(*p >= '0' && *p <= '9'){
		f = *p - '0';

	}else if((*p >= 'a' && *p <= 'f') || (*p >= 'A' && *p <= 'F')){
		c = tolower(*p);
		f = c - 'a' + 10;
	}else{
		return -1;
	}

	return f;
}
unsigned int xstring2uint(char *str)
{
	char *p[2];
	unsigned int i,f,f0;

	if(!(*(str+0) == '0' && *(str+1) == 'x')) return -1;

	p[0] = str+2;
	p[1] = str+3;

	f = 0;
	for(i=0;i<2;i++){
		if((f0 = _16to10(p[i])) < 0) return -1;

		f = f * 16 + f0;
	}

	return f;
}
int itextFlag(ITEXT_T *it,int type,int on)
{
	if(it == NULL) return -1;

	if(on)
		it->flag |= (1 << type);
	else
		it->flag &= ~(1 << type);


	return 0;
}








