#include "xtext.h"
#include <dirent.h>

extern char *XJP_MESSAGE[];

static unsigned char *base_str = "";

static sub_window_t * _subwindow_data_alloc()
{
	sub_window_t *sw;

	sw = (sub_window_t *)malloc(sizeof(sub_window_t));
	sw->line_str[0] = '\0';
	sw->line_data = NULL;
	sw->re_str = NULL;
	sw->func = NULL;
	sw->func_data0 = NULL;
	sw->func_data1 = -1;
	sw->type = XJP_NONE;
	sw->line_no = -1;

	return sw;
}
void * _subwindow_data_free(sub_window_t **head,sub_window_t **tail)
{
	sub_window_t *sw,*sww;

	if(*head == NULL) return NULL;

	for(sw = *head;sw!=NULL;sw=sww){
		sww = sw->next;

		/*
		if(sw->re_str != NULL) free(sw->re_str);
		if(sw->func_data0 != NULL) free(sw->func_data0);
		if(sw->line_data != NULL) free(sw->line_data);
		*/
		free(sw);
	}

	*head = NULL;
	*tail = NULL;

	return NULL;
}
static void * _subwindow_data_add(sub_window_t **head,sub_window_t **tail,sub_window_t *im)
{
	if(*tail){
                im->next = NULL;
                im->prev = *tail;

                (*tail)->next = im;
                *tail = im;
        }else{
                im->next = NULL;
                im->prev = NULL;

                *tail = im;
                *head = im;
        }

        return NULL;
}

static void _subwindow_data_insert(	sub_window_t **head,
					sub_window_t **tail,
					char *line_str,
					char *line_data,
					char *re_str,
					int (*func)(),
					void * data0,
					int data1,
					int type,
					int line_no	)
{
	sub_window_t *sw;

	sw = (sub_window_t *)_subwindow_data_alloc();

	strcpy(sw->line_str,line_str);
	sw->line_data = line_data;
	sw->re_str = re_str;
	sw->func = func;
	sw->func_data0 = data0;
	sw->func_data1 = data1;
	sw->line_no = line_no;
	sw->type = type;

	_subwindow_data_add(head,tail,sw);

	return ;
}
int xtextHelpData2Sub(sub_window_t **head,sub_window_t **tail,xtext_conf_t *xconf)
{
	char line_str[256];
	void *line_data,*data0;
	int data1;
	int type;
	int i = 1;

	if(*head != NULL) _subwindow_data_free(head,tail);

	strcpy(line_str,"-- [Up-Down]ư [Enter]ѹ,¹ --");
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	strcpy(line_str,"(λ:ѹȿǤ)");
	line_data = NULL;
	data0 = (char *)XJP_OK;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_quit,data0,data1,type,i++);

	strcpy(line_str,"(Cancel:ѹȿǤʤ)");
	line_data = NULL;
	data0 = (char *)XJP_CANCEL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_quit,data0,data1,type,i++);

	strcpy(line_str,"(¸:ߤ¸)");
	line_data = NULL;
	data0 = (xtext_conf_t *)xconf;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_save,data0,data1,type,i++);


       	strcpy(line_str,"¸ʸ:");
	line_data = xconf->book_dir;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	sprintf(line_str,"[]");
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	strcpy(line_str,"ڡ:");
	line_data = xconf->page_next;
	data0 = (char *)xconf->page_next;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);


	strcpy(line_str,"ڡ:");
	line_data = xconf->page_prev;
	data0 = (char *)xconf->page_prev;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ڡ:");
	line_data = xconf->conf_page;
	data0 = (char *)xconf->conf_page;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ٵϿ:");
	line_data = xconf->book_mark;
	data0 = (char *)xconf->book_mark;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"٥˥塼:");
	line_data = xconf->siori_menu;
	data0 = (char *)xconf->siori_menu;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"˥塼:");
	line_data = xconf->menu;	
	data0 = (char *)xconf->menu;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"λ:");
	line_data = xconf->quit;
	data0 = (char *)xconf->quit;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ȥON-OFF:");
	line_data = xconf->title_key;
	data0 = (char *)xconf->title_key;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ǡɽON-OFF:");
	line_data = xconf->page_key;
	data0 = (char *)xconf->page_key;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"٥ѹ:");
	line_data = xconf->kinsc_key;
	data0 = (char *)xconf->kinsc_key;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ɥON-OFF:");
	line_data = xconf->chuki_key;
	data0 = (char *)xconf->chuki_key;
	data1 = XJP_CHA;
	type = XJP_CHA;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"[ɥ]");
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	sprintf(line_str,"ɥ: %d",xconf->main_window_width);
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	sprintf(line_str,"ɥ: %d",xconf->main_window_height);
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	strcpy(line_str,"طʿ:");
	line_data = xconf->main_window_color;
	data0 = (char *)xconf->main_window_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ᥤʸ:");
	line_data = xconf->main_font_color;
	data0 = (char *)xconf->main_font_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ʸ:");
	line_data = xconf->rubi_font_color;
	data0 = (char *)xconf->rubi_font_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"˥塼طʿ:");
	line_data = xconf->menu_window_color;
	data0 = (char *)xconf->menu_window_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"˥塼ʸ:");
	line_data = xconf->menu_font_color;
	data0 = (char *)xconf->menu_font_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ʸƿ:");
	line_data = xconf->main_shadow_color;
	data0 = (char *)xconf->main_shadow_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str," طʿ:");
	line_data = xconf->select_window_color;
	data0 = (char *)xconf->select_window_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str," ʸ:");
	line_data = xconf->select_font_color;
	data0 = (char *)xconf->select_font_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str," :");
	line_data = xconf->select_font_background_color;
	data0 = (char *)xconf->select_font_background_color;
	data1 = XJP_COL;
	type = XJP_COL;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);
	strcpy(line_str,"[ե]");
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	strcpy(line_str,"ե(J):");
	line_data = xconf->main_font_j;
	data0 = (char *)xconf->main_font_j;
	data1 = XJP_FONT;
	type = XJP_FONT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ե(small):");
	line_data = xconf->main_font_s;
	data0 = (char *)xconf->main_font_s;
	data1 = XJP_FONT;
	type = XJP_FONT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ե(E):");
	line_data = xconf->main_font_e;
	data0 = (char *)xconf->main_font_e;
	data1 = XJP_FONT;
	type = XJP_FONT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ӥե:");
	line_data = xconf->rubi_font;
	data0 = (char *)xconf->rubi_font;
	data1 = XJP_FONT;
	type = XJP_FONT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"Դ:");
	line_data = &(xconf->line_space);
	data0 = (int *)&xconf->line_space;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ʸ:");
	line_data = &(int)(xconf->row_space);
	data0 = (int *)&xconf->row_space;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"[]");
	line_data = NULL;
	data0 = NULL;
	data1 = XJP_NONE;
	type = XJP_NONE;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,NULL,data0,data1,type,i++);

	strcpy(line_str,"ꥢ:");
	line_data = (int *)&xconf->anti;
	data0 = (int *)&xconf->anti;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ȥɽ:");
	line_data = (int *)&xconf->title_on;
	data0 = (int *)&xconf->title_on;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ǡɽ:");
	line_data = (int *)&xconf->page_on;
	data0 = (int *)&xconf->page_on;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"٥:");
	line_data = (int *)&xconf->kinsc;
	data0 = (int *)&xconf->kinsc;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	strcpy(line_str,"ɥɽ:");
	line_data = (int *)&xconf->chuki;
	data0 = (int *)&xconf->chuki;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);

	/*
	strcpy(line_str,"ɽ:");
	line_data = (int *)&xconf->ruby_on;
	data0 = (int *)&xconf->ruby_on;
	data1 = XJP_INT;
	type = XJP_INT;
	_subwindow_data_insert(head,tail,line_str,line_data,NULL,xtext_conf_change,data0,data1,type,i++);
	*/

	return 0;
}
int xtextSioriData2Sub(sub_window_t **head,sub_window_t **tail,xtext_siori_t *s_head)
{
	sub_window_t *sw;
	xtext_siori_t *si;
	int i;

	if(s_head == NULL) return -1;
	if(*head != NULL) _subwindow_data_free(head,tail);

	_subwindow_data_insert(head,tail,"----- [Up-Down]ư [Enter] -----",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,1);
	_subwindow_data_insert(head,tail,"(󥻥)",NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,2);
	for(si=s_head,i=3;si!=NULL;si=si->next,i++){
		sw = (sub_window_t *)_subwindow_data_alloc();
		sprintf(sw->line_str,"%s (%s)",si->book_title,si->book_time);

		sw->re_str = (char *)malloc(strlen(si->book_path)+2);
		strcpy(sw->re_str,si->book_path);
		sw->func_data1 = XJP_STR;

		sw->line_no = i;

		_subwindow_data_add(head,tail,sw);
	}

	return 0;
}
int xtextBookData2Sub(sub_window_t **head,sub_window_t **tail,char *dname)
{
	sub_window_t *sw;

	IBOOK_T *bhead = NULL, *btail = NULL;
	IBOOK_T *ib;

	int i,total;

	if(*head != NULL) _subwindow_data_free(head,tail);

	total = ibookGetFileData(&bhead,&btail,dname);

	_subwindow_data_insert(head,tail,"----- [Up-Down]ư [Enter] -----",NULL,NULL,NULL,NULL,XJP_NONE,XJP_NONE,1);

	_subwindow_data_insert(head,tail,"(󥻥)",NULL,NULL,xtext_conf_quit,(char *)XJP_CANCEL,XJP_NONE,XJP_NONE,2);

	for(ib=bhead,i=3;ib!=NULL;ib=ib->next,i++){
		/*
		if(ib->code == -2){
			_subwindow_data_insert(head,tail,ib->title,NULL,NULL,_select_book_data,ib->fullpath,XJP_NONE,XJP_NONE,i);

		}else{
		*/
			sw = (sub_window_t *)_subwindow_data_alloc();
			sprintf(sw->line_str,"%s (%s)",ib->title,ib->filename);
			sw->re_str = (char *)malloc(strlen(ib->fullpath)+2);
			strcpy(sw->re_str,ib->fullpath);
			sw->func_data1 = XJP_STR;
			sw->line_no = i;
			_subwindow_data_add(head,tail,sw);
		/*}*/
	}
	book_link_free(&bhead,&btail);

	return 0;
}
static int _get_line_str(char *line,sub_window_t *sw)
{
	if(sw == NULL) return -1;

	if(sw->line_data == NULL){
		strcpy(line,sw->line_str);
	}else{
		if(sw->type == XJP_INT){
			sprintf(line,"%s %d",sw->line_str,*((int *)sw->line_data));
		}else{
			sprintf(line,"%s %s",sw->line_str,(char *)sw->line_data);
		}
	}

	return 0;
}
static int _check_hilight_str(sub_window_t *sw)
{
	if(sw == NULL) return 0;

	if(sw->func==NULL && sw->func_data0==NULL && sw->func_data1==XJP_NONE) return 1;

	return 0;
}
static int _Draw_SubWindow_Text(	Display *disp,
					my_subwindow_t swin,
					int fh,
					sub_window_t *head,
					sub_window_t *tail,
					sub_window_t *CSW,
					int PY	)
{
	Drawable pwin;
	Pixmap pix;
	sub_window_t *psw,*nsw,*sw;
	char line_str[256];

	int i,x,y,CY;

	pwin = swin.win;
	XClearWindow(disp,pwin);

	x = 5;
	CY = PY * fh;

	if(_get_line_str(line_str,CSW) >= 0)
		XmbDrawImageString(disp,pwin,swin.fs,swin.rfgc,x,CY,line_str,strlen(line_str));

	for(sw=CSW->prev,i=1;sw!=NULL;sw=sw->prev,i++){
		if((y = CY - (i * fh)) < fh) break;
		if(_get_line_str(line_str,sw)>=0){

			if(_check_hilight_str(sw)){
				XmbDrawString(disp,pwin,swin.fs,swin.sgc,x,y,line_str,strlen(line_str));
			}else{
				XmbDrawString(disp,pwin,swin.fs,swin.fgc,x,y,line_str,strlen(line_str));
			}
		}
	}
	for(sw=CSW->next,i=1;sw!=NULL;sw=sw->next,i++){
		if((y = CY + (i * fh)) > swin.height) break;
		if(_get_line_str(line_str,sw) >= 0){
			if(_check_hilight_str(sw)){
				XmbDrawString(disp,pwin,swin.fs,swin.sgc,x,y,line_str,strlen(line_str));
			}else{
				XmbDrawString(disp,pwin,swin.fs,swin.fgc,x,y,line_str,strlen(line_str));
			}
		}
	}

	return 0;
}
char * xtextSubWindow(Display *disp,my_window_t win,sub_window_t *head,sub_window_t *tail)
{
	sub_window_t *st;
	int line = 0,sh;

	int percent = 80;
	char *result = NULL;

	my_subwindow_t swin;
	XEvent event;
	KeySym keysym;
	XRectangle ink,log;

	int x,y,loop = 1;

	int fh;

	sub_window_t *CSW;
	int PY,H_LINE;


	swin.fs = win.fs_s;
	swin.gc = win.gc;
	swin.bgc = win.bgc;
	swin.fgc = win.fgc;
	swin.rfgc = win.rfgc;
	swin.sgc = win.sgc;

	swin.fg_pixel = win.menu_fg_pixel;
	swin.bg_pixel = win.menu_bg_pixel;

	swin.parent_win = win.win;
	swin.width = (win.width * percent) / 100;
	swin.height = (win.height * percent) / 100;

	XmbTextExtents(swin.fs,base_str,strlen(base_str),&ink,&log);
	fh = log.height + 5;

	for(st=head;st!=NULL;st=st->next){
		line++;
	}
	sh = line * fh + 5;
	if(sh < swin.height) swin.height = sh;

	swin.x = (win.width - swin.width) / 2;
	swin.y = (win.height - swin.height) / 2;

	swin.win = XCreateSimpleWindow(disp,swin.parent_win,swin.x,swin.y,swin.width,swin.height,0,swin.fg_pixel,swin.bg_pixel);
	XSelectInput(disp,swin.win,ExposureMask|KeyPressMask);
	XMapRaised(disp,swin.win);

	H_LINE = swin.height / fh;
	PY = 1;
	CSW = head;
	while(loop){
		usleep(50);
		while(XPending(disp)){
			XNextEvent(disp,&event);
			switch(event.type){
				case Expose:
					_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY);
				break;
				case KeyPress:
					keysym = XLookupKeysym(&event.xkey,0);
					switch(keysym){
						case XK_Return:
							if(CSW->func == NULL && CSW->re_str != NULL){
								result = CSW->re_str;
								loop = 0;

							}else if(CSW->func != NULL && CSW->re_str == NULL){

								switch(CSW->func(CSW->func_data0,CSW->func_data1)){
									case -4:case -3:
								 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[5]);
									break;
									case -2:
								 		xtextSubWindow_Message(disp,win,XJP_MESSAGE[4]);
									break;
									case -1:
								       		result = XJP_CANCEL;
								       		loop = 0;
									break;
									case 1:
									 	result = XJP_OK;
									 	loop = 0;
									break;
									case 2:
									 	xtextSubWindow_Message(disp,win,XJP_MESSAGE[3]);
									break;
								 }
								_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY);
							}
						break;
						case XK_q:
							loop = 0;
						break;
						case XK_Up:
							if(CSW->prev == NULL) break;
							CSW = CSW->prev;
							if(PY-- <= 1) PY = 1;
							_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY);
						break;
						case XK_Down:
							if(CSW->next == NULL) break;
							CSW = CSW->next;
							if(PY++ >= H_LINE) PY = H_LINE;
							_Draw_SubWindow_Text(disp,swin,fh,head,tail,CSW,PY);
						break;
					}
				break;
			}
		}
	}

	XDestroyWindow(disp,swin.win);

	return result;
}
int xtextSubWindow_Message(Display *disp,my_window_t win,char *message)
{
	my_subwindow_t swin;
	XRectangle ink,log;

	int x,y;
	int message_len;


	swin.fs = win.fs_s;
	swin.gc = win.gc;
	swin.bgc = win.bgc;
	swin.fgc = win.fgc;
	swin.rfgc = win.rfgc;
	swin.sgc = win.sgc;

	swin.fg_pixel = win.menu_fg_pixel;
	swin.bg_pixel = win.menu_bg_pixel;
	swin.parent_win = win.win;

	message_len = strlen(message);
	XmbTextExtents(swin.fs,message,message_len,&ink,&log);

	swin.width = log.width + 4;
	swin.height = log.height + 4;

	swin.x = (win.width - swin.width) / 2;
	swin.y = (win.height - swin.height) / 2;

	swin.win = XCreateSimpleWindow(disp,swin.parent_win,swin.x,swin.y,swin.width,swin.height,1,swin.fg_pixel,swin.bg_pixel);
	XMapRaised(disp,swin.win);

	XmbDrawString(disp,swin.win,swin.fs,swin.fgc,2,log.height,message,message_len);
	XFlush(disp);


	sleep(2);


	XDestroyWindow(disp,swin.win);

	return 0;
}


	


















