#include "itext.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <wkf.h>


static char *K_CODE[5] = {"UN_KNOWN","ASCII","JIS","EUC","SJIS"};
static char *KEYPUSH = "< [Up] select up  [Down] select down  [Space] enter >";


void book_link_free(IBOOK_T **head,IBOOK_T **tail)
{
	IBOOK_T *wd,*wdd;

	if(*head == NULL) return;

	for(wd = *head;wd!=NULL;wd=wdd){
		wdd = wd->next;
		free(wd);
	}

	*head = NULL;
	*tail = NULL;
	return ;
}
static int _link_data_change(IBOOK_T **head,IBOOK_T **tail,IBOOK_T *p,IBOOK_T *t)
{
        IBOOK_T *next,*prev;

        if(p->prev == NULL || t->prev == NULL){
                if(p->prev == NULL){
			t->prev->next = p;
			p->prev = t->prev;

			t->prev = NULL;
                        *head = t;

                }else if(t->prev == NULL){
                        p->prev->next = t;
                        t->prev = p->prev;

                        p->prev = NULL;
                        *head = p;
                }

        }else{
                p->prev->next = t;
                t->prev->next = p;

                prev = p->prev;
                p->prev = t->prev;
                t->prev = prev;
        }

        if(p->next == NULL || t->next == NULL){
                if(p->next == NULL){
			t->next->prev = p;
                        p->next = t->next;

                        t->next = NULL;
                        *tail = t;

                }else if(t->next == NULL){
                        p->next->prev = t;
                        t->next = p->next;

                        p->next = NULL;
                        *tail = p;
                }
        }else{
		p->next->prev = t;
                t->next->prev = p;

                next = p->next;
                p->next = t->next;
                t->next = next;
        }

	        return 0;
}
static int _book_link_sort(IBOOK_T **head,IBOOK_T **tail)
{
	 IBOOK_T *t,*p,*next,*cm;
         unsigned long x,x1;

         if(*head == NULL) return -1;

         for(t = *head;t->next != NULL;t = next){
                 x = t->fno;
                 next = t->next;

                 cm = NULL;
                 for(p = next;p != NULL;p = p->next){
                         x1 = p->fno;
                         if(x1 > x){
                                 x = x1;
                                 cm = p;
                         }
                 }
                 if(cm != NULL){
                         _link_data_change(head,tail,t,cm);
                 }
	 }

	 return 0;
}
static IBOOK_T *_book_link_alloc()
{
	IBOOK_T *ik;

	ik = (IBOOK_T *)malloc(sizeof(IBOOK_T));

	return ik;
}
static void _book_link_add(IBOOK_T **head,IBOOK_T **tail,IBOOK_T *ik)
{
	if(*tail){
		ik->next = NULL;
		ik->prev = *tail;

		(*tail)->next = ik;
		*tail = ik;
	}else{
		ik->next = NULL;
		ik->prev = NULL;

		*tail = ik;
		*head = ik;
	}
	return ;
}
static char *_ibookGetCode(int code)
{
	switch(code){
		case 1:
			return K_CODE[1];
		break;
		case 2:
			return K_CODE[2];
		break;
		case 3:
			return K_CODE[3];
		break;
		case 4:
			return K_CODE[4];
		break;
		default:
			return K_CODE[0];
		break;
	}
}
static int _ibookGetTitle(char *fname,char *title,int ftype)
{
	int i;
	kcode_t code;

	if(ftype == 0){
		FILE *fp;
		unsigned char buf[BUFSIZ];

		if((fp = fopen(fname,"r")) == NULL){
			strcpy(title,"Unknown Title");
			return -1;
		}

		while(fgets(buf,BUFSIZ,fp) != NULL){
			if(buf[0] == '\r' || buf[0] == '\n') continue;
			for(i=0;i<strlen(buf);i++)
				if(buf[i] == '\r' || buf[i] == '\n') buf[i] = '\0';

			wkfConvertKanjiCodeOfString(KC_UNKNOWN,buf,KC_EUC,title,256);
			code = wkfGuessKanjiCodeOfString(buf);

			break;
		}
		fclose(fp);

		return code;

	}else if(ftype == 1){
		unsigned char ziptitle[256];

		if(itextGetZipTitle(fname,ziptitle) > 0){
			wkfConvertKanjiCodeOfString(KC_UNKNOWN,ziptitle,KC_EUC,title,256);
			code = wkfGuessKanjiCodeOfString(ziptitle);
		}

		return code;
	}
}
int ibookGetFileData(IBOOK_T **bhead,IBOOK_T **btail,char *directory)
{
	DIR *dp;
	struct dirent *dir;
	struct stat sbuf;
	char fullpath[256];

	IBOOK_T *ik;

	int book_total = 0;
	int ftype;

	if((dp = opendir(directory)) == NULL) return -1;

	while((dir=readdir(dp)) != NULL){
		if(strncmp(dir->d_name,".",1) == 0 || strncmp(dir->d_name,"..",2) == 0) continue;

		sprintf(fullpath,"%s/%s",directory,dir->d_name);
		stat(fullpath,&sbuf);
		if(S_ISDIR(sbuf.st_mode)){
			ik = (IBOOK_T *)_book_link_alloc();
			ik->size = 0;
			strcpy(ik->fullpath,fullpath);
			strcpy(ik->filename,"DIR");
			sprintf(ik->title,"@ %s",dir->d_name);
			ik->code = -2;

			if(*bhead == NULL){
				*bhead = ik;
				ik->next = *btail;
			}else{
				ik->next = *bhead;
				*bhead = ik;
			}
			book_total++;

		}else{
			ftype = _checkFileType(fullpath);
			if(ftype == 0 || ftype == 1){
				ik = (IBOOK_T *)_book_link_alloc();
				ik->size = sbuf.st_size;
				strcpy(ik->fullpath,fullpath);
				strcpy(ik->filename,dir->d_name);
				ik->code = _ibookGetTitle(ik->fullpath,ik->title,ftype);
				ik->fno = sbuf.st_ctime;
				_book_link_add(bhead,btail,ik);
				book_total++;
			}
		}
	}
	closedir(dp);

	_book_link_sort(bhead,btail);

	return book_total;
}
