/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.test;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.tanukisoftware.wrapper.test.Main;

public class OpenVariousSizeWindows {
    public static void main(String[] args) {
        int end;
        int start;
        System.out.println("Opening several windows of different size every 4 secs.");
        System.out.println(" Make sure that the hidden console doesn't reappear (wrapperw).");
        System.out.println(" You can maximize the windows or move them to see if something happens...");
        System.out.println(" You can use wrapper.app.parameter.2=<index> & wrapper.app.parameter.3=<index> to specify start and end indexes.");
        System.out.println("");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenW = (int)screenSize.getWidth();
        int screenH = (int)screenSize.getHeight();
        int[][] coords = new int[][]{{0, 0, screenW, screenH, 0}, {0, 0, screenW, screenH, 0}, {0, 0, screenW, screenH, 0}, {0, 0, screenW, screenH, 0}, {0, 0, screenW / 2, screenH, 0}, {0, 0, screenW, screenH / 2, 0}, {0, 0, screenW / 2, screenH / 2, 0}, {0, 0, screenW * 2, screenH, 0}, {0, 0, screenW, screenH * 2, 0}, {0, 0, screenW * 2, screenH * 2, 0}, {0, 0, screenW, screenH, 1}, {0, 0, screenW / 2, screenH, 1}, {0, 0, screenW, screenH / 2, 1}, {0, 0, screenW / 2, screenH / 2, 1}, {0, 0, screenW * 2, screenH, 1}, {0, 0, screenW, screenH * 2, 1}, {0, 0, screenW * 2, screenH * 2, 1}, {screenW / 3, screenH / 3, screenW, screenH, 0}, {screenW / 3, screenH / 3, screenW / 2, screenH, 0}, {screenW / 3, screenH / 3, screenW, screenH / 2, 0}, {screenW / 3, screenH / 3, screenW / 2, screenH / 2, 0}, {screenW / 3, screenH / 3, screenW * 2, screenH, 0}, {screenW / 3, screenH / 3, screenW, screenH * 2, 0}, {screenW / 3, screenH / 3, screenW * 2, screenH * 2, 0}, {screenW / 3, screenH / 3, screenW, screenH, 1}, {screenW / 3, screenH / 3, screenW / 2, screenH, 1}, {screenW / 3, screenH / 3, screenW, screenH / 2, 1}, {screenW / 3, screenH / 3, screenW / 2, screenH / 2, 1}, {screenW / 3, screenH / 3, screenW * 2, screenH, 1}, {screenW / 3, screenH / 3, screenW, screenH * 2, 1}, {screenW / 3, screenH / 3, screenW * 2, screenH * 2, 1}, {screenW / 2 - 50, screenH / 2 - 50, screenW, screenH, 0}, {screenW / 2 - 50, screenH / 2 - 50, screenW / 2, screenH, 0}, {screenW / 2 - 50, screenH / 2 - 50, screenW, screenH / 2, 0}, {screenW / 2 - 50, screenH / 2 - 50, screenW / 2, screenH / 2, 0}, {screenW / 2 - 50, screenH / 2 - 50, screenW * 2, screenH, 0}, {screenW / 2 - 50, screenH / 2 - 50, screenW, screenH * 2, 0}, {screenW / 2 - 50, screenH / 2 - 50, screenW * 2, screenH * 2, 0}, {screenW / 2 - 50, screenH / 2 - 50, screenW, screenH, 1}, {screenW / 2 - 50, screenH / 2 - 50, screenW / 2, screenH, 1}, {screenW / 2 - 50, screenH / 2 - 50, screenW, screenH / 2, 1}, {screenW / 2 - 50, screenH / 2 - 50, screenW / 2, screenH / 2, 1}, {screenW / 2 - 50, screenH / 2 - 50, screenW * 2, screenH, 1}, {screenW / 2 - 50, screenH / 2 - 50, screenW, screenH * 2, 1}, {screenW / 2 - 50, screenH / 2 - 50, screenW * 2, screenH * 2, 1}};
        try {
            start = args.length > 0 ? Integer.parseInt(args[0]) : 0;
        }
        catch (NumberFormatException e) {
            start = 0;
        }
        try {
            end = args.length > 1 ? Integer.parseInt(args[1]) : coords.length;
        }
        catch (NumberFormatException e) {
            end = coords.length;
        }
        MyRunnable r = new MyRunnable();
        r.totNumWindows = end - start + 1;
        if (start == 0 && end == 0 || start == 1 && end == 1 || start == 1 && end == 1) {
            System.out.println(Main.getRes().getString(" Create 1 Jframe (it was observed that the first created JFrame can cause the hidden console to reappear)."));
        } else if (start > 3) {
            System.out.println(Main.getRes().getString(" Create {0} JDialog(s) (it was observed that any instance created - not only the first one - can cause the hidden console to reappear).", (Object)new Integer(r.totNumWindows)));
        } else {
            System.out.println(Main.getRes().getString(" Create {0} Window(s).", (Object)new Integer(r.totNumWindows)));
        }
        System.out.println("");
        for (int i = start; i <= end; ++i) {
            try {
                boolean bl = r.createInvisible = coords[i][4] != 0;
                if (i > start) {
                    Thread.sleep(r.createInvisible ? 3000L : 4000L);
                }
                if (i == 0) {
                    r.maximizedState = 6;
                } else if (i == 1) {
                    r.maximizedState = 2;
                } else if (i == 2) {
                    r.maximizedState = 4;
                }
                r.top = coords[i][0];
                r.left = coords[i][1];
                r.width = coords[i][2];
                r.height = coords[i][3];
                r.curWindowIndex = i - start + 1;
                SwingUtilities.invokeLater(r);
                continue;
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        try {
            Thread.sleep(4000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        System.exit(0);
    }

    static class MyRunnable
    implements Runnable {
        public int width;
        public int height;
        public int top = 0;
        public int left = 0;
        public boolean createInvisible;
        public int maximizedState = 0;
        public int totNumWindows;
        public int curWindowIndex;

        MyRunnable() {
        }

        public void run() {
            Window window;
            System.out.println(Main.getRes().getString("Creating new {0} (width={1}, height={2}, top={3}, left={4}, createInvisible={5})...", new Object[]{this.maximizedState > 0 ? "JFrame" : "JDialog", new Integer(this.width), new Integer(this.height), new Integer(this.top), new Integer(this.left), this.createInvisible ? "true" : "false"}));
            if (this.maximizedState > 0) {
                window = new JFrame();
                ((Frame)window).setExtendedState(this.maximizedState);
                ((JFrame)window).setTitle("A window (JFrame) - " + this.curWindowIndex + " / " + this.totNumWindows);
            } else {
                window = new JDialog();
                ((JDialog)window).setModal(true);
                ((JDialog)window).setDefaultCloseOperation(2);
                ((JDialog)window).setTitle("A window (JDialog) - " + this.curWindowIndex + " / " + this.totNumWindows);
            }
            window.setBounds(this.top, this.left, this.width, this.height);
            try {
                if (this.createInvisible) {
                    window.setVisible(false);
                    Thread.sleep(1000L);
                }
                window.setVisible(true);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }
}

