<?php
/*
Plugin Name: akismet-multibyteview
Plugin URI: http://wppluginsj.sourceforge.jp/akismet-multibyteview/
Description: Akismet のコメント管理とダッシュボードにマルチバイト文字を含むコメント情報を表示する機能を追加します。
Author: hiromasa & <a href="http://bono.s201.xrea.com/">bono</a>
Version: 1.20
Author URI: http://another.maple4ever.net/
**/

/*  Copyright 2007 hiromasa & bono (email : webmaster@hiromasa.zone.ne.jp)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/******************************************************************************
 * AkismetMultibyteView - WordPress Interface Define
 *****************************************************************************/

if(!(defined('ABSPATH') && defined('WPINC'))) return;
if(!is_admin()) return;

/******************************************************************************
 * AkismetMultibyteView
 * 
 * @author		hiromasa
 * @version		1.00
 * 
 *****************************************************************************/
class AkismetMultibyteView {
	
	var $plugin_name;
	var $plugin_uri;
	
	var $akismet_admin_uri;
	
	/**
	 * the constructor
	 * 
	 * @param none
	 * @return none
	 */
	function AkismetMultibyteView() {
		
		$this->plugin_name = 'akismet-multibyteview';
		
		$this->plugin_uri  = get_settings('siteurl');
		$this->plugin_uri .= '/wp-content/plugins/akismet-multibyteview/';
		
		$this->akismet_admin_uri = 'edit-comments.php?page=akismet-admin';
		
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function echoAdminHead() {
		
		echo '<script type="text/javascript" src="';
		echo $this->plugin_uri . 'akismet-multibyteview.js">';
		echo '</script>'  . "\n";
		
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function echoAdminFooter() {
		
		echo '<div id="AkismetMutibyteMenu" style="padding: 0 1em 0 1em; text-align: right;">' . "\n";
		echo "<p><a href=\"./{$this->akismet_admin_uri}\" name=\"multibyte_select\">Normal View</a> / ";
		echo "<a href=\"./{$this->akismet_admin_uri}&multibyte=true\" name=\"multibyte_select\">Mutibyte Only View</a></p>";
		echo '</div>' . "\n";
		
	}
	
	/**
	 * WordPress Admin Interface
	 * 
	 * @param none
	 * @return none
	 */
	function hookAkismetQuery($query) {
		
		global $wpdb;
		
		$addQuery
			= ' AND LENGTH(comment_content) <> CHAR_LENGTH(comment_content) ';
		$patch = '-';
		
		$matches = array();
		$pattern
			= "/(SELECT COUNT\(\*\) FROM $wpdb->comments WHERE comment_approved = 'spam')/";
		if(preg_match($pattern, $query, $matches)) {
			$query = $matches[1] . $addQuery;
			$patch = '+';
		}
		
		$matches = array();
		$pattern
			= "/(SELECT \* FROM $wpdb->comments WHERE comment_approved = 'spam')( ORDER BY comment_date DESC LIMIT \d+, \d+)/";
		if(preg_match($pattern, $query, $matches)) {
			$query = $matches[1] . $addQuery . $matches[2];
			$patch = '+';
		}
		
		//for debug..
		//echo $patch . $query . '<br />';
		
		return $query;
		
	}
	
	/**
	 * WordPress Admin Interface
	 *  - AkismetMultibyteCount by bono (http://bono.s201.xrea.com/2007/10/536-wp_akismet-multibyte-count/)
	 * 
	 * @param none
	 * @return none
	 */
	function akismet_stats_mbinfo() {
		
		if ( function_exists('ksd_spam_count') ) {
			$spam_count = ksd_spam_count(); // 古い Akismet で、現在捕獲中のスパム数を取得
		} else {
			$spam_count = akismet_spam_count();
		}
		if ( !$spam_count )
			return;
		$mbs_count = $this->spam_mb_count();
		
		echo '<div>' . "\n";
		echo '<h3>' . __('Spam') . ' （日本語を含むコメント）</h3>' . "\n";
		
		echo '<ul><li>'.sprintf(__('There are currently %1$s comments identified as spam.'), number_format($spam_count) ).'</li>';
		if ( $mbs_count ) {
			echo
				'<li><a href="' . clean_url("{$this->akismet_admin_uri}&multibyte=true") .
				'"><strong>要チェック</strong></a>： スパムじゃないかもしれないコメントを ' .
				$mbs_count.' 件捕獲中です。</li>';
		} else {
			echo '<li>この中に日本語を含むものはありません。</li>';
		}
		echo '</ul>';
		echo '</div>' . "\n";
		
	}
	
	/**
	 * spam_mb_count
	 * 
	 * @param none
	 * @return $count
	 */
	function spam_mb_count() {
		
		global $wpdb;
		$count = $wpdb->get_var("SELECT COUNT(comment_ID) FROM $wpdb->comments WHERE comment_approved = 'spam' AND LENGTH(comment_content) <> CHAR_LENGTH(comment_content)");
		return $count;
		
	}
	
}

/******************************************************************************
 * AkismetMultibyteView - WordPress Interface Define
 *****************************************************************************/

$akismetMultibyteView = new AkismetMultibyteView();

add_action('activity_box_end', array(&$akismetMultibyteView, 'akismet_stats_mbinfo'), 11);

if(strpos($_GET['page'], 'akismet-admin') === false) return;

add_action('admin_head', array(&$akismetMultibyteView, 'echoAdminHead'));
add_action('admin_footer', array(&$akismetMultibyteView, 'echoAdminFooter'));

if(isset($_GET['multibyte'])) {
	add_filter('query',  array(&$akismetMultibyteView, 'hookAkismetQuery'));
}
?>
 