<?php

/* locations.php 1.00-alpha
 * Location info output API for Lightweight Google Maps
 */

require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';
require_once dirname(__FILE__) . '/Lat_Long.php';
define('INFOWINDOW_DATE_FORMAT', 'Y-m-d');

if (! get_settings('lw_fixed_map_page_id')) {
	LWGM_Locations::output_error('The static map page does not exists.');
	exit();
}

if (! isset($_GET['format'])) {
	LWGM_Locations::output_error('Data format does not specified.');
	exit();
}
$locations = new LWGM_Locations;
switch ($_GET['format']) {
case 'xml':
	$locations->output_xml();
	break;
default:
	LWGM_Locations::output_error('Data format does not specified.');
}
exit();

class LWGM_Locations {
var $markers = array();

// ==================================================
// static 
function LWGM_Locations() {
	$this->markers = $this->query_markers();
}

// ==================================================
// private 
function post_info($lat, $lon) {
	$title = get_the_title();
	$link = get_permalink();
	$date = get_the_time(INFOWINDOW_DATE_FORMAT);
	$excerpt = preg_replace('/^\s+/', '', get_the_excerpt());
	$excerpt = preg_replace('/\n.*$/m', '', $excerpt);
	return compact('lat', 'lon', 'title', 'link', 'date', 'excerpt');
}

// ==================================================
// private 
function query_markers() {
	if (isset($_GET['bounds'])) {
		$bounds = array_map('floatval', explode(',', $_GET['bounds']));
		$posts_w_loc = Lat_Long::posts_in_bounds($bounds);
	} else {
		$posts_w_loc = NULL;
	}
	$query = '';
	if (isset($_GET['category'])) {
		$query .= '&cat=' . intval($_GET['category']);
	}
	if (isset($_GET['date'])) {
		list($year, $month, $date) = array_map('intval', explode('-', $_GET['date']));
		$query .= sprintf('&year=%d&monthnum=%d&day=%d', $year, $month, $date);
	}
	$num = isset($_GET['recent']) ? intval($_GET['recent']) : 0;

	$loc = array();
	if ($query || $num) {
		for ($page = 1 ; $page <= 100000 ; $page++) {
			$posts = new WP_Query("paged=$page$query");
			if (! $posts->have_posts() || $page > 100000) {
				break;
			}
			while ($posts->have_posts()) : $posts->the_post();
				if ($posts_w_loc) {
					global $post;
					$latlongs = @$posts_w_loc[$post->ID];
				} else {
					$latlongs = Lat_Long::get_LatLon();
				}
				if ($latlongs) {
					foreach ($latlongs as $l) {
						$loc[] = $this->post_info($l['lat'], $l['lon']);
					}
					if ($num > 0 && count($loc) >= $num) {
						break 2;
					}
				}
			endwhile;
		}
	} elseif ($posts_w_loc) {
		foreach ($posts_w_loc as $p => $latlongs) {
			$posts = new WP_Query("p=$p");
			if ($posts->have_posts()) {
				$posts->the_post();
				foreach ($latlongs as $l) {
					$loc[] = $this->post_info($l['lat'], $l['lon']);
				}
			}
		}
	}
	return $loc;
}

// ==================================================
// public 
function output_xml() {
	header('Content-Type: application/xml; charset=' . get_settings('blog_charset'));
	echo "<markers>\n";
	while ($m = array_shift($this->markers)) {
		$m = array_map('wp_specialchars', $m);
		extract($m);
		echo <<<E__O__T
<marker>
<lat>$lat</lat>
<lon>$lon</lon>
<title>$title</title>
<link>$link</link>
<date>$date</date>
<excerpt>$excerpt</excerpt>
</marker>

E__O__T;
	}
	echo "</markers>\n";
	return;
}

// ==================================================
// static 
function output_error($message) {
	header('Content-Type: application/xml; charset=utf-8');
	echo '<error>' . wp_specialchars($message) . '</error>';
	return;
}

// ==================================================
} // End of class

?>