<?php
/*
Plugin Name: Lightweight Google Maps
Plugin URI: http://wppluginsj.sourceforge.jp/lightweight-google-maps/
Description: Show google maps on your post and/or pages. The map location is read from "Lat_Long" custom fields (does not use Geo plugin.) At a static page, you can refine location markers by category or location name/address.
Version: 0.9.9.1
Author: IKEDA Yuriko
Author URI: http://www.yuriko.net/cat/wordpress
*/

define('LWGM_FIXED_MAP_ID', 'google_maps');
define('LWGM_EACH_MAP_CLASS', 'each_map');
define('LWGM_FIXED_MAP_HEIGHT', 480);
define('LWGM_EACH_MAP_WIDTH', 300);
define('LWGM_EACH_MAP_HEIGHT', 150);
define('LWGM_INFO_WINDOW_WIDTH', 200);
define('LWGM_ZOOM_OF_RECENT_LOCATIONS', 8);
define('LWGM_ZOOM_OF_ADDRESSED_MAP', 13);
define('LWGM_ZOOM_OF_EACH_MAP', 14);

$Lwgm_Plugin_Path = preg_replace('#^.*wp-content#', 'wp-content', dirname(__FILE__));
if (! preg_match('#^wp-content#', $Lwgm_Plugin_Path)) {
	$Lwgm_Plugin_Path = 'wp-content/plugins/lightweight-google-maps';
}
load_plugin_textdomain('lw_googlemaps', $Lwgm_Plugin_Path);
$Lwgm = new Lightweight_Google_Maps;
$Lwgm_admin = new LWGM_Admin;
add_filter('the_content', array($Lwgm, 'each_map'));
add_action('wp_head',     array($Lwgm, 'output_style'));
add_action('wp_footer',   array($Lwgm, 'output_script'));
add_action('admin_menu',  array($Lwgm_admin, 'add_admin_page'));

// ==================================================
function lwgm_dropdown_cats() {
	global $Lwgm_Fixed_Map;
	if (isset($Lwgm_Fixed_Map)) {
?>
<form onsubmit="refine_by_category(this.cat.value); return false;" id="cat_refine"><div>
<label><?php _e('Refine by category:', 'lw_googlemaps');
dropdown_cats(FALSE,'all','name','asc',FALSE,FALSE,TRUE,FALSE,intval($_GET['cat'])); ?>
</label>
<input type="submit" value="<?php _e('Show', 'lw_googlemaps'); ?>" />
</div></form>
<?php
	}
}

// ==================================================
function lwgm_geocoding() {
	global $Lwgm_Fixed_Map;
	if (isset($Lwgm_Fixed_Map)) {
?>
<form onsubmit="move_to_place(this.place.value); return false;" id="geocoding"><div>
<?php _e('Move to an address or a landmark:', 'lw_googlemaps'); ?> <input type="text" size="32" id="place" /> <input type="submit" value="<?php _e('Show', 'lw_googlemaps'); ?>" />
</div></form>
<?php
	}
}

/* ==================================================
 *   Lightweight_Google_Maps Class
   ================================================== */

class Lightweight_Google_Maps {

// ==================================================
function get_zoom_level($field_name, $default_zoom) {
	$zoom = intval(get_option($field_name));
	if ($zoom < 1 || $zoom > 19) {
		$zoom = $default_zoom;
	}
	return $zoom;
}

// ==================================================
function output_style() {
	$page_id = get_option('lw_fixed_map_page_id');
	if ($page_id && is_page($page_id)) {
		global $Lwgm_Fixed_Map;
		$Lwgm_Fixed_Map = $page_id;
		$map_width = intval(get_option('lw_fixed_map_width'));
		$map_height = intval(get_option('lw_fixed_map_height'));
		if (! $map_height) {
			$map_height = LWGM_FIXED_MAP_HEIGHT;
		}
		$element = '#' . LWGM_FIXED_MAP_ID;
	} elseif (! is_page() && get_option('lw_each_map_type') != 'LWGM_LINK_TO_MAP') {
		$map_width = intval(get_option('lw_each_map_width'));
		if (! $map_width) {
			$map_width = LWGM_EACH_MAP_WIDTH;
		}
		$map_height = intval(get_option('lw_each_map_height'));
		if (! $map_height) {
			$map_height = LWGM_EACH_MAP_HEIGHT;
		}
		$element = '.' . LWGM_EACH_MAP_CLASS;
	} else {
		return;
	}
?>
<style type="text/css" media="screen,tv,print,handheld">
<?php echo $element; ?> {
<?php if ($map_width) {echo "	width:{$map_width}px;\n";} ?>
	height:<?php echo $map_height; ?>px;
	clear:both;
	margin:1em auto;
	border:1px solid #999;
	line-height:1.25em;
	text-align:center;
}
<?php echo $element; ?> img {
	margin:0;
	padding:0;
	border:0 none;
}
<?php echo $element; ?> .infowindow {
	text-align:left;
	font-size:0.88em;
}
<?php echo $element; ?> p {
	margin:0;
	text-indent:0;
	text-align:left;
	font-size:0.75em;
}
</style>
<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo  get_option('googlemaps_api_key');?>" type="text/javascript" charset="utf-8"></script>
<?php
}

// ==================================================
function each_map($content) {
	require_once dirname(__FILE__) . '/Lat_Long.php';
	$latlongs = Lat_Long::get_LatLon();
	if (! $latlongs) {
		return $content;
	}
	$map_type = get_option('lw_each_map_type');
	$page_id  = get_option('lw_fixed_map_page_id');
	if ($page_id && is_numeric($page_id)) {
		$page_link = get_permalink($page_id);
		if (strpos($page_link, '?') === FALSE) {
			$page_link .= '?';
		} else {
			$page_link .= '&';
		}
	} else {
		$page_link = '';
	}
	if ($page_link && $map_type == 'LWGM_LINK_TO_MAP') {
		foreach ($latlongs as $l) {
			$content .= '<p class="map_link"><a href="' . "{$page_link}lat={$l['lat']}&amp;lon={$l['lon']}" . '">' . __('View this location on my large map &raquo;', 'lw_googlemaps') . "</a></p>\n";
		}
	} elseif ($map_type != 'LWGM_LINK_TO_MAP') {
		global $post, $Each_Maps;
		foreach ($latlongs as $i => $l) {
			$Each_Maps[$post->ID][$i + 1] = array($l['lat'], $l['lon'], ($page_link ? "{$page_link}lat={$l['lat']}&lon={$l['lon']}" : ''));
			$seq = count($latlongs) >= 2 ?  '_' . ($i + 1) : '';
			$content .= '<div class="each_map" id="map_' . $post->ID . $seq  . '"></div>' . "\n";
		}
	}
	return $content;
}

// ==================================================
function output_script() {
	global $Lwgm_Fixed_Map, $Each_Maps;
	if (isset($Lwgm_Fixed_Map)) {
		$this->fixed_map_script();
	} elseif (count(@$Each_Maps)) {
		$this->each_map_script($Each_Maps);
	}
}

// ==================================================
function fixed_map_script() {
	$addressed_zoom = $this->get_zoom_level('lw_addressed_map_zoom', LWGM_ZOOM_OF_ADDRESSED_MAP);
	$recent_zoom = $this->get_zoom_level('lw_recent_map_zoom', LWGM_ZOOM_OF_RECENT_LOCATIONS);
	$map_type = get_option('lw_fixed_map_type');
	if (! $map_type) {
		$map_type = 'G_HYBRID_MAP';
	}
	global $Lwgm_Plugin_Path;
	$url = get_bloginfo('url') . "/$Lwgm_Plugin_Path/locations.php?format=xml&";
?>
<script type="text/javascript" charset="utf-8">
//<![CDATA[
	function parse_loc(response) {
		var xmldoc  = GXml.parse(response);
		var lat     = xmldoc.documentElement.getElementsByTagName('lat');
		var lon     = xmldoc.documentElement.getElementsByTagName('lon');
		var title   = xmldoc.documentElement.getElementsByTagName('title');
		var link    = xmldoc.documentElement.getElementsByTagName('link');
		var date    = xmldoc.documentElement.getElementsByTagName('date');
		var excerpt = xmldoc.documentElement.getElementsByTagName('excerpt');
		if (lat.length < 1) {
			return null;
		}
		var locs = new Array();
		for (var i = 0 ; i < lat.length ; i++) {
			locs[i] = {
				'latlng' : new GLatLng(GXml.value(lat[i]), GXml.value(lon[i])),
				'title'  : GXml.value(title[i]),
				'link'   : GXml.value(link[i]),
				'date'   : GXml.value(date[i]),
				'excerpt': GXml.value(excerpt[i])
			};
		}
		return locs;
	}
	function get_outline(locs) {
		var outline = new GLatLngBounds(locs[0].latlng, locs[0].latlng);
		for (var i = 0 ; i < locs.length ; i++) {
			outline.extend(locs[i].latlng);
		}
		return outline;
	}
	function create_marker(loc) {
		var marker = new GMarker(loc.latlng);
		var html = '<div class="infowindow"><a href="'+loc.link+'"><strong>'+loc.title+'</strong></a><br />'+loc.date+'</div><p>'+loc.excerpt+'</p>';
		GEvent.addListener(marker, 'click', function() {
			marker.openInfoWindowHtml(html, {'maxWidth':<?php echo LWGM_INFO_WINDOW_WIDTH; ?>});
		});
		return marker;
	}
	function recent_locations(num) {
		var query = 'recent=' + num;
		GDownloadUrl(baseurl + query, function(response) {
			var locs  = parse_loc(response);
			if (! locs) {
				map.setCenter(new GLatLng(38.0,137.5) , 4, <?php echo $map_type; ?>);
				return;
			}
			map.setCenter(locs[0].latlng, <?php echo "$recent_zoom, $map_type"; ?>);
			for (var i = 0 ; i < locs.length ; i++) {
				var marker = create_marker(locs[i]);
				map.addOverlay(marker);
			}
		});
	}
	function refine_by_category(cat_id) {
		var query = 'category=' + cat_id;
		GDownloadUrl(baseurl + query, function(response) {
			var locs  = parse_loc(response);
			if (! locs) {
				map.setCenter(new GLatLng(38.0,137.5) , 4, <?php echo $map_type; ?>);
				map.clearOverlays();
				return;	
			}
			var outline = get_outline(locs);
			map.setCenter(outline.getCenter(), map.getBoundsZoomLevel(outline), <?php echo $map_type; ?>);
			map.clearOverlays();
			for (var i = 0 ; i < locs.length ; i++) {
				var marker = create_marker(locs[i]);
				map.addOverlay(marker);
			}
		});
	}
	function move_to_latlong(latlng) {
		map.setCenter(latlng, <?php echo "$addressed_zoom, $map_type"; ?>);
		map.clearOverlays();
		var bounds = map.getBounds();
		var query = 'bounds=' + bounds.getSouthWest().lat() + ',' + bounds.getSouthWest().lng() + ',' + bounds.getNorthEast().lat() + ',' + bounds.getNorthEast().lng();
		GDownloadUrl(baseurl + query, function(response) {
			var locs  = parse_loc(response);
			if (! locs) {
				return;
			}
			for (var i = 0 ; i < locs.length ; i++) {
				var marker = create_marker(locs[i]);
				map.addOverlay(marker);
			}
		});
	}
	function move_to_place(place) {
		geocoder.getLatLng(place, function(latlng) {
			if (latlng) {
				move_to_latlong(latlng);
			} else {
				alert(place + '<?php _e(': Could not find the latitude/longtitude of this place.', 'lw_googlemaps'); ?>');
			}
		});
	}
	function main() {
		map = new GMap2(document.getElementById('<?php echo LWGM_FIXED_MAP_ID; ?>'));
		map.addControl(new GLargeMapControl());
		map.addControl(new GMapTypeControl());
		map.addControl(new GScaleControl());
		map.addControl(new GOverviewMapControl());
		geocoder = new GClientGeocoder();
<?php
	if (isset($_GET['lat']) && isset($_GET['lon'])) {
?>
		move_to_latlong(new GLatLng(<?php echo floatval($_GET['lat']) . ',' . floatval($_GET['lon']); ?>));
<?php
	} elseif (isset($_GET['place'])) {
?>
		move_to_place('<?php echo wp_specialchars($_GET['place']); ?>');
<?php
	} elseif (isset($_GET['cat'])) {
?>
		refine_by_category(<?php echo intval($_GET['cat']); ?>);
<?php
	} else {
?>
		recent_locations(<?php echo intval(get_option('lw_num_recent_markers')); ?>);
<?php
	}
?>
	}
	if (GBrowserIsCompatible()) {
		var map;
		var geocoder;
		var baseurl = '<?php echo $url; ?>';
		onload = main;
		onunload = GUnload;
	}
//]]>
</script>
<?php
}

// ==================================================
function each_map_script($locations) {
	$page_id = get_option('lw_fixed_map_page_id');
	$map_type = get_option('lw_each_map_type');
	if (! $map_type) {
		$map_type = 'G_NORMAL_MAP';
	}
	$zoom = $this->get_zoom_level('lw_each_map_zoom', LWGM_ZOOM_OF_EACH_MAP);
?>
<script type="text/javascript" charset="utf-8">
	//<![CDATA[
	function main() {
		var markeropt = new Object();
		markeropt.title = "<?php echo ($page_id ? __('Click to view my large map.', 'lw_googlemaps') : ''); ?>";
<?php
	foreach ($locations as $id => $points) {
		foreach ($points as $c => $latlng) {
			$count   = count($points) >= 2 ? "_$c" : '';
			echo <<<E__O__T
		var map$id$count = new GMap2(document.getElementById('map_$id$count'));
		map$id$count.addControl(new GSmallZoomControl());
		map$id$count.setCenter(new GLatLng($latlng[0], $latlng[1]), $zoom, $map_type);
		var marker$id$count = new GMarker(map$id$count.getCenter(), markeropt);

E__O__T;
			if ($latlng[2]) {
				echo <<<E__O__T
		GEvent.addListener(marker$id$count, 'click', function() {location.href = '$latlng[2]'; });

E__O__T;
			}
			echo <<<E__O__T
		map$id$count.addOverlay(marker$id$count);

E__O__T;
		}
	}
?>
	}
	if (GBrowserIsCompatible()) {
		onload = main;
		onunload = GUnload;
	}
//]]>
</script>
<?php
}

// ===== End of class ====================
}

/* ==================================================
 *   LWGM_Admin Class
   ================================================== */

class LWGM_Admin extends Lightweight_Google_Maps {

// ==================================================
function add_admin_page() {
	add_options_page('Lightweight Google Maps', 'Google Maps', 8, basename(__FILE__), array($this, 'admin_page'));
}

// ==================================================
function upate_options() {
	if (@$_POST['convert_geo_locations']) {
		$this->convert_geo_locations();
	}
	$gmap_api_key = @$_POST['gmap_api_key'];
	if ($gmap_api_key) {
		update_option('googlemaps_api_key', $gmap_api_key);
		delete_option('yf_google_api_key');
	} elseif ($gmap_api_key = get_option('yf_google_api_key')) {
		update_option('googlemaps_api_key', $gmap_api_key);
		delete_option('yf_google_api_key');
	}
	$map_page_id = @$_POST['map_page_id'];
	if ($map_page_id) {
		update_option('lw_fixed_map_page_id', $map_page_id);
		delete_option('yf_google_page_id');
	} else {
		delete_option('lw_fixed_map_page_id');
		delete_option('yf_google_page_id');
	}
	$fixed_map_type = @$_POST['fixed_map_type'];
	if ($fixed_map_type) {
		update_option('lw_fixed_map_type', $fixed_map_type);
		delete_option('yf_map_type');
	}
	$fixed_map_width = intval(@$_POST['fixed_map_width']);
	if ($fixed_map_width) {
		update_option('lw_fixed_map_width', $fixed_map_width);
		delete_option('yf_google_width');
	} else {
		delete_option('lw_fixed_map_width');
		if (get_option('yf_google_width')) {
			delete_option('yf_google_width');
		}
	}
	$fixed_map_height = intval(@$_POST['fixed_map_height']);
	if ($fixed_map_height) {
		update_option('lw_fixed_map_height', $fixed_map_height);
		delete_option('yf_google_height');
	} else {
		delete_option('lw_fixed_map_height');
		if (get_option('yf_google_height')) {
			delete_option('yf_google_height');
		}
	}
	$recent_map_zoom = intval(@$_POST['recent_map_zoom']);
	if ($recent_map_zoom) {
		update_option('lw_recent_map_zoom', $recent_map_zoom);
		delete_option('yf_zoom_level');
	}
	$num_recent_markers = intval(@$_POST['num_recent_markers']);
	if ($num_recent_markers) {
		update_option('lw_num_recent_markers', $num_recent_markers);
	} else {
		delete_option('lw_num_recent_markers');
	}
	$addressed_map_zoom = intval(@$_POST['addressed_map_zoom']);
	if ($addressed_map_zoom) {
		update_option('lw_addressed_map_zoom', $addressed_map_zoom);
	}
	$each_map_type = @$_POST['each_map_type'];
	if ($each_map_type) {
		update_option('lw_each_map_type', $each_map_type);
	}
	$each_map_zoom = intval(@$_POST['each_map_zoom']);
	if ($each_map_zoom) {
		update_option('lw_each_map_zoom', $each_map_zoom);
	}
	$each_map_width = intval(@$_POST['each_map_width']);
	if ($each_map_width) {
		update_option('lw_each_map_width', $each_map_width);
	} else {
		delete_option('lw_each_map_width');
	}
	$each_map_height = intval(@$_POST['each_map_height']);
	if ($each_map_height) {
		update_option('lw_each_map_height', $each_map_height);
	} else {
		delete_option('lw_each_map_height');
	}
	delete_option('yf_default_latitude');
	delete_option('yf_default_longitude');
	delete_option('yf_use_thumbs');
	delete_option('yf_thumb_width');
	delete_option('yf_thumb_height');
	delete_option('yf_thumb_url');
	delete_option('yf_thumb_css');
?>
<div class="updated fade"><p><strong><?php _e('Options saved.'); ?></strong></p></div>
<?php
	return;
}

// ==================================================
function output_zoom_select($zoom_level) {
	$options = array();
	$options[$zoom_level] = ' selected="selected"';
	for ($lv = 19; $lv >= 1; $lv--) {
		echo '<option value="' . $lv . '"' . $options[$lv] . ">$lv</option>\n";
	}
	return;
}

// ==================================================
function map_type_checkbox($map_type) {
	$check_boxes = array('', '', '', '');
	switch ($map_type) {
	case 'LWGM_LINK_TO_MAP':
		$check_boxes[0] = ' checked="checked"';
		break;
	case 'G_NORMAL_MAP':
		$check_boxes[1] = ' checked="checked"';
		break;
	case 'G_SATELLITE_MAP':
		$check_boxes[2] = ' checked="checked"';
		break;
	case 'G_HYBRID_MAP':
		$check_boxes[3] = ' checked="checked"';
		break;
	}
	return $check_boxes;
}

// ==================================================
function admin_page() {
	if (isset($_POST['info_update'])) {
		$this->upate_options();
	}
	$gmap_api_key = get_option('googlemaps_api_key');
	if (! $gmap_api_key) {
		$gmap_api_key = get_option('yf_google_api_key');
	}
	$page_id = get_option('lw_fixed_map_page_id');
	if (! $page_id) {
		$page_id = get_option('yf_google_page_id');
	}
	$fixed_map_width = get_option('lw_fixed_map_width');
	if (! $fixed_map_width) {
		$fixed_map_height = get_option('yf_google_width');
	}
	$fixed_map_height = get_option('lw_fixed_map_height');
	if (! $fixed_map_height) {
		$fixed_map_height = get_option('yf_google_height');
	}
	$fixed_map_type = get_option('lw_fixed_map_type');
	if (! $fixed_map_type) {
		$fixed_map_type = get_option('yf_map_type');
	}
	$fixed_map_type_check = $this->map_type_checkbox($fixed_map_type);
	$recent_map_zoom = $this->get_zoom_level('lw_recent_map_zoom', 0);
	if (! $recent_map_zoom) {
		$recent_map_zoom = $this->get_zoom_level('yf_zoom_level', LWGM_ZOOM_OF_RECENT_LOCATIONS);
	}
	$addressed_map_zoom = $this->get_zoom_level('lw_addressed_map_zoom', LWGM_ZOOM_OF_ADDRESSED_MAP);
	$each_map_type_check = $this->map_type_checkbox(get_option('lw_each_map_type'));
	$each_map_zoom = $this->get_zoom_level('lw_each_map_zoom', LWGM_ZOOM_OF_EACH_MAP);
?>
<div class="wrap">
<h2>Lightweight Google Maps</h2>
<form method="post">
<fieldset name="apikey" class="options">
<legend><?php _e('Your Googlemap API Key', 'lw_googlemaps'); ?></legend>
<table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
<tr>
  <th width="20%" scope="row"><label for="gmap_api_key"><?php _e('API Key:', 'lw_googlemaps'); ?></label></th>
  <td><input type="text" name="gmap_api_key" id="gmap_api_key" /> <?php echo sprintf(__("(don't have one? get one <a href=%s>here</a>)", 'lw_googlemaps'), '"http://www.google.com/apis/maps/signup.html"'); ?></td>
</tr><tr>
  <th><?php _e('Current API Key:', 'lw_googlemaps'); ?></th>
  <td><em><?php echo $gmap_api_key ?></em></td>
</tr>
</table>
</fieldset>
<fieldset name="fixedpage" class="options">
<legend><?php _e('Map on fixed pages', 'lw_googlemaps'); ?></legend>
<table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
<tr> 
  <th width="20%" scope="row"><label for="map_page_id"><?php _e('Page ID:', 'lw_googlemaps'); ?></label></th> 
  <td>
    <input type="text" value="<?php echo $page_id ?>" name="map_page_id" id="map_page_id" />
    <div><?php _e('This is a numeric id of the map page. You can find the id number from <a href="edit-pages.php">the Manage/Pages screen</a>.', 'lw_googlemaps'); ?></div>
  </td>
</tr><tr> 
  <th width="20%" scope="row"><label for="fixed_map_type"><?php _e('Type:', 'lw_googlemaps'); ?></label></th> 
  <td>
    <label><input type="radio" name="fixed_map_type" id="fixed_map_type" value="G_NORMAL_MAP"<?php echo $fixed_map_type_check[1]; ?> /> <?php _e('Graphic', 'lw_googlemaps'); ?></label>
    <label><input type="radio" name="fixed_map_type" id="fixed_map_type" value="G_SATELLITE_MAP"<?php echo $fixed_map_type_check[2]; ?> /> <?php _e('Satellite', 'lw_googlemaps'); ?></label>
    <label><input type="radio" name="fixed_map_type" id="fixed_map_type" value="G_HYBRID_MAP"<?php echo $fixed_map_type_check[3]; ?> /> <?php _e('Hybrid', 'lw_googlemaps'); ?></label>
  </td>
</tr><tr>
  <th width="20%" scope="row"><label for="fixed_map_width"><?php _e('Width:', 'lw_googlemaps'); ?></label></th> 
  <td>
    <input type="text" value="<?php echo $fixed_map_width; ?>" name="fixed_map_width" id="fixed_map_width" /> px
  </td>
</tr><tr>
  <th width="20%" scope="row"><label for="fixed_map_height"><?php _e('Height:', 'lw_googlemaps'); ?></label></th> 
  <td>
    <input type="text" value="<?php echo $fixed_map_height;?>" name="fixed_map_height" id="fixed_map_height" /> px
  </td>
</tr><tr>
  <th width="20%" scope="row"><label for="recent_map_zoom"><?php _e('Zoom level of recent locations:', 'lw_googlemaps'); ?></label></th>
  <td>
    <select name="recent_map_zoom" id="recent_map_zoom">
    <?php $this->output_zoom_select($recent_map_zoom); ?>
    </select>
    <span><?php _e('(1: Whole globe, Bigger: Narrower area)', 'lw_googlemaps'); ?></span>
  </td>
</tr><tr>
  <th width="20%" scope="row"><label for="num_recent_markers"><?php _e('Number of recent location markers:', 'lw_googlemaps'); ?></label></th> 
  <td>
    <input type="text" value="<?php echo get_option('lw_num_recent_markers');?>" name="num_recent_markers" id="num_recent_markers" /> <?php _e('points', 'lw_googlemaps'); ?>
  </td>
</tr><tr>
  <th width="20%" scope="row"><label for="addressed_map_zoom"><?php _e('Zoom level of addressed map:', 'lw_googlemaps'); ?></label></th>
  <td>
    <select name="addressed_map_zoom" id="addressed_map_zoom">
    <?php $this->output_zoom_select($addressed_map_zoom); ?>
    </select>
    <span><?php _e('(1: Whole globe, Bigger: Narrower area)', 'lw_googlemaps'); ?></span>
  </td>
</tr>
</table> 
</fieldset>
<fieldset name="eachmap" class="options">
<legend><?php _e('Map for each entries', 'lw_googlemaps'); ?></legend>
<table width="100%" cellspacing="2" cellpadding="5" class="editform"> 
<tr> 
  <th width="20%" scope="row"><label for="each_map_type"><?php _e('Type:', 'lw_googlemaps'); ?></label></th> 
  <td>
    <label><input type="radio" name="each_map_type" id="each_map_type" value="LWGM_LINK_TO_MAP"<?php echo $each_map_type_check[0]; ?> /> <?php _e('Link to my fixed map', 'lw_googlemaps'); ?></label>
    <label><input type="radio" name="each_map_type" id="each_map_type" value="G_NORMAL_MAP"<?php echo $each_map_type_check[1]; ?> /> <?php _e('Graphic', 'lw_googlemaps'); ?></label>
    <label><input type="radio" name="each_map_type" id="each_map_type" value="G_SATELLITE_MAP"<?php echo $each_map_type_check[2]; ?> /> <?php _e('Satellite', 'lw_googlemaps'); ?></label>
    <label><input type="radio" name="each_map_type" id="each_map_type" value="G_HYBRID_MAP"<?php echo $each_map_type_check[3]; ?> /> <?php _e('Hybrid', 'lw_googlemaps'); ?></label>
  </td>
</tr><tr>
  <th width="20%" scope="row"><label for="each_map_width"><?php _e('Width:', 'lw_googlemaps'); ?></label></th> 
  <td>
    <input type="text" value="<?php echo get_option('lw_each_map_width');?>" name="each_map_width" id="each_map_width" /> px
    </td>
</tr><tr>
  <th width="20%" scope="row"><label for="each_map_height"><?php _e('Height:', 'lw_googlemaps'); ?></label></th> 
  <td>
    <input type="text" value="<?php echo get_option('lw_each_map_height');?>" name="each_map_height" id="each_map_height" /> px
  </td>
</tr><tr>
  <th width="20%" scope="row"><label for="each_map_zoom"><?php _e('Zoom level:', 'lw_googlemaps'); ?></label></th>
  <td>
    <select name="each_map_zoom" id="each_map_zoom">
    <?php $this->output_zoom_select($each_map_zoom); ?>
    </select>
    <span><?php _e('(1: Whole globe, Bigger: Narrower area)', 'lw_googlemaps'); ?></span>
  </td>
</tr>
</table>
</fieldset>
<fieldset name="convertgeo" class="options">
<legend><?php _e('Convert geo locations', 'lw_googlemaps'); ?></legend>
<p><label>
  <input type="checkbox" value="1" name="convert_geo_locations" id="convert_geo_locations" /> <?php _e('Convert location data from Geo plug-in.', 'lw_googlemaps');?>
</label></p>
<p><?php _e('Notice: Please de-activate Geo plug-in and wp-eznavi plug-in BEFORE checking this option.', 'lw_googlemaps'); ?></p>
</fieldset>
<div class="submit">
  <p><input type="submit" name="info_update" value="<?php _e('Update Options', 'lw_googlemaps'); ?> &raquo;" /></p>
</div>
</form>
</div>
<?php
} 

// ==================================================
function convert_geo_locations() {
	global $wpdb;
	$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key = '_geo_location' AND meta_value = ','");
	$wpdb->query("UPDATE {$wpdb->postmeta} SET meta_key = 'Lat_Long' WHERE meta_key = '_geo_location'");
	return;
}

// ===== End of class ====================
}

?>