// replaceThousandsSeparator.js

// Implict Objects
// LOG org.apache.commons.logging.Log
// FILE_NAME java.lang.String
// FILES[] java.io.File
// CI hiro.yoshioka.sql.util.CommentInfo

importPackage( Packages.hiro.yoshioka.util,Packages.java.text );

/**
 * after interceptor
 * @param rdh hiro.yoshioka.sdh.ResultSetDataHolder
 * @param table hiro.yoshioka.sql.resource.IDBTable
 */
function after(rdh, table) {
  LOG.warn('START replaceThousandsSeparator.js');
  
  if( rdh.hasResultSetMetaData() ) {
    for (var i=0; i < rdh.getRowCount(); i++ ) {
      var numericColumnValueSet = rdh.getPartOfStringRecordRow(i, SQLDataType.NumericsTypeList);
      LOG.warn('START in numericColumnValueSet::' + numericColumnValueSet);
      for ( var ite = numericColumnValueSet.iterator(); ite.hasNext(); ) {
        var srd = ite.next();
        var strVal = srd.getString();
        if ( StringUtil.isEmpty( strVal ) ) {
          continue;
        }
        var pointIdx = strVal.indexOf('.');
        var bd = new java.math.BigDecimal(strVal);
        var df = new DecimalFormat("###,###,###.###");
        if ( pointIdx > 0 ) {
          LOG.warn('START in for::bd ' + bd);
          srd.setString( df.format( bd.doubleValue() ) );
        } else {
          srd.setString( df.format( bd.longValue() ) );
        }
      }
    }
  }
  
  LOG.warn('END replaceThousandsSeparator.js');
}
