package sql.twitter;

import hiro.yoshioka.sdh.BindObject;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.params.ConnectionSettingBean;
import hiro.yoshioka.sql.resource.twitter.TwitterColumnType;
import hiro.yoshioka.sql.resource.twitter.TwitterSchemaType;
import hiro.yoshioka.sql.resource.twitter.TwitterTableType;
import hiro.yoshioka.sql.twitter.TwitterSQL;
import hiro.yoshioka.sql.util.SQLUtil2;
import hiro.yoshioka.util.SQLDataType;

import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import junit.framework.TestCase;
import twitter4j.TwitterException;

public class TwitterTest extends TestCase {
	static File macConnections = new File(
			"/Users/yonsama/tools/eclipse36/wk/WolfSQLParser/config/connections.def");
	static File winConnections = new File(
			"C:/tools/eclipse/wk/WolfSQLParser/config/connections.def");
	TwitterSQL sql = new TwitterSQL();
	ConnectionProperties properties = null;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		ConnectionSettingBean bean = (ConnectionSettingBean) SQLUtil2
				.readObject(macConnections);
		for (ConnectionProperties p : bean.getConnectionList()) {
			if (p.getDatabaseType().isTwitter()) {
				properties = p;
				break;
			}
		}
		assertNotNull("Connection Properties must be not null.", properties);
		try {
			assertTrue("check connection", sql.connect(properties));
		} catch (SQLException e) {
			fail("excepyion occur check your connection properties");
		}
	}

	@Override
	protected void tearDown() throws Exception {
		sql.close();
		super.tearDown();
	}

	//
	// public void testTimeline() throws TwitterException, SQLException {
	// ResultSetDataHolder2 rdh = sql.getRdh(TwitterSchemaType.Timeline,
	// TwitterTableType.HomeTimeline);
	// System.out.println(rdh);
	// assertTrue("resultset must have count over 20.",
	// rdh.getRowCount() >= 19);
	// for (TwitterColumnType columnType : TwitterColumnType.TIMELINE_LIST) {
	// boolean found = false;
	// for (String key : rdh.getKey()) {
	// if (key.equalsIgnoreCase(columnType.name())) {
	// found = true;
	// break;
	// }
	// }
	// assertTrue("resultset must have this column [" + columnType + "]",
	// found);
	// }
	// }
	//
	// public void testPublicTimeline() throws TwitterException, SQLException {
	// ResultSetDataHolder2 rdh = sql.getRdh(TwitterSchemaType.Timeline,
	// TwitterTableType.PublicTimeline);
	// System.out.println(rdh);
	// assertTrue("resultset must have count over 20.",
	// rdh.getRowCount() >= 19);
	// for (TwitterColumnType columnType : TwitterColumnType.TIMELINE_LIST) {
	// boolean found = false;
	// for (String key : rdh.getKey()) {
	// if (key.equalsIgnoreCase(columnType.name())) {
	// found = true;
	// break;
	// }
	// }
	// assertTrue("resultset must have this column [" + columnType + "]",
	// found);
	// }
	// }
	//
	// /**
	// * name='Arnold', screenName='Schwarzenegger', location='Los Angeles,
	// * California' id=12044602
	// *
	// * @throws SQLException
	// * @throws TwitterException
	// */
	// public void testFollowers() throws TwitterException, SQLException {
	// List<TwitterUser> list = sql.getFollowers(12044602L, 20L);
	// assertEquals("list must have count 20.", 20, list.size());
	// for (TwitterUser user : list) {
	// System.out.println(user);
	// }
	// }

	/**
	 * name='Arnold', screenName='Schwarzenegger', location='Los Angeles,
	 * California' id=12044602
	 *
	 * @throws SQLException
	 * @throws TwitterException
	 */
	public void testRetweetedByUser() throws TwitterException, SQLException {
		Map<String, BindObject> params = new HashMap<String, BindObject>();
		params.put(TwitterColumnType.whomUserId.name(), new BindObject(
				"12044602", SQLDataType.VARCHAR));
		params.put(TwitterColumnType.limitNum.name(), new BindObject("300",
				SQLDataType.VARCHAR));
		ResultSetDataHolder2 rdh = sql.getRdh(TwitterSchemaType.Timeline,
				TwitterTableType.RetweetedByUser, params);
		System.out.println(rdh);
	}

	/**
	 * name='Arnold', screenName='Schwarzenegger', location='Los Angeles,
	 * California' id=12044602
	 *
	 * @throws SQLException
	 * @throws TwitterException
	 */
	public void testRetweetedToUser() throws TwitterException, SQLException {
		Map<String, BindObject> params = new HashMap<String, BindObject>();
		params.put(TwitterColumnType.whomUserId.name(), new BindObject(
				"12044602", SQLDataType.VARCHAR));
		params.put(TwitterColumnType.limitNum.name(), new BindObject("300",
				SQLDataType.VARCHAR));
		ResultSetDataHolder2 rdh = sql.getRdh(TwitterSchemaType.Timeline,
				TwitterTableType.RetweetedToUser, params);
		System.out.println(rdh);
	}
	// public void testTrends() throws TwitterException, SQLException {
	// ResultSetDataHolder2 rdh = sql.getTrends(TwitterTableType.DailyTrends,
	// null);
	// assertTrue("resultset must have count over 20.",
	// rdh.getRowCount() >= 20);
	// for (TwitterColumnType columnType : TwitterColumnType.TREND_LIST) {
	// boolean found = false;
	// for (String key : rdh.getKey()) {
	// if (key.equalsIgnoreCase(columnType.name())) {
	// found = true;
	// break;
	// }
	// }
	// assertTrue("resultset must have this column [" + columnType + "]",
	// found);
	// }
	// System.out.println(rdh);
	// }

}
