package hiro.yoshioka.sql.util;

import hiro.yoshioka.sdh.BindObject;
import hiro.yoshioka.sdh.ConditionOperatorType;
import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.IRequestListener;
import hiro.yoshioka.sql.engine.DominoTransactionRequest;
import hiro.yoshioka.sql.engine.MongoTransactionRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.engine.TransactionRequest;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.DBColumn.SearchableType;
import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.util.ColorNameEnum;
import hiro.yoshioka.util.ColorUtil;
import hiro.yoshioka.util.ImageUtil;
import hiro.yoshioka.util.SQLDataType;
import hiro.yoshioka.util.StringUtil;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;

public class SelectTableDialog extends TitleAreaDialog implements
		SelectionListener {
	private boolean isCellEditorActivating;
	protected Log fLogger = LogFactory.getLog(getClass());
	protected Spinner fMaxRowsFromDB;
	protected Spinner fMaxRowsInCell;
	protected Spinner fMaxColumnNameLength;
	protected IDBTable fIDBTable;
	private IDBColumn[] columns;
	private DBRoot root;
	protected Combo fScriptSelection;
	protected Combo fCharsetSelection;
	protected Section sqlSection;
	protected Text sqlText;
	protected String sqlStatementString;
	protected String dominoSearchQuery;
	private TableViewer mainConditionTable;
	Label maxColumnNameSizeLabel, encodingCharSetLabel;
	protected Button btUpd, btMakeBlob;
	private Button fLogicalBtn, fBarBtn;
	static final String[] COMP = ConditionOperatorType.getAllSymbols();
	static final String[] SORT = { StringUtil.EMPTY_STRING, "ASC", "DESC" }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	static final String[] LAUNCH_COMBO = { StringUtil.EMPTY_STRING,
			LaunchTimingType.onClick.name() }; //$NON-NLS-1$
	static final String[] HEADER = {
			Messages.getString("SelectTableDialog.Display"), Messages.getString("SelectTableDialog.ColumnName"), Messages.getString("SelectTableDialog.Operator"), //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			Messages.getString("SelectTableDialog.ConditionValue"), Messages.getString("SelectTableDialog.Sort"), Messages.getString("SelectTableDialog.Launch") }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	static final int[] COL_SIZE = { 52, 180, 100, 190, 62, 60 };
	private static final int BTN_ID_UPDATE = 4000;
	private static final int BTN_ID_SELECT = 50000;

	protected ConnectionProperties connectionProperties;
	IRequestListener requestListener;
	protected Map<String, BindObject> fCondMap = new LinkedHashMap<String, BindObject>();

	protected DBObject returnFields;
	protected DBObject queryUsesedToSearch;
	protected DBObject orderBy;
	protected Button unidUsingButton;
	protected Button braceEscapeButton;
	private CellEditor[] cellEditor;
	protected List<String> selectColumnList = new ArrayList<String>();
	private boolean nowCanseling;

	public SelectTableDialog(ConnectionProperties connectionProperties,
			Shell parent, IDBTable dbTable, IRequestListener requestListener) {
		super(parent);
		this.requestListener = requestListener;
		this.connectionProperties = connectionProperties;
		this.fIDBTable = dbTable;
		this.root = dbTable.getRoot();
		this.columns = fIDBTable.getColumnsForSelectionDialog();
	}

	MyModel[] myModel;

	@Override
	protected boolean isResizable() {
		return true;
	}

	@Override
	protected void cancelPressed() {
		nowCanseling = true;
		for (CellEditor editor : cellEditor) {
			if (editor.isActivated()) {
				System.out.println("deactivate!!!");
				editor.deactivate();
			}
		}
		System.out.println("canlsellllll");
		super.cancelPressed();
	}

	protected void execute(boolean upd) {
		boolean needsRefresh = false;
		for (CellEditor editor : cellEditor) {
			if (editor.isActivated()) {
				editor.deactivate();
				needsRefresh = true;
			}
		}
		if (needsRefresh) {
			refreshStatement();
		}
		sqlStatementString = sqlText.getText();
		setReturnCode(OK);

		try {
			if (isMongo()) {
				MongoTransactionRequest req = new MongoTransactionRequest(
						SQLOperationType.PREPARED_EXECUTE_QUERY,
						connectionProperties, fIDBTable);
				req.requestForUpdatable = upd;
				req.makeBlob = btMakeBlob.getSelection();
				req.setQueryUsesedToSearch(queryUsesedToSearch);
				req.setReturnFields(returnFields);
				req.setOrderBy(orderBy);
				req.setMaxRownum(fMaxRowsFromDB.getSelection());
				req.setPartName(fIDBTable.getName());
				req.addListener(requestListener);

				SQLServerThread.putRequest(req);
			} else if (isDomino()) {
				DominoTransactionRequest req = null;
				if (unidUsingButton.getSelection()) {
					String[] uids = sqlStatementString.split("\r\n|\r|\n"); //$NON-NLS-1$
					req = new DominoTransactionRequest(
							SQLOperationType.UNID_EXECUTE_QUERY,
							connectionProperties, uids);
					req.setTable(fIDBTable);
				} else {
					req = new DominoTransactionRequest(
							SQLOperationType.PREPARED_EXECUTE_QUERY,
							connectionProperties, fIDBTable);
				}
				req.makeBlob = btMakeBlob.getSelection();
				// TODO:
				// req.requestForUpdatable = upd;
				req.setDominoSearchQuery(dominoSearchQuery);
				// req.setReturnFields(returnFields);
				//
				req.setMaxRownum(fMaxRowsFromDB.getSelection());
				// req.setPartName(fIDBTable.getName());
				req.addListener(requestListener);

				SQLServerThread.putRequest(req);
			} else {
				BindObject[] binds = null;
				if (fCondMap.size() > 0) {
					Collection<BindObject> cv = fCondMap.values();
					binds = cv.toArray(new BindObject[cv.size()]);
				}
				TransactionRequest req = new TransactionRequest(
						SQLOperationType.PREPARED_EXECUTE_QUERY,
						connectionProperties, sqlText.getText(), binds,
						fIDBTable);
				req.makeBlob = btMakeBlob.getSelection();
				for (String key : fCondMap.keySet()) {
					req.addWhereCondition(key, fCondMap.get(key));
				}

				req.requestForUpdatable = upd;
				req.setMaxRownum(fMaxRowsFromDB.getSelection());
				req.setPartName(fIDBTable.getName());
				req.addListener(requestListener);
				req.setSelectColumnList(selectColumnList);

				SQLServerThread.putRequest(req);
			}
		} catch (Exception e) {
			fLogger.error(e);
		}
		close();
	}

	protected void refreshStatement() {
		selectColumnList.clear();
		if (isMongo()) {
			refreshMongoStatement();
		} else if (isDomino()) {
			refreshDominoStatement();
		} else if (isTwitter()) {
			refreshSqlStatement();
		} else {
			refreshSqlStatement();
		}
	}

	private void refreshMongoStatement() {
		try {
			queryUsesedToSearch = null;

			boolean doWhere = false;
			for (int i = 0; i < myModel.length; i++) {
				if (myModel[i].validAppendCondition()) {
					doWhere = true;
					queryUsesedToSearch = new BasicDBObject();
					break;
				}
			}
			returnFields = new BasicDBObject();
			fCondMap.clear();
			//			static final String[] COMP = { "=", "<", "<=", ">=", ">", "LIKE", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
			//				"IS NULL", "IS NOT NULL" }; //$NON-NLS-1$ //$NON-NLS-2$
			if (doWhere) {
				for (int i = 0; i < myModel.length; i++) {
					if (myModel[i].validAppendCondition()) {
						switch (myModel[i].compareOperator) {
						case 0:
							queryUsesedToSearch.put(columns[i].getName(),
									myModel[i].condition);
							break;
						case 1:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$lt", //$NON-NLS-1$
											myModel[i].condition));
							break;
						case 2:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$le", //$NON-NLS-1$
											myModel[i].condition));
							break;
						case 3:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$ge", //$NON-NLS-1$
											myModel[i].condition));
							break;
						case 4:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$gt", //$NON-NLS-1$
											myModel[i].condition));
							break;
						case 5:
							queryUsesedToSearch.put(columns[i].getName(),
									Pattern.compile(myModel[i].condition));
							break;
						case 6:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$exists", false)); //$NON-NLS-1$
							break;
						case 7:
							queryUsesedToSearch.put(columns[i].getName(),
									new BasicDBObject("$exists", true)); //$NON-NLS-1$
							break;
						}
					}
				}
			}

			String targetDB = fIDBTable.getNameWithParentName();
			StringBuilder colBuilder = null;

			if (columns.length == 0) {
				if (doWhere) {
					sqlText.setText(String.format("%s.find( %s )", targetDB, //$NON-NLS-1$
							queryUsesedToSearch.toString()));
				} else {
					sqlText.setText(String.format("%s.find()", targetDB)); //$NON-NLS-1$
				}
			} else {
				colBuilder = new StringBuilder();
				for (int i = 0, j = 0; i < columns.length; i++) {
					if (myModel[i].doDisplay) {
						if (j > 0) {
							colBuilder.append(","); //$NON-NLS-1$
						}
						colBuilder.append(String.format("\"%s\":1", //$NON-NLS-1$
								columns[i].getName()));
						j++;
						returnFields.put(columns[i].getName(), "1"); //$NON-NLS-1$
					}
					if (i > 0 && i % 5 == 0 && (i + 1 < columns.length)) {
						colBuilder.append(StringUtil.LINE_SEPARATOR + " "); //$NON-NLS-1$
					}
				}
				if (doWhere) {
					sqlText.setText(String.format(
							"%s.find(%n  %s,%n  {%s} %n)", targetDB, //$NON-NLS-1$
							queryUsesedToSearch.toString(),
							colBuilder.toString()));
				} else {
					sqlText.setText(String.format(
							"%s.find(%n  {},%n  {%s} %n)", targetDB, //$NON-NLS-1$
							colBuilder.toString()));
				}
			}
			boolean doOrder = false;
			for (int i = 0; i < myModel.length; i++) {
				if (myModel[i].sort > 0) {
					doOrder = true;
					break;
				}
			}
			orderBy = new BasicDBObject();
			if (doOrder) {
				colBuilder = new StringBuilder();
				for (int i = 0; i < myModel.length; i++) {
					if (myModel[i].sort == 1) {
						colBuilder.append(String.format("\"%s\":1,", //$NON-NLS-1$
								columns[i].getName()));
					} else if (myModel[i].sort == 2) {
						colBuilder.append(String.format("\"%s\":-1,", //$NON-NLS-1$
								columns[i].getName()));
					}
				}
				colBuilder.setLength(colBuilder.length() - 1);
				sqlText.setText(String.format("%s.sort({%s})", //$NON-NLS-1$
						sqlText.getText(), colBuilder.toString()));
			}
			sqlStatementString = sqlText.getText();
		} catch (RuntimeException e) {
			e.printStackTrace();
		}
	}

	private void refreshDominoStatement() {
		try {
			StringBuffer buf = new StringBuffer();
			if (fIDBTable.hasAlias()) {
				dominoSearchQuery = String.format("Form=\"%s\" ", //$NON-NLS-1$
						fIDBTable.getAlias());
			} else {
				dominoSearchQuery = String.format("Form=\"%s\" ", //$NON-NLS-1$
						fIDBTable.getName());
			}
			buf.append("SELECT ").append(StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
			if (columns.length == 0) {
				buf.append("* ").append(StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
			} else {
				for (int i = 0, j = 0; i < columns.length; i++) {
					if (myModel[i].doDisplay) {
						if (j > 0) {
							buf.append(","); //$NON-NLS-1$
						}
						if (fLogicalBtn.getSelection()) {
							if (Charset
									.isSupported(fCharsetSelection.getText())) {
								buf.append(columns[i].getNameWithAsComment(
										Charset.forName(fCharsetSelection
												.getText()),
										fMaxColumnNameLength.getSelection()));
							}
						} else {
							buf.append(columns[i].getName());
						}
						j++;
					}
					if (i > 0 && i % 5 == 0 && (i + 1 < columns.length)) {
						buf.append(StringUtil.LINE_SEPARATOR + " "); //$NON-NLS-1$
					}
				}

			}
			buf.append(StringUtil.LINE_SEPARATOR).append("FROM "); //$NON-NLS-1$

			buf.append(String
					.format("%s %n", fIDBTable.getNameWithParentName())); //$NON-NLS-1$
			boolean doWhere = false;
			for (int i = 0; i < myModel.length; i++) {
				if (myModel[i].validAppendCondition()) {
					doWhere = true;
					break;
				}
			}
			fCondMap.clear();
			if (doWhere) {
				StringBuilder searchBuilder = new StringBuilder();
				buf.append("WHERE " + StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
				for (int i = 0; i < myModel.length; i++) {
					if (myModel[i].validAppendCondition()) {
						String q = StringUtil.EMPTY_STRING;
						searchBuilder.append(" & "); //$NON-NLS-1$
						if (myModel[i].compareOperator >= 6) {
							q = String.format("%s %s ", columns[i] //$NON-NLS-1$
									.getName(),
									COMP[myModel[i].compareOperator]);
						} else if (myModel[i].compareOperator == 5) {
							q = String.format("@Contains(%s;\"%s\") ", //$NON-NLS-1$
									columns[i].getName(), myModel[i].condition);
							BindObject bi = new BindObject(q,
									myModel[i].dataType);
							fCondMap.put(myModel[i].columnName, bi);
						} else {
							q = String.format("%s %s %s ", columns[i] //$NON-NLS-1$
									.getName(),
									COMP[myModel[i].compareOperator],
									myModel[i].condition);
							BindObject bi = new BindObject(q,
									myModel[i].dataType);
							fCondMap.put(myModel[i].columnName, bi);
						}
						searchBuilder.append(q);
					}
				}
				dominoSearchQuery += searchBuilder.toString();
				buf.append(dominoSearchQuery);
				buf.append(StringUtil.LINE_SEPARATOR);
			}

			boolean doOrder = false;
			for (int i = 0; i < myModel.length; i++) {
				if (myModel[i].sort > 0) {
					doOrder = true;
					break;
				}
			}
			if (doOrder) {
				buf.append("ORDER BY " + StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
				for (int i = 0; i < myModel.length; i++) {
					if (myModel[i].sort > 0) {
						buf.append(columns[i].getName() + " " //$NON-NLS-1$
								+ SORT[myModel[i].sort] + ","); //$NON-NLS-1$
					}
				}
				buf.setLength(buf.length() - 1);
			}
			sqlStatementString = buf.toString();
			sqlText.setText(buf.toString());
		} catch (RuntimeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	protected String getSpecialRendition() {
		StringBuilder buf = new StringBuilder();
		if (fBarBtn.getSelection()) {
			buf.append("-- BAR_GRAPH_ON_CHART=true").append( //$NON-NLS-1$
					StringUtil.LINE_SEPARATOR);
		}
		if (fMaxRowsInCell.getSelection() > 1) {
			buf.append(String.format("-- multi_line=%d %n", fMaxRowsInCell //$NON-NLS-1$
					.getSelection()));
		}
		if (fScriptSelection.getSelectionIndex() > 0) {
			buf.append(String.format("-- interceptors [ %s ] %n", //$NON-NLS-1$
					fScriptSelection.getText()));
		}
		int delCnt = 0;
		for (int i = 0; i < columns.length; i++) {
			if (!myModel[i].doDisplay) {
				delCnt++;
				continue;
			}
			if (myModel[i].doDisplay && myModel[i].launchTiming > 0) {
				LaunchTimingType launch = LaunchTimingType
						.valueOf(LAUNCH_COMBO[myModel[i].launchTiming]);
				buf.append(String.format("-- LAUNCH IDX=%d %s %n", //$NON-NLS-1$
						(i + 1 - delCnt), launch));
			}
		}
		return buf.toString();
	}

	private String getColumnName(IDBColumn column, boolean withAlias,
			boolean doQuote, DatabaseType db_type) {
		String columnName = column.getName();
		if (db_type.isFileMaker()) {
			return String.format("\"%s\"", columnName);
		}
		if (db_type.isMsAccessJackess()) {
			if (columnName.startsWith("_")) {
				return String.format("\"%s\"", columnName);
			}
			return columnName;
		}
		if (doQuote) {
			return String.format("\"%s\"", column.getName());
		}

		if (withAlias && Charset.isSupported(fCharsetSelection.getText())) {
			return column.getNameWithAsComment(
					Charset.forName(fCharsetSelection.getText()),
					fMaxColumnNameLength.getSelection());
		} else {
			return columnName;
		}

	}

	public static void main(String[] args) {
		String col_name = "顧客サブ名称（カナ）";
		Pattern pattern = Pattern.compile("[(（）)]");
		Matcher m = pattern.matcher(col_name);
		if (m.find()) {
			System.out.println("found.");
		} else {
			System.out.println("not found");
		}
	}

	private DatabaseType getDatabaseType() {
		if (this.root == null) {
			return DatabaseType.UNKNOWN;
		}
		return DatabaseType.parse(this.root.getDatabaseProductName());
	}

	private void refreshSqlStatement() {
		try {
			DatabaseType db_type = getDatabaseType();
			StringBuffer buf = new StringBuffer();
			buf.append(getSpecialRendition());
			buf.append("SELECT ").append(StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
			if (columns.length == 0) {
				buf.append("* ").append(StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
			} else {
				for (int i = 0, j = 0; i < columns.length; i++) {
					if (myModel[i].doDisplay) {
						boolean doQuote = false;
						String col_name = columns[i].getName();
						if (braceEscapeButton.getSelection()) {
							Pattern pattern = Pattern.compile("[(（）)]");
							Matcher m = pattern.matcher(col_name);
							if (m.find()) {
								doQuote = true;
								col_name = String.format("\"%s\"", col_name);
							}
						}
						selectColumnList.add(col_name);
						if (j > 0) {
							buf.append(","); //$NON-NLS-1$
						}
						buf.append(getColumnName(columns[i],
								fLogicalBtn.getSelection(), doQuote, db_type));
						j++;
					}
					if (i > 0 && i % 5 == 0 && (i + 1 < columns.length)) {
						buf.append(StringUtil.LINE_SEPARATOR + " "); //$NON-NLS-1$
					}
				}

			}
			buf.append(StringUtil.LINE_SEPARATOR).append("FROM "); //$NON-NLS-1$
			switch (db_type) {
			case FILE_MAKER:
				buf.append(String.format("\"%s\" %n", fIDBTable.getName())); //$NON-NLS-1$
				break;
			case CASSANDRA:
				buf.append(String.format("%s %n", fIDBTable.getName())); //$NON-NLS-1$
				break;
			default:
				buf.append(String.format(
						"%s %n", fIDBTable.getNameWithParentName())); //$NON-NLS-1$
				break;
			}
			boolean doWhere = false;
			for (int i = 0; i < myModel.length; i++) {
				if (myModel[i].validAppendCondition()) {
					doWhere = true;
					break;
				}
			}
			fCondMap.clear();
			if (doWhere) {
				buf.append("WHERE " + StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
				for (int i = 0; i < myModel.length; i++) {
					if (myModel[i].validAppendCondition()) {
						if (myModel[i].compareOperator >= 6) {
							buf.append(String.format(
									"%s %s ",
									getColumnName(columns[i], false, false,
											db_type),
									COMP[myModel[i].compareOperator]));
						} else {
							buf.append(String.format(
									"%s %s ? ",
									getColumnName(columns[i], false, false,
											db_type),
									COMP[myModel[i].compareOperator]));
							BindObject bi = new BindObject(
									myModel[i].condition, myModel[i].dataType);
							bi.operator = ConditionOperatorType
									.parseBySymbol(COMP[myModel[i].compareOperator]);
							fCondMap.put(myModel[i].columnName, bi);
						}
						buf.append(" AND "); //$NON-NLS-1$
					}
				}
				buf.setLength(buf.length() - 5);
				buf.append(StringUtil.LINE_SEPARATOR);
			}

			boolean doOrder = false;
			for (int i = 0; i < myModel.length; i++) {
				if (myModel[i].sort > 0) {
					doOrder = true;
					break;
				}
			}
			if (doOrder) {
				buf.append("ORDER BY " + StringUtil.LINE_SEPARATOR); //$NON-NLS-1$
				for (int i = 0; i < myModel.length; i++) {
					if (myModel[i].sort > 0) {
						buf.append(getColumnName(columns[i], false, false,
								db_type) + " " //$NON-NLS-1$
								+ SORT[myModel[i].sort] + ","); //$NON-NLS-1$
					}
				}
				buf.setLength(buf.length() - 1);
			}
			sqlStatementString = buf.toString();
			sqlText.setText(buf.toString());
		} catch (RuntimeException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	private class MyLabelProvider implements ITableLabelProvider,
			IColorProvider {

		@Override
		public Image getColumnImage(Object element, int columnIndex) {
			if (columnIndex == 0) {
				MyModel model = (MyModel) element;
				if (model.doDisplay && model.searchableType.isVisible()) {
					return ImageUtil.getImage(ImageUtil.ACTION_83_INFO);
				}
			}
			return null;
		}

		@Override
		public String getColumnText(Object element, int columnIndex) {
			try {
				MyModel model = (MyModel) element;
				switch (columnIndex) {
				case 0:
					return StringUtil.EMPTY_STRING; //$NON-NLS-1$
				case 1:
					return StringUtil.EMPTY_STRING + model.columnName; //$NON-NLS-1$
				case 2:
					return COMP[model.compareOperator];
				case 3:
					return model.condition;
				case 4:
					return SORT[model.sort];
				case 5:
					return LAUNCH_COMBO[model.launchTiming];
				}
				return StringUtil.EMPTY_STRING; //$NON-NLS-1$
			} catch (RuntimeException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return "a"; //$NON-NLS-1$
		}

		@Override
		public void addListener(ILabelProviderListener listener) {
		}

		@Override
		public void dispose() {
		}

		@Override
		public boolean isLabelProperty(Object element, String property) {
			return false;
		}

		@Override
		public void removeListener(ILabelProviderListener listener) {
		}

		@Override
		public Color getForeground(Object element) {
			MyModel model = (MyModel) element;
			if (!model.doDisplay) {
				return ColorUtil.getColor(ColorNameEnum.GRAY);
			}
			return null;
		}

		@Override
		public Color getBackground(Object element) {
			return null;
		}
	}

	public class MyModel {
		boolean doDisplay = true;

		String columnName;

		String logicalName;

		int compareOperator;

		SQLDataType dataType;

		private String condition = StringUtil.EMPTY_STRING; //$NON-NLS-1$

		int sort;

		SearchableType searchableType;

		int launchTiming;

		public MyModel(String columnName) {
			this.columnName = columnName;
		}

		public boolean validAppendCondition() {
			if (searchableType.isSearchable()) {
				return condition.trim().length() > 0 || compareOperator >= 6;
			}
			return false;
		}

		public String toString() {
			return columnName + "=" + condition; //$NON-NLS-1$
		}
	}

	private class MyCellModifier implements ICellModifier {

		private TableViewer viewer;

		public void setViewer(TableViewer viewer) {
			this.viewer = viewer;
		}

		public boolean canModify(Object element, String property) {
			MyModel model = (MyModel) element;
			if (HEADER[0].equals(property)) { // disp
				return model.searchableType.isVisible();
			} else if (HEADER[1].equals(property)) { // name
				return false;
			} else if (HEADER[2].equals(property)) { // operator
				return model.searchableType.isSearchable();
			} else if (HEADER[3].equals(property)) {
				return model.searchableType.isSearchable()
						&& model.compareOperator < 6;
			} else if (HEADER[4].equals(property)) { // order
				return model.searchableType.isVisible();
			} else if (HEADER[5].equals(property)) { // launch
				return model.searchableType.isVisible();
			} else {
				return true;
			}
		}

		public Object getValue(Object element, String property) {
			MyModel model = (MyModel) element;
			if (HEADER[0].equals(property)) {
				return model.doDisplay;
			} else if (HEADER[1].equals(property)) {
				if (StringUtil.isEmpty(model.logicalName)) {
					return model.columnName;
				} else {
					return String.format("%s (%s)", model.columnName,
							model.logicalName);
				}
			} else if (HEADER[2].equals(property)) {
				return model.compareOperator;
			} else if (HEADER[3].equals(property)) {
				return model.condition;
			} else if (HEADER[4].equals(property)) {
				return model.sort;
			} else {
				return model.launchTiming;
			}
		}

		public void modify(Object element, String property, Object value) {
			TableItem item = (TableItem) element;
			if (item == null) {
				return;
			}
			MyModel model = (MyModel) item.getData();
			if (HEADER[0].equals(property)) {
				model.doDisplay = ((Boolean) value).booleanValue();
			} else if (HEADER[1].equals(property)) {
				model.columnName = (String) value;
			} else if (HEADER[2].equals(property)) {
				model.compareOperator = ((Integer) value).intValue();
			} else if (HEADER[3].equals(property)) {
				model.condition = (String) value;
			} else if (HEADER[4].equals(property)) {
				model.sort = ((Integer) value).intValue();
			} else if (HEADER[5].equals(property)) {
				model.launchTiming = ((Integer) value).intValue();
			} else {
				model.condition = (String) value;
			}
			viewer.update(item.getData(), null);
			refreshStatement();
		}
	}

	private class MyContentProvider implements IStructuredContentProvider {

		public Object[] getElements(Object inputElement) {
			return (MyModel[]) inputElement;
		}

		public void dispose() {

		}

		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {

		}

	}

	public class DelegatingEditor extends CellEditor {
		private int colIdx;
		private StructuredViewer viewer;

		private CellEditor delegatingTextEditor;

		private CellEditor delegatingDropDownCompEditor;

		private CellEditor delegatingDropDownSortEditor;

		private CellEditor activeEditor;

		private CellEditor delegatingCheckBoxEditor;

		private CellEditor delegatingDropDownLaunchEditor;

		private class DelegatingListener implements ICellEditorListener {

			public void applyEditorValue() {
				fireApplyEditorValue();
			}

			public void cancelEditor() {
				fireCancelEditor();
			}

			public void editorValueChanged(boolean oldValidState,
					boolean newValidState) {
				fireEditorValueChanged(oldValidState, newValidState);
			}

		}

		public DelegatingEditor(int colIdx, StructuredViewer viewer,
				Composite parent) {
			super(parent);
			this.colIdx = colIdx;
			this.viewer = viewer;
			DelegatingListener l = new DelegatingListener();
			this.delegatingTextEditor = new TextCellEditor(parent);
			this.delegatingTextEditor.addListener(l);

			this.delegatingDropDownCompEditor = new ComboBoxCellEditor(parent,
					COMP, SWT.READ_ONLY);
			Control ctl = this.delegatingDropDownCompEditor.getControl();
			if (ctl instanceof CCombo) {
				CCombo cmb = (CCombo) ctl;
				cmb.setVisibleItemCount(COMP.length);
			}
			this.delegatingDropDownCompEditor.addListener(l);

			this.delegatingDropDownSortEditor = new ComboBoxCellEditor(parent,
					SORT, SWT.READ_ONLY);
			this.delegatingDropDownSortEditor.addListener(l);

			this.delegatingCheckBoxEditor = new CheckboxCellEditor(parent);
			this.delegatingCheckBoxEditor.addListener(l);

			this.delegatingDropDownLaunchEditor = new ComboBoxCellEditor(
					parent, LAUNCH_COMBO, SWT.READ_ONLY);
			this.delegatingDropDownLaunchEditor.addListener(l);

		}

		protected Control createControl(Composite parent) {
			return null;
		}

		protected Object doGetValue() {
			return activeEditor.getValue();
		}

		protected void doSetFocus() {
			activeEditor.setFocus();
		}

		public void activate() {
			if (activeEditor != null) {
				activeEditor.activate();
			}
			if (activeEditor != delegatingCheckBoxEditor) {
				isCellEditorActivating = true;
				validate();
			}
		}

		protected void doSetValue(Object value) {
			switch (colIdx) {
			case 0:
				activeEditor = delegatingCheckBoxEditor;
				break;
			case 1:
				throw new RuntimeException("dont edit"); //$NON-NLS-1$
			case 2:
				activeEditor = delegatingDropDownCompEditor;
				break;
			case 3:
				activeEditor = delegatingTextEditor;
				break;
			case 4:
				activeEditor = delegatingDropDownSortEditor;
				break;
			case 5:
				activeEditor = delegatingDropDownLaunchEditor;
				break;
			}
			activeEditor.setValue(value);
		}

		public void deactivate() {
			if (activeEditor != null) {
				Control control = activeEditor.getControl();
				if (control != null && !control.isDisposed()) {
					control.setVisible(false);
				}
				activeEditor.deactivate();
			}
			isCellEditorActivating = false;
			validate();
		}

		public void dispose() {

		}

		public Control getControl() {
			return activeEditor.getControl();
		}
	}

	private void validate() {
		if (nowCanseling) {
			return;
		}

		String newErrorMessage = null;
		if (isCellEditorActivating) {
			newErrorMessage = Messages
					.getString("SelectTableDialog.CellEditorIsActivatingPressEnterInCellEditor"); //$NON-NLS-1$
		}
		setErrorMessage(newErrorMessage);

		if (connectionProperties.isConnected()) {
			Button bt = getButton(BTN_ID_UPDATE);
			if (bt != null) {
				if (getDatabaseType().isFileMaker()) {
					bt.setEnabled(false);
				} else {
					bt.setEnabled(newErrorMessage == null);
				}
			}
			bt = getButton(BTN_ID_SELECT);
			if (bt != null) {
				bt.setEnabled(newErrorMessage == null);
			}
		}
	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		GridLayout gl = (GridLayout) parent.getLayout();
		gl.verticalSpacing = 0;
		gl.marginBottom = 0;
		gl.marginTop = 0;
		gl.marginHeight = 1;
		btUpd = createButton(parent, BTN_ID_UPDATE,
				Messages.getString("SelectTableDialog.ExecuteForUpdate"), false); //$NON-NLS-1$
		if (connectionProperties.isConnected()) {
			if (getDatabaseType().isFileMaker()) {
				btUpd.setEnabled(false);
			} else {
				btUpd.addSelectionListener(new SelectionAdapter() {
					@Override
					public void widgetSelected(SelectionEvent e) {
						// mainConditionTable.a
						execute(true);
					}
				});
			}
		} else {
			btUpd.setEnabled(false);
		}
		if (isDomino()) {
			btUpd.setEnabled(false);
		}
		if (fIDBTable.hasPk()) {
			setTitle(StringUtil.EMPTY_STRING);
		} else {
			setTitle(Messages.getString("SelectTableDialog.MustHavePrimaryKet")); //$NON-NLS-1$
		}

		Button btOK = createButton(parent, BTN_ID_SELECT,
				Messages.getString("SelectTableDialog.Execute"), false); //$NON-NLS-1$
		if (connectionProperties.isConnected()) {
			btOK.addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					execute(false);
				}
			});
		} else {
			btOK.setEnabled(false);
		}

		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, true);
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		getShell()
				.setText(
						String.format(
								Messages.getString("SelectTableDialog.SelectColumnsFrom"), fIDBTable.getUName())); //$NON-NLS-1$
		Composite inner = new Composite(parent, SWT.NONE);
		inner.setLayoutData(new GridData(GridData.FILL_BOTH));
		inner.setLayout(new FillLayout());

		try {
			TableWrapLayout layout = new TableWrapLayout();
			layout.numColumns = 4;

			FormToolkit toolkit = new FormToolkit(parent.getDisplay());
			ScrolledForm root = toolkit.createScrolledForm(inner);
			Composite body = root.getBody();
			body.setLayout(layout);

			// ---------------------------------------
			if (isDomino()) {
				Section UNIDSection = toolkit.createSection(root.getBody(),
						Section.TITLE_BAR | Section.EXPANDED);
				TableWrapData twd00 = new TableWrapData(
						TableWrapData.FILL_GRAB, TableWrapData.TOP, 1, 4);

				UNIDSection.setLayoutData(twd00);
				UNIDSection.setText(Messages
						.getString("SelectTableDialog.UsingUNIDorElse")); //$NON-NLS-1$

				unidUsingButton = toolkit.createButton(UNIDSection,
						Messages.getString("SelectTableDialog.Check"), //$NON-NLS-1$
						SWT.CHECK);
				UNIDSection.setClient(unidUsingButton);
			}
			// ---------------------------------------

			int maxColumnNameSize = 0;
			setTitle(Messages.getString("SelectTableDialog.SelectCondition")); //$NON-NLS-1$

			Section section = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);

			section.setText(Messages
					.getString("SelectTableDialog.ColumnCondition")); //$NON-NLS-1$
			TableWrapData twd0 = new TableWrapData(TableWrapData.FILL_GRAB,
					TableWrapData.TOP, 1, 4);

			section.setLayoutData(twd0);
			section.setLayout(new GridLayout());

			Composite c = new Composite(section, SWT.BORDER);
			c.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

			TableWrapLayout tr = new TableWrapLayout();
			tr.numColumns = 1;
			c.setLayout(tr);

			Table table = new Table(c, SWT.BORDER | SWT.FULL_SELECTION
					| SWT.V_SCROLL);
			final MyCellModifier modifier = new MyCellModifier();
			mainConditionTable = new TableViewer(table);

			modifier.setViewer(mainConditionTable);
			table.setLinesVisible(true);
			table.setHeaderVisible(true);
			mainConditionTable.setLabelProvider(new MyLabelProvider());
			mainConditionTable.setContentProvider(new MyContentProvider());
			mainConditionTable.setCellModifier(modifier);
			mainConditionTable.setColumnProperties(HEADER);
			cellEditor = new CellEditor[HEADER.length];
			for (int i = 0; i < HEADER.length; i++) {
				TableColumn column = new TableColumn(table, SWT.NONE);
				column.setText(HEADER[i]);
				column.setWidth(COL_SIZE[i]);
				cellEditor[i] = new DelegatingEditor(i, mainConditionTable,
						mainConditionTable.getTable());
			}
			mainConditionTable.setCellEditors(cellEditor);

			TableWrapData layoutData = new TableWrapData(
					TableWrapData.FILL_GRAB);
			layoutData.heightHint = 5 + table.getItemHeight() * 8;
			twd0.heightHint = 19 + table.getItemHeight() * 9;
			table.setLayoutData(layoutData);

			// whomUserId
			myModel = new MyModel[columns.length];
			for (int i = 0; i < columns.length; i++) {
				myModel[i] = new MyModel(columns[i].getName());
				myModel[i].logicalName = columns[i].getComment();
				myModel[i].dataType = columns[i].getDataType();
				myModel[i].searchableType = columns[i].getSearchableType();
				myModel[i].doDisplay = myModel[i].searchableType.isVisible();
				if (myModel[i].searchableType.isSearchable()) {
					myModel[i].condition = columns[i]
							.getDefaultConditionValue();
				} else {
					myModel[i].condition = Messages
							.getString("SelectTableDialog.SEARCH_INVALID"); //$NON-NLS-1$
				}
				myModel[i].launchTiming = columns[i].isOnClickable() ? 1 : 0;
				maxColumnNameSize = columns[i].getMaxColumnNameLength();
			}
			mainConditionTable.setInput(myModel);
			section.setClient(c);

			// ---------------------------------------
			Section section2 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section2.setText(Messages
					.getString("SelectTableDialog.COLUMNASLogialName")); //$NON-NLS-1$
			section2.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB,
					TableWrapData.TOP, 1, 4));
			section2.addMouseTrackListener(new MouseTrackListener() {
				@Override
				public void mouseHover(MouseEvent arg0) {
				}

				@Override
				public void mouseExit(MouseEvent arg0) {
				}

				@Override
				public void mouseEnter(MouseEvent arg0) {
					if (cellEditor != null && isCellEditorActivating) {
						for (CellEditor cell : cellEditor) {
							if (cell != null) {
								cell.deactivate();
							}
						}
					}
				}
			});

			Composite inner2 = toolkit.createComposite(section2);
			section2.setClient(inner2);
			inner2.setLayout(new GridLayout(6, false));
			fLogicalBtn = toolkit
					.createButton(
							inner2,
							Messages.getString("SelectTableDialog.LogicalName"), SWT.CHECK); //$NON-NLS-1$
			fLogicalBtn.addSelectionListener(this);
			fLogicalBtn.setSelection(false);
			maxColumnNameSizeLabel = toolkit.createLabel(inner2,
					Messages.getString("SelectTableDialog.MaxColumnNameSize")); //$NON-NLS-1$
			maxColumnNameSizeLabel.setForeground(ColorUtil
					.getColor(ColorNameEnum.GRAY));
			fMaxColumnNameLength = new Spinner(inner2, SWT.BORDER);
			fMaxColumnNameLength
					.setToolTipText(Messages
							.getString("SelectTableDialog.ColumnNameortheAliasmaximumbytesize")); //$NON-NLS-1$
			fMaxColumnNameLength.setMinimum(0);
			fMaxColumnNameLength.setMaximum(100);
			fMaxColumnNameLength.setSelection(maxColumnNameSize);
			fMaxColumnNameLength.setEnabled(false);
			encodingCharSetLabel = toolkit
					.createLabel(
							inner2,
							Messages.getString("SelectTableDialog.Charsetuseincalcmaxnamesize")); //$NON-NLS-1$
			encodingCharSetLabel.setForeground(ColorUtil
					.getColor(ColorNameEnum.GRAY));
			fCharsetSelection = new Combo(inner2, SWT.BORDER);
			fCharsetSelection
					.setToolTipText(Messages
							.getString("SelectTableDialog.Charsetuseincalcmaxnamesize2")); //$NON-NLS-1$
			fCharsetSelection.setItems(StringUtil.ENCODINGS);
			fCharsetSelection.setEnabled(false);
			boolean doAddDefEncode = true;
			for (int i = 0; i < StringUtil.ENCODINGS.length; i++) {
				if (StringUtil.ENCODINGS[i]
						.equalsIgnoreCase(StringUtil.DEFAULT_ENCODING)) {
					fCharsetSelection.select(i);
					doAddDefEncode = false;
				}
			}
			if (doAddDefEncode) {
				fCharsetSelection.add(StringUtil.DEFAULT_ENCODING, 0);
				fCharsetSelection.select(0);
			}
			fCharsetSelection.setLayoutData(new GridData(
					GridData.FILL_HORIZONTAL));

			// ---------------------------------------
			Section section2_0 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section2_0.setText(Messages
					.getString("SelectTableDialog.GetBinaryData")); //$NON-NLS-1$
			TableWrapData trDataB = new TableWrapData(TableWrapData.FILL_GRAB,
					TableWrapData.TOP, 1, 1);
			trDataB.maxWidth = 150;
			section2_0.setLayoutData(trDataB);

			btMakeBlob = toolkit.createButton(section2_0,
					Messages.getString("SelectTableDialog.Get"), SWT.CHECK); //$NON-NLS-1$

			btMakeBlob.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			section2_0.setClient(btMakeBlob);
			// ---------------------------------------
			Section section2_2 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section2_2.setText(Messages
					.getString("SelectTableDialog.MaxRowsSelection")); //$NON-NLS-1$
			TableWrapData trData0 = new TableWrapData(TableWrapData.FILL_GRAB,
					TableWrapData.TOP, 1, 1);
			trData0.maxWidth = 120;
			section2_2.setLayoutData(trData0);

			fMaxRowsFromDB = new Spinner(section2_2, SWT.BORDER);
			fMaxRowsFromDB.setToolTipText(Messages
					.getString("SelectTableDialog.Maxrownumfromdatabase")); //$NON-NLS-1$
			fMaxRowsFromDB.setMinimum(1);
			fMaxRowsFromDB.setMaximum(1000000);
			fMaxRowsFromDB.setSelection(connectionProperties.getMaxRowNum());
			GridData gdRows = new GridData();
			gdRows.widthHint = 100;
			fMaxRowsFromDB.setLayoutData(gdRows);
			section2_2.setClient(fMaxRowsFromDB);
			// ---------------------------------------
			Section section2_3 = toolkit.createSection(root.getBody(),
					Section.TITLE_BAR);
			TableWrapData trData = new TableWrapData(TableWrapData.FILL_GRAB,
					TableWrapData.TOP, 1, 1);
			trData.maxWidth = 100;
			section2_3.setLayoutData(trData);
			section2_3.setText(Messages
					.getString("SelectTableDialog.CurrentRowNum")); //$NON-NLS-1$
			final Label numOfRow = toolkit.createLabel(section2_3, "   ");
			section2_3.setClient(numOfRow);

			if (fIDBTable.isTable() || fIDBTable.isView()) {
				if (connectionProperties.isConnected()) {
					TransactionRequest tr_count = new TransactionRequest(
							SQLOperationType.COUNT, connectionProperties,
							fIDBTable);
					tr_count.addListener(new RequestAdaptor() {
						@Override
						public void called_done(Request request,
								SQLOperationType operation,
								ConnectionProperties properteis, final Object o) {
							fLogger.debug("request count done...[" + o + "]"); //$NON-NLS-1$ //$NON-NLS-2$
							Display.getDefault().asyncExec(new Runnable() {
								@Override
								public void run() {
									if (!numOfRow.isDisposed()) {
										numOfRow.setText("" + o); //$NON-NLS-1$
									}
								}
							});
						}
					});
					SQLServerThread.putRequest(tr_count);
				} else {
					root.setMessage(
							Messages.getString("SelectTableDialog.NowDisconnected"), IMessageProvider.ERROR); //$NON-NLS-1$
				}
			} else {
				numOfRow.setText("-"); //$NON-NLS-1$
			}

			// ---------------------------------------
			Section section2_4 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section2_4.setText(Messages
					.getString("SelectTableDialog.MaxRowsInCell")); //$NON-NLS-1$
			TableWrapData trDataDR = new TableWrapData(TableWrapData.FILL_GRAB,
					TableWrapData.TOP, 1, 1);
			trDataB.maxWidth = 200;
			section2_4.setLayoutData(trDataDR);

			fMaxRowsInCell = new Spinner(section2_4, SWT.BORDER);
			section2_4.setClient(fMaxRowsInCell);
			fMaxRowsInCell.setToolTipText(Messages
					.getString("SelectTableDialog.MaxRowsInCellTooltips")); //$NON-NLS-1$
			fMaxRowsInCell.setMinimum(1);
			fMaxRowsInCell.setMaximum(10);
			fMaxRowsInCell.setSelection(1);
			fMaxRowsInCell
					.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			fMaxRowsInCell.addSelectionListener(this);
			// ---------------------------------------
			Section section23_1 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section23_1.setText(Messages
					.getString("SelectTableDialog.JavascriptLabel")); //$NON-NLS-1$
			section23_1.setLayoutData(new TableWrapData(TableWrapData.FILL,
					TableWrapData.TOP, 1, 2));

			fScriptSelection = new Combo(section23_1, SWT.READ_ONLY);
			section23_1.setClient(fScriptSelection);
			createScriptItems();
			fScriptSelection.add(
					Messages.getString("SelectTableDialog.NoUseJavascript"), 0); //$NON-NLS-1$
			fScriptSelection.select(0);

			fScriptSelection.addSelectionListener(this);

			// ---------------------------------------
			Section section23_2 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section23_2.setText(Messages
					.getString("SelectTableDialog.DisplayBarChart")); //$NON-NLS-1$
			section23_2.setLayoutData(new TableWrapData(TableWrapData.LEFT,
					TableWrapData.TOP, 1, 1));
			fBarBtn = toolkit
					.createButton(
							section23_2,
							Messages.getString("SelectTableDialog.BarChart"), SWT.CHECK); //$NON-NLS-1$
			fBarBtn.addSelectionListener(this);
			fBarBtn.setSelection(false);
			section23_2.setClient(fBarBtn);

			// ---------------------------------------
			Section section23_3 = toolkit.createSection(root.getBody(),
					Section.EXPANDED | Section.TITLE_BAR);
			section23_3.setText("Escape using quot");
			section23_3.setLayoutData(new TableWrapData(TableWrapData.LEFT,
					TableWrapData.TOP, 1, 1));
			braceEscapeButton = toolkit.createButton(section23_3, "括弧",
					SWT.CHECK);
			braceEscapeButton.addSelectionListener(this);
			braceEscapeButton.setSelection(true);
			section23_3.setClient(braceEscapeButton);

			// ---------------------------------------
			sqlSection = toolkit.createSection(root.getBody(), Section.TWISTIE
					| Section.TITLE_BAR | Section.EXPANDED);
			sqlSection.setLayout(new FillLayout());
			sqlSection.setText(Messages
					.getString("SelectTableDialog.SQLStatementLabel")); //$NON-NLS-1$
			sqlSection.addMouseTrackListener(new MouseTrackListener() {
				@Override
				public void mouseHover(MouseEvent arg0) {
				}

				@Override
				public void mouseExit(MouseEvent arg0) {
				}

				@Override
				public void mouseEnter(MouseEvent arg0) {
					if (cellEditor != null && isCellEditorActivating) {
						for (CellEditor cell : cellEditor) {
							if (cell != null) {
								cell.deactivate();
							}
						}
					}
				}
			});
			if (isMongo()) {
				sqlSection
						.setText(Messages
								.getString("SelectTableDialog.MongoQueryLanguageStatement")); //$NON-NLS-1$
			}
			TableWrapData twd = new TableWrapData(TableWrapData.FILL,
					TableWrapData.FILL, 1, 4);
			twd.heightHint = 90 + (table.getItemCount() / 4 + 1) * 5;
			sqlSection.setLayoutData(twd);

			sqlText = toolkit.createText(sqlSection, "sel", SWT.MULTI //$NON-NLS-1$
					| SWT.V_SCROLL | SWT.H_SCROLL);
			sqlSection.setClient(sqlText);

			refreshStatement();

			root.computeSize(660, 620, true);

			return root;
		} catch (RuntimeException e) {
			e.printStackTrace();
		}

		return parent;
	}

	// @Override
	// protected Point getInitialSize() {
	// return new Point(680, 640);
	// }

	protected void createScriptItems() {
	}

	public boolean isMongo() {
		if (connectionProperties == null) {
			return false;
		}
		return connectionProperties.getDatabaseType().isMongo();
	}

	public boolean isDomino() {
		if (connectionProperties == null) {
			return false;
		}
		return connectionProperties.getDatabaseType().isDomino();
	}

	public boolean isTwitter() {
		if (connectionProperties == null) {
			return false;
		}
		return connectionProperties.getDatabaseType().isTwitter();
	}

	// ------------------------------------------------------------
	// CLASS
	// ------------------------------------------------------------

	public String getSqlStatementString() {
		return StringUtil.nvl(sqlStatementString);
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		if (e.getSource() == fLogicalBtn) {
			maxColumnNameSizeLabel
					.setForeground(fLogicalBtn.getSelection() ? ColorUtil
							.getColor(ColorNameEnum.BLACK) : ColorUtil
							.getColor(ColorNameEnum.GRAY));
			encodingCharSetLabel
					.setForeground(fLogicalBtn.getSelection() ? ColorUtil
							.getColor(ColorNameEnum.BLACK) : ColorUtil
							.getColor(ColorNameEnum.GRAY));
			fMaxColumnNameLength.setEnabled(fLogicalBtn.getSelection());
			fCharsetSelection.setEnabled(fLogicalBtn.getSelection());
			if (fLogicalBtn.getSelection()) {
				btUpd.setEnabled(false);
			} else {
				btUpd.setEnabled(true);
				if (fIDBTable.hasPk()) {
					setMessage(StringUtil.EMPTY_STRING);
				} else {
					setMessage(
							Messages.getString("SelectTableDialog.MustHavePrimaryKet"),
							MessageDialog.WARNING);
				}
			}
		}
		refreshStatement();
	}
}