package hiro.yoshioka.sql.util;

import hiro.yoshioka.util.StringUtil;

import java.text.SimpleDateFormat;
import java.util.Date;

public class SQLHistoryData {
	static SimpleDateFormat fFormatter = new SimpleDateFormat(
			"yyyy/MM/dd HH:mm:ss.SSS");

	public static SQLHistoryData EMPTY_DATA = new SQLHistoryData(
			StringUtil.EMPTY_STRING, StringUtil.EMPTY_STRING,
			StringUtil.EMPTY_STRING, StringUtil.EMPTY_STRING);

	public static String[] SDH_KEY = { "TIME", "DRIVER", "STATEMENT", "TABLE",
			"BIND", "CALLS" };

	String fSQLStatement = StringUtil.EMPTY_STRING;

	String displayString = StringUtil.EMPTY_STRING;

	String fBindData = StringUtil.EMPTY_STRING;

	String fTimeStamp = StringUtil.EMPTY_STRING;

	int calls = 1;

	long returnedRows;

	boolean updatable;

	public boolean isUpdatable() {
		return updatable;
	}

	public void setUpdatable(boolean updatable) {
		this.updatable = updatable;
	}

	/**
	 * 
	 */
	String fTableName;

	public SQLHistoryData() {

	}

	public SQLHistoryData(String displayString, String statement,
			String string, String tableNameE) {
		this.displayString = displayString;
		fSQLStatement = statement;
		fBindData = string;
		fTableName = tableNameE;
		resetDate();
	}

	public long getReturnedRows() {
		return returnedRows;
	}

	public void setReturnedRows(long returnedRows) {
		this.returnedRows = returnedRows;
	}

	public String getBindData() {
		return fBindData;
	}

	public void setBindData(String bindData) {
		fBindData = bindData;
	}

	public String getDisplayString() {
		return displayString;
	}

	public void setDisplayString(String displayString) {
		this.displayString = displayString;
	}

	public String getSQLStatement() {
		return fSQLStatement;
	}

	public void setSQLStatement(String statement) {
		fSQLStatement = statement;
	}

	public String getTimeStamp() {
		return fTimeStamp;
	}

	public void setTimeStamp(String timeStamp) {
		fTimeStamp = timeStamp;
	}

	public void resetDate() {
		fTimeStamp = fFormatter.format(new Date());
	}

	public String getDay() {
		if (fTimeStamp == null || fTimeStamp.length() < 10) {
			return StringUtil.EMPTY_STRING;
		}
		return fTimeStamp.substring(0, 10);
	}

	public String getDayWa() {
		if (fTimeStamp == null || fTimeStamp.length() < 10) {
			return StringUtil.EMPTY_STRING;
		}
		return fTimeStamp.substring(5, 7) + "MM" + fTimeStamp.substring(8, 10)
				+ "DD";
	}

	public String getTime() {
		if (fTimeStamp == null || fTimeStamp.length() < 19) {
			return StringUtil.EMPTY_STRING;
		}
		return fTimeStamp.substring(11, 19);
	}

	public String getTableName() {
		return StringUtil.nvl(fTableName);
	}

	public void setTableName(String tableName) {
		fTableName = tableName;
	}

	public int getCalls() {
		return calls;
	}

	public void setCalls(int calls) {
		this.calls = calls;
	}

	public void countUp() {
		this.calls++;
	}

}
