package hiro.yoshioka.sql.resource.xml;

import hiro.yoshioka.sql.resource.DBCrossRefference;
import hiro.yoshioka.sql.resource.IDBColumn;
import hiro.yoshioka.sql.resource.IDBTable;

import java.util.ArrayList;
import java.util.List;

public class DBTableValue extends DBResouceValue {
	boolean type_function;

	boolean type_procedure;

	boolean type_table;

	boolean type_view;

	boolean type_system;

	boolean hasPk;

	DBCrossRefferenceValue[] crossRefferenceValue;

	public DBCrossRefferenceValue[] getCrossRefferenceValue() {
		return crossRefferenceValue;
	}

	public void setCrossRefferenceValue(DBCrossRefferenceValue[] cross) {
		this.crossRefferenceValue = cross;
	}

	public DBTableValue() {
	}

	public DBTableValue(IDBTable table) {
		super(table);
		parent = new DBSchemaValue(table.getParent());
		IDBColumn[] list = table.getColumns();
		for (int i = 0; i < list.length; i++) {
			children.put(list[i].getName(), new DBColumnValue(this, list[i]));
		}
		setType_function(table.isFunction());
		setType_procedure(table.isProcudeure());
		setType_table(table.isTable());
		setType_view(table.isView());
		setType_system(table.isSystem());
		setHasPk(table.hasPk());
		DBCrossRefference[] cross = table.getCrossReferences();
		DBCrossRefferenceValue[] al = new DBCrossRefferenceValue[cross.length];
		for (int j = 0; j < al.length; j++) {
			al[j] = new DBCrossRefferenceValue(cross[j]);
		}
		setCrossRefferenceValue(al);
	}

	public boolean isType_function() {
		return type_function;
	}

	public DBColumnValue[] getColumns() {
		return getChildren().values().toArray(new DBColumnValue[0]);
	}

	public int[] getPkPositions() {
		DBColumnValue[] columns = getColumns();
		List<Integer> retList = new ArrayList<Integer>();
		for (int i = 0; i < columns.length; i++) {
			if (columns[i].isPkey()) {
				retList.add(new Integer(i));
			}
		}
		int[] retInt = new int[retList.size()];
		for (int i = 0; i < retInt.length; i++) {
			retInt[i] = retList.get(i);
		}
		return retInt;
	}

	public void setType_function(boolean type_function) {
		this.type_function = type_function;
	}

	public boolean isType_procedure() {
		return type_procedure;
	}

	public void setType_procedure(boolean type_procedure) {
		this.type_procedure = type_procedure;
	}

	public boolean isType_system() {
		return type_system;
	}

	public void setType_system(boolean type_system) {
		this.type_system = type_system;
	}

	public boolean isType_table() {
		return type_table;
	}

	public void setType_table(boolean type_table) {
		this.type_table = type_table;
	}

	public boolean isType_view() {
		return type_view;
	}

	public void setType_view(boolean type_view) {
		this.type_view = type_view;
	}

	public boolean isHasPk() {
		return hasPk;
	}

	public void setHasPk(boolean hasPk) {
		this.hasPk = hasPk;
	}

}
