package hiro.yoshioka.sql.resource.twitter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum TwitterTableType {
	/** AccountSettings */
	AccountSettings("AccountSettings"),
	// /**
	// * Returns the top ten topics that are currently trending on Twitter. The
	// * response includes the time of the request, the name of each trend, and
	// * the url to the Twitter Search results page for that topic.
	// */
	// Trends("Trends"),
	// /**
	// * Returns the current top 10 trending topics on Twitter. The response
	// * includes the time of the request, the name of each trending topic, and
	// * query used on Twitter Search results page for that topic.
	// */
	// CurrentTrends("CurrentTrends"),
	// /** Returns the top 20 trending topics for each hour in a given day. */
	// DailyTrends("DailyTrends"),
	// /** Returns the top 30 trending topics for each day in a given week. */
	// WeeklyTrends("WeeklyTrends"),
	// /**
	// * Returns the locations that Twitter has trending topic information for.
	// * The response is an array of "locations" that encode the location's
	// WOEID
	// * (a Yahoo! Where On Earth ID) and some other human-readable information
	// * such as a canonical name and country the location belongs in.
	// */
	AvailableTrends("AvailableTrends"),
	/**
	 * Returns the top 10 trending topics for a specific location Twitter has
	 * trending topic information for. The response is an array of "trend"
	 * objects that encode the name of the trending topic, the query parameter
	 * that can be used to search for the topic on Search, and the direct URL
	 * that can be issued against Search. This information is cached for five
	 * minutes, and therefore users are discouraged from querying these
	 * endpoints faster than once every five minutes. Global trends information
	 * is also available from this API by using a WOEID of 1.
	 */
	LocationTrends("LocationTrends"),
	/**  */
	HomeTimeline("HomeTimeline"),
	/**  */
	Mentions("Mentions"),
	/**  */
	RetweetedByUser("RetweetedByUser"),

	RetweetedToUser("RetweetedToUser"),
	/**
	 * Returns the 20 most recent tweets of the authenticated user that have
	 * been retweeted by others.
	 */
	RetweetsOfMe("RetweetsOfMe"),
	/**
	 * Returns the 20 most recent statuses posted from the authenticating user.
	 * It's also possible to request another user's timeline via the id
	 * parameter. This is the equivalent of the Web / page for your own user, or
	 * the profile page for a third party. For backwards compatibility reasons,
	 * retweets are stripped out of the user_timeline when calling in XML or
	 * JSON (they appear with 'RT' in RSS and Atom). If you'd like them
	 * included, you can merge them in from statuses retweeted_by_me.
	 */
	UserTimeline("UserTimeline"),
	/**
	 * Returns the 20 most recent direct messages sent to the authenticating
	 * user. The XML and JSON versions include detailed information about the
	 * sender and recipient user.
	 */
	DirectMessages("DirectMessages"),
	/**
	 * Returns the 20 most recent direct messages sent by the authenticating
	 * user. The XML and JSON versions include detailed information about the
	 * sender and recipient user.
	 */
	SentDirectMessages("SentDirectMessages"),
	/**
	 * Returns extended information of a given user, specified by ID or screen
	 * name as per the required id parameter. The author's most recent status
	 * will be returned inline.
	 */
	ShowUser("ShowUser"),
	/**
	 * Return up to 100 users worth of extended information, specified by either
	 * ID, screen name, or combination of the two. The author's most recent
	 * status (if the authenticating user has permission) will be returned
	 * inline.
	 */
	LookupUsers("LookupUsers"),
	/**
	 * Run a search for users similar to the Find People button on Twitter.com;
	 * the same results returned by people search on Twitter.com will be
	 * returned by using this API. Usage note: It is only possible to retrieve
	 * the first 1000 matches from this API.
	 */
	SearchUsers("SearchUsers"),
	/**
	 * Returns an array of numeric IDs for every user the specified user is
	 * followed by.
	 */
	FollowersIDs("FollowersIDs"),

	;

	public static final List<TwitterTableType> ACCOUNT_TABLES = new ArrayList<TwitterTableType>();
	// public static final List<TwitterTableType> TREND_TABLES = new
	// ArrayList<TwitterTableType>();
	public static final List<TwitterTableType> LOCAL_TREND_TABLES = new ArrayList<TwitterTableType>();
	public static final List<TwitterTableType> TIMELINE_TABLES = new ArrayList<TwitterTableType>();
	public static final List<TwitterTableType> DIRECT_MESSAGES_TABLES = new ArrayList<TwitterTableType>();
	public static final List<TwitterTableType> USER_TABLES = new ArrayList<TwitterTableType>();
	public static final List<TwitterTableType> FOLLOWERS_TABLES = new ArrayList<TwitterTableType>();

	public static final Map<TwitterSchemaType, List<TwitterTableType>> SCHEMA_MAPPINGS = new HashMap<TwitterSchemaType, List<TwitterTableType>>();
	static {
		ACCOUNT_TABLES.add(AccountSettings);

		// TREND_TABLES.add(Trends);
		// TREND_TABLES.add(CurrentTrends);
		// TREND_TABLES.add(DailyTrends);
		// TREND_TABLES.add(WeeklyTrends);
		LOCAL_TREND_TABLES.add(AvailableTrends);
		LOCAL_TREND_TABLES.add(LocationTrends);

		TIMELINE_TABLES.add(HomeTimeline);
		TIMELINE_TABLES.add(Mentions);
		TIMELINE_TABLES.add(RetweetedByUser);
		TIMELINE_TABLES.add(RetweetedToUser);
		TIMELINE_TABLES.add(RetweetsOfMe);
		TIMELINE_TABLES.add(UserTimeline);

		DIRECT_MESSAGES_TABLES.add(DirectMessages);
		DIRECT_MESSAGES_TABLES.add(SentDirectMessages);

		USER_TABLES.add(ShowUser);
		USER_TABLES.add(LookupUsers);
		USER_TABLES.add(SearchUsers);

		FOLLOWERS_TABLES.add(FollowersIDs);
		// --------------------------------------
		SCHEMA_MAPPINGS.put(TwitterSchemaType.Account, ACCOUNT_TABLES);
		// SCHEMA_MAPPINGS.put(TwitterSchemaType.Trends, TREND_TABLES);
		SCHEMA_MAPPINGS.put(TwitterSchemaType.LocalTrends, LOCAL_TREND_TABLES);
		SCHEMA_MAPPINGS.put(TwitterSchemaType.Timeline, TIMELINE_TABLES);
		SCHEMA_MAPPINGS.put(TwitterSchemaType.DirectMessage,
				DIRECT_MESSAGES_TABLES);
		SCHEMA_MAPPINGS.put(TwitterSchemaType.User, USER_TABLES);
		SCHEMA_MAPPINGS.put(TwitterSchemaType.Followers, FOLLOWERS_TABLES);
	}

	private String tableName;

	private TwitterTableType(String tableName) {
		this.tableName = tableName;
	}

	public String getTableName() {
		return tableName;
	}

	public static List<TwitterTableType> getTableTypeListOf(
			TwitterSchemaType schemaType) {
		return SCHEMA_MAPPINGS.get(schemaType);
	}
}
