package hiro.yoshioka.sql.resource.twitter;

public enum TwitterSchemaType {
	/**
	 * Account.
	 */
	Account("Account"),
	/**
	 * Timeline.
	 */
	Timeline("Timeline"),
	/**
	 * Local Trends.
	 */
	LocalTrends("Local Trends"),
	// We retired the endpoint.
	// https://dev.twitter.com/blog/changing-trends-api
	// Try getLocationTrends(woeid) instead.
	// http://twitter4j.org/en/javadoc/twitter4j/api/LocalTrendsMethods.html...)
	// Thanks,
	// Yusuke
	// /**
	// * Trends.
	// */
	// Trends("Trends"),
	/** DirectMessage */
	DirectMessage("DirectMessage"),
	/**
	 * User. <BR>
	 * http://twitter4j.org/en/javadoc/twitter4j/User.html
	 */
	User("User"),
	/**
	 * Followers. <BR>
	 * http://twitter4j.org/en/javadoc/twitter4j/api/FriendsFollowersMethods.
	 * html
	 */
	Followers("Followers");

	private String schemaName;

	private TwitterSchemaType(String schemaName) {
		this.schemaName = schemaName;
	}

	public String getSchemaName() {
		return schemaName;
	}

}
