package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.List;

public class WolfView extends AbsWolfDominoReflection {
	Method getName;
	Method getColumnCount;
	Method getFirstDocument;
	Method getNextDocument;
	Method getLastDocument;
	Method getReaders;

	public WolfView(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);
		// lotus.domino.ACLEntry
		getReaders = targetInstance.getClass().getMethod("getReaders");
		getName = targetInstance.getClass().getMethod("getName");
		getColumnCount = targetInstance.getClass().getMethod("getColumnCount");
		getFirstDocument = targetInstance.getClass().getMethod(
				"getFirstDocument");
		try {
			getNextDocument = targetInstance.getClass().getMethod(
					"getNextDocument",
					new WolfDocument(classManager, null).getDominoClass());
		} catch (NoSuchMethodException e) {
			for (Method m : targetInstance.getClass().getMethods()) {
				if (m.toString().indexOf(
						".getNextDocument(lotus.domino.Document)") >= 0) {
					getNextDocument = m;
					break;
				}
			}
		}
		getLastDocument = targetInstance.getClass()
				.getMethod("getLastDocument");

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.View";
	}

	public List<String> getReaders() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (List<String>) getReaders.invoke(targetInstance);

	}

	public WolfDocument getFirstDocument() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object o = getFirstDocument.invoke(targetInstance);
		if (o == null) {
			return null;
		}
		return new WolfDocument(classManager, o);
	}

	public WolfDocument getNextDocument(WolfDocument now)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException,
			SecurityException, ClassNotFoundException, NoSuchMethodException {
		Object o = getNextDocument.invoke(targetInstance,
				now.getTargetInstance());
		if (o == null) {
			return null;
		}
		return new WolfDocument(classManager, o);
	}

	public WolfDocument getLastDocument() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object o = getLastDocument.invoke(targetInstance);
		if (o == null) {
			return null;
		}
		return new WolfDocument(classManager, o);
	}

	public int getColumnCount() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (Integer) getColumnCount.invoke(targetInstance);
	}

	public String getName() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (String) getName.invoke(targetInstance);
	}

	@Override
	public String toString() {
		try {
			return String.format("WolfView %s numOfColumn[%d]", getName(),
					getColumnCount());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return "WolfView";
	}

}
