package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Vector;

public class WolfSession extends AbsWolfDominoReflection {
	Method getPlatform;
	Method getNotesVersion;
	Method getDbDirectory;
	Method getDatabase;
	Method createDxlExporter;
	Method getUserGroupNameList;

	public WolfSession(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);

		getNotesVersion = targetInstance.getClass()
				.getMethod("getNotesVersion");
		getPlatform = targetInstance.getClass().getMethod("getPlatform");
		getDbDirectory = targetInstance.getClass().getMethod("getDbDirectory",
				String.class);
		getDatabase = targetInstance.getClass().getMethod("getDatabase",
				String.class, String.class, boolean.class);
		createDxlExporter = targetInstance.getClass().getMethod(
				"createDxlExporter");
		getUserGroupNameList = targetInstance.getClass().getMethod(
				"getUserGroupNameList");

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.Session";
	}

	public String getNotesVersion() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (String) getNotesVersion.invoke(targetInstance);
	}

	public String getPlatform() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		return (String) getPlatform.invoke(targetInstance);
	}

	public Vector<Object> getUserGroupNameList()
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException,
			SecurityException, ClassNotFoundException, NoSuchMethodException {
		Object instance = getUserGroupNameList.invoke(targetInstance);
		if (instance == null) {
			return null;
		}
		return (Vector<Object>) instance;
	}

	public WolfDBDirectory getDbDirectory(String path)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException,
			SecurityException, ClassNotFoundException, NoSuchMethodException {
		Object instance = getDbDirectory.invoke(targetInstance, path);
		if (instance == null) {
			return null;
		}
		return new WolfDBDirectory(classManager, instance);
	}

	public WolfDatabase getDatabase(String server, String db,
			boolean createonfail) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object instance = getDatabase.invoke(targetInstance, server, db,
				createonfail);
		if (instance == null) {
			return null;
		}
		return new WolfDatabase(classManager, instance);
	}

	public WolfDxlExporter createDxlExporter() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object instance = createDxlExporter.invoke(targetInstance);
		if (instance == null) {
			return null;
		}
		return new WolfDxlExporter(classManager, instance);
	}

	@Override
	public String toString() {
		try {
			return String.format("WolfSession %s %s  ", getNotesVersion(),
					getPlatform());

		} catch (Exception e) {
			e.printStackTrace();
		}
		return "WolfSession";
	}
}
