package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public class WolfDxlExporter extends AbsWolfDominoReflection {
	Method setOutputDOCTYPE;
	Method exportDxl;
	Method setConvertNotesBitmapsToGIF;

	public WolfDxlExporter(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);

		setOutputDOCTYPE = targetInstance.getClass().getMethod(
				"setOutputDOCTYPE", boolean.class);
		setConvertNotesBitmapsToGIF = targetInstance.getClass().getMethod(
				"setConvertNotesBitmapsToGIF", boolean.class);
		Class noteCollection = classManager
				.getClassForName("lotus.domino.NoteCollection");
		exportDxl = targetInstance.getClass().getMethod("exportDxl",
				noteCollection);

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.DxlExporter";
	}

	public void setOutputDOCTYPE(boolean outputDocType)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException {
		setOutputDOCTYPE.invoke(targetInstance, outputDocType);

	}

	public void setConvertNotesBitmapsToGIF(boolean doGif)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException {
		setConvertNotesBitmapsToGIF.invoke(targetInstance, doGif);

	}

	public String exportDxl(WolfNoteCollection collection)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException {
		return (String) exportDxl.invoke(targetInstance,
				collection.getTargetInstance());
	}
}
