package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class WolfDocument extends AbsWolfDominoReflection {

	// Method hasItem;

	public WolfDocument(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);
	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.Document";
	}

	public boolean hasItem(String name) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			SecurityException, NoSuchMethodException {
		return (Boolean) targetInstance.getClass()
				.getMethod("hasItem", String.class)
				.invoke(targetInstance, name);
	}

	public Vector getItemValue(String name) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			SecurityException, NoSuchMethodException {

		return (Vector) targetInstance.getClass()
				.getMethod("getItemValue", String.class)
				.invoke(targetInstance, name);
	}

	public String getURL() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			SecurityException, NoSuchMethodException {
		return (String) targetInstance.getClass().getMethod("getURL")
				.invoke(targetInstance);
	}

	public String getHttpURL() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			SecurityException, NoSuchMethodException {
		return (String) targetInstance.getClass().getMethod("getHttpURL")
				.invoke(targetInstance);
	}

	public String getNotesURL() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			SecurityException, NoSuchMethodException {
		return (String) targetInstance.getClass().getMethod("getNotesURL")
				.invoke(targetInstance);
	}

	public WolfDocumentCollection getResponses()
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, SecurityException,
			NoSuchMethodException, MalformedURLException,
			ClassNotFoundException {
		Object instance = targetInstance.getClass().getMethod("getResponses")
				.invoke(targetInstance);
		if (instance == null) {
			return null;
		}
		return new WolfDocumentCollection(classManager, instance);
	}

	public Integer getSize() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			SecurityException, NoSuchMethodException {
		return (Integer) targetInstance.getClass().getMethod("getSize")
				.invoke(targetInstance);
	}

	public String getUniversalID() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			SecurityException, NoSuchMethodException {
		return (String) targetInstance.getClass().getMethod("getUniversalID")
				.invoke(targetInstance);
	}

	public String getItemValueString(String name)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, SecurityException, NoSuchMethodException {

		return (String) targetInstance.getClass()
				.getMethod("getItemValueString", String.class)
				.invoke(targetInstance, name);
	}

	public WolfItem getFirstItem(String name) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object instance = targetInstance.getClass()
				.getMethod("getFirstItem", String.class)
				.invoke(targetInstance, name);
		if (instance == null) {
			return null;
		}

		return new WolfItem(classManager, instance);
	}

	public List<WolfItem> getItems() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Vector o = (Vector) targetInstance.getClass().getMethod("getItems")
				.invoke(targetInstance);
		if (o == null) {
			return Collections.EMPTY_LIST;
		}
		List<WolfItem> retList = new ArrayList<WolfItem>();
		for (Object instance : o) {
			WolfItem item = new WolfItem(classManager, instance);
			retList.add(item);
		}
		return retList;
	}

	public WolfItem getItem(String key) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Vector o = (Vector) targetInstance.getClass().getMethod("getItems")
				.invoke(targetInstance);
		if (o == null) {
			return null;
		}
		for (Object instance : o) {
			WolfItem item = new WolfItem(classManager, instance);
			if (item.getName().equals(key)) {
				return item;
			}
			item.recycle();
		}
		return null;
	}

	public WolfItem appendItemValue(String key, int appendInteger)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, SecurityException,
			NoSuchMethodException, MalformedURLException,
			ClassNotFoundException {
		Object instance = targetInstance.getClass()
				.getMethod("appendItemValue", String.class, int.class)
				.invoke(targetInstance, key, appendInteger);
		if (instance == null) {
			return null;
		}

		return new WolfItem(classManager, instance);
	}

	public WolfItem appendItemValue(String key, double appendDouble)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, SecurityException,
			NoSuchMethodException, MalformedURLException,
			ClassNotFoundException {
		Object instance = targetInstance.getClass()
				.getMethod("appendItemValue", String.class, double.class)
				.invoke(targetInstance, key, appendDouble);
		if (instance == null) {
			return null;
		}

		return new WolfItem(classManager, instance);
	}

	public WolfItem appendItemValue(String key, Object appendInstance)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, SecurityException,
			NoSuchMethodException, MalformedURLException,
			ClassNotFoundException {
		Object instance = targetInstance.getClass()
				.getMethod("appendItemValue", String.class, Object.class)
				.invoke(targetInstance, key, appendInstance);
		if (instance == null) {
			return null;
		}

		return new WolfItem(classManager, instance);
	}

	public void replaceItemValue(String key, Object replaceObject)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, SecurityException, NoSuchMethodException {
		targetInstance.getClass()
				.getMethod("replaceItemValue", String.class, Object.class)
				.invoke(targetInstance, key, replaceObject);
	}

	public boolean save() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			SecurityException, NoSuchMethodException {
		return (Boolean) targetInstance.getClass().getMethod("save")
				.invoke(targetInstance);
	}

	public boolean save(boolean force) throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			SecurityException, NoSuchMethodException {
		return (Boolean) targetInstance.getClass()
				.getMethod("save", boolean.class).invoke(targetInstance, force);
	}

	@Override
	public String toString() {
		StringBuilder buf = new StringBuilder();
		try {
			buf.append(String.format("WolfDocument%n"));
			// ここでItemを取ってrecycleすると他で呼べなくなる
			// for (WolfItem item : getItems()) {
			// buf.append("  " + item);
			// item.recycle();
			// }
		} catch (Exception e) {
			e.printStackTrace();
		}
		return buf.toString();
	}
}
