package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public class WolfDBDirectory extends AbsWolfDominoReflection {
	public static final int dbDirectory_database_type = 1247;
	Method getFirstDatabase;
	Method getNextDatabase;

	public WolfDBDirectory(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);

		getFirstDatabase = targetInstance.getClass().getMethod(
				"getFirstDatabase", int.class);
		getNextDatabase = targetInstance.getClass()
				.getMethod("getNextDatabase");

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.DbDirectory";
	}

	public WolfDatabase getFirstDatabase(int database_type)
			throws IllegalArgumentException, IllegalAccessException,
			InvocationTargetException, MalformedURLException,
			SecurityException, ClassNotFoundException, NoSuchMethodException {

		Object instance = getFirstDatabase
				.invoke(targetInstance, database_type);
		if (instance == null) {
			return null;
		}
		return new WolfDatabase(classManager, instance);
	}

	public WolfDatabase getNextDatabase() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException,
			MalformedURLException, SecurityException, ClassNotFoundException,
			NoSuchMethodException {
		Object instance = getNextDatabase.invoke(targetInstance);
		if (instance == null) {
			return null;
		}
		return new WolfDatabase(classManager, instance);
	}
}
