package hiro.yoshioka.sql.notes;

import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.notes.reflect.WolfDatabase;
import hiro.yoshioka.sql.notes.reflect.WolfDocumentCollection;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBTable;
import hiro.yoshioka.sql.resource.notes.NotesDBTable;

import java.util.concurrent.Callable;

public class NotesRunnerCount extends AbsNotesRunner implements
		Callable<Integer> {
	NotesDBTable table;
	ConnectionProperties properties;
	ResultSetDataHolder2 rdh2;

	public NotesRunnerCount(ClassManager manager,
			ConnectionProperties properties, IDBTable table) {
		super(manager, properties);
		this.table = (NotesDBTable) table;
		this.properties = properties;
	}

	@Override
	public Integer call() throws Exception {
		initClass();
		createSession();
		Integer ret = null;
		try {
			WolfDatabase database = getDatabaseByTable(table);

			if (!database.isOpen()) {
				database.open();
			}
			try {
				String query = null;
				if (table.hasAlias()) {
					query = String.format("Form=\"%s\"", table.getAlias());
				} else {
					query = String.format("Form=\"%s\"", table.getName());
				}
				System.out.println("query=" + query);
				WolfDocumentCollection docs = database.search(query);

				ret = docs.getCount();
				docs.recycle();
			} catch (Exception ne) {
				ne.printStackTrace();
				System.out.println(ne.getLocalizedMessage());
			} finally {
			}

		} finally {
			wolf_session.recycle();
		}
		return ret;
	}

}
