package hiro.yoshioka.sql.notes;

import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sql.notes.ddl.ACL;
import hiro.yoshioka.sql.notes.reflect.WolfACL;
import hiro.yoshioka.sql.notes.reflect.WolfDatabase;
import hiro.yoshioka.sql.params.ConnectionProperties;
import hiro.yoshioka.sql.resource.IDBSchema;

import java.util.concurrent.Callable;

public class NotesRunnerAcl extends AbsNotesRunner implements Callable<ACL> {
	IDBSchema schema;

	public NotesRunnerAcl(ClassManager manager,
			ConnectionProperties properties, IDBSchema schema) {
		super(manager, properties);
		this.schema = schema;
	}

	@Override
	public ACL call() throws Exception {
		initClass();
		createSession();
		ACL ret = null;
		try {
			WolfDatabase database = getDatabaseBySchema(schema);

			if (!database.isOpen()) {
				database.open();
			}
			try {
				WolfACL wolf_acl = database.getACL();
				ret = new ACL();
				ret.setHtml((wolf_acl.toHtmlString()));
				wolf_acl.recycle();
			} catch (Exception ne) {
				ne.printStackTrace();
				System.out.println(ne.getLocalizedMessage());
			} finally {
			}

		} finally {
			wolf_session.recycle();
		}
		return ret;
	}

}
