package hiro.yoshioka.ast.sql.oracle.util;

import hiro.yoshioka.ast.sql.ISchemaTableColumn;
import hiro.yoshioka.ast.sql.RowColumn;
import hiro.yoshioka.ast.sql.oracle.ASTFrom;
import hiro.yoshioka.ast.sql.oracle.ASTIDDot;
import hiro.yoshioka.ast.sql.oracle.ASTIdentifier;
import hiro.yoshioka.ast.sql.oracle.ASTQueryTableExpressionClause;
import hiro.yoshioka.ast.sql.oracle.ASTSchemaTableColumn;
import hiro.yoshioka.ast.sql.oracle.ASTSelectColumnsElement;
import hiro.yoshioka.ast.sql.oracle.SimpleNode;
import hiro.yoshioka.ast.sql.oracle.WolfSQLParserTreeConstants;
import hiro.yoshioka.ast.sql.util.ASTAssist;

public class BetweenSQLNodeVisitor extends DefaultSQLNodeVisitor {
	public int fPointElementType;

	public ASTAssist fLastAssist;

	public ASTSchemaTableColumn fASTSchemaTableColumn;

	public ASTQueryTableExpressionClause fASTQueryTableExpressionClause;

	public Object doJob(SimpleNode node, Object data) {
		if (node.contain((RowColumn) data)) {
			v.add(node);
			if (fLastAssist != null
					&& node.getID() == WolfSQLParserTreeConstants.JJTSCHEMATABLECOLUMN) {
				fLastAssist.fASTSchemaTableColumn = (ISchemaTableColumn) node;
			}
		}
		SimpleNode n;
		for (int ord = 0; ord < node.jjtGetNumChildren(); ord++) {
			n = (SimpleNode) node.jjtGetChild(ord);
			// if (node.getID() == WolfSQLParserTreeConstants.JJTFUNCTION
			// && n.getID() == WolfSQLParserTreeConstants.JJTEXPRESSION) {
			// fFunctionCallExpression = true;
			// }
			n.jjtAccept(this, data);
		}
		return v;
	}

	public Object visit(ASTFrom node, Object data) {
		fPointElementType = WolfSQLParserTreeConstants.JJTFROM;
		return doJob(node, data);
	}

	public Object visit(ASTSelectColumnsElement node, Object data) {
		fPointElementType = WolfSQLParserTreeConstants.JJTSELECTCOLUMNSELEMENT;
		return doJob(node, data);
	}

	// public Object visit(ASTExpr node, Object data) {
	// ASTEditorTableColumn ret = (ASTEditorTableColumn) doJob(node, data);
	// if(ret == null || node.jjtGetNumChildren()>1){
	// ret = new ASTEditorTableColumn();
	// ret.fExpr = node;
	// }
	// return doJob(node,data);
	// }
	public Object visit(ASTSchemaTableColumn node, Object data) {
		if (node.contain((RowColumn) data)) {
			fASTSchemaTableColumn = node;
		}
		return doJob(node, data);
	}

	public Object visit(ASTIDDot node, Object data) {
		return doJob(node, data);
	}

	public Object visit(ASTIdentifier node, Object data) {
		return doJob(node, data);
	}

	public Object visit(ASTQueryTableExpressionClause node, Object data) {
		if (node.contain((RowColumn) data)) {
			int num = node.jjtGetNumChildren();
			if (num > 1) {
				if (node.getChild(num - 1).getID() == WolfSQLParserTreeConstants.JJTIDENTIFIER
						&& node.getChild(num - 2).getID() == WolfSQLParserTreeConstants.JJTIDENTIFIER
						&& node.getChild(num - 1).contain((RowColumn) data)) {
					return doJob(node, data);
				}
			}
			if (log.isTraceEnabled()) {
				log.trace("fpASTQueryTableExpressionClause =" + node);
			}
		}
		return doJob(node, data);
	}

}
