package hiro.yoshioka.ast.sql.oracle;

import hiro.yoshioka.ast.sql.AbsSQLParser;
import hiro.yoshioka.ast.sql.AbsSimpleNode;
import hiro.yoshioka.ast.sql.ISubQuery;
import hiro.yoshioka.sql.resource.TmpSelectionDBTable;

public class ASTDefaultSubquery extends ASTDefaultDML implements ISubQuery {
	TmpSelectionDBTable shadowTable = new TmpSelectionDBTable();

	public ASTDefaultSubquery(int id) {
		super(id);
	}

	public ASTDefaultSubquery(AbsSQLParser p, int id) {
		super(p, id);
	}

	public boolean updatableStatement() {
		AbsSimpleNode[] children = getChildren();
		for (int i = 0; i < children.length; i++) {
			if (i == 0) {
				if (children[i].getFirstToken().getImage().equals("*")) {
					if (log.isInfoEnabled()) {
						log.info("SELECT * FROMでのUPDATEは不可");
					}
					return false;
				}
			}
			if (children[i].getFirstToken().getImage().equalsIgnoreCase("FROM")) {
				if (children[i].getChildren().length > 1) {
					if (log.isInfoEnabled()) {
						log.info("FROMに複数のテーブルを指定してのUPDATEは不可");
					}
					return false;
				}
			}
			if (children[i].getFirstToken().getImage()
					.equalsIgnoreCase("ORDER")) {
				if (log.isInfoEnabled()) {
					log.info("ORDER BY句を指定してのUPDATEは不可");
				}
				return false;
			}
			if (children[i].getFirstToken().getImage()
					.equalsIgnoreCase("GROUP")) {
				if (log.isInfoEnabled()) {
					log.info("GROUP BY句を指定してのUPDATEは不可");
				}
				return false;
			}
		}
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see hiro.yoshioka.ast.sql.mysql.ISubQuery#getTmpSelectionDBTable()
	 */
	public TmpSelectionDBTable getTmpSelectionDBTable() {
		return shadowTable;
	}

	public boolean beginTransaction() {
		return false;
	}

	public String infomatin() {
		StringBuffer buf = new StringBuffer();
		buf.append(getTmpSelectionDBTable().toString());
		return buf.toString();
	}
}
