/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.lib.explorer.model;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.core.IResourceChangeListener;

public class LibDirectoryNodeModel {
    FileFilter filter = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.isFile() && (pathname.getPath().toLowerCase().endsWith(".rptlibrary") || pathname.getPath().toLowerCase().endsWith(".css"));
        }
    };
    List childrenList = new ArrayList();
    private String directoryPath;
    private String text;
    private IResourceChangeListener resourceListener;

    public LibDirectoryNodeModel(String path) {
        this.directoryPath = path;
        this.text = new File(path).getName();
    }

    public Object[] getChildren() {
        if (this.childrenList.size() > 0) {
            return this.childrenList.toArray();
        }
        File file = new File(this.directoryPath);
        if (!file.exists()) {
            return new Object[]{Messages.getString((String)"LibraryExplorerProvider.FolderNotExist")};
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles(this.filter);
            int i = 0;
            while (i < children.length) {
                if (children[i].isDirectory()) {
                    this.childrenList.add(new LibDirectoryNodeModel(children[i].getAbsolutePath()));
                } else {
                    try {
                        LibraryHandle library = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(children[i].getAbsolutePath());
                        if (this.resourceListener != null) {
                            library.addResourceChangeListener(this.resourceListener);
                        }
                        this.childrenList.add(library);
                    }
                    catch (DesignFileException designFileException) {}
                }
                ++i;
            }
            return this.childrenList.toArray();
        }
        return null;
    }

    public void dispose() {
        for (Object obj : this.childrenList) {
            if (obj instanceof LibDirectoryNodeModel) {
                ((LibDirectoryNodeModel)obj).dispose();
            }
            if (!(obj instanceof LibraryHandle)) continue;
            if (this.resourceListener != null) {
                ((LibraryHandle)obj).removeResourceChangeListener(this.resourceListener);
            }
            ((LibraryHandle)obj).close();
        }
    }

    public void setResourceListener(IResourceChangeListener listener) {
        this.resourceListener = listener;
    }

    public String getText() {
        return this.text;
    }
}

