/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.render;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.withaxes.AxisSubUnit;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints3D;
import org.eclipse.birt.chart.computation.withaxes.StackGroup;
import org.eclipse.birt.chart.computation.withaxes.StackedSeriesLookup;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.engine.extension.i18n.Messages;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.Polygon3DRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.DeferredCache;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.util.EList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Bar
extends AxesRenderer {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    private static final int MIN_HEIGHT = 10;
    DeferredCache subDeferredCache = null;

    protected double[] computeStackPosition(AxisSubUnit au, double dValue, Axis ax) {
        if (ax.isPercent()) {
            dValue = au.valuePercentage(dValue);
        }
        double dStart = au.getStackedValue(dValue);
        double dEnd = au.stackValue(dValue);
        return new double[]{dStart, dEnd};
    }

    public final void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        ColorDefinition cd;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)vex);
        }
        boolean bRendering3D = this.isDimension3D();
        if (bRendering3D && this.subDeferredCache == null) {
            this.dc = this.subDeferredCache = this.dc.deriveNewDeferredCache();
        }
        boolean hasAddedComparsionPolygon = false;
        SeriesRenderingHints srh = null;
        SeriesRenderingHints3D srh3d = null;
        if (bRendering3D) {
            srh3d = (SeriesRenderingHints3D)isrh;
        } else {
            srh = (SeriesRenderingHints)isrh;
        }
        ChartWithAxes cwa = (ChartWithAxes)this.getModel();
        Bounds boClientArea = isrh.getClientAreaBounds(true);
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        logger.log(1, Messages.getString("info.render.series", new Object[]{((Object)((Object)this)).getClass().getName(), this.iSeriesIndex + 1, this.iSeriesCount}, this.getRunTimeContext().getULocale()));
        BarSeries bs = (BarSeries)this.getSeries();
        if (!bs.isVisible()) {
            this.restoreClipping(ipr);
            return;
        }
        RiserType rt = bs.getRiser();
        double dSeriesThickness = bRendering3D ? 0.0 : srh.getSeriesThickness();
        double dZeroLocation = bRendering3D ? srh3d.getPlotZeroLocation() : srh.getZeroLocation();
        double dBaseLocation = -1.0;
        DataPointHints[] dpha = isrh.getDataPoints();
        this.validateNullDatapoint(dpha);
        double sizeForNonCategory = -1.0;
        if (!bRendering3D && !((SeriesRenderingHints)isrh).isCategoryScale() && dpha.length != 0) {
            sizeForNonCategory = this.computeSizeForNonCategoryBar(cwa.isTransposed(), dpha);
        }
        LineAttributes lia = goFactory.createLineAttributes((cd = bs.getRiserOutline()) == null ? null : goFactory.copyOf(cd), LineStyle.SOLID_LITERAL, 1);
        double dX = 0.0;
        double dY = 0.0;
        double dZ = 0.0;
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dSpacing = 0.0;
        double dValue = 0.0;
        double dWidthZ = 0.0;
        double dSpacingZ = 0.0;
        Location[] loaFrontFace = null;
        List<Location3D[]> loa3dFace = null;
        boolean bInverted = false;
        double dUnitSpacing = !cwa.isSetUnitSpacing() ? 50.0 : cwa.getUnitSpacing();
        Bounds clipArea = goFactory.copyOf(boClientArea);
        if (cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
            boClientArea.delta(-dSeriesThickness, dSeriesThickness, 0.0, 0.0);
            clipArea.delta(-dSeriesThickness, 0.0, 2.0 * dSeriesThickness, dSeriesThickness);
        }
        this.renderClipping(ipr, clipArea);
        AxisSubUnit au = null;
        Axis ax = this.getAxis();
        StackedSeriesLookup ssl = null;
        StackGroup sg = null;
        if (!bRendering3D) {
            ssl = srh.getStackedSeriesLookup();
            sg = ssl.getStackGroup((Series)bs);
        }
        int iSharedUnitIndex = sg == null ? 0 : sg.getSharedIndex();
        int iSharedUnitCount = sg == null ? 1 : sg.getSharedCount();
        Label laDataPoint = null;
        try {
            laDataPoint = bRendering3D ? srh3d.getLabelAttributes((Series)bs) : srh.getLabelAttributes((Series)bs);
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
        }
        SeriesDefinition sd = this.getSeriesDefinition();
        EList elPalette = sd.getSeriesPalette().getEntries();
        if (elPalette.isEmpty()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.empty.palette", new Object[]{bs}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        boolean bPaletteByCategory = cwa.getLegend().getItemType().getValue() == 1;
        int iThisSeriesIndex = -1;
        if (!bPaletteByCategory && (iThisSeriesIndex = sd.getRunTimeSeries().indexOf(bs)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{bs, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        double[] faX = new double[dpha.length];
        double[] faY = new double[dpha.length];
        boolean bShowOutside = this.isShowOutside();
        int i = 0;
        while (i < dpha.length) {
            block144: {
                block161: {
                    Bounds boDataPoint;
                    Location loDataPoint;
                    Position pDataPoint;
                    block162: {
                        block163: {
                            block164: {
                                EList elTriggers;
                                Bounds compareBounds;
                                Fill fixedFill;
                                block160: {
                                    block150: {
                                        block156: {
                                            block159: {
                                                block158: {
                                                    block157: {
                                                        block151: {
                                                            double plotBaseLocation;
                                                            block155: {
                                                                block154: {
                                                                    block152: {
                                                                        block153: {
                                                                            double dEnd;
                                                                            double dStart;
                                                                            BarAxisIdLookup basLookup;
                                                                            block145: {
                                                                                block149: {
                                                                                    block148: {
                                                                                        block147: {
                                                                                            block146: {
                                                                                                block143: {
                                                                                                    faX[i] = Double.NaN;
                                                                                                    faY[i] = Double.NaN;
                                                                                                    int iOutside = this.checkEntryByType(this.getInternalBaseAxis().getScale(), dpha[i].getBaseValue());
                                                                                                    if (iOutside == 0) break block143;
                                                                                                    dpha[i].markOutside();
                                                                                                    break block144;
                                                                                                }
                                                                                                laDataPoint = bRendering3D ? srh3d.getLabelAttributes((Series)bs) : srh.getLabelAttributes((Series)bs);
                                                                                                Fill f = null;
                                                                                                if (bPaletteByCategory) {
                                                                                                    f = FillUtil.getPaletteFill((EList)elPalette, (int)i);
                                                                                                } else if (iThisSeriesIndex >= 0) {
                                                                                                    f = FillUtil.getPaletteFill((EList)elPalette, (int)iThisSeriesIndex);
                                                                                                }
                                                                                                this.updateTranslucency(f, (Series)bs);
                                                                                                fixedFill = dpha[i] != null && dpha[i].getOrthogonalValue() instanceof Double ? FillUtil.convertFill((Fill)f, (double)((Double)dpha[i].getOrthogonalValue()), null) : FillUtil.copyOf((Fill)f);
                                                                                                if (bRendering3D) {
                                                                                                    Location3D lo3d = dpha[i].getLocation3D();
                                                                                                    dX = lo3d.getX();
                                                                                                    dY = lo3d.getY();
                                                                                                    dZ = lo3d.getZ();
                                                                                                    dSpacing = dpha[i].getSize2D().getWidth() * dUnitSpacing / 200.0;
                                                                                                    dSpacingZ = dpha[i].getSize2D().getHeight() * dUnitSpacing / 200.0;
                                                                                                } else {
                                                                                                    Location lo = dpha[i].getLocation();
                                                                                                    dX = lo.getX();
                                                                                                    dY = lo.getY();
                                                                                                    dSpacing = dpha[i].getSize() * dUnitSpacing / 200.0;
                                                                                                }
                                                                                                if (!cwa.isTransposed()) break block145;
                                                                                                basLookup = new BarAxisIdLookup((ChartWithAxes)this.cm, this.getAxis());
                                                                                                if (((SeriesRenderingHints)isrh).isCategoryScale()) {
                                                                                                    dHeight = dpha[i].getSize();
                                                                                                    dHeight -= 2.0 * dSpacing;
                                                                                                    dY += (dHeight /= (double)basLookup.getCount()) * (double)basLookup.getId();
                                                                                                    dY += (double)iSharedUnitIndex * (dHeight /= (double)iSharedUnitCount) + dSpacing;
                                                                                                } else {
                                                                                                    dHeight = Math.min(sizeForNonCategory, (dpha[i].getSize() - 2.0 * dSpacing) * 0.8);
                                                                                                    dSpacing = (dpha[i].getSize() - dHeight) / 2.0;
                                                                                                    dY -= dpha[i].getSize() * 0.5;
                                                                                                    dY += (dHeight /= (double)basLookup.getCount()) * (double)basLookup.getId();
                                                                                                    dY += (double)iSharedUnitIndex * (dHeight /= (double)iSharedUnitCount) + dSpacing;
                                                                                                }
                                                                                                if (this.isStackedOrPercent(bs)) {
                                                                                                    au = ssl.getUnit((Series)bs, i);
                                                                                                    dValue = Bar.isNaN((Object)dpha[i].getOrthogonalValue()) ? 0.0 : (Double)dpha[i].getOrthogonalValue();
                                                                                                    double[] values = this.computeStackPosition(au, dValue, ax);
                                                                                                    dStart = values[0];
                                                                                                    dEnd = values[1];
                                                                                                    try {
                                                                                                        double dMargin = srh.getLocationOnOrthogonal((Object)dEnd) - srh.getLocationOnOrthogonal((Object)dStart);
                                                                                                        double lastPosition = au.getLastPosition(dValue);
                                                                                                        dBaseLocation = Double.isNaN(lastPosition) ? srh.getLocationOnOrthogonal((Object)dStart) : au.getLastPosition(dValue);
                                                                                                        au.setLastPosition(dValue, dBaseLocation, dMargin);
                                                                                                        dX = au.getLastPosition(dValue);
                                                                                                    }
                                                                                                    catch (Exception ex) {
                                                                                                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                                                                                                    }
                                                                                                }
                                                                                                if (!ChartUtil.isStudyLayout((Chart)cwa)) {
                                                                                                    dBaseLocation = dZeroLocation;
                                                                                                } else {
                                                                                                    au = ssl.getUnit((Series)bs, i);
                                                                                                    dValue = Methods.asDouble((Object)dpha[i].getOrthogonalValue());
                                                                                                    try {
                                                                                                        double dMargin = srh.getLocationOnOrthogonal(dpha[i].getOrthogonalValue()) - srh.getLocationOnOrthogonal(srh.getOrthogonalScale().getMinimum());
                                                                                                        double lastPosition = au.getLastPosition(dValue);
                                                                                                        double precisionDelta = 1.0E-8;
                                                                                                        dBaseLocation = Double.isNaN(lastPosition) ? srh.getLocationOnOrthogonal(srh.getOrthogonalScale().getMinimum()) - precisionDelta : au.getLastPosition(dValue) - precisionDelta;
                                                                                                        au.setLastPosition(dValue, dBaseLocation, dMargin);
                                                                                                    }
                                                                                                    catch (Exception ex) {
                                                                                                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                                                                                                    }
                                                                                                    dX = au.getLastPosition(dValue);
                                                                                                }
                                                                                                if (!ChartUtil.mathLT((double)dX, (double)boClientArea.getLeft())) break block146;
                                                                                                if (ChartUtil.mathLT((double)dBaseLocation, (double)boClientArea.getLeft()) && !bShowOutside) break block144;
                                                                                                dX = boClientArea.getLeft();
                                                                                                break block147;
                                                                                            }
                                                                                            if (ChartUtil.mathLT((double)dBaseLocation, (double)boClientArea.getLeft())) {
                                                                                                dBaseLocation = boClientArea.getLeft();
                                                                                            }
                                                                                        }
                                                                                        if (!ChartUtil.mathGT((double)dX, (double)(boClientArea.getLeft() + boClientArea.getWidth()))) break block148;
                                                                                        if (ChartUtil.mathGT((double)dBaseLocation, (double)(boClientArea.getLeft() + boClientArea.getWidth()))) break block144;
                                                                                        dX = boClientArea.getLeft() + boClientArea.getWidth();
                                                                                        break block149;
                                                                                    }
                                                                                    if (ChartUtil.mathGT((double)dBaseLocation, (double)(boClientArea.getLeft() + boClientArea.getWidth()))) {
                                                                                        dBaseLocation = boClientArea.getLeft() + boClientArea.getWidth();
                                                                                    }
                                                                                }
                                                                                dWidth = dBaseLocation - dX;
                                                                                boolean bl = bInverted = dWidth < 0.0;
                                                                                if (bInverted) {
                                                                                    dX = dBaseLocation;
                                                                                    dWidth = -dWidth;
                                                                                }
                                                                                break block150;
                                                                            }
                                                                            if (bRendering3D) {
                                                                                dWidth = dpha[i].getSize2D().getWidth();
                                                                                dWidth -= 2.0 * dSpacing;
                                                                                dWidthZ = dpha[i].getSize2D().getHeight();
                                                                                dWidthZ -= 2.0 * dSpacingZ;
                                                                                dX += dSpacing;
                                                                                dZ += dSpacingZ;
                                                                            } else {
                                                                                basLookup = new BarAxisIdLookup((ChartWithAxes)this.cm, this.getAxis());
                                                                                if (((SeriesRenderingHints)isrh).isCategoryScale()) {
                                                                                    dWidth = dpha[i].getSize();
                                                                                    dWidth -= 2.0 * dSpacing;
                                                                                    dX += (dWidth /= (double)basLookup.getCount()) * (double)basLookup.getId();
                                                                                    dX += (double)iSharedUnitIndex * (dWidth /= (double)iSharedUnitCount) + dSpacing;
                                                                                } else {
                                                                                    dWidth = Math.min(sizeForNonCategory, (dpha[i].getSize() - 2.0 * dSpacing) * 0.8);
                                                                                    dSpacing = (dpha[i].getSize() - dWidth) / 2.0;
                                                                                    dX -= dpha[i].getSize() / 2.0;
                                                                                    dX += (dWidth /= (double)basLookup.getCount()) * (double)basLookup.getId();
                                                                                    dX += (double)iSharedUnitIndex * (dWidth /= (double)iSharedUnitCount) + dSpacing;
                                                                                }
                                                                            }
                                                                            if (this.isStackedOrPercent(bs)) {
                                                                                if (bRendering3D) {
                                                                                    throw new ChartException("org.eclipse.birt.chart.engine.extension", 15, "exception.no.stack.percent.3D.chart", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                                                                                }
                                                                                au = ssl.getUnit((Series)bs, i);
                                                                                dValue = Bar.isNaN((Object)dpha[i].getOrthogonalValue()) ? 0.0 : ((Number)dpha[i].getOrthogonalValue()).doubleValue();
                                                                                double[] values = this.computeStackPosition(au, dValue, ax);
                                                                                dStart = values[0];
                                                                                dEnd = values[1];
                                                                                try {
                                                                                    double dMargin = srh.getLocationOnOrthogonal((Object)dEnd) - srh.getLocationOnOrthogonal((Object)dStart);
                                                                                    double lastPosition = au.getLastPosition(dValue);
                                                                                    dBaseLocation = Double.isNaN(lastPosition) ? srh.getLocationOnOrthogonal((Object)dStart) : au.getLastPosition(dValue);
                                                                                    au.setLastPosition(dValue, dBaseLocation, dMargin);
                                                                                    dY = au.getLastPosition(dValue);
                                                                                }
                                                                                catch (Exception ex) {
                                                                                    throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                                                                                }
                                                                            }
                                                                            if (!ChartUtil.isStudyLayout((Chart)cwa)) {
                                                                                dBaseLocation = dZeroLocation;
                                                                            } else {
                                                                                au = ssl.getUnit((Series)bs, i);
                                                                                Object oValue = dpha[i].getOrthogonalValue();
                                                                                dValue = oValue == null ? 0.0 : Methods.asDouble((Object)oValue);
                                                                                try {
                                                                                    double dMargin = srh.getLocationOnOrthogonal(oValue == null ? Integer.valueOf(0) : oValue) - srh.getLocationOnOrthogonal(srh.getOrthogonalScale().getMinimum());
                                                                                    double lastPosition = au.getLastPosition(dValue);
                                                                                    dBaseLocation = Double.isNaN(lastPosition) ? srh.getLocationOnOrthogonal(srh.getOrthogonalScale().getMinimum()) : au.getLastPosition(dValue);
                                                                                    au.setLastPosition(dValue, dBaseLocation, dMargin);
                                                                                }
                                                                                catch (Exception ex) {
                                                                                    throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                                                                                }
                                                                                dY = au.getLastPosition(dValue);
                                                                            }
                                                                            if (!bRendering3D) break block151;
                                                                            plotBaseLocation = srh3d.getPlotBaseLocation();
                                                                            if (!(dY < plotBaseLocation)) break block152;
                                                                            if (!bShowOutside) break block153;
                                                                            dBaseLocation = plotBaseLocation;
                                                                            dY = plotBaseLocation;
                                                                            break block154;
                                                                        }
                                                                        if (dBaseLocation < plotBaseLocation) break block144;
                                                                        dY = plotBaseLocation;
                                                                        break block154;
                                                                    }
                                                                    if (dBaseLocation < plotBaseLocation) {
                                                                        dBaseLocation = plotBaseLocation;
                                                                    }
                                                                }
                                                                if (!(dY > plotBaseLocation + srh3d.getPlotHeight())) break block155;
                                                                if (dBaseLocation > plotBaseLocation + srh3d.getPlotHeight()) break block144;
                                                                dY = plotBaseLocation + srh3d.getPlotHeight();
                                                                break block156;
                                                            }
                                                            if (dBaseLocation > plotBaseLocation + srh3d.getPlotHeight()) {
                                                                dBaseLocation = plotBaseLocation + srh3d.getPlotHeight();
                                                            }
                                                            break block156;
                                                        }
                                                        if (!(dY < boClientArea.getTop())) break block157;
                                                        if (dBaseLocation < boClientArea.getTop()) break block144;
                                                        dY = boClientArea.getTop();
                                                        break block158;
                                                    }
                                                    if (dBaseLocation < boClientArea.getTop()) {
                                                        dBaseLocation = boClientArea.getTop();
                                                    }
                                                }
                                                if (!(dY > boClientArea.getTop() + boClientArea.getHeight())) break block159;
                                                if (dBaseLocation > boClientArea.getTop() + boClientArea.getHeight() && !bShowOutside) break block144;
                                                dY = boClientArea.getTop() + boClientArea.getHeight();
                                                break block156;
                                            }
                                            if (dBaseLocation > boClientArea.getTop() + boClientArea.getHeight()) {
                                                dBaseLocation = boClientArea.getTop() + boClientArea.getHeight();
                                            }
                                        }
                                        dHeight = dBaseLocation - dY;
                                        boolean bl = bRendering3D ? dHeight <= 0.0 : (bInverted = dHeight < 0.0);
                                        if (bInverted) {
                                            dY = dBaseLocation;
                                            dHeight = -dHeight;
                                        }
                                    }
                                    compareBounds = null;
                                    if (this.getModel().getDimension() == ChartDimension.TWO_DIMENSIONAL_LITERAL || this.getModel().getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
                                        compareBounds = BoundsImpl.create((double)dX, (double)dY, (double)dWidth, (double)dHeight);
                                    }
                                    if (rt.getValue() == 0) {
                                        if (bRendering3D) {
                                            loa3dFace = this.computeRiserRectangle3D(bInverted, dX, dY, dZ, dHeight, dWidth, dWidthZ);
                                        } else {
                                            loaFrontFace = this.computeRiserRectangle2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth);
                                        }
                                    } else if (rt.getValue() == 1) {
                                        if (bRendering3D) {
                                            loa3dFace = this.computeRiserTriangle3D(bInverted, dX, dY, dZ, dHeight, dWidth, dWidthZ);
                                        } else if (this.isStackedOrPercent(bs)) {
                                            StackedSizeHints slh = this.getCurrentStackedSizeHints(i);
                                            double[] size = null;
                                            size = this.isTransposed() ? Bar.computeStacked2DTopNBottomSize(slh, au, dValue, dHeight) : Bar.computeStacked2DTopNBottomSize(slh, au, dValue, dWidth);
                                            loaFrontFace = this.computeStackedRiserTriangle2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth, size[0], size[1], this.getCurrentStackedSizeHints(i));
                                        } else {
                                            loaFrontFace = this.computeRiserTriangle2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth);
                                        }
                                    } else if (rt.getValue() == 2) {
                                        if (bRendering3D) {
                                            loa3dFace = this.computeRiserTube3D(dX, dY, dZ, dHeight, dWidth, dWidthZ);
                                        } else {
                                            loaFrontFace = this.computeRiserTube2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth);
                                        }
                                    } else if (rt.getValue() == 3) {
                                        if (bRendering3D) {
                                            loa3dFace = this.computeRiserCone3D(bInverted, dX, dY, dZ, dHeight, dWidth, dWidthZ);
                                        } else if (this.isStackedOrPercent(bs)) {
                                            StackedSizeHints slh = this.getCurrentStackedSizeHints(i);
                                            double[] size = null;
                                            size = this.isTransposed() ? Bar.computeStacked2DTopNBottomSize(slh, au, dValue, dHeight) : Bar.computeStacked2DTopNBottomSize(slh, au, dValue, dWidth);
                                            loaFrontFace = this.computeStackedRiserCone2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth, size[0], size[1]);
                                        } else {
                                            loaFrontFace = this.computeRiserCone2D(bInverted, i, faX, faY, dX, dY, dHeight, dWidth);
                                        }
                                    } else {
                                        throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.unspecified.riser.type", new Object[]{rt.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                                    }
                                    if (!Bar.isNaN((Object)dpha[i].getOrthogonalValue())) break block160;
                                    faX[i] = Double.NaN;
                                    faY[i] = Double.NaN;
                                    break block144;
                                }
                                if (!bRendering3D) {
                                    int j = 0;
                                    while (j < loaFrontFace.length) {
                                        Location location = loaFrontFace[j];
                                        if (location.getX() < boClientArea.getLeft()) {
                                            location.setX(boClientArea.getLeft());
                                        } else if (location.getX() > boClientArea.getLeft() + boClientArea.getWidth()) {
                                            location.setX(boClientArea.getLeft() + boClientArea.getWidth());
                                        }
                                        if (location.getY() < boClientArea.getTop()) {
                                            location.setY(boClientArea.getTop());
                                        } else if (location.getY() > boClientArea.getTop() + boClientArea.getHeight()) {
                                            location.setY(boClientArea.getTop() + boClientArea.getHeight());
                                        }
                                        ++j;
                                    }
                                }
                                if (this.isInteractivityEnabled() && !(elTriggers = bs.getTriggers()).isEmpty()) {
                                    StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]);
                                    if (bRendering3D) {
                                        int j = 0;
                                        while (j < loa3dFace.size()) {
                                            Location3D[] points = loa3dFace.get(j);
                                            if (points.length > 2) {
                                                InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
                                                iev.setCursor(bs.getCursor());
                                                Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)bs), Polygon3DRenderEvent.class);
                                                pre3d.setPoints3D(points);
                                                Location panningOffset = this.getPanningOffset();
                                                if (this.get3DEngine().processEvent((PrimitiveRenderEvent)pre3d, panningOffset.getX(), panningOffset.getY()) != null) {
                                                    iev.setHotSpot((PrimitiveRenderEvent)pre3d);
                                                    ipr.enableInteraction(iev);
                                                }
                                            }
                                            ++j;
                                        }
                                    } else {
                                        boolean isConeOrTriangle = rt.getValue() == 1 || rt.getValue() == 3;
                                        InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
                                        iev.setCursor(bs.getCursor());
                                        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)bs), PolygonRenderEvent.class);
                                        Location[] hotspotLoa = new Location[loaFrontFace.length];
                                        int a = 0;
                                        while (a < hotspotLoa.length) {
                                            hotspotLoa[a] = goFactory.createLocation(loaFrontFace[a].getX(), loaFrontFace[a].getY());
                                            ++a;
                                        }
                                        if (hotspotLoa.length == 4) {
                                            if (this.isTransposed()) {
                                                if (hotspotLoa[2].getX() - hotspotLoa[1].getX() < 10.0) {
                                                    hotspotLoa[2].setX(hotspotLoa[1].getX() + 10.0);
                                                    hotspotLoa[3].setX(hotspotLoa[0].getX() + 10.0);
                                                }
                                            } else if (isConeOrTriangle) {
                                                if (hotspotLoa[0].getY() - hotspotLoa[1].getY() < 10.0) {
                                                    hotspotLoa[1].setY(hotspotLoa[0].getY() - 10.0);
                                                    hotspotLoa[2].setY(hotspotLoa[3].getY() - 10.0);
                                                }
                                            } else if (hotspotLoa[1].getY() - hotspotLoa[0].getY() < 10.0) {
                                                hotspotLoa[0].setY(hotspotLoa[1].getY() - 10.0);
                                                hotspotLoa[3].setY(hotspotLoa[2].getY() - 10.0);
                                            }
                                        } else if (hotspotLoa.length == 3) {
                                            if (this.isTransposed()) {
                                                if (hotspotLoa[1].getX() - hotspotLoa[0].getX() < 10.0) {
                                                    hotspotLoa[1].setX(hotspotLoa[0].getX() + 10.0);
                                                }
                                            } else if (hotspotLoa[0].getY() - hotspotLoa[1].getY() < 10.0) {
                                                hotspotLoa[1].setY(hotspotLoa[0].getY() - 10.0);
                                            }
                                        }
                                        pre.setPoints(hotspotLoa);
                                        iev.setHotSpot((PrimitiveRenderEvent)pre);
                                        ipr.enableInteraction(iev);
                                    }
                                }
                                ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawElement", (Object)dpha[i], (Object)fixedFill);
                                ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dpha[i], (Object)fixedFill, (Object)this.getRunTimeContext().getScriptContext());
                                this.getRunTimeContext().notifyStructureChange("beforeDrawElement", (Object)dpha[i]);
                                this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dpha[i]);
                                if (this.isTransposed() ? dWidth != 0.0 : dHeight != 0.0 || bShowOutside) {
                                    if (bRendering3D) {
                                        if (!hasAddedComparsionPolygon) {
                                            hasAddedComparsionPolygon = true;
                                            Location3D[] l3d = new Location3D[4];
                                            int k = 0;
                                            while (k < 4) {
                                                l3d[k] = goFactory.createLocation3D(0.0, 0.0, 0.0);
                                                ++k;
                                            }
                                            double x0 = dpha[0].getLocation3D().getX();
                                            double x1 = dpha[dpha.length - 1].getLocation3D().getX() + dSpacing * 2.0;
                                            double z = dZ + dWidthZ;
                                            l3d[0].set(x0, dY, z);
                                            l3d[1].set(x0, dY + boClientArea.getHeight(), z);
                                            l3d[2].set(x1, dY + boClientArea.getHeight(), z);
                                            l3d[3].set(x1, dY, z);
                                            Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)dpha[i], Polygon3DRenderEvent.class);
                                            pre3d.setEnable(false);
                                            pre3d.setDoubleSided(false);
                                            pre3d.setOutline(null);
                                            pre3d.setPoints3D(l3d);
                                            pre3d.setBackground(fixedFill);
                                            Object event = this.dc.getParentDeferredCache().addPlane((PrimitiveRenderEvent)pre3d, 2);
                                            if (event instanceof WrappedInstruction) {
                                                ((WrappedInstruction)event).setSubDeferredCache(this.subDeferredCache);
                                            }
                                            pre3d.setDoubleSided(false);
                                            pre3d.setEnable(true);
                                        }
                                        if (rt.getValue() == 2) {
                                            this.renderRiserTube3D(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loa3dFace, fixedFill, lia, dpha[i]);
                                        } else if (rt.getValue() == 3) {
                                            this.renderRiserCone3D(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loa3dFace, fixedFill, lia, dpha[i]);
                                        } else {
                                            this.render3DPlane(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loa3dFace, fixedFill, lia);
                                        }
                                    } else if (rt.getValue() == 2) {
                                        this.renderRiserTube2D(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), dpha[i], loaFrontFace, fixedFill, lia, cwa.getDimension(), cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL ? dSeriesThickness / 2.0 : dSeriesThickness / 4.0, cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL, this.isTransposed(), true, bInverted, this.isStackedOrPercent(bs), 0, compareBounds);
                                    } else if (rt.getValue() == 3) {
                                        boolean isStacked = this.isStackedOrPercent(bs);
                                        double coneThickness = cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL ? dSeriesThickness / 2.0 : dSeriesThickness / 4.0;
                                        double coneBottomHeight = this.computeBottomOvalHeightOfCone(i, coneThickness, loaFrontFace, dValue, isStacked);
                                        this.renderRiserCone2D(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), dpha[i], loaFrontFace, fixedFill, lia, cwa.getDimension(), coneThickness, cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL, this.isTransposed(), true, bInverted, this.isStackedOrPercent(bs), coneBottomHeight, 0, compareBounds);
                                    } else if (rt.getValue() == 1) {
                                        double[] thicknesses = this.computeThicknessesWithTriangle2D(loaFrontFace, dWidth, dHeight, dSeriesThickness);
                                        if (cwa.getDimension() == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
                                            this.adjustLocationsWithTriangle2D(loaFrontFace, thicknesses[0], thicknesses[1], dSeriesThickness);
                                        }
                                        this.renderRiserTriangle2D(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loaFrontFace, fixedFill, lia, cwa.getDimension(), thicknesses[0], thicknesses[1], true, 0, compareBounds);
                                    } else {
                                        this.renderPlane(ipr, WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), loaFrontFace, fixedFill, lia, cwa.getDimension(), dSeriesThickness, true, 0, compareBounds);
                                    }
                                }
                                ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawElement", (Object)dpha[i], (Object)fixedFill);
                                ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dpha[i], (Object)fixedFill, (Object)this.getRunTimeContext().getScriptContext());
                                this.getRunTimeContext().notifyStructureChange("afterDrawElement", (Object)dpha[i]);
                                this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dpha[i]);
                                laDataPoint.getCaption().setValue(dpha[i].getDisplayValue());
                                ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                                this.getRunTimeContext().notifyStructureChange("beforeDrawDataPointLabel", (Object)laDataPoint);
                                pDataPoint = null;
                                loDataPoint = null;
                                Location3D loDataPoint3d = null;
                                boDataPoint = null;
                                try {
                                    if (laDataPoint.isVisible()) {
                                        pDataPoint = bRendering3D ? srh3d.getLabelPosition((Series)bs) : srh.getLabelPosition((Series)bs);
                                        loDataPoint = goFactory.createLocation(0.0, 0.0);
                                        loDataPoint3d = goFactory.createLocation3D(0.0, 0.0, 0.0);
                                        boDataPoint = goFactory.createBounds(0.0, 0.0, 0.0, 0.0);
                                    }
                                }
                                catch (Exception ex) {
                                    throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, (Throwable)ex);
                                }
                                if (!laDataPoint.isVisible() || dHeight == 0.0 && !bShowOutside || dWidth == 0.0 || dpha[i].isOutside()) break block161;
                                if (cwa.isTransposed()) break block162;
                                if (!bRendering3D) break block163;
                                if (pDataPoint.getValue() != 5) break block164;
                                if (!bInverted) {
                                    loDataPoint3d.set(dX + dWidth / 2.0, dY - (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0);
                                    Text3DRenderEvent tre = (Text3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), Text3DRenderEvent.class);
                                    tre.setLabel(laDataPoint);
                                    tre.setTextPosition(8);
                                    tre.setAction(2);
                                    Location3D[] loa3d = new Location3D[]{loDataPoint3d, goFactory.createLocation3D(dX, dY - (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0), goFactory.createLocation3D(dX, dY - (double)p.getVerticalSpacing() - 16.0, dZ + dWidthZ / 2.0), goFactory.createLocation3D(dX + dWidth, dY - (double)p.getVerticalSpacing() - 16.0, dZ + dWidthZ / 2.0), goFactory.createLocation3D(dX + dWidth, dY - (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0)};
                                    tre.setBlockBounds3D(loa3d);
                                    this.getDeferredCache().addLabel((TextRenderEvent)tre);
                                } else {
                                    loDataPoint3d.set(dX + dWidth / 2.0, dY + dHeight + (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0);
                                    Text3DRenderEvent tre = (Text3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), Text3DRenderEvent.class);
                                    tre.setAction(2);
                                    tre.setLabel(laDataPoint);
                                    tre.setTextPosition(4);
                                    Location3D[] loa3d = new Location3D[]{loDataPoint3d, goFactory.createLocation3D(dX + dWidth, dY + dHeight + (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0), goFactory.createLocation3D(dX + dWidth, dY + dHeight + 16.0 + (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0), goFactory.createLocation3D(dX, dY + dHeight + 16.0 + (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0), goFactory.createLocation3D(dX, dY + dHeight + (double)p.getVerticalSpacing(), dZ + dWidthZ / 2.0)};
                                    tre.setBlockBounds3D(loa3d);
                                    this.getDeferredCache().addLabel((TextRenderEvent)tre);
                                }
                                break block161;
                            }
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.bar3d", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                        switch (pDataPoint.getValue()) {
                            case 5: {
                                if (!bInverted) {
                                    loDataPoint.set(dX + dWidth / 2.0, dY - (double)p.getVerticalSpacing());
                                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.ABOVE_LITERAL, loDataPoint, null);
                                } else {
                                    loDataPoint.set(dX + dWidth / 2.0, dY + dHeight + (double)p.getVerticalSpacing());
                                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.BELOW_LITERAL, loDataPoint, null);
                                }
                                break block161;
                            }
                            case 4: {
                                if (rt.getValue() == 3 || rt.getValue() == 1) {
                                    if (!bInverted) {
                                        loDataPoint.set(dX + dWidth / 2.0, dY + dHeight);
                                        this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.ABOVE_LITERAL, loDataPoint, null);
                                    } else {
                                        loDataPoint.set(dX + dWidth / 2.0, dY);
                                        this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.BELOW_LITERAL, loDataPoint, null);
                                    }
                                } else {
                                    boDataPoint.updateFrom(loaFrontFace);
                                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 3, laDataPoint, null, null, boDataPoint);
                                }
                                break block161;
                            }
                            default: {
                                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.bar", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                            }
                        }
                    }
                    switch (pDataPoint.getValue()) {
                        case 5: {
                            if (!bInverted) {
                                loDataPoint.set(dX - (double)p.getHorizontalSpacing(), dY + dHeight / 2.0);
                                this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.LEFT_LITERAL, loDataPoint, null);
                                break;
                            }
                            loDataPoint.set(dX + dWidth + (double)p.getHorizontalSpacing(), dY + dHeight / 2.0);
                            this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.RIGHT_LITERAL, loDataPoint, null);
                            break;
                        }
                        case 4: {
                            if (rt.getValue() == 3 || rt.getValue() == 1) {
                                if (!bInverted) {
                                    loDataPoint.set(dX + dWidth, dY + dHeight / 2.0);
                                    this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.LEFT_LITERAL, loDataPoint, null);
                                    break;
                                }
                                loDataPoint.set(dX, dY + dHeight / 2.0);
                                this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 2, laDataPoint, Position.RIGHT_LITERAL, loDataPoint, null);
                                break;
                            }
                            boDataPoint.updateFrom(loaFrontFace);
                            this.renderLabel(WrappedStructureSource.createSeriesDataPoint((Series)bs, (DataPointHints)dpha[i]), 3, laDataPoint, null, null, boDataPoint);
                            break;
                        }
                        default: {
                            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.illegal.datapoint.position.bar", new Object[]{pDataPoint.getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
                        }
                    }
                }
                ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPointLabel", (Object)dpha[i], (Object)laDataPoint, (Object)this.getRunTimeContext().getScriptContext());
                this.getRunTimeContext().notifyStructureChange("afterDrawDataPointLabel", (Object)laDataPoint);
            }
            ++i;
        }
        if (!bRendering3D) {
            List<Object> points = new ArrayList<double[]>();
            int i2 = 0;
            while (i2 < faX.length) {
                points.add(new double[]{faX[i2], faY[i2]});
                ++i2;
            }
            points = this.filterNull(points);
            if (this.isLastRuntimeSeriesInAxis()) {
                this.getRunTimeContext().putState((Object)"stacked_series_location_key", null);
            } else {
                this.getRunTimeContext().putState((Object)"stacked_series_location_key", points);
            }
            if (this.getSeries().getCurveFitting() != null) {
                Location[] larray = this.createLocationArray(points);
                this.renderFittingCurve(ipr, larray, this.getSeries().getCurveFitting(), false, true);
            }
        }
        this.resetAllStackedSizeHints();
        if (!bRendering3D) {
            this.restoreClipping(ipr);
        }
    }

    private double computeSizeForNonCategoryBar(boolean isTransposed, DataPointHints[] dpha) {
        double sizeForNonCategory = dpha[0].getSize();
        double maxSize = 0.0;
        int i = 0;
        while (i < dpha.length - 1) {
            if (dpha[i].getSize() > maxSize) {
                maxSize = dpha[i].getSize();
            }
            int j = i + 1;
            while (j < dpha.length) {
                double space = 0.0;
                space = isTransposed ? dpha[j].getLocation().getY() - dpha[i].getLocation().getY() : dpha[j].getLocation().getX() - dpha[i].getLocation().getX();
                if (sizeForNonCategory > (space = Math.abs(space))) {
                    sizeForNonCategory = space;
                }
                ++j;
            }
            ++i;
        }
        sizeForNonCategory = Math.max(sizeForNonCategory * 0.8, maxSize * 0.3);
        return sizeForNonCategory;
    }

    private StackedSizeHints getCurrentStackedSizeHints(int i) {
        Object obj = this.getRunTimeContext().getState((Object)"stacked_series_size_key");
        if (obj == null) {
            this.getRunTimeContext().putState((Object)"stacked_series_size_key", new ArrayList());
            obj = this.getRunTimeContext().getState((Object)"stacked_series_size_key");
        }
        List stackedSizes = (List)obj;
        while (stackedSizes.size() - 1 <= i) {
            stackedSizes.add(new StackedSizeHints());
        }
        StackedSizeHints slh = (StackedSizeHints)stackedSizes.get(i);
        return slh;
    }

    private void resetAllStackedSizeHints() {
        if (this.isLastRuntimeSeriesInGroup()) {
            this.getRunTimeContext().putState((Object)"stacked_series_size_key", null);
        }
    }

    private static double[] computeStacked2DTopNBottomSize(StackedSizeHints stackedSizeHints, AxisSubUnit au, double dValue, double size) {
        double stackedSizePercent = Bar.computeStacked2DTopSizePercent(stackedSizeHints, au, dValue);
        double topSize = 0.0;
        double bottomSize = 0.0;
        if (dValue >= 0.0) {
            if (Double.isNaN(stackedSizeHints.getLastPositiveBottom()) && !Double.isNaN(size)) {
                stackedSizeHints.setLastPositiveBottom(size);
            }
            bottomSize = stackedSizeHints.getLastPositiveBottom();
            stackedSizeHints.setLastPositiveBottom(bottomSize * stackedSizePercent);
        } else {
            if (Double.isNaN(stackedSizeHints.getLastNegativeBottom()) && !Double.isNaN(size)) {
                stackedSizeHints.setLastNegativeBottom(size);
            }
            bottomSize = stackedSizeHints.getLastNegativeBottom();
            stackedSizeHints.setLastNegativeBottom(bottomSize * stackedSizePercent);
        }
        topSize = bottomSize * stackedSizePercent;
        return new double[]{topSize, bottomSize};
    }

    private boolean isStackedOrPercent(BarSeries bs) {
        return bs.isStacked();
    }

    private static double computeStacked2DTopSizePercent(StackedSizeHints stackedSizeHints, AxisSubUnit au, double dValue) {
        double dCurrentTotal = 0.0;
        if (dValue >= 0.0) {
            dCurrentTotal = Double.isNaN(stackedSizeHints.getRemainedPositiveTotal()) ? au.getPositiveTotal() : stackedSizeHints.getRemainedPositiveTotal();
            stackedSizeHints.setRemainedPositiveTotal(dCurrentTotal - dValue);
        } else {
            dCurrentTotal = Double.isNaN(stackedSizeHints.getRemainedNegativeTotal()) ? au.getNegativeTotal() : stackedSizeHints.getRemainedNegativeTotal();
            stackedSizeHints.setRemainedNegativeTotal(dCurrentTotal - dValue);
        }
        if (ChartUtil.mathEqual((double)dCurrentTotal, (double)0.0)) {
            return 0.0;
        }
        double dTopSizePercent = (dCurrentTotal - dValue) / dCurrentTotal;
        return dTopSizePercent;
    }

    private Location[] computeRiserRectangle2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth) {
        Location[] loaFrontFace = new Location[]{goFactory.createLocation(dX, dY), goFactory.createLocation(dX, dY + dHeight), goFactory.createLocation(dX + dWidth, dY + dHeight), goFactory.createLocation(dX + dWidth, dY)};
        if (this.isTransposed()) {
            faX[i] = bInverted ? dX + dWidth : dX;
            faY[i] = dY + dHeight / 2.0;
        } else {
            faX[i] = dX + dWidth / 2.0;
            faY[i] = bInverted ? dY + dHeight : dY;
        }
        return loaFrontFace;
    }

    private List<Location3D[]> computeRiserRectangle3D(boolean bInverted, double dX, double dY, double dZ, double dHeight, double dWidth, double dWidthZ) {
        ArrayList<Location3D[]> loa3dFace = new ArrayList<Location3D[]>();
        if (!bInverted) {
            Location3D[] a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY + dHeight, dZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ), goFactory.createLocation3D(dX, dY, dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY + dHeight, dZ), goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX, dY, dZ + dWidthZ), goFactory.createLocation3D(dX, dY + dHeight, dZ + dWidthZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ + dWidthZ), goFactory.createLocation3D(dX, dY, dZ + dWidthZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY + dHeight, dZ), goFactory.createLocation3D(dX, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX, dY, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ + dWidthZ)};
            loa3dFace.add(a3dFace);
        } else {
            Location3D[] a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX, dY + dHeight, dZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX, dY, dZ + dWidthZ), goFactory.createLocation3D(dX, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX, dY + dHeight, dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ + dWidthZ), goFactory.createLocation3D(dX, dY, dZ + dWidthZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY + dHeight, dZ), goFactory.createLocation3D(dX, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX + dWidth, dY, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ + dWidthZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX, dY + dHeight, dZ + dWidthZ)};
            loa3dFace.add(a3dFace);
        }
        return loa3dFace;
    }

    private Location[] computeStackedRiserTriangle2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth, double dTopSize, double dBottomSize, StackedSizeHints ssh) {
        if (ssh.getInitialBounds() == null) {
            Bounds b = goFactory.createBounds(dX, dY, dWidth, dHeight);
            ssh.setInitialBounds(b);
        }
        Location[] loaFrontFace = new Location[4];
        if (this.isTransposed()) {
            double dX1 = bInverted ? dX : dX + dWidth;
            double dX2 = bInverted ? dX + dWidth : dX;
            double dTopDelta = (dHeight - dTopSize) / 2.0;
            double dBottomDelta = (dHeight - dBottomSize) / 2.0;
            loaFrontFace[0] = goFactory.createLocation(dX1, dY + dBottomDelta + dBottomSize);
            loaFrontFace[1] = goFactory.createLocation(dX2, dY + dTopDelta + dTopSize);
            loaFrontFace[2] = goFactory.createLocation(dX2, dY + dTopDelta);
            loaFrontFace[3] = goFactory.createLocation(dX1, dY + dBottomDelta);
            faX[i] = dX2;
            faY[i] = dY + dHeight / 2.0;
        } else {
            double dY1 = bInverted ? dY : dY + dHeight;
            double dY2 = bInverted ? dY + dHeight : dY;
            double dTopDelta = (dWidth - dTopSize) / 2.0;
            double dBottomDelta = (dWidth - dBottomSize) / 2.0;
            loaFrontFace[0] = goFactory.createLocation(dX + dBottomDelta, dY1);
            loaFrontFace[1] = goFactory.createLocation(dX + dTopDelta, dY2);
            loaFrontFace[2] = goFactory.createLocation(dX + dTopDelta + dTopSize, dY2);
            loaFrontFace[3] = goFactory.createLocation(dX + dBottomDelta + dBottomSize, dY1);
            faX[i] = dX + dWidth / 2.0;
            faY[i] = dY2;
        }
        return loaFrontFace;
    }

    private Location[] computeRiserTriangle2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth) {
        Location[] loaFrontFace = new Location[3];
        if (this.isTransposed()) {
            double dX1 = bInverted ? dX : dX + dWidth;
            double dX2 = bInverted ? dX + dWidth : dX;
            loaFrontFace[0] = goFactory.createLocation(dX1, dY + dHeight);
            loaFrontFace[1] = goFactory.createLocation(dX2, dY + dHeight / 2.0);
            loaFrontFace[2] = goFactory.createLocation(dX1, dY);
            faX[i] = dX2;
            faY[i] = dY + dHeight / 2.0;
        } else {
            double dY1 = bInverted ? dY : dY + dHeight;
            double dY2 = bInverted ? dY + dHeight : dY;
            loaFrontFace[0] = goFactory.createLocation(dX, dY1);
            loaFrontFace[1] = goFactory.createLocation(dX + dWidth / 2.0, dY2);
            loaFrontFace[2] = goFactory.createLocation(dX + dWidth, dY1);
            faX[i] = dX + dWidth / 2.0;
            faY[i] = dY2;
        }
        return loaFrontFace;
    }

    private List<Location3D[]> computeRiserTriangle3D(boolean bInverted, double dX, double dY, double dZ, double dHeight, double dWidth, double dWidthZ) {
        ArrayList<Location3D[]> loa3dFace = new ArrayList<Location3D[]>();
        if (!bInverted) {
            Location3D[] a3dFace = new Location3D[]{goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth / 2.0, dY, dZ + dWidthZ / 2.0)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY + dHeight, dZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ), goFactory.createLocation3D(dX + dWidth / 2.0, dY, dZ + dWidthZ / 2.0)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX, dY + dHeight, dZ), goFactory.createLocation3D(dX + dWidth / 2.0, dY, dZ + dWidthZ / 2.0)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth / 2.0, dY, dZ + dWidthZ / 2.0)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY + dHeight, dZ), goFactory.createLocation3D(dX, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ)};
            loa3dFace.add(a3dFace);
        } else {
            Location3D[] a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth / 2.0, dY + dHeight, dZ + dWidthZ / 2.0)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX + dWidth, dY, dZ), goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX + dWidth / 2.0, dY + dHeight, dZ + dWidthZ / 2.0)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX, dY, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth / 2.0, dY + dHeight, dZ + dWidthZ / 2.0)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX + dWidth, dY, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY, dZ), goFactory.createLocation3D(dX + dWidth / 2.0, dY + dHeight, dZ + dWidthZ / 2.0)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ + dWidthZ), goFactory.createLocation3D(dX, dY, dZ + dWidthZ)};
            loa3dFace.add(a3dFace);
        }
        return loa3dFace;
    }

    private Location[] computeRiserTube2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth) {
        Location[] loaFrontFace = new Location[]{goFactory.createLocation(dX, dY), goFactory.createLocation(dX, dY + dHeight), goFactory.createLocation(dX + dWidth, dY + dHeight), goFactory.createLocation(dX + dWidth, dY)};
        if (this.isTransposed()) {
            faX[i] = bInverted ? dX + dWidth : dX;
            faY[i] = dY + dHeight / 2.0;
        } else {
            faX[i] = dX + dWidth / 2.0;
            faY[i] = bInverted ? dY + dHeight : dY;
        }
        return loaFrontFace;
    }

    private List<Location3D[]> computeRiserTube3D(double dX, double dY, double dZ, double dHeight, double dWidth, double dWidthZ) {
        ArrayList<Location3D[]> loa3dFace = new ArrayList<Location3D[]>();
        Location3D[] a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY + dHeight, dZ), goFactory.createLocation3D(dX, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ)};
        loa3dFace.add(a3dFace);
        a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ + dWidthZ), goFactory.createLocation3D(dX, dY, dZ + dWidthZ)};
        loa3dFace.add(a3dFace);
        return loa3dFace;
    }

    private Location[] computeStackedRiserCone2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth, double dTopSize, double dBottomSize) {
        Location[] loaFrontFace = new Location[4];
        if (this.isTransposed()) {
            double dX1 = bInverted ? dX : dX + dWidth;
            double dX2 = bInverted ? dX + dWidth : dX;
            double dTopDelta = (dHeight - dTopSize) / 2.0;
            double dBottomDelta = (dHeight - dBottomSize) / 2.0;
            loaFrontFace[0] = goFactory.createLocation(dX1, dY + dBottomDelta + dBottomSize);
            loaFrontFace[1] = goFactory.createLocation(dX2, dY + dTopDelta + dTopSize);
            loaFrontFace[2] = goFactory.createLocation(dX2, dY + dTopDelta);
            loaFrontFace[3] = goFactory.createLocation(dX1, dY + dBottomDelta);
            faX[i] = dX2;
            faY[i] = dY + dHeight / 2.0;
        } else {
            double dY1 = bInverted ? dY : dY + dHeight;
            double dY2 = bInverted ? dY + dHeight : dY;
            double dTopDelta = (dWidth - dTopSize) / 2.0;
            double dBottomDelta = (dWidth - dBottomSize) / 2.0;
            loaFrontFace[0] = goFactory.createLocation(dX + dBottomDelta, dY1);
            loaFrontFace[1] = goFactory.createLocation(dX + dTopDelta, dY2);
            loaFrontFace[2] = goFactory.createLocation(dX + dTopDelta + dTopSize, dY2);
            loaFrontFace[3] = goFactory.createLocation(dX + dBottomDelta + dBottomSize, dY1);
            faX[i] = dX + dWidth / 2.0;
            faY[i] = dY2;
        }
        return loaFrontFace;
    }

    private Location[] computeRiserCone2D(boolean bInverted, int i, double[] faX, double[] faY, double dX, double dY, double dHeight, double dWidth) {
        Location[] loaFrontFace = new Location[3];
        if (this.isTransposed()) {
            double dX1 = bInverted ? dX : dX + dWidth;
            double dX2 = bInverted ? dX + dWidth : dX;
            loaFrontFace[0] = goFactory.createLocation(dX1, dY);
            loaFrontFace[1] = goFactory.createLocation(dX2, dY + dHeight / 2.0);
            loaFrontFace[2] = goFactory.createLocation(dX1, dY + dHeight);
            faX[i] = dX2;
            faY[i] = dY + dHeight / 2.0;
        } else {
            double dY1 = bInverted ? dY : dY + dHeight;
            double dY2 = bInverted ? dY + dHeight : dY;
            loaFrontFace[0] = goFactory.createLocation(dX, dY1);
            loaFrontFace[1] = goFactory.createLocation(dX + dWidth / 2.0, dY2);
            loaFrontFace[2] = goFactory.createLocation(dX + dWidth, dY1);
            faX[i] = dX + dWidth / 2.0;
            faY[i] = dY2;
        }
        return loaFrontFace;
    }

    private List<Location3D[]> computeRiserCone3D(boolean bInverted, double dX, double dY, double dZ, double dHeight, double dWidth, double dWidthZ) {
        ArrayList<Location3D[]> loa3dFace = new ArrayList<Location3D[]>();
        if (!bInverted) {
            Location3D[] a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY + dHeight, dZ), goFactory.createLocation3D(dX, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ + dWidthZ), goFactory.createLocation3D(dX + dWidth, dY + dHeight, dZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX + dWidth / 2.0, dY, dZ + dWidthZ / 2.0)};
            loa3dFace.add(a3dFace);
        } else {
            Location3D[] a3dFace = new Location3D[]{goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ), goFactory.createLocation3D(dX + dWidth, dY, dZ + dWidthZ), goFactory.createLocation3D(dX, dY, dZ + dWidthZ)};
            loa3dFace.add(a3dFace);
            a3dFace = new Location3D[]{goFactory.createLocation3D(dX + dWidth / 2.0, dY + dHeight, dZ + dWidthZ / 2.0)};
            loa3dFace.add(a3dFace);
        }
        return loa3dFace;
    }

    public final void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        BarSeries bs = (BarSeries)this.getSeries();
        ColorDefinition cd = bs.getRiserOutline();
        LineAttributes lia = goFactory.createLineAttributes(cd == null ? null : goFactory.copyOf(cd), LineStyle.SOLID_LITERAL, 1);
        if (fPaletteEntry == null) {
            fPaletteEntry = goFactory.RED();
        } else if (fPaletteEntry instanceof MultipleFill) {
            fPaletteEntry = (Fill)((MultipleFill)fPaletteEntry).getFills().get(0);
        }
        Location[] loaFrontFace = null;
        double dSeriesThickness = 0.0;
        switch (bs.getRiser().getValue()) {
            case 0: 
            case 2: {
                if (bs.getRiser().getValue() == 0 && this.getModel().getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
                    dSeriesThickness = 3.0 * this.getDeviceScale();
                }
                if (bs.getRiser().getValue() == 2) {
                    dSeriesThickness = 2.0 * this.getDeviceScale();
                }
                loaFrontFace = new Location[]{goFactory.createLocation(bo.getLeft(), bo.getTop() + dSeriesThickness), goFactory.createLocation(bo.getLeft(), bo.getTop() + bo.getHeight()), goFactory.createLocation(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight()), goFactory.createLocation(bo.getLeft() + bo.getWidth(), bo.getTop() + dSeriesThickness)};
                break;
            }
            case 1: 
            case 3: {
                loaFrontFace = new Location[]{goFactory.createLocation(bo.getLeft(), bo.getTop() + bo.getHeight()), goFactory.createLocation(bo.getLeft() + bo.getWidth() / 2.0, bo.getTop()), goFactory.createLocation(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight())};
                break;
            }
            default: {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.legend.graphic.unknown.riser", new Object[]{bs.getRiser().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
            }
        }
        if (bs.getRiser().getValue() == 2) {
            this.renderRiserTube2D(ipr, StructureSource.createLegend((Legend)lg), null, loaFrontFace, fPaletteEntry, lia, this.getModel().getDimension(), 2.0 * this.getDeviceScale(), false, false, false, false, false, 0, null);
        } else if (bs.getRiser().getValue() == 3) {
            this.renderRiserCone2D(ipr, StructureSource.createLegend((Legend)lg), null, loaFrontFace, fPaletteEntry, lia, this.getModel().getDimension(), 2.0 * this.getDeviceScale(), false, false, false, false, false, 2.0 * this.getDeviceScale(), 0, null);
        } else if (bs.getRiser().getValue() == 1) {
            ChartDimension cdim = this.getModel().getDimension();
            if (cdim != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
                this.adjustLocationsWithTriangle2D(loaFrontFace, 0.0, 2.0 * this.getDeviceScale(), 2.0 * this.getDeviceScale());
            }
            this.renderRiserTriangle2D(ipr, StructureSource.createLegend((Legend)lg), loaFrontFace, fPaletteEntry, lia, cdim == ChartDimension.THREE_DIMENSIONAL_LITERAL ? ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL : cdim, 0.0, 2.0 * this.getDeviceScale(), false, 0, null);
        } else {
            this.renderPlane(ipr, StructureSource.createLegend((Legend)lg), loaFrontFace, fPaletteEntry, lia, this.getModel().getDimension(), 3.0 * this.getDeviceScale(), false);
        }
    }

    private Location[] createLocationArray(List ll) {
        Location[] loa = new Location[ll.size()];
        int i = 0;
        while (i < loa.length) {
            double[] obj = (double[])ll.get(i);
            loa[i] = goFactory.createLocation(obj[0], obj[1]);
            ++i;
        }
        return loa;
    }

    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
    }

    private void renderRiserTube2D(IPrimitiveRenderer ipr, Object oSource, DataPointHints dpha, Location[] loaFront, Fill f, LineAttributes lia, ChartDimension cd, double dSeriesThickness, boolean bOffset, boolean bTransposed, boolean bDeferred, boolean bInverted, boolean bStacked, int zorder_hint, Bounds compareBounds) throws ChartException {
        double dWidth;
        Fill fBrighter;
        ArrayList<PrimitiveRenderEvent> alModel = new ArrayList<PrimitiveRenderEvent>();
        if (!this.isDimension3D()) {
            f = FillUtil.convertFillToGradient((Fill)f, (boolean)bTransposed);
            fBrighter = FillUtil.getBrighterFill((Fill)f);
        } else {
            fBrighter = FillUtil.changeBrightness((Fill)f, (double)0.89);
            f = FillUtil.convertFillToGradient3D((Fill)f, (boolean)bTransposed);
        }
        LineAttributes liaBorder = goFactory.copyOf(lia);
        if (liaBorder.getColor() == null) {
            liaBorder.setColor(FillUtil.getDarkerColor((Fill)f));
        }
        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, PolygonRenderEvent.class);
        LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, LineRenderEvent.class);
        OvalRenderEvent ore = (OvalRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, OvalRenderEvent.class);
        ArcRenderEvent are = (ArcRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, ArcRenderEvent.class);
        double d = dWidth = bTransposed ? loaFront[1].getY() - loaFront[0].getY() : loaFront[2].getX() - loaFront[1].getX();
        if (bOffset) {
            int i = 0;
            while (i < loaFront.length) {
                if (bTransposed) {
                    loaFront[i].setX(loaFront[i].getX() + dSeriesThickness);
                } else {
                    loaFront[i].setY(loaFront[i].getY() - dSeriesThickness);
                }
                ++i;
            }
        }
        Bounds bottomBounds = null;
        bottomBounds = bTransposed ? goFactory.createBounds(loaFront[0].getX() - dSeriesThickness, loaFront[0].getY() + dWidth, dSeriesThickness * 2.0, Math.abs(dWidth)) : goFactory.createBounds(loaFront[0].getX(), loaFront[1].getY() - dSeriesThickness, dWidth, dSeriesThickness * 2.0);
        Bounds topBounds = null;
        topBounds = bTransposed ? goFactory.createBounds(loaFront[3].getX() - dSeriesThickness, loaFront[3].getY() + dWidth, dSeriesThickness * 2.0, Math.abs(dWidth)) : goFactory.createBounds(loaFront[0].getX(), loaFront[0].getY() - dSeriesThickness, dWidth, dSeriesThickness * 2.0);
        if (bottomBounds != null) {
            ore.setBounds(bottomBounds);
            ore.setBackground(f);
            ore.setOutline(liaBorder);
            if (bDeferred) {
                alModel.add(ore.copy());
            } else {
                ipr.fillOval(ore);
            }
            are.setBackground(null);
            are.setOutline(liaBorder);
            are.setBounds(ore.getBounds());
            are.setAngleExtent(180.0);
            are.setStyle(1);
            if (bTransposed) {
                are.setStartAngle(90.0);
            } else {
                are.setStartAngle(180.0);
            }
            if (bDeferred) {
                alModel.add(are.copy());
            } else {
                ipr.drawArc(are);
            }
        }
        pre.setPoints(loaFront);
        pre.setBackground(f);
        pre.setOutline(null);
        if (bDeferred) {
            alModel.add(pre.copy());
        } else {
            ipr.fillPolygon(pre);
        }
        if (bTransposed) {
            lre.setStart(loaFront[1]);
            lre.setEnd(loaFront[2]);
        } else {
            lre.setStart(loaFront[0]);
            lre.setEnd(loaFront[1]);
        }
        lre.setLineAttributes(liaBorder);
        if (bDeferred) {
            alModel.add(lre.copy());
        } else {
            ipr.drawLine(lre);
        }
        if (bTransposed) {
            lre.setStart(loaFront[0]);
            lre.setEnd(loaFront[3]);
        } else {
            lre.setStart(loaFront[2]);
            lre.setEnd(loaFront[3]);
        }
        lre.setLineAttributes(liaBorder);
        if (bDeferred) {
            alModel.add(lre.copy());
        } else {
            ipr.drawLine(lre);
        }
        if (topBounds != null) {
            ore.setBounds(topBounds);
            ore.setBackground(fBrighter);
            ore.setOutline(liaBorder);
            if (bDeferred) {
                alModel.add(ore.copy());
            } else {
                ipr.fillOval(ore);
                ipr.drawOval(ore);
            }
            are.setBackground(null);
            are.setOutline(liaBorder);
            are.setBounds(ore.getBounds());
            are.setAngleExtent(180.0);
            are.setStyle(1);
            if (bTransposed) {
                are.setStartAngle(90.0);
            } else {
                are.setStartAngle(180.0);
            }
            if (bDeferred) {
                alModel.add(are.copy());
            } else {
                ipr.drawArc(are);
            }
        }
        this.renderInteractivity(ipr, dpha, (PrimitiveRenderEvent)ore);
        if (!alModel.isEmpty()) {
            WrappedInstruction wi = new WrappedInstruction(this.getDeferredCache(), alModel, 2, (long)zorder_hint);
            wi.setCompareBounds(compareBounds);
            this.dc.addModel(wi);
        }
    }

    private void renderRiserCone2D(IPrimitiveRenderer ipr, Object oSource, DataPointHints dpha, Location[] loaFront, Fill f, LineAttributes lia, ChartDimension cd, double dSeriesThickness, boolean bOffset, boolean bTransposed, boolean bDeferred, boolean bInverted, boolean bIsStacked, double ovalHeight, int zorder_hint, Bounds compareBounds) throws ChartException {
        Bounds tmpBounds;
        LineAttributes liaBorder;
        ArrayList<PrimitiveRenderEvent> alModel = new ArrayList<PrimitiveRenderEvent>();
        f = !this.isDimension3D() ? FillUtil.convertFillToGradient((Fill)f, (boolean)bTransposed) : FillUtil.convertFillToGradient3D((Fill)f, (boolean)bTransposed);
        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, PolygonRenderEvent.class);
        LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, LineRenderEvent.class);
        ArcRenderEvent are = (ArcRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, ArcRenderEvent.class);
        double dBottomWidth = 0.0;
        dBottomWidth = bIsStacked ? (bTransposed ? loaFront[0].getY() - loaFront[3].getY() : loaFront[3].getX() - loaFront[0].getX()) : (bTransposed ? loaFront[2].getY() - loaFront[0].getY() : loaFront[2].getX() - loaFront[0].getX());
        double dTopWidth = 0.0;
        dTopWidth = bIsStacked ? (bTransposed ? loaFront[1].getY() - loaFront[2].getY() : loaFront[2].getX() - loaFront[1].getX()) : Double.NaN;
        if (bOffset) {
            int i = 0;
            while (i < loaFront.length) {
                if (bTransposed) {
                    loaFront[i].setX(loaFront[i].getX() + dSeriesThickness);
                } else {
                    loaFront[i].setY(loaFront[i].getY() - dSeriesThickness);
                }
                ++i;
            }
        }
        if ((liaBorder = goFactory.copyOf(lia)).getColor() == null) {
            liaBorder.setColor(FillUtil.getDarkerColor((Fill)f));
        }
        Bounds bottomBounds = bTransposed ? (bIsStacked ? goFactory.createBounds(loaFront[3].getX() - ovalHeight, loaFront[3].getY() + dBottomWidth, ovalHeight * 2.0, Math.abs(dBottomWidth)) : goFactory.createBounds(loaFront[0].getX() - ovalHeight, loaFront[0].getY() + dBottomWidth, ovalHeight * 2.0, Math.abs(dBottomWidth))) : goFactory.createBounds(loaFront[0].getX(), loaFront[0].getY() - ovalHeight, dBottomWidth, ovalHeight * 2.0);
        double topHeight = ovalHeight * dTopWidth / dBottomWidth;
        Bounds topBounds = bTransposed ? (bIsStacked ? goFactory.createBounds(loaFront[2].getX() - topHeight, loaFront[2].getY() + dTopWidth, topHeight * 2.0, Math.abs(dTopWidth)) : null) : goFactory.createBounds(loaFront[1].getX(), loaFront[1].getY() - topHeight, dTopWidth, topHeight * 2.0);
        if (!bTransposed) {
            if (bInverted) {
                tmpBounds = topBounds;
                topBounds = bottomBounds;
                bottomBounds = tmpBounds;
            }
        } else if (!bInverted) {
            tmpBounds = topBounds;
            topBounds = bottomBounds;
            bottomBounds = tmpBounds;
        }
        if (bottomBounds != null) {
            are.setOutline(liaBorder);
            are.setBounds(bottomBounds);
            are.setBackground(f);
            are.setAngleExtent(360.0);
            are.setStyle(1);
            if (bTransposed) {
                are.setStartAngle(90.0);
            } else {
                are.setStartAngle(180.0);
            }
            if (bDeferred) {
                alModel.add(are.copy());
            } else {
                ipr.drawArc(are);
                ipr.fillArc(are);
            }
        }
        pre.setPoints(loaFront);
        pre.setBackground(f);
        pre.setOutline(null);
        if (bDeferred) {
            alModel.add(pre.copy());
        } else {
            ipr.fillPolygon(pre);
        }
        lre.setLineAttributes(liaBorder);
        lre.setStart(loaFront[0]);
        lre.setEnd(loaFront[1]);
        if (bDeferred) {
            alModel.add(lre.copy());
        } else {
            ipr.drawLine(lre);
        }
        lre.setLineAttributes(liaBorder);
        if (bIsStacked) {
            lre.setStart(loaFront[3]);
            lre.setEnd(loaFront[2]);
        } else {
            lre.setStart(loaFront[2]);
            lre.setEnd(loaFront[1]);
        }
        if (bDeferred) {
            alModel.add(lre.copy());
        } else {
            ipr.drawLine(lre);
        }
        if (topBounds != null) {
            are.setOutline(liaBorder);
            are.setBounds(topBounds);
            are.setBackground(f);
            are.setAngleExtent(360.0);
            are.setStyle(1);
            if (bTransposed) {
                are.setStartAngle(90.0);
            } else {
                are.setStartAngle(180.0);
            }
            if (bDeferred) {
                alModel.add(are.copy());
            } else {
                ipr.drawArc(are);
                ipr.fillArc(are);
            }
        }
        this.renderInteractivity(ipr, dpha, (PrimitiveRenderEvent)are);
        if (!alModel.isEmpty()) {
            WrappedInstruction wi = new WrappedInstruction(this.getDeferredCache(), alModel, 3, (long)zorder_hint);
            wi.setCompareBounds(compareBounds);
            this.dc.addModel(wi);
        }
    }

    private void renderRiserTriangle2D(IPrimitiveRenderer ipr, Object oSource, Location[] loaFront, Fill f, LineAttributes lia, ChartDimension cd, double dTopThickness, double dBottomThickness, boolean bDeferred, int zorder_hint, Bounds compareBounds) throws ChartException {
        if (cd.getValue() == 0) {
            PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, PolygonRenderEvent.class);
            pre.setPoints(loaFront);
            pre.setBackground(f);
            pre.setOutline(lia);
            if (bDeferred) {
                this.dc.addPlane((PrimitiveRenderEvent)pre, 3);
            } else {
                ipr.fillPolygon(pre);
                ipr.drawPolygon(pre);
            }
            return;
        }
        boolean bSolidColor = f instanceof ColorDefinition;
        Fill fDarker = null;
        Fill fBrighter = null;
        if (cd.getValue() == 1) {
            fDarker = FillUtil.getDarkerFill((Fill)f);
            fBrighter = FillUtil.getBrighterFill((Fill)f);
        }
        if (this.isDimension3D()) {
            fBrighter = FillUtil.changeBrightness((Fill)f, (double)0.89);
            fDarker = FillUtil.changeBrightness((Fill)f, (double)0.65);
            f = FillUtil.changeBrightness((Fill)f, (double)0.89);
        }
        int nSides = loaFront.length;
        Location[][] loaa = new Location[nSides + 1][];
        double dSmallestY = 0.0;
        int i = 0;
        while (i < nSides) {
            int j = i + 1;
            if (j >= loaFront.length) {
                j = 0;
            }
            double[] correctThicknesses = this.computeCorrectThicknessesWithTriangle2D(nSides, i, dTopThickness, dBottomThickness);
            Location[] loa = new Location[]{goFactory.createLocation(loaFront[i].getX(), loaFront[i].getY()), goFactory.createLocation(loaFront[j].getX(), loaFront[j].getY()), goFactory.createLocation(loaFront[j].getX() + correctThicknesses[0], loaFront[j].getY() - correctThicknesses[0]), goFactory.createLocation(loaFront[i].getX() + correctThicknesses[1], loaFront[i].getY() - correctThicknesses[1])};
            loaa[i] = loa;
            ++i;
        }
        loaa[nSides] = loaFront;
        int i2 = 0;
        while (i2 < nSides - 1) {
            Location[] loaI = loaa[i2];
            int j = i2 + 1;
            while (j < nSides) {
                Location[] loaJ = loaa[j];
                double dI = Bar.getY((Location[])loaI, (int)4);
                double dJ = Bar.getY((Location[])loaJ, (int)4);
                if (ChartUtil.mathGT((double)dJ, (double)dI)) {
                    loaa[i2] = loaJ;
                    loaa[j] = loaI;
                    loaI = loaJ;
                } else if (ChartUtil.mathEqual((double)dJ, (double)dI) && ChartUtil.mathGT((double)(dI = Bar.getX((Location[])loaI, (int)4)), (double)(dJ = Bar.getX((Location[])loaJ, (int)4)))) {
                    loaa[i2] = loaJ;
                    loaa[j] = loaI;
                    loaI = loaJ;
                }
                ++j;
            }
            ++i2;
        }
        int iSmallestYIndex = 0;
        int i3 = 0;
        while (i3 < nSides) {
            double dY = Bar.getY((Location[])loaa[i3], (int)4);
            if (i3 == 0) {
                dSmallestY = dY;
            } else if (ChartUtil.mathGT((double)dSmallestY, (double)dY)) {
                dSmallestY = dY;
                iSmallestYIndex = i3;
            }
            ++i3;
        }
        ArrayList<PrimitiveRenderEvent> alModel = new ArrayList<PrimitiveRenderEvent>(nSides + 1);
        int i4 = 0;
        while (i4 < nSides + 1) {
            PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, PolygonRenderEvent.class);
            pre.setOutline(lia);
            pre.setPoints(loaa[i4]);
            Fill fP = i4 == nSides ? f : (i4 == iSmallestYIndex ? fBrighter : fDarker);
            pre.setBackground(fP);
            if (i4 == nSides) {
                if (bDeferred) {
                    alModel.add(pre.copy());
                } else {
                    ipr.fillPolygon(pre);
                }
            } else if (i4 == iSmallestYIndex) {
                if (!bSolidColor) {
                    pre.setBackground((Fill)LIGHT_GLASS);
                }
                if (bDeferred) {
                    alModel.add(pre.copy());
                } else {
                    ipr.fillPolygon(pre);
                }
            } else {
                if (!bSolidColor) {
                    pre.setBackground((Fill)DARK_GLASS);
                }
                if (bDeferred) {
                    alModel.add(pre.copy());
                } else {
                    ipr.fillPolygon(pre);
                }
            }
            if (!bDeferred) {
                ipr.drawPolygon(pre);
            }
            ++i4;
        }
        if (!alModel.isEmpty()) {
            WrappedInstruction wi = new WrappedInstruction(this.getDeferredCache(), alModel, 2, (long)zorder_hint);
            wi.setCompareBounds(compareBounds);
            this.dc.addModel(wi);
        }
    }

    private void renderRiserTube3D(IPrimitiveRenderer ipr, Object oSource, List loaFace, Fill f, LineAttributes lia, DataPointHints dpha) throws ChartException {
        EList elTriggers;
        if (loaFace == null || loaFace.size() != 2) {
            throw new IllegalArgumentException();
        }
        DeferredCache subCache = this.createSubDeferreceCache4Tube3D(ipr, oSource, loaFace, f);
        Polygon3DRenderEvent pre = (Polygon3DRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, Polygon3DRenderEvent.class);
        Point2D.Double[] ovalsTop = null;
        Point2D.Double[] ovalsBottom = null;
        double yTop = 0.0;
        double yBottom = 0.0;
        int i = 0;
        while (i < loaFace.size()) {
            Location3D[] locations = (Location3D[])loaFace.get(i);
            Point2D.Double pointA = new Point2D.Double(locations[0].getX(), locations[0].getZ());
            Point2D.Double pointB = new Point2D.Double(locations[2].getX(), locations[2].getZ());
            if (i == 0) {
                ovalsTop = Bar.computeOvalPoints(30, pointA, pointB);
                yTop = locations[0].getY();
            } else {
                ovalsBottom = Bar.computeOvalPoints(30, pointA, pointB);
                yBottom = locations[0].getY();
            }
            ++i;
        }
        Location3D[] topPoints = new Location3D[30];
        Location3D[] bottomPoints = new Location3D[30];
        int i2 = 0;
        while (i2 < 30) {
            topPoints[i2] = goFactory.createLocation3D(ovalsTop[i2].getX(), yTop, ovalsTop[i2].getY());
            bottomPoints[i2] = goFactory.createLocation3D(ovalsBottom[i2].getX(), yBottom, ovalsBottom[i2].getY());
            int preSize = i2 - 1;
            if (i2 == 0) {
                preSize = 29;
                topPoints[preSize] = goFactory.createLocation3D(ovalsTop[preSize].getX(), yTop, ovalsTop[preSize].getY());
                bottomPoints[preSize] = goFactory.createLocation3D(ovalsBottom[preSize].getX(), yBottom, ovalsBottom[preSize].getY());
            }
            pre.setPoints3D(new Location3D[]{topPoints[i2], bottomPoints[i2], bottomPoints[preSize], topPoints[preSize]});
            pre.setBackground(f);
            pre.setDoubleSided(false);
            subCache.addPlane((PrimitiveRenderEvent)pre, 2);
            ++i2;
        }
        pre.setDoubleSided(false);
        pre.setBrightness(10.0);
        pre.setPoints3D(topPoints, yBottom < yTop);
        pre.setOutline(lia);
        pre.setBackground(f);
        subCache.addPlane((PrimitiveRenderEvent)pre, 3);
        pre.setDoubleSided(false);
        pre.setPoints3D(bottomPoints, yBottom > yTop);
        pre.setOutline(lia);
        pre.setBackground(f);
        subCache.addPlane((PrimitiveRenderEvent)pre, 3);
        if (this.isInteractivityEnabled() && !(elTriggers = this.getSeries().getTriggers()).isEmpty()) {
            StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha);
            int i3 = 0;
            while (i3 < topPoints.length) {
                InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
                iev.setCursor(this.getSeries().getCursor());
                Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)this.getSeries()), Polygon3DRenderEvent.class);
                int preSize = i3 == 0 ? 29 : i3 - 1;
                pre3d.setPoints3D(new Location3D[]{topPoints[preSize], bottomPoints[preSize], bottomPoints[i3], topPoints[i3]});
                Location panningOffset = this.getPanningOffset();
                if (this.get3DEngine().processEvent((PrimitiveRenderEvent)pre3d, panningOffset.getX(), panningOffset.getY()) != null) {
                    iev.setHotSpot((PrimitiveRenderEvent)pre3d);
                    ipr.enableInteraction(iev);
                }
                ++i3;
            }
        }
    }

    private DeferredCache createSubDeferreceCache4Tube3D(IPrimitiveRenderer ipr, Object oSource, List loaFace, Fill f) throws ChartException {
        DeferredCache subCache = this.dc.deriveNewDeferredCache();
        subCache.setAntialiasing(true);
        Location3D[] l3d = new Location3D[4];
        int k = 0;
        while (k < 4) {
            l3d[k] = goFactory.createLocation3D(0.0, 0.0, 0.0);
            ++k;
        }
        Location3D[] l0 = (Location3D[])loaFace.get(0);
        Location3D[] l1 = (Location3D[])loaFace.get(1);
        l3d[0].set(l0[0].getX(), l0[0].getY(), l0[0].getZ());
        l3d[1].set(l0[2].getX(), l0[2].getY(), l0[2].getZ());
        l3d[2].set(l1[2].getX(), l1[2].getY(), l1[2].getZ());
        l3d[3].set(l1[0].getX(), l1[0].getY(), l1[0].getZ());
        Polygon3DRenderEvent pre3dEvent = (Polygon3DRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, Polygon3DRenderEvent.class);
        pre3dEvent.setEnable(false);
        pre3dEvent.setDoubleSided(false);
        pre3dEvent.setOutline(null);
        pre3dEvent.setPoints3D(l3d);
        pre3dEvent.setBackground(f);
        Object event = this.dc.addPlane((PrimitiveRenderEvent)pre3dEvent, 2);
        if (event instanceof WrappedInstruction) {
            ((WrappedInstruction)event).setSubDeferredCache(subCache);
        }
        pre3dEvent.reset();
        return subCache;
    }

    private void renderRiserCone3D(IPrimitiveRenderer ipr, Object oSource, List loaFace, Fill f, LineAttributes lia, DataPointHints dpha) throws ChartException {
        EList elTriggers;
        if (loaFace == null || loaFace.size() != 2) {
            throw new IllegalArgumentException();
        }
        DeferredCache subCache = this.createSubDeferredCache4Cone3D(ipr, oSource, loaFace, f);
        Polygon3DRenderEvent pre = (Polygon3DRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, Polygon3DRenderEvent.class);
        Location3D[] locations = (Location3D[])loaFace.get(0);
        Point2D.Double pointA = new Point2D.Double(locations[0].getX(), locations[0].getZ());
        Point2D.Double pointB = new Point2D.Double(locations[2].getX(), locations[2].getZ());
        Point2D.Double[] ovals = Bar.computeOvalPoints(30, pointA, pointB);
        double yBottom = locations[0].getY();
        Location3D pTop = ((Location3D[])loaFace.get(1))[0];
        Location3D[] bottomPoints = new Location3D[30];
        int i = 0;
        while (i < 30) {
            bottomPoints[i] = goFactory.createLocation3D(ovals[i].getX(), yBottom, ovals[i].getY());
            int preSize = i - 1;
            if (i == 0) {
                preSize = 29;
                bottomPoints[preSize] = goFactory.createLocation3D(ovals[preSize].getX(), yBottom, ovals[preSize].getY());
            }
            if (pTop.getY() - yBottom > 0.0) {
                pre.setPoints3D(new Location3D[]{bottomPoints[i], bottomPoints[preSize], pTop});
            } else {
                pre.setPoints3D(new Location3D[]{bottomPoints[i], pTop, bottomPoints[preSize]});
            }
            pre.setBackground(f);
            pre.setDoubleSided(false);
            subCache.addPlane((PrimitiveRenderEvent)pre, 2);
            ++i;
        }
        pre.setDoubleSided(false);
        pre.setPoints3D(bottomPoints, pTop.getY() - yBottom < 0.0);
        pre.setOutline(lia);
        pre.setBackground(f);
        subCache.addPlane((PrimitiveRenderEvent)pre, 3);
        if (this.isInteractivityEnabled() && !(elTriggers = this.getSeries().getTriggers()).isEmpty()) {
            StructureSource iSource = WrappedStructureSource.createSeriesDataPoint((Series)this.getSeries(), (DataPointHints)dpha);
            int i2 = 0;
            while (i2 < bottomPoints.length) {
                InteractionEvent iev = this.createEvent(iSource, (List)elTriggers, ipr);
                iev.setCursor(this.getSeries().getCursor());
                Polygon3DRenderEvent pre3d = (Polygon3DRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createSeries((Series)this.getSeries()), Polygon3DRenderEvent.class);
                int preSize = i2 == 0 ? 29 : i2 - 1;
                pre3d.setPoints3D(new Location3D[]{bottomPoints[preSize], bottomPoints[i2], pTop});
                Location panningOffset = this.getPanningOffset();
                if (this.get3DEngine().processEvent((PrimitiveRenderEvent)pre3d, panningOffset.getX(), panningOffset.getY()) != null) {
                    iev.setHotSpot((PrimitiveRenderEvent)pre3d);
                    ipr.enableInteraction(iev);
                }
                ++i2;
            }
        }
    }

    private DeferredCache createSubDeferredCache4Cone3D(IPrimitiveRenderer ipr, Object oSource, List loaFace, Fill f) throws ChartException {
        DeferredCache subCache = this.dc.deriveNewDeferredCache();
        subCache.setAntialiasing(true);
        Location3D[] l3d = new Location3D[3];
        int k = 0;
        while (k < 3) {
            l3d[k] = goFactory.createLocation3D(0.0, 0.0, 0.0);
            ++k;
        }
        Location3D[] l0 = (Location3D[])loaFace.get(0);
        Location3D[] l1 = (Location3D[])loaFace.get(1);
        l3d[0].set(l0[0].getX(), l0[0].getY(), l0[0].getZ());
        l3d[1].set(l0[2].getX(), l0[2].getY(), l0[2].getZ());
        l3d[2].set(l1[0].getX(), l1[0].getY(), l1[0].getZ());
        Polygon3DRenderEvent pre3dEvent = (Polygon3DRenderEvent)((EventObjectCache)ipr).getEventObject(oSource, Polygon3DRenderEvent.class);
        pre3dEvent.setEnable(false);
        pre3dEvent.setDoubleSided(false);
        pre3dEvent.setOutline(null);
        pre3dEvent.setPoints3D(l3d);
        pre3dEvent.setBackground(f);
        Object event = this.dc.addPlane((PrimitiveRenderEvent)pre3dEvent, 2);
        if (event instanceof WrappedInstruction) {
            ((WrappedInstruction)event).setSubDeferredCache(subCache);
        }
        pre3dEvent.reset();
        return subCache;
    }

    private static Point2D.Double[] computeOvalPoints(int size, Point2D.Double pointA, Point2D.Double pointB) {
        Point2D.Double original = new Point2D.Double();
        original.x = (pointA.x + pointB.x) / 2.0;
        original.y = (pointA.y + pointB.y) / 2.0;
        double width = Math.abs(pointA.x - pointB.x);
        double height = Math.abs(pointA.y - pointB.y);
        return Bar.computeOvalPoints(size, width, height, original);
    }

    private static Point2D.Double[] computeOvalPoints(int size, double width, double height, Point2D.Double original) {
        if (size <= 0 || width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException();
        }
        Point2D.Double[] points = new Point2D.Double[size];
        double interval = Math.PI * 2 / (double)size;
        double dWidth = width / 2.0;
        double dHeight = height / 2.0;
        double degree = 0.0;
        int i = 0;
        while (i < size) {
            points[i] = new Point2D.Double(dWidth * Math.cos(degree) + original.x, dHeight * Math.sin(degree) + original.y);
            ++i;
            degree += interval;
        }
        return points;
    }

    private double computeBottomOvalHeightOfCone(int iSeriesIndex, double defaultThickness, Location[] loaFrontFace, double dValue, boolean isStacked) {
        double width = 0.0;
        double initialWidth = 0.0;
        StackedSizeHints ssh = this.getCurrentStackedSizeHints(iSeriesIndex);
        if (isStacked) {
            width = this.isTransposed() ? loaFrontFace[0].getY() - loaFrontFace[3].getY() : loaFrontFace[3].getX() - loaFrontFace[0].getX();
        } else {
            double d = width = this.isTransposed() ? loaFrontFace[2].getY() - loaFrontFace[0].getY() : loaFrontFace[2].getX() - loaFrontFace[0].getX();
        }
        if (dValue >= 0.0) {
            if (Double.isNaN(ssh.getInitialPositiveConeBottomWidth())) {
                ssh.setInitialPositiveConeBottomWidth(width);
            }
            initialWidth = ssh.getInitialPositiveConeBottomWidth();
        } else {
            if (Double.isNaN(ssh.getInitialNegativeConeBottomWidth())) {
                ssh.setInitialNegativeConeBottomWidth(width);
            }
            initialWidth = ssh.getInitialNegativeConeBottomWidth();
        }
        double value = defaultThickness * width / initialWidth;
        return value < 2.0 ? 2.0 : value;
    }

    private double[] computeThicknessesWithTriangle2D(Location[] loaFrontFace, double dWidth, double dHeight, double dSeriesThickness) {
        double topWidth = 0.0;
        double bottomWidth = 0.0;
        if (!this.isTransposed()) {
            if (loaFrontFace.length == 4) {
                topWidth = loaFrontFace[2].getX() - loaFrontFace[1].getX();
                bottomWidth = loaFrontFace[3].getX() - loaFrontFace[0].getX();
            } else {
                bottomWidth = loaFrontFace[2].getX() - loaFrontFace[0].getX();
            }
        } else if (loaFrontFace.length == 4) {
            topWidth = loaFrontFace[1].getY() - loaFrontFace[2].getY();
            bottomWidth = loaFrontFace[0].getY() - loaFrontFace[3].getY();
        } else {
            bottomWidth = loaFrontFace[0].getY() - loaFrontFace[2].getY();
        }
        double width = dWidth;
        if (this.isTransposed()) {
            width = dHeight;
        }
        double topThickness = topWidth / width * dSeriesThickness;
        double bottomThickness = bottomWidth / width * dSeriesThickness;
        return new double[]{topThickness, bottomThickness};
    }

    private void adjustLocationsWithTriangle2D(Location[] loaFrontFace, double dTopThickness, double dBottomThickness, double dSeriesThickness) {
        double topOffset = (dSeriesThickness - dTopThickness) / 2.0;
        double bottomOffset = (dSeriesThickness - dBottomThickness) / 2.0;
        if (loaFrontFace.length == 4) {
            loaFrontFace[0].setX(loaFrontFace[0].getX() + bottomOffset);
            loaFrontFace[0].setY(loaFrontFace[0].getY() - bottomOffset);
            loaFrontFace[1].setX(loaFrontFace[1].getX() + topOffset);
            loaFrontFace[1].setY(loaFrontFace[1].getY() - topOffset);
            loaFrontFace[2].setX(loaFrontFace[2].getX() + topOffset);
            loaFrontFace[2].setY(loaFrontFace[2].getY() - topOffset);
            loaFrontFace[3].setX(loaFrontFace[3].getX() + bottomOffset);
            loaFrontFace[3].setY(loaFrontFace[3].getY() - bottomOffset);
        } else {
            loaFrontFace[0].setX(loaFrontFace[0].getX() + bottomOffset);
            loaFrontFace[0].setY(loaFrontFace[0].getY() - bottomOffset);
            loaFrontFace[1].setX(loaFrontFace[1].getX() + topOffset);
            loaFrontFace[1].setY(loaFrontFace[1].getY() - topOffset);
            loaFrontFace[2].setX(loaFrontFace[2].getX() + bottomOffset);
            loaFrontFace[2].setY(loaFrontFace[2].getY() - bottomOffset);
        }
    }

    private double[] computeCorrectThicknessesWithTriangle2D(int nSides, int nCurrentSide, double dTopThickness, double dBottomThickness) {
        double[] thicknesses = new double[]{dTopThickness, dBottomThickness};
        if (nSides == 3) {
            switch (nCurrentSide) {
                case 0: {
                    break;
                }
                case 1: {
                    thicknesses[0] = dBottomThickness;
                    thicknesses[1] = dTopThickness;
                    break;
                }
                case 2: {
                    thicknesses[0] = dBottomThickness;
                    thicknesses[1] = dBottomThickness;
                }
            }
        } else if (nSides == 4) {
            switch (nCurrentSide) {
                case 0: {
                    break;
                }
                case 1: {
                    thicknesses[0] = dTopThickness;
                    thicknesses[1] = dTopThickness;
                    break;
                }
                case 2: {
                    thicknesses[0] = dBottomThickness;
                    thicknesses[1] = dTopThickness;
                    break;
                }
                case 3: {
                    thicknesses[0] = dBottomThickness;
                    thicknesses[1] = dBottomThickness;
                }
            }
        }
        return thicknesses;
    }

    private static class BarAxisIdLookup {
        private final int barAxisId;
        private final int barAxisCount;

        public BarAxisIdLookup(ChartWithAxes cwa, Axis curAxis) {
            Axis[] axs = cwa.getOrthogonalAxes(cwa.getBaseAxes()[0], true);
            int count = 0;
            int id = 0;
            Axis[] axisArray = axs;
            int n = axs.length;
            int n2 = 0;
            while (n2 < n) {
                SeriesDefinition sd;
                Axis axis = axisArray[n2];
                if (axis.isSideBySide() && axis.getSeriesDefinitions().size() > 0 && (sd = (SeriesDefinition)axis.getSeriesDefinitions().get(0)).getDesignTimeSeries() instanceof BarSeries) {
                    if (curAxis == axis) {
                        id = count;
                    }
                    ++count;
                }
                ++n2;
            }
            if (count > 1 && curAxis.isSideBySide()) {
                this.barAxisId = id;
                this.barAxisCount = count;
            } else {
                this.barAxisId = 0;
                this.barAxisCount = 1;
            }
        }

        public int getCount() {
            return this.barAxisCount;
        }

        public int getId() {
            return this.barAxisId;
        }
    }

    public static class StackedSizeHints {
        public double fdLastPositiveBottom = Double.NaN;
        public double fdRemainedPositiveTotal = Double.NaN;
        public double fdLastNegativeBottom = Double.NaN;
        public double fdRemainedNegativeTotal = Double.NaN;
        private double fdInitialPositiveConeBottomWidth = Double.NaN;
        private double fdInitialNegativeConeBottomWidth = Double.NaN;
        private Bounds fbInitialTriangleBounds = null;

        public double getLastPositiveBottom() {
            return this.fdLastPositiveBottom;
        }

        public void setLastPositiveBottom(double fdPositiveDelta) {
            this.fdLastPositiveBottom = fdPositiveDelta;
        }

        public double getRemainedPositiveTotal() {
            return this.fdRemainedPositiveTotal;
        }

        public void setRemainedPositiveTotal(double fdRemainedPositiveTotal) {
            this.fdRemainedPositiveTotal = fdRemainedPositiveTotal;
        }

        public double getLastNegativeBottom() {
            return this.fdLastNegativeBottom;
        }

        public void setLastNegativeBottom(double fdNegativeDelta) {
            this.fdLastNegativeBottom = fdNegativeDelta;
        }

        public double getRemainedNegativeTotal() {
            return this.fdRemainedNegativeTotal;
        }

        public void setRemainedNegativeTotal(double fdRemainedNegativeTotal) {
            this.fdRemainedNegativeTotal = fdRemainedNegativeTotal;
        }

        public double getInitialPositiveConeBottomWidth() {
            return this.fdInitialPositiveConeBottomWidth;
        }

        public void setInitialPositiveConeBottomWidth(double dInitialPositiveConeBottomWidth) {
            this.fdInitialPositiveConeBottomWidth = dInitialPositiveConeBottomWidth;
        }

        public double getInitialNegativeConeBottomWidth() {
            return this.fdInitialNegativeConeBottomWidth;
        }

        public void setInitialNegativeConeBottomWidth(double dInitialNegativeConeBottomWidth) {
            this.fdInitialNegativeConeBottomWidth = dInitialNegativeConeBottomWidth;
        }

        public Bounds getInitialBounds() {
            return this.fbInitialTriangleBounds;
        }

        public void setInitialBounds(Bounds initialBounds) {
            this.fbInitialTriangleBounds = initialBounds;
        }
    }
}

