/*
 * Decompiled with CFR 0.152.
 */
package hiro.yoshioka.csveditor;

import hiro.yoshioka.csveditor.CSVRDHView;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CSVEditor
extends FormEditor
implements IResourceChangeListener {
    private CSVRDHView csv_table_editor;
    private int mTextPageIndex;
    private TextEditor mTextEditor;
    private boolean mIsCreatingPage = false;
    private static String BROWSER_ID = "yonsama";
    private IDocument mDocument;
    QualifiedName qname = new QualifiedName("yonsama", String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "_current_page");

    public CSVEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void onDocumentChanged(DocumentEvent event) {
        System.out.println("docChanged " + event);
    }

    protected void addPages() {
        this.createAndroidPages();
        this.selectDefaultPage(null);
    }

    protected void createAndroidPages() {
        this.mIsCreatingPage = true;
        this.createPage0();
        this.createTextEditor();
        this.createUndoRedoActions();
        this.mIsCreatingPage = false;
    }

    public boolean isCreatingPages() {
        return this.mIsCreatingPage;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            IFile file = fileInput.getFile();
            this.setPartName(String.format("%1$s", file.getName()));
        }
    }

    private void createUndoRedoActions() {
        IActionBars bars = this.getEditorSite().getActionBars();
        if (bars != null) {
            IAction action = this.mTextEditor.getAction(ActionFactory.UNDO.getId());
            bars.setGlobalActionHandler(ActionFactory.UNDO.getId(), action);
            action = this.mTextEditor.getAction(ActionFactory.REDO.getId());
            bars.setGlobalActionHandler(ActionFactory.REDO.getId(), action);
            bars.updateActionBars();
        }
    }

    protected void selectDefaultPage(String defaultPageId) {
        if (defaultPageId == null && this.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            try {
                String pageId = file.getPersistentProperty(this.qname);
                if (pageId != null) {
                    defaultPageId = pageId;
                }
            }
            catch (CoreException coreException) {}
        }
        if (defaultPageId != null) {
            try {
                this.setActivePage(Integer.parseInt(defaultPageId));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void removePages() {
        int count = this.getPageCount();
        int i = count - 1;
        while (i >= 0) {
            this.removePage(i);
            --i;
        }
    }

    public IFormPage setActivePage(String pageId) {
        System.out.println("pageId=" + pageId);
        if (pageId.equals("editor_part")) {
            super.setActivePage(this.mTextPageIndex);
            return null;
        }
        return super.setActivePage(pageId);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        System.out.println("nowPage=" + newPageIndex + "/" + this.mIsCreatingPage);
        if (this.mIsCreatingPage) {
            return;
        }
        if (newPageIndex == 0) {
            this.csv_table_editor.refreshFromString(this.getDocument().get());
        } else {
            String newInput = this.csv_table_editor.getInputString();
            if (!newInput.equals(this.mDocument.get())) {
                this.mDocument.set(newInput);
            }
        }
        System.out.println("ei=" + this.getEditorInput());
        if (this.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            try {
                file.setPersistentProperty(this.qname, Integer.toString(newPageIndex));
            }
            catch (CoreException coreException) {}
        }
    }

    void createPage0() {
        try {
            this.csv_table_editor = new CSVRDHView();
            int index = this.addPage((IEditorPart)this.csv_table_editor, this.getEditorInput());
            this.setPageText(index, this.csv_table_editor.getTitle());
            this.csv_table_editor.refreshFromEditorInput();
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    public IFile getFile() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)this.getEditorInput()).getFile();
        }
        return null;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.commitPages(true);
        this.getEditor(this.mTextPageIndex).doSave(monitor);
    }

    public void doSaveAs() {
        this.commitPages(true);
        IEditorPart editor = this.getEditor(this.mTextPageIndex);
        editor.doSaveAs();
        this.setPageText(this.mTextPageIndex, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void commitPages(boolean onSave) {
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                IFormPage form_page;
                IManagedForm managed_form;
                Object page = this.pages.get(i);
                if (page != null && page instanceof IFormPage && (managed_form = (form_page = (IFormPage)page).getManagedForm()) != null && managed_form.isDirty()) {
                    managed_form.commit(onSave);
                }
                ++i;
            }
        }
    }

    public final IHyperlinkListener createHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                super.linkActivated(e);
                String link = e.data.toString();
                if (link.startsWith("http") || link.startsWith("file:/")) {
                    CSVEditor.this.openLinkInBrowser(link);
                } else if (link.startsWith("page:")) {
                    CSVEditor.this.setActivePage(link.substring(5));
                }
            }
        };
    }

    private void openLinkInBrowser(String link) {
        try {
            IWorkbenchBrowserSupport wbs = WorkbenchBrowserSupport.getInstance();
            wbs.createBrowser(BROWSER_ID).openURL(new URL(link));
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    private void createTextEditor() {
        try {
            int index;
            this.mTextEditor = new TextEditor();
            this.mTextPageIndex = index = this.addPage((IEditorPart)this.mTextEditor, this.getEditorInput());
            this.setPageText(index, this.mTextEditor.getTitle());
            IDocumentProvider provider = this.mTextEditor.getDocumentProvider();
            this.mDocument = provider.getDocument((Object)this.getEditorInput());
            this.mDocument.addDocumentListener(new IDocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    CSVEditor.this.onDocumentChanged(event);
                }

                public void documentAboutToBeChanged(DocumentEvent event) {
                }
            });
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Android Text Editor Error", null, (IStatus)e.getStatus());
        }
    }

    public IDocument getDocument() {
        return this.mDocument;
    }

    public IProject getProject() {
        FileEditorInput fileInput;
        IFile inputFile;
        IEditorInput input;
        if (this.mTextEditor != null && (input = this.mTextEditor.getEditorInput()) instanceof FileEditorInput && (inputFile = (fileInput = (FileEditorInput)input).getFile()) != null) {
            return inputFile.getProject();
        }
        return null;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] pages = CSVEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)CSVEditor.this.mTextEditor.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(CSVEditor.this.mTextEditor.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }
}

