/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.wrapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.fisshplate.wrapper.SheetWrapper;

public class WorkbookWrapper {
    private HSSFWorkbook hssfWorkbook;
    private List sheetList = new ArrayList();

    public WorkbookWrapper(HSSFWorkbook workbook) {
        this.hssfWorkbook = workbook;
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            this.sheetList.add(new SheetWrapper(workbook.getSheetAt(i), this, i));
        }
    }

    public HSSFWorkbook getHSSFWorkbook() {
        return this.hssfWorkbook;
    }

    public SheetWrapper getSheetAt(int index) {
        return (SheetWrapper)this.sheetList.get(index);
    }

    public SheetWrapper getSheetByName(String sheetName) {
        for (int i = 0; i < this.sheetList.size(); ++i) {
            SheetWrapper sheet = (SheetWrapper)this.sheetList.get(i);
            String name = sheet.getSheetName();
            if (!name.equals(sheetName)) continue;
            return sheet;
        }
        return null;
    }

    public int getSheetCount() {
        return this.sheetList.size();
    }
}

