/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.wrapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.seasar.fisshplate.wrapper.RowWrapper;
import org.seasar.fisshplate.wrapper.WorkbookWrapper;

public class SheetWrapper {
    private HSSFSheet hssfSheet;
    private WorkbookWrapper workbook;
    private List rowList = new ArrayList();
    private int sheetIndex;

    public SheetWrapper(HSSFSheet sheet, WorkbookWrapper workbook, int sheetIndex) {
        this.workbook = workbook;
        this.hssfSheet = sheet;
        this.sheetIndex = sheetIndex;
        for (int i = 0; i <= sheet.getLastRowNum(); ++i) {
            this.rowList.add(new RowWrapper(sheet.getRow(i), this));
        }
    }

    public HSSFSheet getHSSFSheet() {
        return this.hssfSheet;
    }

    public WorkbookWrapper getWorkbook() {
        return this.workbook;
    }

    public RowWrapper getRow(int index) {
        return (RowWrapper)this.rowList.get(index);
    }

    public int getRowCount() {
        return this.rowList.size();
    }

    public int getSheetIndex() {
        return this.sheetIndex;
    }

    public String getSheetName() {
        return this.workbook.getHSSFWorkbook().getSheetName(this.sheetIndex);
    }

    public void removeRow(int i) {
        RowWrapper row = this.getRow(i);
        this.hssfSheet.removeRow(row.getHSSFRow());
        this.rowList.remove(i);
    }

    public void prepareForMerge() {
        this.removeAllRow();
        this.removeAllMergedRegion();
    }

    private void removeAllRow() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            HSSFRow hssfRow = this.getRow(i).getHSSFRow();
            if (hssfRow == null) continue;
            this.hssfSheet.removeRow(hssfRow);
        }
    }

    private void removeAllMergedRegion() {
        int i = 0;
        while (0 < this.hssfSheet.getNumMergedRegions()) {
            this.hssfSheet.removeMergedRegion(0);
            ++i;
        }
    }
}

