/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.seasar.fisshplate.context.FPContext;
import org.seasar.fisshplate.context.PageContext;
import org.seasar.fisshplate.core.element.Root;
import org.seasar.fisshplate.core.parser.FPParser;
import org.seasar.fisshplate.core.parser.RowParser;
import org.seasar.fisshplate.exception.FPMergeException;
import org.seasar.fisshplate.exception.FPParseException;
import org.seasar.fisshplate.util.InputStreamUtil;
import org.seasar.fisshplate.wrapper.SheetWrapper;
import org.seasar.fisshplate.wrapper.WorkbookWrapper;

public class FPTemplate {
    private FPParser parser = new FPParser();

    public void addRowParser(RowParser rowParser) {
        this.parser.addRowParser(rowParser);
    }

    public HSSFWorkbook process(String templateName, Map data) throws FPParseException, FPMergeException, IOException {
        InputStream is = InputStreamUtil.getResourceAsStream(templateName);
        HSSFWorkbook workbook = new HSSFWorkbook(new POIFSFileSystem(is));
        InputStreamUtil.close(is);
        return this.process(workbook, data);
    }

    public HSSFWorkbook process(InputStream is, Map data) throws FPParseException, FPMergeException, IOException {
        return this.process(new HSSFWorkbook(new POIFSFileSystem(is)), data);
    }

    public HSSFWorkbook process(HSSFWorkbook hssfWorkbook, Map data) throws FPParseException, FPMergeException {
        WorkbookWrapper workbook = new WorkbookWrapper(hssfWorkbook);
        for (int i = 0; i < workbook.getSheetCount(); ++i) {
            SheetWrapper sheet = workbook.getSheetAt(i);
            if (sheet.getRowCount() < 1) continue;
            Root root = this.parser.parse(sheet);
            sheet.prepareForMerge();
            if (data == null) {
                data = new HashMap<String, PageContext>();
            }
            FPContext context = new FPContext(sheet.getHSSFSheet(), data);
            PageContext pageContext = new PageContext();
            data.put("page", pageContext);
            root.merge(context);
        }
        return hssfWorkbook;
    }
}

