/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.parser.handler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.seasar.fisshplate.core.element.AbstractCell;
import org.seasar.fisshplate.core.element.El;
import org.seasar.fisshplate.core.element.GenericCell;
import org.seasar.fisshplate.core.element.NullCell;
import org.seasar.fisshplate.core.element.Suspend;
import org.seasar.fisshplate.core.element.TemplateElement;
import org.seasar.fisshplate.core.parser.CellParser;
import org.seasar.fisshplate.core.parser.LinkParser;
import org.seasar.fisshplate.core.parser.PictureParser;
import org.seasar.fisshplate.wrapper.CellWrapper;

public class CellParserHandler {
    private static final Pattern patEl = Pattern.compile("\\$\\{[^\\$\\{\\}]+\\}");
    private static final Pattern patSuspend = Pattern.compile("^\\s*#suspend\\s+(.*\\$\\{[^\\$\\{\\}]+\\}.*)");
    private static CellParser[] builtInCellParser = new CellParser[]{new PictureParser(), new LinkParser()};

    public TemplateElement getElement(CellWrapper cell) {
        if (cell.getHSSFCell() == null) {
            return new NullCell();
        }
        String value = this.getCellValue(cell);
        if (value == null) {
            return new GenericCell(cell);
        }
        AbstractCell cellElem = this.getElementByParsers(cell, value);
        Matcher mat = patEl.matcher(value);
        if (mat.find()) {
            return this.createEl(cellElem, value);
        }
        return cellElem;
    }

    private AbstractCell getElementByParsers(CellWrapper cell, String value) {
        CellParser parser;
        AbstractCell cellElem = null;
        for (int i = 0; i < builtInCellParser.length && (cellElem = (parser = builtInCellParser[i]).getElement(cell, value)) == null; ++i) {
        }
        if (cellElem == null) {
            cellElem = new GenericCell(cell);
        }
        return cellElem;
    }

    private String getCellValue(CellWrapper cell) {
        HSSFCell hssfCell = cell.getHSSFCell();
        String value = null;
        if (hssfCell.getCellType() == 1) {
            value = hssfCell.getRichStringCellValue().getString();
        } else if (hssfCell.getCellType() == 2) {
            value = hssfCell.getCellFormula();
        }
        return value;
    }

    private TemplateElement createEl(AbstractCell cellElem, String value) {
        Matcher mat = patSuspend.matcher(value);
        if (mat.find()) {
            cellElem.setCellValue(mat.group(1));
            El el = new El(cellElem);
            return new Suspend(el);
        }
        return new El(cellElem);
    }
}

