/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.fisshplate.core.element.WhileBlock;
import org.seasar.fisshplate.core.parser.FPParser;
import org.seasar.fisshplate.core.parser.RowParser;
import org.seasar.fisshplate.exception.FPParseException;
import org.seasar.fisshplate.wrapper.CellWrapper;
import org.seasar.fisshplate.wrapper.RowWrapper;

public class WhileParser
implements RowParser {
    private static final Pattern pat = Pattern.compile("^\\s*#while\\s+(.+)");

    public boolean process(CellWrapper cell, FPParser parser) throws FPParseException {
        String value = cell.getStringValue();
        Matcher mat = pat.matcher(value);
        if (!mat.find()) {
            return false;
        }
        String condition = mat.group(1);
        RowWrapper row = cell.getRow();
        WhileBlock block = new WhileBlock(row, condition);
        parser.addBlockElement(block);
        return true;
    }
}

