/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.fisshplate.core.element.AbstractBlock;
import org.seasar.fisshplate.core.element.IteratorBlock;
import org.seasar.fisshplate.core.parser.FPParser;
import org.seasar.fisshplate.core.parser.RowParser;
import org.seasar.fisshplate.exception.FPParseException;
import org.seasar.fisshplate.wrapper.CellWrapper;
import org.seasar.fisshplate.wrapper.RowWrapper;

public class IteratorBlockParser
implements RowParser {
    private static final Pattern patIterator = Pattern.compile("^\\s*#foreach\\s+(\\S+)\\s*:\\s*(\\S+)(\\s+index=(\\S+))*(\\s+max=(\\S+))*\\s*$");

    public boolean process(CellWrapper cell, FPParser parser) throws FPParseException {
        String value = cell.getStringValue();
        Matcher mat = patIterator.matcher(value);
        if (!mat.find()) {
            return false;
        }
        AbstractBlock block = this.buildElement(cell, mat);
        parser.addBlockElement(block);
        return true;
    }

    private AbstractBlock buildElement(CellWrapper cell, Matcher mat) throws FPParseException {
        RowWrapper row = cell.getRow();
        String varName = mat.group(1);
        String iteratorName = mat.group(2);
        String indexName = mat.group(4);
        String maxString = mat.group(6);
        int max = 0;
        if (maxString != null) {
            try {
                max = Integer.parseInt(maxString);
            }
            catch (NumberFormatException ex) {
                throw new FPParseException("EFP00008", row);
            }
        }
        return new IteratorBlock(row, varName, iteratorName, indexName, max);
    }
}

