/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.parser;

import java.util.Stack;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.seasar.fisshplate.core.element.AbstractBlock;
import org.seasar.fisshplate.core.element.Root;
import org.seasar.fisshplate.core.element.Row;
import org.seasar.fisshplate.core.element.TemplateElement;
import org.seasar.fisshplate.core.parser.RowParser;
import org.seasar.fisshplate.core.parser.handler.CellParserHandler;
import org.seasar.fisshplate.core.parser.handler.RowParserHandler;
import org.seasar.fisshplate.exception.FPParseException;
import org.seasar.fisshplate.wrapper.CellWrapper;
import org.seasar.fisshplate.wrapper.RowWrapper;
import org.seasar.fisshplate.wrapper.SheetWrapper;

public class FPParser {
    private Root rootElement;
    private Stack blockStack = new Stack();
    private RowParserHandler rowParserHandler = new RowParserHandler();
    private CellParserHandler cellParserHandler = new CellParserHandler();

    public Root parse(SheetWrapper sheet) throws FPParseException {
        this.rootElement = new Root();
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            this.parseRow(sheet.getRow(i));
        }
        if (this.blockStack.size() > 0) {
            throw new FPParseException("EFP00001", new Object[]{"?"});
        }
        return this.rootElement;
    }

    public Root getRoot() {
        return this.rootElement;
    }

    private void parseRow(RowWrapper row) throws FPParseException {
        if (row.isNullRow()) {
            this.createRowElement(row);
            return;
        }
        for (int i = 0; i < row.getCellCount(); ++i) {
            CellWrapper cell = row.getCell(i);
            if (!this.isCellParsable(cell) || !this.rowParserHandler.parse(cell, this)) continue;
            return;
        }
        this.createRowElement(row);
    }

    private void createRowElement(RowWrapper row) {
        Row rowElem = new Row(row, this.rootElement, this.cellParserHandler);
        this.addTemplateElement(rowElem);
    }

    private boolean isCellParsable(CellWrapper cell) {
        if (cell == null) {
            return false;
        }
        HSSFCell hssfCell = cell.getHSSFCell();
        return hssfCell != null && hssfCell.getCellType() == 1;
    }

    public void addBlockElement(AbstractBlock block) {
        if (!this.isBlockStackBlank()) {
            AbstractBlock parentBlock = (AbstractBlock)this.blockStack.lastElement();
            parentBlock.addChild(block);
        }
        this.pushBlockToStack(block);
    }

    public void pushBlockToStack(AbstractBlock block) {
        this.blockStack.push(block);
    }

    public void addTemplateElement(TemplateElement elem) {
        if (!this.isBlockStackBlank()) {
            AbstractBlock block = (AbstractBlock)this.blockStack.lastElement();
            block.addChild(elem);
        } else {
            this.rootElement.addBody(elem);
        }
    }

    public boolean isBlockStackBlank() {
        return this.blockStack.size() < 1;
    }

    public AbstractBlock popFromBlockStack() {
        return (AbstractBlock)this.blockStack.pop();
    }

    public AbstractBlock getLastElementFromStack() {
        return (AbstractBlock)this.blockStack.lastElement();
    }

    public void addRowParser(RowParser parser) {
        this.rowParserHandler.addRowParser(parser);
    }
}

