/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.fisshplate.core.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.fisshplate.core.element.AbstractBlock;
import org.seasar.fisshplate.core.element.ElseBlock;
import org.seasar.fisshplate.core.element.ElseIfBlock;
import org.seasar.fisshplate.core.element.PageFooterBlock;
import org.seasar.fisshplate.core.element.PageHeaderBlock;
import org.seasar.fisshplate.core.element.Root;
import org.seasar.fisshplate.core.parser.FPParser;
import org.seasar.fisshplate.core.parser.RowParser;
import org.seasar.fisshplate.exception.FPParseException;
import org.seasar.fisshplate.wrapper.CellWrapper;

public class EndParser
implements RowParser {
    private static final Pattern patEnd = Pattern.compile("(^\\s*#end\\s*$|#pageHeaderEnd|#pageFooterEnd)");
    static /* synthetic */ Class class$org$seasar$fisshplate$core$element$IfBlock;

    public boolean process(CellWrapper cell, FPParser parser) throws FPParseException {
        String value = cell.getStringValue();
        Matcher mat = patEnd.matcher(value);
        if (!mat.find()) {
            return false;
        }
        this.checkBlockStack(cell, parser);
        this.processEnd(parser);
        return true;
    }

    private void checkBlockStack(CellWrapper cell, FPParser parser) throws FPParseException {
        if (parser.isBlockStackBlank()) {
            throw new FPParseException("EFP00001", cell.getRow());
        }
    }

    private void processEnd(FPParser parser) throws FPParseException {
        Root root = parser.getRoot();
        AbstractBlock block = parser.popFromBlockStack();
        Class<?> clazz = block.getClass();
        if (clazz == ElseBlock.class || clazz == ElseIfBlock.class) {
            block = this.getIfBlockFromStack(parser);
        } else {
            if (clazz == PageHeaderBlock.class) {
                root.setPageHeader(block);
                return;
            }
            if (clazz == PageFooterBlock.class) {
                root.setPageFooter(block);
                return;
            }
        }
        if (parser.isBlockStackBlank()) {
            root.addBody(block);
        }
    }

    private AbstractBlock getIfBlockFromStack(FPParser parser) {
        Object block = null;
        while (block == null || block.getClass() != (class$org$seasar$fisshplate$core$element$IfBlock == null ? EndParser.class$("org.seasar.fisshplate.core.element.IfBlock") : class$org$seasar$fisshplate$core$element$IfBlock)) {
            block = parser.popFromBlockStack();
        }
        return block;
    }
}

