/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.IToggleBreakpointsTargetManagerListener;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleBreakpointsTargetManager {
    public static String DEFAULT_TOGGLE_TARGET_ID = "default";
    private static Set DEFAULT_TOGGLE_TARGET_ID_SET = new TreeSet();
    public static final String PREF_TARGETS = "preferredTargets";
    private static ToggleBreakpointsTargetManager fgSingleton;
    private Map fKnownFactories;
    private Map fPreferredTargets;
    private Map fFactoriesByTargetID = new HashMap();
    private ListenerList fChangedListners = new ListenerList();
    static /* synthetic */ Class class$0;

    static {
        DEFAULT_TOGGLE_TARGET_ID_SET.add(DEFAULT_TOGGLE_TARGET_ID);
    }

    public static ToggleBreakpointsTargetManager getDefault() {
        if (fgSingleton == null) {
            fgSingleton = new ToggleBreakpointsTargetManager();
        }
        return fgSingleton;
    }

    private void initializeFactories() {
        this.fKnownFactories = new LinkedHashMap();
        this.fKnownFactories.put(DEFAULT_TOGGLE_TARGET_ID, new ToggleBreakpointsTargetAdapterFactory());
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), "toggleBreakpointsTargetFactories");
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute("id");
            if (id != null && id.length() != 0) {
                if (this.fKnownFactories.containsKey(id)) {
                    DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "org.eclipse.debug.ui.toggleBreakpointsTargetFactory extension failed to load breakpoint toggle target because the specified id is already registered.  Specified ID is: " + id, null));
                } else {
                    this.fKnownFactories.put(id, new ToggleTargetFactory(elements[i]));
                }
            } else {
                DebugUIPlugin.log((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "org.eclipse.debug.ui.toggleBreakpointsTargetFactory extension failed to load breakpoint toggle target because the specified id is empty.", null));
            }
            ++i;
        }
        System.setProperty("org.eclipse.debug.ui.breakpoints.toggleFactoriesUsed", this.fKnownFactories.size() > 1 ? "true" : "false");
    }

    private Set getEnabledFactories(IWorkbenchPart part, ISelection selection) {
        if (this.fKnownFactories == null) {
            this.initializeFactories();
        }
        HashSet<IToggleBreakpointsTargetFactory> set = new HashSet<IToggleBreakpointsTargetFactory>();
        Iterator itr = this.fKnownFactories.keySet().iterator();
        while (itr.hasNext()) {
            String id = (String)itr.next();
            IToggleBreakpointsTargetFactory factory = (IToggleBreakpointsTargetFactory)this.fKnownFactories.get(id);
            if (factory instanceof ToggleTargetFactory && ((ToggleTargetFactory)factory).isEnabled(part, selection)) {
                set.add(factory);
                continue;
            }
            if (!(factory instanceof ToggleBreakpointsTargetAdapterFactory) || !((ToggleBreakpointsTargetAdapterFactory)factory).isEnabled(part, selection)) continue;
            set.add(factory);
        }
        return set;
    }

    private Set getEnabledTargetIDs(Collection factoriesToQuery, IWorkbenchPart part, ISelection selection) {
        TreeSet<String> idsForSelection = new TreeSet<String>();
        Iterator factoriesItr = factoriesToQuery.iterator();
        while (factoriesItr.hasNext()) {
            IToggleBreakpointsTargetFactory factory = (IToggleBreakpointsTargetFactory)factoriesItr.next();
            Iterator targetIDsItr = factory.getToggleTargets(part, selection).iterator();
            while (targetIDsItr.hasNext()) {
                String targetID = (String)targetIDsItr.next();
                this.fFactoriesByTargetID.put(targetID, factory);
                idsForSelection.add(targetID);
            }
        }
        return idsForSelection;
    }

    public Set getEnabledToggleBreakpointsTargetIDs(IWorkbenchPart part, ISelection selection) {
        return this.getEnabledTargetIDs(this.getEnabledFactories(part, selection), part, selection);
    }

    public String getPreferredToggleBreakpointsTargetID(IWorkbenchPart part, ISelection selection) {
        Set factories = this.getEnabledFactories(part, selection);
        Set possibleIDs = this.getEnabledTargetIDs(factories, part, selection);
        return this.chooseToggleTargetIDInSet(possibleIDs, part, selection);
    }

    public IToggleBreakpointsTarget getToggleBreakpointsTarget(IWorkbenchPart part, ISelection selection) {
        String id = this.getPreferredToggleBreakpointsTargetID(part, selection);
        IToggleBreakpointsTargetFactory factory = (IToggleBreakpointsTargetFactory)this.fFactoriesByTargetID.get(id);
        if (factory != null) {
            if (DEFAULT_TOGGLE_TARGET_ID.equals(id)) {
                return ((ToggleBreakpointsTargetAdapterFactory)factory).createDefaultToggleTarget(part, selection);
            }
            return factory.createToggleTarget(id);
        }
        return null;
    }

    public String getToggleBreakpointsTargetName(String id) {
        IToggleBreakpointsTargetFactory factory = (IToggleBreakpointsTargetFactory)this.fFactoriesByTargetID.get(id);
        if (factory != null) {
            return factory.getToggleTargetName(id);
        }
        return null;
    }

    public String getToggleBreakpointsTargetDescription(String id) {
        IToggleBreakpointsTargetFactory factory = (IToggleBreakpointsTargetFactory)this.fFactoriesByTargetID.get(id);
        if (factory != null) {
            return factory.getToggleTargetDescription(id);
        }
        return null;
    }

    public void addChangedListener(IToggleBreakpointsTargetManagerListener listener) {
        this.fChangedListners.add((Object)listener);
    }

    public void removeChangedListener(IToggleBreakpointsTargetManagerListener listener) {
        this.fChangedListners.remove((Object)listener);
    }

    private void storePreferredTargets() {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this.fPreferredTargets.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Iterator setIter = ((Set)entry.getKey()).iterator();
            while (setIter.hasNext()) {
                String currentID = (String)setIter.next();
                buffer.append(currentID);
                buffer.append(',');
            }
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append(':');
            buffer.append(entry.getValue());
            buffer.append('|');
        }
        DebugUIPlugin.getDefault().getPluginPreferences().setValue(PREF_TARGETS, buffer.toString());
    }

    private void loadPreferredTargets() {
        this.fPreferredTargets = new HashMap();
        String preferenceValue = DebugUIPlugin.getDefault().getPluginPreferences().getString(PREF_TARGETS);
        StringTokenizer entryTokenizer = new StringTokenizer(preferenceValue, "|");
        while (entryTokenizer.hasMoreTokens()) {
            String token = entryTokenizer.nextToken();
            int valueStart = token.indexOf(58);
            StringTokenizer keyTokenizer = new StringTokenizer(token.substring(0, valueStart), ",");
            TreeSet<String> keys = new TreeSet<String>();
            while (keyTokenizer.hasMoreTokens()) {
                keys.add(keyTokenizer.nextToken());
            }
            this.fPreferredTargets.put(keys, token.substring(valueStart + 1));
        }
    }

    public void setPreferredTarget(Set possibleIDs, String preferredID) {
        String currentKey;
        if (possibleIDs == null) {
            return;
        }
        if (this.fKnownFactories == null) {
            this.initializeFactories();
        }
        if (this.fPreferredTargets == null) {
            this.loadPreferredTargets();
        }
        if ((currentKey = (String)this.fPreferredTargets.get(possibleIDs)) == null || !currentKey.equals(preferredID)) {
            this.fPreferredTargets.put(possibleIDs, preferredID);
            this.storePreferredTargets();
            this.firePreferredTargetsChanged();
        }
    }

    private String getUserPreferredTarget(Set possibleTargetIDs) {
        if (this.fPreferredTargets == null) {
            this.loadPreferredTargets();
        }
        return (String)this.fPreferredTargets.get(possibleTargetIDs);
    }

    private String chooseToggleTargetIDInSet(Set possibleTargetIDs, IWorkbenchPart part, ISelection selection) {
        if (possibleTargetIDs == null || possibleTargetIDs.isEmpty()) {
            return null;
        }
        String preferredID = this.getUserPreferredTarget(possibleTargetIDs);
        if (preferredID == null) {
            Iterator possibleIDsIterator = possibleTargetIDs.iterator();
            while (preferredID == null && possibleIDsIterator.hasNext()) {
                IToggleBreakpointsTargetFactory factory = (IToggleBreakpointsTargetFactory)this.fFactoriesByTargetID.get(possibleIDsIterator.next());
                if (factory == null) continue;
                preferredID = factory.getDefaultToggleTarget(part, selection);
            }
            if (preferredID == null || !possibleTargetIDs.contains(preferredID)) {
                preferredID = (String)possibleTargetIDs.iterator().next();
            }
            this.setPreferredTarget(possibleTargetIDs, preferredID);
        }
        return preferredID;
    }

    private void firePreferredTargetsChanged() {
        Object[] listeners = this.fChangedListners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IToggleBreakpointsTargetManagerListener)listeners[i]).preferredTargetsChanged();
            ++i;
        }
    }

    private static class ToggleBreakpointsTargetAdapterFactory
    implements IToggleBreakpointsTargetFactory {
        private ToggleBreakpointsTargetAdapterFactory() {
        }

        private IAdaptable getAdaptable(IWorkbenchPart part, ISelection selection) {
            IWorkbenchPart adaptable = null;
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                if (ss.getFirstElement() instanceof IAdaptable) {
                    adaptable = (IAdaptable)ss.getFirstElement();
                }
            } else {
                adaptable = part;
            }
            return adaptable;
        }

        private boolean canGetToggleBreakpointsTarget(IAdaptable adaptable) {
            if (adaptable != null) {
                IToggleBreakpointsTarget adapter;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IToggleBreakpointsTarget)adaptable.getAdapter((Class)clazz)) == null) {
                    IAdapterManager adapterManager = Platform.getAdapterManager();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (adapterManager.hasAdapter((Object)adaptable, clazz2.getName())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        private IToggleBreakpointsTarget getToggleBreakpointsTarget(IAdaptable adaptable) {
            if (adaptable != null) {
                IToggleBreakpointsTarget adapter;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (IToggleBreakpointsTarget)adaptable.getAdapter((Class)clazz)) == null) {
                    IAdapterManager adapterManager = Platform.getAdapterManager();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (adapterManager.hasAdapter((Object)adaptable, clazz2.getName())) {
                        Class<?> clazz3 = class$0;
                        if (clazz3 == null) {
                            try {
                                clazz3 = class$0 = Class.forName("org.eclipse.debug.ui.actions.IToggleBreakpointsTarget");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        adapter = (IToggleBreakpointsTarget)adapterManager.loadAdapter((Object)adaptable, clazz3.getName());
                    }
                }
                return adapter;
            }
            return null;
        }

        public boolean isEnabled(IWorkbenchPart part, ISelection selection) {
            IAdaptable adaptable = this.getAdaptable(part, selection);
            return adaptable != null && this.canGetToggleBreakpointsTarget(adaptable);
        }

        public IToggleBreakpointsTarget createToggleTarget(String targetID) {
            return null;
        }

        public IToggleBreakpointsTarget createDefaultToggleTarget(IWorkbenchPart part, ISelection selection) {
            IAdaptable adaptable = this.getAdaptable(part, selection);
            return this.getToggleBreakpointsTarget(adaptable);
        }

        public Set getToggleTargets(IWorkbenchPart part, ISelection selection) {
            IAdaptable adaptable = this.getAdaptable(part, selection);
            if (this.canGetToggleBreakpointsTarget(adaptable)) {
                return DEFAULT_TOGGLE_TARGET_ID_SET;
            }
            return Collections.EMPTY_SET;
        }

        public String getToggleTargetName(String targetID) {
            return ActionMessages.ToggleBreakpointsTargetManager_defaultToggleTarget_name;
        }

        public String getToggleTargetDescription(String targetID) {
            return ActionMessages.ToggleBreakpointsTargetManager_defaultToggleTarget_description;
        }

        public String getDefaultToggleTarget(IWorkbenchPart part, ISelection selection) {
            return DEFAULT_TOGGLE_TARGET_ID;
        }
    }

    private static class ToggleTargetFactory
    implements IToggleBreakpointsTargetFactory {
        private IConfigurationElement fConfigElement;
        private IToggleBreakpointsTargetFactory fFactory;
        private Expression fEnablementExpression;

        public ToggleTargetFactory(IConfigurationElement configElement) {
            this.fConfigElement = configElement;
        }

        private IToggleBreakpointsTargetFactory getFactory() {
            if (this.fFactory != null) {
                return this.fFactory;
            }
            try {
                Object obj = this.fConfigElement.createExecutableExtension("class");
                if (!(obj instanceof IToggleBreakpointsTargetFactory)) {
                    throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "org.eclipse.debug.ui.toggleBreakpointsTargetFactories extension failed to load breakpoint toggle target because the specified class does not implement org.eclipse.debug.ui.actions.IToggleBreakpointsTargetFactory.  Class specified was: " + obj, null));
                }
                this.fFactory = (IToggleBreakpointsTargetFactory)obj;
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e.getStatus());
                this.fFactory = null;
            }
            return this.fFactory;
        }

        public boolean isEnabled(IWorkbenchPart part, ISelection selection) {
            boolean enabled = false;
            Expression expression = this.getEnablementExpression();
            enabled = expression != null ? this.evalEnablementExpression(part, selection, expression) : true;
            return enabled;
        }

        private IStructuredSelection getDebugContext(IWorkbenchPart part) {
            ISelection selection = DebugUITools.getDebugContextManager().getContextService(part.getSite().getWorkbenchWindow()).getActiveContext();
            if (selection instanceof IStructuredSelection) {
                return (IStructuredSelection)selection;
            }
            return StructuredSelection.EMPTY;
        }

        private boolean evalEnablementExpression(IWorkbenchPart part, ISelection selection, Expression exp) {
            if (exp != null) {
                IEvaluationContext context = DebugUIPlugin.createEvaluationContext(part);
                List debugContextList = this.getDebugContext(part).toList();
                context.addVariable("debugContext", (Object)debugContextList);
                if (selection instanceof IStructuredSelection) {
                    List selectionList = ((IStructuredSelection)selection).toList();
                    context.addVariable("selection", (Object)selectionList);
                }
                if (part instanceof IEditorPart) {
                    context.addVariable("editorInput", (Object)((IEditorPart)part).getEditorInput());
                }
                try {
                    EvaluationResult result = exp.evaluate(context);
                    if (result == EvaluationResult.TRUE) {
                        return true;
                    }
                }
                catch (CoreException coreException) {}
            }
            return false;
        }

        private Expression getEnablementExpression() {
            if (this.fEnablementExpression == null) {
                try {
                    IConfigurationElement enablement;
                    IConfigurationElement[] elements = this.fConfigElement.getChildren("enablement");
                    IConfigurationElement iConfigurationElement = enablement = elements.length > 0 ? elements[0] : null;
                    if (enablement != null) {
                        this.fEnablementExpression = ExpressionConverter.getDefault().perform(enablement);
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e.getStatus());
                    this.fEnablementExpression = null;
                }
            }
            return this.fEnablementExpression;
        }

        public IToggleBreakpointsTarget createToggleTarget(String targetID) {
            IToggleBreakpointsTargetFactory factory = this.getFactory();
            if (factory != null) {
                return factory.createToggleTarget(targetID);
            }
            return null;
        }

        public Set getToggleTargets(IWorkbenchPart part, ISelection selection) {
            IToggleBreakpointsTargetFactory factory = this.getFactory();
            if (factory != null) {
                return factory.getToggleTargets(part, selection);
            }
            return Collections.EMPTY_SET;
        }

        public String getToggleTargetName(String targetID) {
            IToggleBreakpointsTargetFactory factory = this.getFactory();
            if (factory != null) {
                return factory.getToggleTargetName(targetID);
            }
            return null;
        }

        public String getToggleTargetDescription(String targetID) {
            IToggleBreakpointsTargetFactory factory = this.getFactory();
            if (factory != null) {
                return factory.getToggleTargetDescription(targetID);
            }
            return null;
        }

        public String getDefaultToggleTarget(IWorkbenchPart part, ISelection selection) {
            IToggleBreakpointsTargetFactory factory = this.getFactory();
            if (factory != null) {
                return factory.getDefaultToggleTarget(part, selection);
            }
            return null;
        }
    }
}

