/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlArea;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import java.util.LinkedList;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class Event
extends SimpleScriptable {
    static final String KEY_CURRENT_EVENT = "Event#current";
    public static final String TYPE_SUBMIT = "submit";
    public static final String TYPE_CHANGE = "change";
    public static final String TYPE_LOAD = "load";
    public static final String TYPE_UNLOAD = "unload";
    public static final String TYPE_FOCUS = "focus";
    public static final String TYPE_FOCUS_IN = "focusin";
    public static final String TYPE_FOCUS_OUT = "focusout";
    public static final String TYPE_BLUR = "blur";
    public static final String TYPE_KEY_DOWN = "keydown";
    public static final String TYPE_KEY_PRESS = "keypress";
    public static final String TYPE_INPUT = "input";
    public static final String TYPE_KEY_UP = "keyup";
    public static final String TYPE_RESET = "reset";
    public static final String TYPE_BEFORE_UNLOAD = "beforeunload";
    public static final String TYPE_DOM_DOCUMENT_LOADED = "DOMContentLoaded";
    public static final String TYPE_PROPERTY_CHANGE = "propertychange";
    public static final String TYPE_HASH_CHANGE = "hashchange";
    public static final String TYPE_READY_STATE_CHANGE = "readystatechange";
    public static final String TYPE_ERROR = "error";
    public static final String TYPE_MESSAGE = "message";
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short CAPTURING_PHASE = 1;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short AT_TARGET = 2;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final short BUBBLING_PHASE = 3;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int ABORT = 0x400000;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int ALT_MASK = 1;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int BACK = 0x20000000;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int BLUR = 8192;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int CHANGE = 32768;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int CLICK = 64;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int CONTROL_MASK = 2;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int DBLCLICK = 128;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int DRAGDROP = 2048;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int ERROR = 0x800000;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int FOCUS = 4096;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int FORWARD = 0x8000000;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int HELP = 0x10000000;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int KEYDOWN = 256;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int KEYPRESS = 1024;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int KEYUP = 512;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int LOAD = 524288;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int LOCATE = 0x1000000;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int META_MASK = 8;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int MOUSEDOWN = 1;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int MOUSEDRAG = 32;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int MOUSEMOVE = 16;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int MOUSEOUT = 8;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int MOUSEOVER = 4;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int MOUSEUP = 2;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int MOVE = 0x2000000;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int RESET = 65536;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int RESIZE = 0x4000000;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int SCROLL = 262144;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int SELECT = 16384;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int SHIFT_MASK = 4;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int SUBMIT = 131072;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int TEXT = 0x40000000;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int UNLOAD = 0x100000;
    @JsxConstant(value={@WebBrowser(value=BrowserName.FF)})
    public static final int XFER_DONE = 0x200000;
    private Object srcElement_;
    private Object target_;
    private Object currentTarget_;
    private String type_;
    private Object keyCode_;
    private boolean shiftKey_;
    private boolean ctrlKey_;
    private boolean altKey_;
    private String propertyName_;
    private boolean stopPropagation_;
    private Object returnValue_;
    private boolean preventDefault_;
    private short eventPhase_;
    private boolean bubbles_ = true;
    private boolean cancelable_ = true;
    private final long timeStamp_ = System.currentTimeMillis();

    public Event(DomNode domNode, String type) {
        this((SimpleScriptable)domNode.getScriptObject(), type);
        this.setDomNode(domNode, false);
    }

    public Event(SimpleScriptable scriptable, String type) {
        this.srcElement_ = scriptable;
        this.target_ = scriptable;
        this.currentTarget_ = scriptable;
        this.type_ = type;
        this.setParentScope((Scriptable)scriptable);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public static Event createPropertyChangeEvent(DomNode domNode, String propertyName) {
        Event event = new Event(domNode, TYPE_PROPERTY_CHANGE);
        event.propertyName_ = propertyName;
        return event;
    }

    public Event() {
    }

    void startFire() {
        LinkedList<Event> events = (LinkedList<Event>)Context.getCurrentContext().getThreadLocal((Object)KEY_CURRENT_EVENT);
        if (events == null) {
            events = new LinkedList<Event>();
            Context.getCurrentContext().putThreadLocal((Object)KEY_CURRENT_EVENT, events);
        }
        events.add(this);
    }

    void endFire() {
        ((LinkedList)Context.getCurrentContext().getThreadLocal((Object)KEY_CURRENT_EVENT)).removeLast();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getSrcElement() {
        return this.srcElement_;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setSrcElement(Object srcElement) {
        this.srcElement_ = srcElement;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public Object getTarget() {
        return this.target_;
    }

    public void setTarget(Object target) {
        this.target_ = target;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public Object getCurrentTarget() {
        return this.currentTarget_;
    }

    public void setCurrentTarget(Scriptable target) {
        this.currentTarget_ = target;
    }

    @JsxGetter
    public String getType() {
        return this.type_;
    }

    @JsxSetter
    public void setType(String type) {
        this.type_ = type;
    }

    public void setEventType(String eventType) {
        this.type_ = eventType;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public long getTimeStamp() {
        return this.timeStamp_;
    }

    protected void setKeyCode(Object keyCode) {
        this.keyCode_ = keyCode;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public Object getKeyCode() {
        if (this.keyCode_ == null) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_EVENT_KEY_CODE_UNDEFINED)) {
                return Undefined.instance;
            }
            return 0;
        }
        return this.keyCode_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getShiftKey() {
        return this.shiftKey_;
    }

    protected void setShiftKey(boolean shiftKey) {
        this.shiftKey_ = shiftKey;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getCtrlKey() {
        return this.ctrlKey_;
    }

    protected void setCtrlKey(boolean ctrlKey) {
        this.ctrlKey_ = ctrlKey;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public boolean getAltKey() {
        return this.altKey_;
    }

    protected void setAltKey(boolean altKey) {
        this.altKey_ = altKey;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public int getEventPhase() {
        return this.eventPhase_;
    }

    public void setEventPhase(short phase) {
        if (phase != 1 && phase != 2 && phase != 3) {
            throw new IllegalArgumentException("Illegal phase specified: " + phase);
        }
        this.eventPhase_ = phase;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public boolean getBubbles() {
        return this.bubbles_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public boolean getCancelable() {
        return this.cancelable_;
    }

    @JsxGetter
    public boolean getCancelBubble() {
        return this.stopPropagation_;
    }

    @JsxSetter
    public void setCancelBubble(boolean newValue) {
        this.stopPropagation_ = newValue;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void stopPropagation() {
        this.stopPropagation_ = true;
    }

    public boolean isPropagationStopped() {
        return this.stopPropagation_;
    }

    @JsxGetter
    public Object getReturnValue() {
        return this.returnValue_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getPropertyName() {
        return this.propertyName_;
    }

    @JsxSetter
    public void setReturnValue(Object returnValue) {
        this.returnValue_ = returnValue;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void initEvent(String type, boolean bubbles, boolean cancelable) {
        this.type_ = type;
        this.bubbles_ = bubbles;
        this.cancelable_ = cancelable;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void preventDefault() {
        this.preventDefault_ = true;
    }

    public boolean isAborted(ScriptResult result) {
        boolean checkReturnValue = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_EVENT_ABORTED_BY_RETURN_VALUE_FALSE);
        return ScriptResult.isFalse(result) || !checkReturnValue && this.preventDefault_ || checkReturnValue && Boolean.FALSE.equals(this.returnValue_);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Event ");
        buffer.append(this.getType());
        buffer.append(" (");
        buffer.append("Current Target: ");
        buffer.append(this.currentTarget_);
        buffer.append(");");
        return buffer.toString();
    }

    public boolean applies(DomNode node) {
        if (TYPE_BLUR.equals(this.getType()) || TYPE_FOCUS.equals(this.getType())) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_FOCUS_DOCUMENT_DESCENDANTS) && node instanceof HtmlPage) {
                return true;
            }
            return node instanceof SubmittableElement || node instanceof HtmlAnchor || node instanceof HtmlArea;
        }
        return true;
    }
}

