/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import java.util.Arrays;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameInputDialog
extends BaseDialog {
    private String message;
    private String value;
    private String helpContextID;
    private Text text;
    private String errorMessage;
    private Text errorMessageText;
    private String[] existedNames;

    public RenameInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, String helpContextID) {
        super(dialogTitle);
        this.message = dialogMessage;
        this.value = initialValue;
        this.helpContextID = helpContextID;
    }

    public RenameInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, String[] existedNames, String helpContextID) {
        this(parentShell, dialogTitle, dialogMessage, initialValue, helpContextID);
        this.existedNames = existedNames;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        if (this.message != null) {
            Label label = new Label(container, 64);
            label.setText(this.message);
            label.setLayoutData((Object)new GridData());
            label.setFont(parent.getFont());
        }
        this.text = new Text(container, 2052);
        this.text.setText(this.value);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 250;
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RenameInputDialog.this.text.getText().trim().length() == 0) {
                    RenameInputDialog.this.getButton(0).setEnabled(false);
                    RenameInputDialog.this.setErrorMessage(Messages.getString((String)"RenameInputDialog.Message.BlankName"));
                } else if (RenameInputDialog.this.existedNames != null && Arrays.asList(RenameInputDialog.this.existedNames).contains(RenameInputDialog.this.text.getText().trim())) {
                    RenameInputDialog.this.getButton(0).setEnabled(false);
                    RenameInputDialog.this.setErrorMessage(Messages.getString((String)"RenameInputDialog.Message.DuplicateName"));
                } else {
                    RenameInputDialog.this.getButton(0).setEnabled(true);
                    RenameInputDialog.this.setErrorMessage(null);
                }
            }
        });
        this.errorMessageText = new Text(container, 72);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.errorMessageText.setLayoutData((Object)gd);
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        RenameInputDialog.applyDialogFont((Control)composite);
        UIUtil.bindHelp((Control)parent, this.helpContextID);
        return composite;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected void okPressed() {
        this.setResult(this.text.getText());
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        Control composite = super.createContents(parent);
        if (this.text.getText().trim().length() == 0) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(Messages.getString((String)"RenameInputDialog.Message.BlankName"));
        } else if (this.existedNames != null && Arrays.asList(this.existedNames).contains(this.text.getText().trim())) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(Messages.getString((String)"RenameInputDialog.Message.DuplicateName"));
        }
        return composite;
    }
}

