/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.util.LinkedList;
import java.util.List;

public class SortMap {
    private LinkedList keyList = new LinkedList();
    private LinkedList entryList = new LinkedList();

    public boolean containKey(Object key) {
        if (key == null) {
            return false;
        }
        int i = 0;
        while (i < this.keyList.size()) {
            if (this.keyList.get(i).equals(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containValue(Object value) {
        int i = 0;
        while (i < this.entryList.size()) {
            if (((Entry)this.entryList.get((int)i)).value == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getIndexOf(Object key) {
        if (key == null) {
            return -1;
        }
        int i = 0;
        while (i < this.keyList.size()) {
            if (this.keyList.get(i).equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void putAt(Object key, Object value, int index) {
        if (key == null || value == null) {
            return;
        }
        if (this.containValue(value) || this.containValue(key) || index < 0 || index > this.keyList.size() + 1) {
            return;
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = value;
        this.entryList.add(entry);
        this.keyList.add(index, key);
    }

    public void put(Object key, Object value) {
        if (key == null || value == null) {
            return;
        }
        if (this.containValue(value)) {
            return;
        }
        if (this.containKey(key)) {
            int i = 0;
            while (i < this.entryList.size()) {
                if (((Entry)this.entryList.get((int)i)).key.equals(key)) {
                    ((Entry)this.entryList.get((int)i)).value = value;
                }
                ++i;
            }
        } else {
            Entry entry = new Entry();
            entry.key = key;
            entry.value = value;
            this.entryList.add(entry);
            this.keyList.add(key);
        }
    }

    public void remove(Object key) {
        if (key == null) {
            return;
        }
        if (!this.containKey(key)) {
            return;
        }
        int i = 0;
        while (i < this.entryList.size()) {
            if (((Entry)this.entryList.get((int)i)).key.equals(key)) {
                this.entryList.remove(i);
            }
            ++i;
        }
        this.keyList.remove(key);
    }

    public void remove(int index) {
        if (index < 0 || index >= this.keyList.size()) {
            return;
        }
        Object key = this.keyList.get(index);
        int i = 0;
        while (i < this.entryList.size()) {
            if (((Entry)this.entryList.get((int)i)).key.equals(key)) {
                this.entryList.remove(i);
            }
            ++i;
        }
        this.keyList.remove(key);
    }

    public List getKeyList() {
        return this.keyList;
    }

    public List getValueList() {
        LinkedList<Object> valueList = new LinkedList<Object>();
        int i = 0;
        while (i < this.keyList.size()) {
            valueList.add(this.getValue(this.keyList.get(i)));
            ++i;
        }
        return valueList;
    }

    public Object getValue(Object key) {
        if (key == null) {
            return null;
        }
        if (!this.containKey(key)) {
            return null;
        }
        int i = 0;
        while (i < this.entryList.size()) {
            if (((Entry)this.entryList.get((int)i)).key.equals(key)) {
                return ((Entry)this.entryList.get((int)i)).value;
            }
            ++i;
        }
        return null;
    }

    public Object getValue(int index) {
        if (index < 0 || index >= this.keyList.size()) {
            return null;
        }
        Object key = this.keyList.get(index);
        int i = 0;
        while (i < this.entryList.size()) {
            if (((Entry)this.entryList.get((int)i)).key.equals(key)) {
                return ((Entry)this.entryList.get((int)i)).value;
            }
            ++i;
        }
        return null;
    }

    public void clear() {
        this.keyList.clear();
        this.entryList.clear();
    }

    public int size() {
        return this.keyList.size();
    }

    private static class Entry {
        Object key;
        Object value;

        private Entry() {
        }
    }
}

