/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ComputedColumnExpressionFilter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.BindingExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DataItemBindingDialog
extends BaseDialog {
    protected static final String NAME = Messages.getString((String)"DataItemBindingDialog.text.Name");
    protected static final String DISPLAY_NAME = Messages.getString((String)"DataItemBindingDialog.text.displayName");
    protected static final String DATA_TYPE = Messages.getString((String)"DataItemBindingDialog.text.DataType");
    protected static final String EXPRESSION = Messages.getString((String)"DataItemBindingDialog.text.Expression");
    protected static final String AGGREGATE_ON = Messages.getString((String)"DataItemBindingDialog.text.AggregateOn");
    protected static final String FORCE_BINDING_TEXT = Messages.getString((String)"DataItemBindingDialog.text.ForceBinding");
    protected static final String DEFAULT_ITEM_NAME = "data item";
    protected static final String ALL = Messages.getString((String)"DataItemBindingDialog.text.All");
    protected static final String NONE = Messages.getString((String)"DataItemBindingDialog.text.None");
    protected static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices();
    protected static final IChoice[] DATA_TYPE_CHOICES = DATA_TYPE_CHOICE_SET.getChoices(null);
    protected static final String NEW_DATAITEM_TITLE = Messages.getString((String)"DataItemBindingDialog.title.CreateNewItem");
    protected static final String EDIT_DATAITEM_TITLE = Messages.getString((String)"DataItemBindingDialog.title.EditDataItem");
    protected ReportItemHandle input;
    protected DesignElementHandle bindingObject;
    protected String[] dataTypes;
    protected String[] itemNames;
    protected String expression;
    private Combo itemType;
    private Text itemName;
    private Text itemDisplayName;
    private Text itemExpression;
    private String typeSelect;
    protected ComputedColumnHandle bindingColumn;
    protected boolean isCreateNew;
    private String displayName;
    private String name;
    private ComputedColumn newBinding;
    ComputedColumnExpressionFilter filter;
    protected ExpressionProvider expressionProvider;

    public DataItemBindingDialog(boolean isCreateNew) {
        super(isCreateNew ? NEW_DATAITEM_TITLE : EDIT_DATAITEM_TITLE);
        this.isCreateNew = isCreateNew;
    }

    public DataItemBindingDialog(String title) {
        super(title);
    }

    protected String[] convertListToStrings(List list) {
        if (list == null) {
            return null;
        }
        String[] strings = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            strings[i] = list.get(i).toString();
            ++i;
        }
        return strings;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        UIUtil.bindHelp((Control)composite, "org.eclipse.birt.cshelp.DataItemBindingDialog_ID");
        ((GridLayout)composite.getLayout()).numColumns = 3;
        new Label(composite, 0).setText(NAME);
        this.itemName = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.minimumWidth = 250;
        this.itemName.setLayoutData((Object)data);
        WidgetUtil.createGridPlaceholder(composite, 1, false);
        this.itemName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataItemBindingDialog.this.updateButtonStatus();
            }
        });
        new Label(composite, 0).setText(DISPLAY_NAME);
        this.itemDisplayName = new Text(composite, 2048);
        this.itemDisplayName.setLayoutData((Object)new GridData(768));
        WidgetUtil.createGridPlaceholder(composite, 1, false);
        new Label(composite, 0).setText(DATA_TYPE);
        this.itemType = new Combo(composite, 2056);
        this.itemType.setLayoutData((Object)new GridData(768));
        this.itemType.setVisibleItemCount(30);
        WidgetUtil.createGridPlaceholder(composite, 1, false);
        new Label(composite, 0).setText(EXPRESSION);
        this.itemExpression = new Text(composite, 2048);
        this.itemExpression.setLayoutData((Object)new GridData(768));
        this.itemExpression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataItemBindingDialog.this.updateButtonStatus();
            }
        });
        Button expressionButton = new Button(composite, 8);
        expressionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataItemBindingDialog.this.handleExpressionButtonSelectEvent();
            }
        });
        UIUtil.setExpressionButtonImage(expressionButton);
        this.init();
        return composite;
    }

    private ComputedColumnHandle getInputBinding(ReportItemHandle input, String bindingName) {
        List elementsList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)input);
        if (elementsList != null && elementsList.size() > 0) {
            int i = 0;
            while (i < elementsList.size()) {
                if (((ComputedColumnHandle)elementsList.get(i)).getName().equals(bindingName)) {
                    return (ComputedColumnHandle)elementsList.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    private int getItemIndex(String[] items, String item) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void init() {
        this.initDataTypes();
        this.initName();
        this.initDisplayName();
        this.initExpression();
    }

    private void initDisplayName() {
        if (this.displayName != null && this.itemDisplayName != null) {
            this.itemDisplayName.setText(this.displayName);
        }
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        this.initDisplayName();
    }

    private void initDataTypes() {
        if (this.dataTypes != null && this.itemType != null) {
            this.itemType.setItems(this.dataTypes);
            if (this.typeSelect != null) {
                this.itemType.select(this.getItemIndex(this.itemType.getItems(), this.typeSelect));
            } else {
                this.itemType.select(0);
            }
        }
    }

    private void initExpression() {
        if (this.expression != null && this.itemExpression != null) {
            this.itemExpression.setText(this.expression);
        }
    }

    private void initName() {
        if (this.name != null && this.itemName != null) {
            this.itemName.setText(this.name);
        }
    }

    protected void save() throws SemanticException {
        if (this.itemName.getText() != null && this.itemName.getText().trim().length() > 0) {
            if (this.bindingColumn == null) {
                if (this.itemExpression.getText() == null || this.itemExpression.getText().length() == 0) {
                    return;
                }
                this.newBinding.setName(this.itemName.getText());
                this.newBinding.setDisplayName(this.itemDisplayName.getText());
                int i = 0;
                while (i < DATA_TYPE_CHOICES.length) {
                    if (DATA_TYPE_CHOICES[i].getDisplayName().endsWith(this.itemType.getText())) {
                        this.newBinding.setDataType(DATA_TYPE_CHOICES[i].getName());
                        break;
                    }
                    ++i;
                }
                this.newBinding.setExpression(this.itemExpression.getText());
                this.bindingColumn = DEUtil.addColumn((DesignElementHandle)this.getBindingObject(), (ComputedColumn)this.newBinding, (boolean)this.isForceBinding());
            } else {
                if (this.itemExpression.getText() != null && this.itemExpression.getText().length() == 0) {
                    DataItemHandle itemHandle = (DataItemHandle)this.getBindingObject();
                    String resultSetName = itemHandle.getResultSetColumn();
                    if (this.bindingColumn.getName().equals(resultSetName)) {
                        itemHandle.setResultSetColumn(null);
                    }
                    itemHandle.getColumnBindings().removeItem((Object)this.bindingColumn.getStructure());
                    this.bindingColumn = null;
                    return;
                }
                if (this.bindingColumn.getName() == null || !this.bindingColumn.getName().equals(this.itemName.getText().trim())) {
                    this.bindingColumn.setName(this.itemName.getText());
                }
                if (this.bindingColumn.getDisplayName() == null || !this.bindingColumn.getDisplayName().equals(this.itemDisplayName.getText().trim())) {
                    this.bindingColumn.setDisplayName(this.itemDisplayName.getText());
                }
                int i = 0;
                while (i < DATA_TYPE_CHOICES.length) {
                    if (DATA_TYPE_CHOICES[i].getDisplayName().endsWith(this.itemType.getText())) {
                        this.bindingColumn.setDataType(DATA_TYPE_CHOICES[i].getName());
                        break;
                    }
                    ++i;
                }
                this.bindingColumn.setExpression(this.itemExpression.getText());
            }
        }
    }

    protected boolean isForceBinding() {
        return false;
    }

    protected void setResultSetColumn() throws SemanticException {
        if (this.input instanceof DataItemHandle) {
            ((DataItemHandle)this.input).setResultSetColumn(this.bindingColumn.getName());
        }
    }

    protected void okPressed() {
        try {
            this.save();
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return;
        }
        super.okPressed();
    }

    protected DesignElementHandle getBindingObject() {
        return DEUtil.getBindingHolder((DesignElementHandle)this.input);
    }

    public void setDataTypes(String[] dataTypes) {
        this.dataTypes = dataTypes;
        this.initDataTypes();
    }

    public void setExpression(String expression) {
        this.expression = expression;
        this.initExpression();
    }

    public void setName(String name) {
        this.name = name;
        this.initName();
    }

    protected void createColumnName(ReportItemHandle input, String name) {
        this.newBinding = StructureFactory.newComputedColumn((DesignElementHandle)input, (String)name);
        this.setName(this.newBinding.getName());
    }

    public void setInput(ReportItemHandle input) {
        this.input = input;
        this.setDataTypes(ChoiceSetFactory.getDisplayNamefromChoiceSet(DATA_TYPE_CHOICE_SET));
        try {
            if (!this.isCreateNew) {
                this.bindingColumn = this.getInputBinding(input, ((DataItemHandle)input).getResultSetColumn());
            }
            if (this.isCreateNew) {
                this.createColumnName(input, DEFAULT_ITEM_NAME);
                this.setTypeSelect(this.dataTypes[0]);
            } else if (this.bindingColumn != null) {
                this.setName(this.bindingColumn.getName());
                this.setDisplayName(this.bindingColumn.getDisplayName());
                this.setTypeSelect(DATA_TYPE_CHOICE_SET.findChoice(this.bindingColumn.getDataType()).getDisplayName());
                this.setExpression(this.bindingColumn.getExpression());
            } else {
                this.createColumnName(input, ((DataItemHandle)input).getResultSetColumn());
                this.setTypeSelect(this.dataTypes[0]);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
        }
    }

    public void setTypeSelect(String typeSelect) {
        this.typeSelect = typeSelect;
        this.initDataTypes();
    }

    public String getName() {
        return this.itemName.getText().trim();
    }

    public String getExpression() {
        return this.itemExpression.getText();
    }

    public String getTypeSelect() {
        return this.itemType.getText();
    }

    protected void handleExpressionButtonSelectEvent() {
        ExpressionBuilder expression = new ExpressionBuilder(this.getExpression());
        if (this.expressionProvider == null) {
            this.expressionProvider = new BindingExpressionProvider((DesignElementHandle)DEUtil.getBindingHolder((DesignElementHandle)this.input), this.bindingColumn);
        }
        if (this.bindingColumn != null) {
            if (this.filter != null) {
                this.expressionProvider.removeFilter(this.filter);
            }
            this.filter = new ComputedColumnExpressionFilter(this.bindingColumn);
            this.expressionProvider.addFilter(this.filter);
        }
        expression.setExpressionProvier(this.expressionProvider);
        if (expression.open() == 0) {
            this.setExpression(expression.getResult());
        }
    }

    public void setExpressionProvider(ExpressionProvider provider) {
        this.expressionProvider = provider;
    }

    public ComputedColumnHandle getBindingColumn() {
        return this.bindingColumn;
    }

    protected void updateButtonStatus() {
        if (this.getOkButton() != null) {
            if (this.itemName.getText() == null || this.itemName.getText().trim().equals("") || this.itemExpression.getText() == null || this.itemExpression.getText().trim().equals("")) {
                this.getOkButton().setEnabled(false);
            } else {
                this.getOkButton().setEnabled(true);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtonStatus();
    }
}

