/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetUIUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractBindingDialogHelper;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ResourceEditDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionButton;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.CLabel;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.BindingExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.AggregationArgumentHandle;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.AggregationArgument;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class BindingDialogHelper
extends AbstractBindingDialogHelper {
    protected static final String NAME = Messages.getString((String)"BindingDialogHelper.text.Name");
    protected static final String DATA_TYPE = Messages.getString((String)"BindingDialogHelper.text.DataType");
    protected static final String FUNCTION = Messages.getString((String)"BindingDialogHelper.text.Function");
    protected static final String DATA_FIELD = Messages.getString((String)"BindingDialogHelper.text.DataField");
    protected static final String FILTER_CONDITION = Messages.getString((String)"BindingDialogHelper.text.Filter");
    protected static final String AGGREGATE_ON = Messages.getString((String)"BindingDialogHelper.text.AggOn");
    protected static final String TABLE = Messages.getString((String)"BindingDialogHelper.text.Table");
    protected static final String LIST = Messages.getString((String)"BindingDialogHelper.text.List");
    protected static final String GRID = Messages.getString((String)"BindingDialogHelper.text.Grid");
    protected static final String GROUP = Messages.getString((String)"BindingDialogHelper.text.Group");
    protected static final String EXPRESSION = Messages.getString((String)"BindingDialogHelper.text.Expression");
    protected static final String DISPLAY_NAME = Messages.getString((String)"BindingDialogHelper.text.displayName");
    protected static final String ALLOW_EXPORT = Messages.getString((String)"BindingDialogHelper.text.allowExport");
    protected static final String DISPLAY_NAME_ID = Messages.getString((String)"BindingDialogHelper.text.displayNameID");
    protected static final String DEFAULT_ITEM_NAME = Messages.getString((String)"BindingDialogHelper.bindingName.dataitem");
    protected static final String DEFAULT_AGGREGATION_NAME = Messages.getString((String)"BindingDialogHelper.bindingName.aggregation");
    protected static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getStructure("ComputedColumn").getMember("dataType").getAllowedChoices();
    protected static final IChoice[] DATA_TYPE_CHOICES = DATA_TYPE_CHOICE_SET.getChoices(null);
    protected String[] dataTypes = ChoiceSetFactory.getDisplayNamefromChoiceSet(DATA_TYPE_CHOICE_SET);
    protected Button btnTable;
    private Text txtName;
    private Text txtFilter;
    private Text txtExpression;
    private Combo cmbType;
    private Combo cmbFunction;
    private Combo cmbGroup;
    private Button btnGroup;
    private Button btnDisplayNameID;
    private Button btnRemoveDisplayNameID;
    private Composite paramsComposite;
    private Map<String, Control> paramsMap = new LinkedHashMap<String, Control>();
    private Map<String, String[]> paramsValueMap = new HashMap<String, String[]>();
    private Composite composite;
    private Text txtDisplayName;
    private Text txtDisplayNameID;
    private ComputedColumn newBinding;
    private CLabel messageLine;
    private Combo cmbName;
    private Combo cmbDataField;
    private Label lbName;
    private Label lbDisplayNameID;
    private boolean isCreate;
    private boolean isRef;
    private Object container;
    private static final String EMPTY_STRING = "";
    private boolean hasInitDialog = false;
    private boolean isEditModal = false;
    private boolean hasModified = false;
    private Button btnAllowExport;

    public void createContent(Composite parent) {
        this.isCreate = this.getBinding() == null;
        this.isRef = this.getBindingHolder().getDataBindingType() == 2;
        this.composite = parent;
        ((GridLayout)this.composite.getLayout()).numColumns = 4;
        this.lbName = new Label(this.composite, 0);
        this.lbName.setText(NAME);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = 200;
        if (this.isRef) {
            this.cmbName = new Combo(this.composite, 2056);
            this.cmbName.setLayoutData((Object)gd);
            this.cmbName.setVisibleItemCount(30);
            this.cmbName.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BindingDialogHelper.this.modifyDialogContent();
                    String bindingName = BindingDialogHelper.this.cmbName.getItem(BindingDialogHelper.this.cmbName.getSelectionIndex());
                    for (ComputedColumnHandle computedColumn : BindingDialogHelper.this.getBindingHolder().getDataBindingReference().getColumnBindings()) {
                        if (!computedColumn.getName().equals(bindingName)) continue;
                        BindingDialogHelper.this.setBinding(computedColumn);
                        BindingDialogHelper.this.initDialog();
                        return;
                    }
                }
            });
        } else {
            this.txtName = new Text(this.composite, 2048);
            this.txtName.setLayoutData((Object)gd);
            this.txtName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BindingDialogHelper.this.modifyDialogContent();
                    BindingDialogHelper.this.validate();
                }
            });
        }
        this.lbDisplayNameID = new Label(this.composite, 0);
        this.lbDisplayNameID.setText(DISPLAY_NAME_ID);
        this.lbDisplayNameID.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    if (BindingDialogHelper.this.btnDisplayNameID.isEnabled()) {
                        BindingDialogHelper.this.openKeySelectionDialog();
                    }
                }
            }
        });
        this.txtDisplayNameID = new Text(this.composite, 2056);
        this.txtDisplayNameID.setLayoutData((Object)new GridData(768));
        this.btnDisplayNameID = new Button(this.composite, 0);
        this.btnDisplayNameID.setEnabled(this.getAvailableResourceUrls() != null && this.getAvailableResourceUrls().length > 0);
        this.btnDisplayNameID.setText("...");
        this.btnDisplayNameID.setToolTipText(Messages.getString((String)"ResourceKeyDescriptor.button.browse.tooltip"));
        this.btnDisplayNameID.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BindingDialogHelper.this.openKeySelectionDialog();
            }
        });
        this.btnRemoveDisplayNameID = new Button(this.composite, 0);
        this.btnRemoveDisplayNameID.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_DELETE"));
        this.btnRemoveDisplayNameID.setToolTipText(Messages.getString((String)"ResourceKeyDescriptor.button.reset.tooltip"));
        this.btnRemoveDisplayNameID.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BindingDialogHelper.this.txtDisplayNameID.setText(BindingDialogHelper.EMPTY_STRING);
                BindingDialogHelper.this.txtDisplayName.setText(BindingDialogHelper.EMPTY_STRING);
                BindingDialogHelper.this.modifyDialogContent();
                BindingDialogHelper.this.updateRemoveBtnState();
            }
        });
        new Label(this.composite, 0).setText(DISPLAY_NAME);
        this.txtDisplayName = new Text(this.composite, 2048);
        this.txtDisplayName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BindingDialogHelper.this.modifyDialogContent();
            }
        });
        this.txtDisplayName.setLayoutData((Object)gd);
        new Label(this.composite, 0).setText(DATA_TYPE);
        this.cmbType = new Combo(this.composite, 2056);
        this.cmbType.setLayoutData((Object)gd);
        this.cmbType.setVisibleItemCount(30);
        this.cmbType.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                BindingDialogHelper.this.validate();
            }

            public void widgetSelected(SelectionEvent arg0) {
                BindingDialogHelper.this.modifyDialogContent();
                BindingDialogHelper.this.validate();
            }
        });
        Label allowExportLabel = new Label(this.composite, 0);
        allowExportLabel.setText(ALLOW_EXPORT);
        this.btnAllowExport = new Button(this.composite, 32);
        this.btnAllowExport.setSelection(true);
        GridData gd1 = new GridData(768);
        gd1.horizontalSpan = 3;
        gd1.widthHint = 200;
        this.btnAllowExport.setLayoutData((Object)gd1);
        this.btnAllowExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingDialogHelper.this.modifyDialogContent();
            }
        });
        WidgetUtil.setExcludeGridData((Control)allowExportLabel, true);
        WidgetUtil.setExcludeGridData((Control)this.btnAllowExport, true);
        if (this.isAggregate()) {
            this.createAggregateSection(this.composite);
        } else {
            this.createCommonSection(this.composite);
        }
        this.createMessageSection(this.composite);
        gd = new GridData(1808);
        this.composite.setLayoutData((Object)gd);
        this.setContentSize(this.composite);
    }

    private void openKeySelectionDialog() {
        String[] result;
        ResourceEditDialog dlg = new ResourceEditDialog(this.composite.getShell(), Messages.getString((String)"ResourceKeyDescriptor.title.SelectKey"));
        dlg.setResourceURLs(this.getResourceURLs());
        if (dlg.open() == 0 && (result = (String[])dlg.getDetailResult()) != null && result.length > 1) {
            this.txtDisplayNameID.setText(DEUtil.resolveNull((String)result[0]));
            this.txtDisplayName.setText(DEUtil.resolveNull((String)result[1]));
            this.modifyDialogContent();
            this.updateRemoveBtnState();
        }
    }

    public void initDialog() {
        this.cmbType.setItems(this.dataTypes);
        this.txtDisplayName.setFocus();
        if (this.isAggregate()) {
            this.initFunction();
            this.initFilter();
            this.initGroups();
        }
        if (this.isCreate) {
            if (this.isRef) {
                if (this.getBinding() == null) {
                    for (ComputedColumnHandle computedColumn : this.getBindingHolder().getDataBindingReference().getColumnBindings()) {
                        if (this.isAggregate() ? computedColumn.getAggregateFunction() == null || computedColumn.getAggregateFunction().equals(EMPTY_STRING) : computedColumn.getAggregateFunction() != null && !computedColumn.getAggregateFunction().equals(EMPTY_STRING)) continue;
                        this.cmbName.add(computedColumn.getName());
                    }
                } else {
                    this.setDisplayName(this.getBinding().getDisplayName());
                    this.setDisplayNameID(this.getBinding().getDisplayNameID());
                    this.setAllowExport(this.getBinding().allowExport());
                    int i = 0;
                    while (i < DATA_TYPE_CHOICES.length) {
                        if (DATA_TYPE_CHOICES[i].getName().equals(this.getBinding().getDataType())) {
                            this.setTypeSelect(DATA_TYPE_CHOICES[i].getDisplayName());
                            break;
                        }
                        ++i;
                    }
                    this.setDataFieldExpression(this.getBinding());
                }
            } else {
                this.newBinding = StructureFactory.newComputedColumn((DesignElementHandle)this.getBindingHolder(), (String)(this.isAggregate() ? DEFAULT_AGGREGATION_NAME : DEFAULT_ITEM_NAME));
                this.setName(this.newBinding.getName());
                this.setAllowExport(this.newBinding.allowExport());
                if (!this.isAggregate()) {
                    this.setTypeSelect(this.getDataTypeDisplayName("string"));
                }
            }
        } else if (this.isRef) {
            int i = 0;
            for (ComputedColumnHandle computedColumn : this.getBindingHolder().getDataBindingReference().getColumnBindings()) {
                if (this.isAggregate() ? computedColumn.getAggregateFunction() == null || computedColumn.getAggregateFunction().equals(EMPTY_STRING) : computedColumn.getAggregateFunction() != null && !computedColumn.getAggregateFunction().equals(EMPTY_STRING)) continue;
                this.cmbName.add(computedColumn.getName());
                if (this.getBinding().getName().equals(computedColumn.getName())) {
                    this.cmbName.select(i);
                }
                ++i;
            }
            this.setDisplayName(this.getBinding().getDisplayName());
            this.setDisplayNameID(this.getBinding().getDisplayNameID());
            this.setAllowExport(this.getBinding().allowExport());
            i = 0;
            while (i < DATA_TYPE_CHOICES.length) {
                if (DATA_TYPE_CHOICES[i].getName().equals(this.getBinding().getDataType())) {
                    this.setTypeSelect(DATA_TYPE_CHOICES[i].getDisplayName());
                    break;
                }
                ++i;
            }
            this.setDataFieldExpression(this.getBinding());
        } else {
            this.setName(this.getBinding().getName());
            this.setDisplayName(this.getBinding().getDisplayName());
            this.setDisplayNameID(this.getBinding().getDisplayNameID());
            this.setAllowExport(this.getBinding().allowExport());
            if (this.getBinding().getDataType() != null) {
                if (DATA_TYPE_CHOICE_SET.findChoice(this.getBinding().getDataType()) != null) {
                    this.setTypeSelect(DATA_TYPE_CHOICE_SET.findChoice(this.getBinding().getDataType()).getDisplayName());
                } else {
                    this.cmbType.setText(EMPTY_STRING);
                }
            }
            this.setDataFieldExpression(this.getBinding());
        }
        if (!this.isCreate) {
            if (this.isRef) {
                this.cmbName.setEnabled(true);
            } else {
                this.txtName.setEnabled(false);
            }
        }
        this.validate();
        this.hasInitDialog = true;
    }

    private void initExpressionButton(ExpressionHandle expressionHandle, Text text) {
        ExpressionButtonUtil.initExpressionButtonControl((Control)text, expressionHandle);
    }

    private void initFilter() {
        if (this.binding != null) {
            ExpressionHandle expressionHandle = this.binding.getExpressionProperty("filterExpr");
            this.initExpressionButton(expressionHandle, this.txtFilter);
        }
    }

    private void initFunction() {
        this.cmbFunction.setItems(this.getFunctionDisplayNames());
        if (this.binding == null) {
            this.cmbFunction.select(0);
            this.handleFunctionSelectEvent();
            return;
        }
        try {
            String functionString = this.getFunctionDisplayName(DataAdapterUtil.adaptModelAggregationType((String)this.binding.getAggregateFunction()));
            int itemIndex = this.getItemIndex(this.getFunctionDisplayNames(), functionString);
            this.cmbFunction.select(itemIndex);
            this.handleFunctionSelectEvent();
        }
        catch (AdapterException e) {
            ExceptionHandler.handle(e);
        }
        Iterator iterator = this.binding.argumentsIterator();
        while (iterator.hasNext()) {
            AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
            String argName = DataAdapterUtil.adaptArgumentName((String)arg.getName());
            if (!this.paramsMap.containsKey(argName) || arg.getValue() == null) continue;
            Control control = this.paramsMap.get(argName);
            if (control instanceof Text) {
                ((Text)control).setText(arg.getValue());
                continue;
            }
            if (!(control instanceof Combo)) continue;
            ((Combo)control).setText(arg.getValue());
        }
    }

    private String[] getFunctionDisplayNames() {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return new String[0];
        }
        String[] displayNames = new String[choices.length];
        int i = 0;
        while (i < choices.length) {
            displayNames[i] = choices[i].getDisplayName();
            ++i;
        }
        Arrays.sort(displayNames, new AlphabeticallyComparator());
        return displayNames;
    }

    private IAggrFunction getFunctionByDisplayName(String displayName) {
        IAggrFunction[] choices = this.getFunctions();
        if (choices == null) {
            return null;
        }
        int i = 0;
        while (i < choices.length) {
            if (choices[i].getDisplayName().equals(displayName)) {
                return choices[i];
            }
            ++i;
        }
        return null;
    }

    private String getFunctionDisplayName(String function) {
        try {
            return DataUtil.getAggregationManager().getAggregation(function).getDisplayName();
        }
        catch (BirtException e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    private IAggrFunction[] getFunctions() {
        try {
            List aggrInfoList = DataUtil.getAggregationManager().getAggregations(0);
            return aggrInfoList.toArray(new IAggrFunction[0]);
        }
        catch (BirtException e) {
            ExceptionHandler.handle(e);
            return new IAggrFunction[0];
        }
    }

    private void initTextField(Text txtParam, IParameterDefn param) {
        if (this.paramsValueMap.containsKey(param.getName())) {
            txtParam.setText(this.paramsValueMap.get(param.getName())[0]);
            txtParam.setData("exprType", (Object)this.paramsValueMap.get(param.getName())[1]);
            ExpressionButton button = (ExpressionButton)txtParam.getData("exprButton");
            if (button != null) {
                button.refresh();
            }
            return;
        }
        if (this.binding != null) {
            Iterator iterator = this.binding.argumentsIterator();
            while (iterator.hasNext()) {
                AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
                if (!arg.getName().equals(param.getName())) continue;
                ExpressionButtonUtil.initExpressionButtonControl((Control)txtParam, arg, "value");
                return;
            }
        }
    }

    private void initDataFields(Combo cmbDataField, IParameterDefn param) {
        Object button;
        cmbDataField.setItems(this.getColumnBindings());
        if (this.paramsValueMap.containsKey(param.getName())) {
            cmbDataField.setText(this.paramsValueMap.get(param.getName())[0]);
            cmbDataField.setData("exprType", (Object)this.paramsValueMap.get(param.getName())[1]);
            ExpressionButton button2 = (ExpressionButton)cmbDataField.getData("exprButton");
            if (button2 != null) {
                button2.refresh();
            }
            return;
        }
        if (this.binding != null) {
            ExpressionHandle expressionHandle = null;
            Iterator iterator = this.binding.argumentsIterator();
            while (iterator.hasNext()) {
                ExpressionHandle value;
                AggregationArgumentHandle arg = (AggregationArgumentHandle)iterator.next();
                if (!arg.getName().equals(param.getName())) continue;
                expressionHandle = value = arg.getExpressionProperty("value");
                break;
            }
            if (expressionHandle == null) {
                expressionHandle = this.binding.getExpressionProperty("expression");
            }
            ExpressionButtonUtil.initExpressionButtonControl((Control)cmbDataField, expressionHandle);
        }
        if ((button = cmbDataField.getData("exprButton")) instanceof ExpressionButton && !((ExpressionButton)button).isSupportType("javascript")) {
            cmbDataField.removeAll();
        }
    }

    private String[] getColumnBindings() {
        List elementsList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)this.getBindingHolder());
        String[] bindings = new String[elementsList.size()];
        int i = 0;
        while (i < bindings.length) {
            bindings[i] = ((ComputedColumnHandle)elementsList.get(i)).getName();
            ++i;
        }
        return bindings;
    }

    private void initGroups() {
        String[] groups = this.getGroups();
        if (groups.length > 0) {
            this.cmbGroup.setItems(groups);
            if (this.binding != null && this.binding.getAggregateOn() != null) {
                this.btnGroup.setSelection(true);
                this.btnTable.setSelection(false);
                if (!this.isRef) {
                    this.cmbGroup.setEnabled(true);
                }
                int i = 0;
                while (i < groups.length) {
                    if (groups[i].equals(this.binding.getAggregateOn())) {
                        this.cmbGroup.select(i);
                        return;
                    }
                    ++i;
                }
            } else if (this.container instanceof DesignElementHandle && ((DesignElementHandle)this.container).getContainer().getContainer() instanceof TableGroupHandle) {
                TableGroupHandle groupHandle = (TableGroupHandle)((DesignElementHandle)this.container).getContainer().getContainer();
                int i = 0;
                while (i < groups.length) {
                    if (groups[i].equals(groupHandle.getName())) {
                        this.cmbGroup.select(i);
                    }
                    ++i;
                }
                this.btnTable.setSelection(false);
                this.btnGroup.setSelection(true);
            } else if (this.container instanceof ListGroupHandle) {
                ListGroupHandle groupHandle = (ListGroupHandle)this.container;
                int i = 0;
                while (i < groups.length) {
                    if (groups[i].equals(groupHandle.getName())) {
                        this.cmbGroup.select(i);
                    }
                    ++i;
                }
                this.btnTable.setSelection(false);
                this.btnGroup.setSelection(true);
            } else {
                this.btnTable.setSelection(true);
                this.btnGroup.setSelection(false);
                this.cmbGroup.select(0);
                this.cmbGroup.setEnabled(false);
            }
        } else {
            this.btnGroup.setEnabled(false);
            this.cmbGroup.setEnabled(false);
            this.btnTable.setSelection(true);
        }
    }

    private String[] getGroups() {
        if (this.getBindingHolder() instanceof ListingHandle) {
            ListingHandle listingHandle = (ListingHandle)this.getBindingHolder();
            ArrayList<String> groupNames = new ArrayList<String>();
            int i = 0;
            while (i < listingHandle.getGroups().getCount()) {
                String groupName = ((GroupHandle)listingHandle.getGroups().get(i)).getName();
                if (groupName != null) {
                    groupNames.add(groupName);
                }
                ++i;
            }
            return groupNames.toArray(new String[0]);
        }
        return new String[0];
    }

    private void setDataFieldExpression(ComputedColumnHandle binding) {
        if (binding != null && this.txtExpression != null && !this.txtExpression.isDisposed()) {
            ExpressionButtonUtil.initExpressionButtonControl((Control)this.txtExpression, binding, "expression");
        }
    }

    private void setName(String name) {
        if (name != null && this.txtName != null) {
            this.txtName.setText(name);
        }
    }

    private void setDisplayName(String displayName) {
        if (displayName != null && this.txtDisplayName != null) {
            this.txtDisplayName.setText(displayName);
        }
    }

    private void setDisplayNameID(String displayNameID) {
        if (displayNameID != null && this.txtDisplayNameID != null) {
            this.txtDisplayNameID.setText(displayNameID);
        }
    }

    private void setAllowExport(boolean allowExport) {
        if (this.btnAllowExport != null) {
            this.btnAllowExport.setSelection(allowExport);
        }
    }

    private void setTypeSelect(String typeSelect) {
        if (this.dataTypes != null && this.cmbType != null) {
            if (typeSelect != null) {
                this.cmbType.select(this.getItemIndex(this.cmbType.getItems(), typeSelect));
            } else {
                this.cmbType.select(0);
            }
        }
    }

    private int getItemIndex(String[] items, String item) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(item)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void createAggregateSection(Composite composite) {
        new Label(composite, 0).setText(FUNCTION);
        this.cmbFunction = new Combo(composite, 2056);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.cmbFunction.setLayoutData((Object)gd);
        this.cmbFunction.setVisibleItemCount(30);
        this.cmbFunction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingDialogHelper.this.modifyDialogContent();
                BindingDialogHelper.this.handleFunctionSelectEvent();
                BindingDialogHelper.this.validate();
            }
        });
        this.paramsComposite = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 0;
        gridData.horizontalSpan = 4;
        gridData.exclude = true;
        this.paramsComposite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        Layout parentLayout = this.paramsComposite.getParent().getLayout();
        if (parentLayout instanceof GridLayout) {
            layout.horizontalSpacing = ((GridLayout)parentLayout).horizontalSpacing;
        }
        this.paramsComposite.setLayout((Layout)layout);
        new Label(composite, 0).setText(FILTER_CONDITION);
        this.txtFilter = new Text(composite, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtFilter.setLayoutData((Object)gd);
        this.txtFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                BindingDialogHelper.this.modifyDialogContent();
                BindingDialogHelper.this.validate();
            }
        });
        this.createExpressionButton(composite, (Control)this.txtFilter);
        Label lblAggOn = new Label(composite, 0);
        lblAggOn.setText(AGGREGATE_ON);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        lblAggOn.setLayoutData((Object)gridData);
        Composite aggOnComposite = new Composite(composite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        aggOnComposite.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        aggOnComposite.setLayout((Layout)layout);
        this.btnTable = new Button(aggOnComposite, 16);
        if (this.getBindingHolder() instanceof TableHandle) {
            this.btnTable.setText(TABLE);
        } else if (this.getBindingHolder() instanceof ListHandle) {
            this.btnTable.setText(LIST);
        } else if (this.getBindingHolder() instanceof GridHandle) {
            this.btnTable.setText(GRID);
        }
        this.btnTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BindingDialogHelper.this.modifyDialogContent();
                BindingDialogHelper.this.cmbGroup.setEnabled(false);
            }
        });
        WidgetUtil.createGridPlaceholder(aggOnComposite, 1, false);
        this.btnGroup = new Button(aggOnComposite, 16);
        this.btnGroup.setText(GROUP);
        this.btnGroup.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BindingDialogHelper.this.modifyDialogContent();
                BindingDialogHelper.this.cmbGroup.setEnabled(true);
            }
        });
        this.cmbGroup = new Combo(aggOnComposite, 2056);
        this.cmbGroup.setLayoutData((Object)new GridData(768));
        this.cmbGroup.setVisibleItemCount(30);
        this.cmbGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingDialogHelper.this.modifyDialogContent();
            }
        });
        this.cmbFunction.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BindingDialogHelper.this.modifyDialogContent();
            }
        });
        if (this.isRef) {
            this.txtDisplayName.setEnabled(false);
            this.txtDisplayNameID.setEnabled(false);
            this.btnDisplayNameID.setEnabled(false);
            this.cmbType.setEnabled(false);
            this.cmbFunction.setEnabled(false);
            this.txtFilter.setEnabled(false);
            this.paramsComposite.setEnabled(false);
            this.cmbGroup.setEnabled(false);
            this.btnTable.setEnabled(false);
            this.btnGroup.setEnabled(false);
        }
    }

    private void createCommonSection(Composite composite) {
        new Label(composite, 0).setText(EXPRESSION);
        this.txtExpression = new Text(composite, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtExpression.setLayoutData((Object)gd);
        this.createExpressionButton(composite, (Control)this.txtExpression);
        this.txtExpression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BindingDialogHelper.this.modifyDialogContent();
                BindingDialogHelper.this.validate();
            }
        });
        if (this.isRef) {
            this.txtDisplayName.setEnabled(false);
            this.txtDisplayNameID.setEnabled(false);
            this.btnDisplayNameID.setEnabled(false);
            this.cmbType.setEnabled(false);
            this.txtExpression.setEnabled(false);
        }
    }

    private void createMessageSection(Composite composite) {
        this.messageLine = new CLabel(composite, 16384);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 4;
        this.messageLine.setLayoutData(layoutData);
    }

    public void setMessage(String message) {
        this.messageLine.setText(message);
        this.messageLine.setImage(null);
    }

    public void setErrorMessage(String message) {
        this.messageLine.setText(message);
        this.messageLine.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
    }

    private void verifyInput() {
        if (this.isRef) {
            if (this.cmbName.getText() == null || this.cmbName.getText().equals(EMPTY_STRING)) {
                this.dialog.setCanFinish(false);
            } else {
                this.dialogCanFinish();
            }
            return;
        }
        if (this.txtName != null && (this.txtName.getText() == null || this.txtName.getText().trim().equals(EMPTY_STRING))) {
            this.dialog.setCanFinish(false);
            return;
        }
        if (this.cmbType.getText() == null || this.cmbType.getText().equals(EMPTY_STRING)) {
            this.dialog.setCanFinish(false);
            return;
        }
        if (this.binding == null) {
            for (ComputedColumnHandle computedColumn : this.bindingHolder.getColumnBindings()) {
                if (!computedColumn.getName().equals(this.txtName.getText())) continue;
                this.dialog.setCanFinish(false);
                this.setErrorMessage(Messages.getFormattedString((String)"BindingDialogHelper.error.nameduplicate", (Object[])new Object[]{this.txtName.getText()}));
                return;
            }
        }
        this.setMessage(EMPTY_STRING);
        if (this.txtExpression != null && (this.txtExpression.getText() == null || this.txtExpression.getText().trim().equals(EMPTY_STRING)) && !this.isAllowEmyptExpression()) {
            this.dialog.setCanFinish(false);
            return;
        }
        if (this.isAggregate()) {
            try {
                IAggrFunction aggregation = DataUtil.getAggregationManager().getAggregation(this.getFunctionByDisplayName(this.cmbFunction.getText()).getName());
                if (aggregation.getParameterDefn().length > 0) {
                    IParameterDefn[] parameters;
                    IParameterDefn[] iParameterDefnArray = parameters = aggregation.getParameterDefn();
                    int n = parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IParameterDefn param = iParameterDefnArray[n2];
                        if (!param.isOptional()) {
                            Control control = this.paramsMap.get(param.getName());
                            String paramValue = null;
                            if (control instanceof Text) {
                                paramValue = ((Text)control).getText();
                            }
                            if (control instanceof Combo) {
                                paramValue = ((Combo)control).getText();
                            }
                            if (paramValue == null || paramValue.trim().equals(EMPTY_STRING)) {
                                this.dialog.setCanFinish(false);
                                this.setErrorMessage(Messages.getFormattedString((String)"BindingDialogHelper.error.empty", (Object[])new String[]{param.getDisplayName()}));
                                return;
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (BirtException birtException) {}
        }
        this.dialogCanFinish();
    }

    private boolean isAllowEmyptExpression() {
        ReportItemHandle itemHandle = this.getBindingHolder();
        return itemHandle instanceof DataItemHandle && itemHandle.getDataSet() == null && itemHandle.getContainer() instanceof LibraryHandle;
    }

    private void dialogCanFinish() {
        if (!this.isAllowEmyptExpression() && !this.hasModified && this.isEditModal()) {
            this.dialog.setCanFinish(false);
        } else {
            this.dialog.setCanFinish(true);
        }
    }

    private void handleFunctionSelectEvent() {
        if (this.isRef) {
            return;
        }
        Control[] children = this.paramsComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        IAggrFunction function = this.getFunctionByDisplayName(this.cmbFunction.getText());
        if (function != null) {
            this.paramsMap.clear();
            IParameterDefn[] params = function.getParameterDefn();
            if (params.length > 0) {
                ((GridData)this.paramsComposite.getLayoutData()).exclude = false;
                ((GridData)this.paramsComposite.getLayoutData()).heightHint = -1;
                int width = 0;
                if (this.paramsComposite.getParent().getLayout() instanceof GridLayout) {
                    Control[] controls = this.paramsComposite.getParent().getChildren();
                    int i2 = 0;
                    while (i2 < controls.length) {
                        int labelWidth;
                        if (controls[i2] instanceof Label && ((GridData)controls[i2].getLayoutData()).horizontalSpan == 1 && (labelWidth = controls[i2].getBounds().width - controls[i2].getBorderWidth() * 2) > width) {
                            width = labelWidth;
                        }
                        ++i2;
                    }
                }
                IParameterDefn[] iParameterDefnArray = params;
                int n = params.length;
                int n2 = 0;
                while (n2 < n) {
                    final IParameterDefn param = iParameterDefnArray[n2];
                    Label lblParam = new Label(this.paramsComposite, 64);
                    lblParam.setText(String.valueOf(param.getDisplayName()) + Messages.getString((String)"BindingDialogHelper.text.Colon"));
                    GridData gd = new GridData();
                    gd.widthHint = lblParam.computeSize((int)-1, (int)-1).x;
                    if (gd.widthHint < width) {
                        gd.widthHint = width;
                    }
                    lblParam.setLayoutData((Object)gd);
                    if (param.isDataField()) {
                        this.cmbDataField = new Combo(this.paramsComposite, 2048);
                        this.cmbDataField.setLayoutData((Object)new GridData(768));
                        this.cmbDataField.setVisibleItemCount(30);
                        this.createExpressionButton(this.paramsComposite, (Control)this.cmbDataField);
                        this.initDataFields(this.cmbDataField, param);
                        this.cmbDataField.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                BindingDialogHelper.this.modifyDialogContent();
                                BindingDialogHelper.this.validate();
                                BindingDialogHelper.this.paramsValueMap.put(param.getName(), new String[]{BindingDialogHelper.this.cmbDataField.getText(), (String)BindingDialogHelper.this.cmbDataField.getData("exprType")});
                            }
                        });
                        this.cmbDataField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                String expr = BindingDialogHelper.this.getColumnBindingExpressionByName(BindingDialogHelper.this.cmbDataField.getText());
                                if (expr != null) {
                                    BindingDialogHelper.this.cmbDataField.setText(expr);
                                }
                            }
                        });
                        this.paramsMap.put(param.getName(), (Control)this.cmbDataField);
                    } else {
                        final Text txtParam = new Text(this.paramsComposite, 2048);
                        txtParam.addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent e) {
                                BindingDialogHelper.this.modifyDialogContent();
                                BindingDialogHelper.this.validate();
                                BindingDialogHelper.this.paramsValueMap.put(param.getName(), new String[]{txtParam.getText(), (String)txtParam.getData("exprType")});
                            }
                        });
                        GridData gridData = new GridData(768);
                        gridData.horizontalIndent = 0;
                        txtParam.setLayoutData((Object)gridData);
                        this.createExpressionButton(this.paramsComposite, (Control)txtParam);
                        this.paramsMap.put(param.getName(), (Control)txtParam);
                        this.initTextField(txtParam, param);
                    }
                    ++n2;
                }
            } else {
                ((GridData)this.paramsComposite.getLayoutData()).heightHint = 0;
                ((GridData)this.paramsComposite.getLayoutData()).exclude = true;
            }
            try {
                this.cmbType.setText(this.getDataTypeDisplayName(DataAdapterUtil.adapterToModelDataType((int)DataUtil.getAggregationManager().getAggregation(function.getName()).getDataType())));
            }
            catch (BirtException e) {
                ExceptionHandler.handle(e);
            }
        } else {
            ((GridData)this.paramsComposite.getLayoutData()).heightHint = 0;
            ((GridData)this.paramsComposite.getLayoutData()).exclude = true;
        }
        this.paramsComposite.layout(true, true);
        this.setContentSize(this.composite);
    }

    private void createExpressionButton(Composite parent, Control control) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                BindingDialogHelper.this.modifyDialogContent();
                BindingDialogHelper.this.validate();
            }
        };
        if (this.expressionProvider == null) {
            this.expressionProvider = new BindingExpressionProvider((DesignElementHandle)this.bindingHolder, this.binding);
        }
        ExpressionButton button = ExpressionButtonUtil.createExpressionButton(parent, control, (IExpressionProvider)this.expressionProvider, (Object)this.bindingHolder, listener);
        if (this.isRef) {
            button.setEnabled(false);
        }
    }

    private String getColumnBindingExpressionByName(String name) {
        List elementsList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)this.bindingHolder);
        for (ComputedColumnHandle binding : elementsList) {
            if (!binding.getName().equals(name)) continue;
            return ExpressionButtonUtil.getCurrentExpressionConverter((Control)this.cmbDataField).getBindingExpression(name);
        }
        return null;
    }

    private String getArgumentByDisplayName(String function, String argument) {
        try {
            IAggrFunction info = DataUtil.getAggregationManager().getAggregation(function);
            IParameterDefn[] iParameterDefnArray = info.getParameterDefn();
            int n = iParameterDefnArray.length;
            int n2 = 0;
            while (n2 < n) {
                IParameterDefn param = iParameterDefnArray[n2];
                if (param.getDisplayName().equals(argument)) {
                    return param.getName();
                }
                ++n2;
            }
        }
        catch (BirtException e) {
            ExceptionHandler.handle(e);
        }
        return null;
    }

    private String getArgumentDisplayNameByName(String function, String argument) {
        try {
            IAggrFunction info = DataUtil.getAggregationManager().getAggregation(function);
            IParameterDefn[] iParameterDefnArray = info.getParameterDefn();
            int n = iParameterDefnArray.length;
            int n2 = 0;
            while (n2 < n) {
                IParameterDefn param = iParameterDefnArray[n2];
                if (param.getName().equals(argument)) {
                    return param.getDisplayName();
                }
                ++n2;
            }
        }
        catch (BirtException e) {
            ExceptionHandler.handle(e);
        }
        return null;
    }

    public void validate() {
        this.verifyInput();
        this.updateRemoveBtnState();
    }

    public boolean differs(ComputedColumnHandle binding) {
        if (this.isAggregate()) {
            if (this.txtName != null && !this.strEquals(this.txtName.getText(), binding.getName())) {
                return true;
            }
            if (this.cmbName != null && !this.strEquals(this.cmbName.getText(), binding.getName())) {
                return true;
            }
            if (this.btnAllowExport.getSelection() != binding.allowExport()) {
                return true;
            }
            if (!this.strEquals(binding.getDisplayName(), this.txtDisplayName.getText())) {
                return true;
            }
            if (!this.strEquals(binding.getDisplayNameID(), this.txtDisplayNameID.getText())) {
                return true;
            }
            if (!this.strEquals(binding.getDataType(), this.getDataType())) {
                return true;
            }
            try {
                if (!this.strEquals(DataAdapterUtil.adaptModelAggregationType((String)binding.getAggregateFunction()), this.getFunctionByDisplayName(this.cmbFunction.getText()).getName())) {
                    return true;
                }
            }
            catch (AdapterException adapterException) {}
            if (!this.expressionEquals(binding.getExpressionProperty("filterExpr"), this.txtFilter)) {
                return true;
            }
            if (this.btnTable.getSelection() == (binding.getAggregateOn() != null)) {
                return true;
            }
            if (!this.btnTable.getSelection() && !binding.getAggregateOn().equals(this.cmbGroup.getText())) {
                return true;
            }
            boolean hasArguments = false;
            Iterator iterator = binding.argumentsIterator();
            while (iterator.hasNext()) {
                AggregationArgumentHandle handle = (AggregationArgumentHandle)iterator.next();
                if (this.paramsMap.containsKey(handle.getName())) {
                    String[] paramValue = this.getControlValue(this.paramsMap.get(handle.getName()));
                    if (!this.expressionEquals(handle.getExpressionProperty("value"), paramValue)) {
                        return true;
                    }
                } else {
                    return true;
                }
                hasArguments = true;
            }
            if (!hasArguments && !this.paramsMap.isEmpty()) {
                return true;
            }
        } else {
            if (this.txtName != null && !this.strEquals(this.txtName.getText(), binding.getName())) {
                return true;
            }
            if (this.cmbName != null && !this.strEquals(this.cmbName.getText(), binding.getName())) {
                return true;
            }
            if (!this.strEquals(this.txtDisplayName.getText(), binding.getDisplayName())) {
                return true;
            }
            if (!this.strEquals(this.txtDisplayNameID.getText(), binding.getDisplayNameID())) {
                return true;
            }
            if (this.btnAllowExport.getSelection() != binding.allowExport()) {
                return true;
            }
            if (!this.strEquals(this.getDataType(), binding.getDataType())) {
                return true;
            }
            if (!this.expressionEquals(binding.getExpressionProperty("expression"), this.txtExpression)) {
                return true;
            }
        }
        return false;
    }

    private boolean expressionEquals(ExpressionHandle expressionHandle, Text text) {
        return expressionHandle == null ? text.getText().trim().length() == 0 : this.strEquals(expressionHandle.getStringExpression(), text.getText()) && this.strEquals(expressionHandle.getType(), (String)text.getData("exprType"));
    }

    private boolean expressionEquals(ExpressionHandle expressionHandle, String[] strs) {
        return expressionHandle == null ? strs == null || strs[0].trim().length() == 0 : strs != null && this.strEquals(expressionHandle.getStringExpression(), strs[0]) && this.strEquals(expressionHandle.getType(), strs[1]);
    }

    private String[] getControlValue(Control control) {
        if (control instanceof Text) {
            return new String[]{((Text)control).getText(), (String)control.getData("exprType")};
        }
        if (control instanceof Combo) {
            return new String[]{((Combo)control).getText(), (String)control.getData("exprType")};
        }
        return null;
    }

    private boolean strEquals(String left, String right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return EMPTY_STRING.equals(right);
        }
        if (right == null) {
            return EMPTY_STRING.equals(left);
        }
        return left.equals(right);
    }

    private String getDataTypeDisplayName(String dataType) {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            if (dataType.equals(DATA_TYPE_CHOICES[i].getName())) {
                return DATA_TYPE_CHOICES[i].getDisplayName();
            }
            ++i;
        }
        return EMPTY_STRING;
    }

    private String getDataType() {
        int i = 0;
        while (i < DATA_TYPE_CHOICES.length) {
            if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                return DATA_TYPE_CHOICES[i].getName();
            }
            ++i;
        }
        return EMPTY_STRING;
    }

    public ComputedColumnHandle editBinding(ComputedColumnHandle binding) throws SemanticException {
        if (this.isRef) {
            return this.getBindingColumn();
        }
        if (this.isAggregate()) {
            binding.setDisplayName(this.txtDisplayName.getText());
            binding.setDisplayNameID(this.txtDisplayNameID.getText());
            int i = 0;
            while (i < DATA_TYPE_CHOICES.length) {
                if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                    binding.setDataType(DATA_TYPE_CHOICES[i].getName());
                    break;
                }
                ++i;
            }
            binding.setAllowExport(this.btnAllowExport.getSelection());
            binding.setAggregateFunction(this.getFunctionByDisplayName(this.cmbFunction.getText()).getName());
            ExpressionButtonUtil.saveExpressionButtonControl((Control)this.txtFilter, binding, "filterExpr");
            if (this.btnTable.getSelection()) {
                binding.setAggregateOn(null);
            } else {
                binding.setAggregateOn(this.cmbGroup.getText());
            }
            binding.setExpression(null);
            binding.clearArgumentList();
            for (String arg : this.paramsMap.keySet()) {
                String[] value = this.getControlValue(this.paramsMap.get(arg));
                if (value == null) continue;
                AggregationArgument argHandle = StructureFactory.createAggregationArgument();
                argHandle.setName(arg);
                argHandle.setExpressionProperty("value", new Expression((Object)value[0], value[1]));
                binding.addArgument(argHandle);
            }
        } else {
            int i = 0;
            while (i < DATA_TYPE_CHOICES.length) {
                if (DATA_TYPE_CHOICES[i].getDisplayName().equals(this.cmbType.getText())) {
                    binding.setDataType(DATA_TYPE_CHOICES[i].getName());
                    break;
                }
                ++i;
            }
            binding.setDisplayName(this.txtDisplayName.getText());
            binding.setDisplayNameID(this.txtDisplayNameID.getText());
            binding.setAllowExport(this.btnAllowExport.getSelection());
            ExpressionButtonUtil.saveExpressionButtonControl((Control)this.txtExpression, binding, "expression");
        }
        return binding;
    }

    public ComputedColumnHandle newBinding(ReportItemHandle bindingHolder, String name) throws SemanticException {
        if (this.isRef) {
            return this.getBindingColumn();
        }
        ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)bindingHolder, (String)(name == null ? this.txtName.getText() : name));
        ComputedColumnHandle binding = DEUtil.addColumn((DesignElementHandle)bindingHolder, (ComputedColumn)column, (boolean)true);
        return this.editBinding(binding);
    }

    public void setContainer(Object container) {
        this.container = container;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canProcessWithWarning() {
        if (!this.isAggregate()) {
            return true;
        }
        try {
            String type = this.getDataTypeDisplayName(DataAdapterUtil.adapterToModelDataType((int)DataUtil.getAggregationManager().getAggregation(this.getFunctionByDisplayName(this.cmbFunction.getText()).getName()).getDataType()));
            if (!(type == null || type.equals(EMPTY_STRING) || type.equals(this.cmbType.getText()) || this.canProcessFunctionTypeError(this.cmbFunction.getText(), this.cmbType.getText(), type))) {
                return false;
            }
            IAggrFunction function = this.getFunctionByDisplayName(this.cmbFunction.getText());
            if (function == null) return true;
            DataSetHandle dataSetHandle = DEUtil.getFirstDataSet((DesignElementHandle)this.bindingHolder);
            ArrayList columnList = null;
            if (dataSetHandle != null) {
                CachedMetaDataHandle meta = dataSetHandle.getCachedMetaDataHandle();
                if (meta == null) {
                    DataSetUIUtil.updateColumnCache(dataSetHandle);
                    meta = dataSetHandle.getCachedMetaDataHandle();
                }
                columnList = meta.getResultSet().getListValue();
            }
            List bindingList = DEUtil.getAllColumnBindingList((DesignElementHandle)this.bindingHolder, (boolean)true);
            IParameterDefn[] iParameterDefnArray = function.getParameterDefn();
            int n = iParameterDefnArray.length;
            int n2 = 0;
            while (true) {
                String[] expression;
                if (n2 >= n) {
                    return true;
                }
                IParameterDefn param = iParameterDefnArray[n2];
                if (param.isDataField() && (expression = this.getControlValue(this.paramsMap.get(param.getName()))) != null) {
                    String columnName;
                    String bindingName;
                    if (bindingList != null && (bindingName = ExpressionUtil.getColumnBindingName((String)expression[0])) != null) {
                        for (ComputedColumnHandle bindingHandle : bindingList) {
                            if (!bindingHandle.getName().equals(bindingName) || param.supportDataType(DataAdapterUtil.adaptModelDataType((String)bindingHandle.getDataType()))) continue;
                            if (!this.canProcessParamTypeError(expression[0], param.getDisplayName())) {
                                return false;
                            }
                            break;
                        }
                    } else if (columnList != null && (columnName = ExpressionUtil.getColumnName((String)expression[0])) != null) {
                        for (ResultSetColumn column : columnList) {
                            if (!column.getColumnName().equals(columnName) || param.supportDataType(DataAdapterUtil.adaptModelDataType((String)column.getDataType()))) continue;
                            if (this.canProcessParamTypeError(expression[0], param.getDisplayName())) break;
                            return false;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (BirtException birtException) {}
        return true;
    }

    private boolean canProcessFunctionTypeError(String function, String type, String recommended) {
        MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"Warning"), null, Messages.getFormattedString((String)"BindingDialogHelper.warning.function", (Object[])new String[]{recommended}), 4, new String[]{Messages.getString((String)Messages.getString((String)"BindingDialogHelper.warning.button.yes")), Messages.getString((String)Messages.getString((String)"BindingDialogHelper.warning.button.no"))}, 0);
        return dialog.open() == 0;
    }

    private boolean canProcessParamTypeError(String expression, String parameter) {
        MessageDialog dialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString((String)"Warning"), null, Messages.getFormattedString((String)"BindingDialogHelper.warning.parameter", (Object[])new String[]{expression, parameter}), 4, new String[]{Messages.getString((String)"BindingDialogHelper.warning.button.yes"), Messages.getString((String)"BindingDialogHelper.warning.button.no")}, 0);
        return dialog.open() == 0;
    }

    private String[] getBaseNames() {
        List resources = SessionHandleAdapter.getInstance().getReportDesignHandle().getIncludeResources();
        if (resources == null) {
            return null;
        }
        return resources.toArray(new String[0]);
    }

    private URL[] getAvailableResourceUrls() {
        ArrayList<URL> urls = new ArrayList<URL>();
        String[] baseNames = this.getBaseNames();
        if (baseNames == null) {
            return urls.toArray(new URL[0]);
        }
        int i = 0;
        while (i < baseNames.length) {
            URL url = SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(baseNames[i], 5);
            if (url != null) {
                urls.add(url);
            }
            ++i;
        }
        return urls.toArray(new URL[0]);
    }

    private URL[] getResourceURLs() {
        String[] baseNames = this.getBaseNames();
        if (baseNames == null) {
            return null;
        }
        URL[] urls = new URL[baseNames.length];
        int i = 0;
        while (i < baseNames.length) {
            urls[i] = SessionHandleAdapter.getInstance().getReportDesignHandle().findResource(baseNames[i], 5);
            ++i;
        }
        return urls;
    }

    private void updateRemoveBtnState() {
        this.btnRemoveDisplayNameID.setEnabled(!this.txtDisplayNameID.getText().equals(EMPTY_STRING));
    }

    public void setEditModal(boolean isEditModal) {
        this.isEditModal = isEditModal;
    }

    public boolean isEditModal() {
        return this.isEditModal;
    }

    private void modifyDialogContent() {
        if (this.hasInitDialog && this.isEditModal() && !this.hasModified) {
            this.hasModified = true;
            this.validate();
        }
    }
}

