/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.DataEngineThreadLocal;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.olap.data.util.BufferedRandomAccessFile;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

abstract class BaseDiskArray
implements IDiskArray {
    private static final String fileNamePrefix = "BasicDiskList";
    private static final int FILE_BUFFER_SIZE = 1024;
    private static final int bufferSize = 100;
    protected static final short NORMAL_VALUE = 0;
    protected static final short NULL_VALUE = -1;
    private static Logger logger = Logger.getLogger(BaseDiskArray.class.getName());
    private int currentCacheStartIndex = 0;
    private int size = 0;
    private File diskFile = null;
    protected BufferedRandomAccessFile randomAccessFile = null;
    private Object[] buffer = new Object[100];
    private List segmentOffsets = new ArrayList();

    public BaseDiskArray() throws IOException {
        this.segmentOffsets.add(0);
        this.createRandomAccessFile();
        DataEngineThreadLocal.getInstance().getCloseListener().add(this);
    }

    public boolean add(Object o) throws IOException {
        if (this.size >= this.currentCacheStartIndex && this.size < this.currentCacheStartIndex + 100) {
            this.buffer[this.size - this.currentCacheStartIndex] = o;
        }
        this.writeObject(o);
        ++this.size;
        if (this.size % 100 == 0) {
            this.segmentOffsets.add(this.getOffset());
        }
        return true;
    }

    private void createRandomAccessFile() throws IOException {
        this.createCacheFile();
        this.randomAccessFile = new BufferedRandomAccessFile(this.diskFile, "rw", 1024);
    }

    private int getOffset() throws IOException {
        return (int)this.randomAccessFile.getFilePointer();
    }

    protected abstract void writeObject(Object var1) throws IOException;

    public Object get(int index) throws IOException {
        this.RangeCheck(index);
        if (index < this.currentCacheStartIndex || index > this.currentCacheStartIndex + 100 - 1) {
            int readSize = 100;
            if (index / 100 == this.segmentOffsets.size() - 1) {
                readSize = this.size % 100;
            }
            this.currentCacheStartIndex = index / 100 * 100;
            this.readObjects(this.getSegmentOffset(index), readSize);
        }
        return this.buffer[index % 100];
    }

    private int getSegmentOffset(int index) {
        return (Integer)this.segmentOffsets.get(index / 100);
    }

    private void readObjects(int offset, int readSize) throws IOException {
        this.randomAccessFile.seek(offset);
        int i = 0;
        while (i < readSize) {
            this.buffer[i] = this.readObject();
            ++i;
        }
    }

    protected abstract Object readObject() throws IOException;

    private void createCacheFile() throws IOException {
        String tempFileStr = DataEngineThreadLocal.getInstance().getPathManager().getTempFileName(fileNamePrefix, this.hashCode(), "");
        if (this.diskFile == null) {
            this.diskFile = new File(tempFileStr);
            FileSecurity.createNewFile(this.diskFile);
        }
    }

    public int size() {
        return this.size;
    }

    public void close() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        this.clearDiskFile();
        this.size = 0;
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private void clearDiskFile() throws IOException {
        if (this.randomAccessFile != null) {
            this.randomAccessFile.close();
            this.randomAccessFile = null;
        }
        if (this.diskFile != null) {
            FileSecurity.fileDelete(this.diskFile);
            this.diskFile = null;
        }
    }

    public void clear() throws IOException {
        this.currentCacheStartIndex = -1;
        this.size = 0;
        this.clearDiskFile();
        this.segmentOffsets.clear();
        this.segmentOffsets.add(0);
        this.createRandomAccessFile();
    }
}

