/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IGroupInstanceInfo;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PLSUtil {
    public static boolean isPLSEnabled(IQueryDefinition queryDefn) {
        return queryDefn.getQueryExecutionHints() != null && queryDefn.getQueryExecutionHints().getTargetGroupInstances().size() > 0;
    }

    public static boolean needUpdateDataSet(IQueryDefinition queryDefn, StreamManager manager) throws DataException {
        RAInputStream in;
        block7: {
            assert (queryDefn != null);
            assert (queryDefn.getQueryExecutionHints() != null);
            if (queryDefn.getQueryExecutionHints().getTargetGroupInstances().size() == 0) {
                return false;
            }
            in = null;
            if (manager.hasInStream(102, 0, 0)) {
                in = manager.getInStream(102, 0, 0);
            }
            try {
                if (in != null) break block7;
                return true;
            }
            catch (IOException e) {
                throw new DataException(e.getLocalizedMessage());
            }
        }
        int savedGroupLevel = IOUtil.readInt((InputStream)in);
        in.close();
        int currentRequestedGroupLevel = PLSUtil.getOutmostPlsGroupLevel(queryDefn);
        return savedGroupLevel < currentRequestedGroupLevel;
    }

    public static int getOutmostPlsGroupLevel(IQueryDefinition queryDefn) {
        assert (queryDefn != null);
        assert (queryDefn.getQueryExecutionHints() != null);
        int currentRequestedGroupLevel = 0;
        for (IGroupInstanceInfo info : queryDefn.getQueryExecutionHints().getTargetGroupInstances()) {
            int n = currentRequestedGroupLevel = info.getGroupLevel() > currentRequestedGroupLevel ? info.getGroupLevel() : currentRequestedGroupLevel;
        }
        return currentRequestedGroupLevel;
    }

    private static List<String> getReCalGroupNames(IQueryDefinition query, List<IGroupInstanceInfo> targetGroups) {
        int groupLevel = Integer.MAX_VALUE;
        for (IGroupInstanceInfo instance : targetGroups) {
            if (groupLevel <= instance.getGroupLevel()) continue;
            groupLevel = instance.getGroupLevel();
        }
        List groups = query.getGroups();
        ArrayList<String> reCalGroups = new ArrayList<String>();
        int i = groupLevel - 1;
        while (i < groups.size()) {
            reCalGroups.add(((IGroupDefinition)groups.get(i)).getName());
            ++i;
        }
        return reCalGroups;
    }

    public static String constructNonReCalBindingDataSetName(String originalBindingName) {
        return "${RE_CAL:" + originalBindingName + "}$";
    }

    public static boolean isPLSProcessedBinding(IBinding binding) {
        try {
            String columnName;
            if (binding.getExpression() instanceof IScriptExpression && (columnName = ExpressionUtil.getColumnName((String)((IScriptExpression)binding.getExpression()).getText())) != null && columnName.startsWith("${RE_CAL:")) {
                return true;
            }
        }
        catch (BirtException birtException) {}
        return false;
    }

    public static IQueryDefinition populateBindings(IQueryDefinition queryDefn) throws DataException {
        try {
            List<String> reCalGroupNames = PLSUtil.getReCalGroupNames(queryDefn, queryDefn.getQueryExecutionHints().getTargetGroupInstances());
            for (IBinding binding : queryDefn.getBindings().values()) {
                String text;
                if (binding.getAggregatOns().size() != 0 && reCalGroupNames.contains(binding.getAggregatOns().get(0)) || binding.getExpression() instanceof IScriptExpression && binding.getAggrFunction() == null && (ExpressionUtil.getColumnName((String)(text = ((IScriptExpression)binding.getExpression()).getText())) != null || ExpressionUtil.getColumnBindingName((String)text) == null || !PLSUtil.referToRecAggrBinding(queryDefn, reCalGroupNames, text))) continue;
                String expr = ExpressionUtil.createJSDataSetRowExpression((String)PLSUtil.constructNonReCalBindingDataSetName(binding.getBindingName()));
                binding.setExpression(new ScriptExpression(expr));
                binding.getAggregatOns().clear();
                binding.setAggrFunction(null);
            }
            return queryDefn;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private static boolean referToRecAggrBinding(IQueryDefinition queryDefn, List<String> reCalGroupNames, String exprText) throws BirtException {
        List columnBindings = ExpressionUtil.extractColumnExpressions((String)exprText, (String)"row");
        if (columnBindings != null) {
            for (IColumnBinding cb : columnBindings) {
                String text;
                IBinding usedBinding = (IBinding)queryDefn.getBindings().get(cb.getResultSetColumnName());
                if (usedBinding.getAggrFunction() != null && usedBinding.getAggregatOns().size() > 0 && reCalGroupNames.contains(usedBinding.getAggregatOns().get(0))) {
                    return true;
                }
                if (!(usedBinding.getExpression() instanceof IScriptExpression) || !PLSUtil.referToRecAggrBinding(queryDefn, reCalGroupNames, text = ((IScriptExpression)usedBinding.getExpression()).getText())) continue;
                return true;
            }
        }
        return false;
    }
}

