/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ListingElementExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.w3c.dom.css.CSSValue;

public class ListBandExecutor
extends StyledItemExecutor {
    ListingElementExecutor listExecutor;
    int currentItem;

    protected ListBandExecutor(ExecutorManager manager) {
        super(manager, 11);
    }

    void setListingExecutor(ListingElementExecutor listExecutor) {
        this.listExecutor = listExecutor;
    }

    public IContent execute() {
        ListBandDesign bandDesign = (ListBandDesign)this.getDesign();
        IListBandContent bandContent = this.report.createListBandContent();
        this.setContent(bandContent);
        this.restoreResultSet();
        this.initializeContent(bandDesign, bandContent);
        this.startTOCEntry(bandContent);
        this.handlePageBreakInterval();
        this.currentItem = 0;
        return bandContent;
    }

    protected void handlePageBreakInterval() {
        BandDesign band;
        if (this.listExecutor.breakOnDetailBand && (band = (BandDesign)this.design).getBandType() == 0) {
            if (this.listExecutor.softBreakBefore) {
                CSSValue pageBreak;
                IStyle style = this.content.getStyle();
                if (style != null && ((pageBreak = style.getProperty(47)) == null || IStyle.AUTO_VALUE.equals(pageBreak))) {
                    style.setProperty(47, IStyle.SOFT_VALUE);
                }
                this.listExecutor.softBreakBefore = false;
                this.listExecutor.addAfterBreak = true;
                this.listExecutor.pageRowCount = 0;
            }
            this.listExecutor.next();
            if (this.listExecutor.needSoftBreakAfter()) {
                this.listExecutor.softBreakBefore = true;
            }
        }
    }

    public void close() throws BirtException {
        this.finishTOCEntry();
        super.close();
    }

    public boolean hasNextChild() {
        ListBandDesign bandDesign = (ListBandDesign)this.design;
        return this.currentItem < bandDesign.getContentCount();
    }

    public IReportItemExecutor getNextChild() {
        ListBandDesign bandDesign = (ListBandDesign)this.design;
        if (this.currentItem < bandDesign.getContentCount()) {
            ReportItemDesign itemDesign = bandDesign.getContent(this.currentItem++);
            ReportItemExecutor executor = this.manager.createExecutor(this, itemDesign);
            return executor;
        }
        return null;
    }
}

